% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_data_quality_job_definition}
\alias{sagemaker_create_data_quality_job_definition}
\title{Creates a definition for a job that monitors data quality and drift}
\usage{
sagemaker_create_data_quality_job_definition(
  JobDefinitionName,
  DataQualityBaselineConfig = NULL,
  DataQualityAppSpecification,
  DataQualityJobInput,
  DataQualityJobOutputConfig,
  JobResources,
  NetworkConfig = NULL,
  RoleArn,
  StoppingCondition = NULL,
  Tags = NULL
)
}
\arguments{
\item{JobDefinitionName}{[required] The name for the monitoring job definition.}

\item{DataQualityBaselineConfig}{Configures the constraints and baselines for the monitoring job.}

\item{DataQualityAppSpecification}{[required] Specifies the container that runs the monitoring job.}

\item{DataQualityJobInput}{[required] A list of inputs for the monitoring job. Currently endpoints are
supported as monitoring inputs.}

\item{DataQualityJobOutputConfig}{[required]}

\item{JobResources}{[required]}

\item{NetworkConfig}{Specifies networking configuration for the monitoring job.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
assume to perform tasks on your behalf.}

\item{StoppingCondition}{}

\item{Tags}{(Optional) An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL}{Using Cost Allocation Tags}
in the \emph{Amazon Web Services Billing and Cost Management User Guide}.}
}
\description{
Creates a definition for a job that monitors data quality and drift. For information about model monitor, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html}{Amazon SageMaker Model Monitor}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_data_quality_job_definition/} for full documentation.
}
\keyword{internal}
