% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutmetrics_operations.R
\name{lookoutmetrics_create_metric_set}
\alias{lookoutmetrics_create_metric_set}
\title{Creates a dataset}
\usage{
lookoutmetrics_create_metric_set(
  AnomalyDetectorArn,
  MetricSetName,
  MetricSetDescription = NULL,
  MetricList,
  Offset = NULL,
  TimestampColumn = NULL,
  DimensionList = NULL,
  MetricSetFrequency = NULL,
  MetricSource,
  Timezone = NULL,
  Tags = NULL,
  DimensionFilterList = NULL
)
}
\arguments{
\item{AnomalyDetectorArn}{[required] The ARN of the anomaly detector that will use the dataset.}

\item{MetricSetName}{[required] The name of the dataset.}

\item{MetricSetDescription}{A description of the dataset you are creating.}

\item{MetricList}{[required] A list of metrics that the dataset will contain.}

\item{Offset}{After an interval ends, the amount of seconds that the detector waits
before importing data. Offset is only supported for S3, Redshift, Athena
and datasources.}

\item{TimestampColumn}{Contains information about the column used for tracking time in your
source data.}

\item{DimensionList}{A list of the fields you want to treat as dimensions.}

\item{MetricSetFrequency}{The frequency with which the source data will be analyzed for anomalies.}

\item{MetricSource}{[required] Contains information about how the source data should be interpreted.}

\item{Timezone}{The time zone in which your source data was recorded.}

\item{Tags}{A list of
\href{https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html}{tags}
to apply to the dataset.}

\item{DimensionFilterList}{A list of filters that specify which data is kept for anomaly detection.}
}
\description{
Creates a dataset.

See \url{https://www.paws-r-sdk.com/docs/lookoutmetrics_create_metric_set/} for full documentation.
}
\keyword{internal}
