% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_model_package}
\alias{sagemaker_create_model_package}
\title{Creates a model package that you can use to create SageMaker models or
list on Amazon Web Services Marketplace, or a versioned model that is
part of a model group}
\usage{
sagemaker_create_model_package(
  ModelPackageName = NULL,
  ModelPackageGroupName = NULL,
  ModelPackageDescription = NULL,
  InferenceSpecification = NULL,
  ValidationSpecification = NULL,
  SourceAlgorithmSpecification = NULL,
  CertifyForMarketplace = NULL,
  Tags = NULL,
  ModelApprovalStatus = NULL,
  MetadataProperties = NULL,
  ModelMetrics = NULL,
  ClientToken = NULL,
  CustomerMetadataProperties = NULL,
  DriftCheckBaselines = NULL,
  Domain = NULL,
  Task = NULL,
  SamplePayloadUrl = NULL,
  AdditionalInferenceSpecifications = NULL
)
}
\arguments{
\item{ModelPackageName}{The name of the model package. The name must have 1 to 63 characters.
Valid characters are a-z, A-Z, 0-9, and - (hyphen).

This parameter is required for unversioned models. It is not applicable
to versioned models.}

\item{ModelPackageGroupName}{The name or Amazon Resource Name (ARN) of the model package group that
this model version belongs to.

This parameter is required for versioned models, and does not apply to
unversioned models.}

\item{ModelPackageDescription}{A description of the model package.}

\item{InferenceSpecification}{Specifies details about inference jobs that can be run with models based
on this model package, including the following:
\itemize{
\item The Amazon ECR paths of containers that contain the inference code
and model artifacts.
\item The instance types that the model package supports for transform
jobs and real-time endpoints used for inference.
\item The input and output content formats that the model package supports
for inference.
}}

\item{ValidationSpecification}{Specifies configurations for one or more transform jobs that SageMaker
runs to test the model package.}

\item{SourceAlgorithmSpecification}{Details about the algorithm that was used to create the model package.}

\item{CertifyForMarketplace}{Whether to certify the model package for listing on Amazon Web Services
Marketplace.

This parameter is optional for unversioned models, and does not apply to
versioned models.}

\item{Tags}{A list of key value pairs associated with the model. For more
information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}
in the \emph{Amazon Web Services General Reference Guide}.}

\item{ModelApprovalStatus}{Whether the model is approved for deployment.

This parameter is optional for versioned models, and does not apply to
unversioned models.

For versioned models, the value of this parameter must be set to
\code{Approved} to deploy the model.}

\item{MetadataProperties}{}

\item{ModelMetrics}{A structure that contains model metrics reports.}

\item{ClientToken}{A unique token that guarantees that the call to this API is idempotent.}

\item{CustomerMetadataProperties}{The metadata properties associated with the model package versions.}

\item{DriftCheckBaselines}{Represents the drift check baselines that can be used when the model
monitor is set using the model package. For more information, see the
topic on \href{https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection}{Drift Detection against Previous Baselines in SageMaker Pipelines}
in the \emph{Amazon SageMaker Developer Guide}.}

\item{Domain}{The machine learning domain of your model package and its components.
Common machine learning domains include computer vision and natural
language processing.}

\item{Task}{The machine learning task your model package accomplishes. Common
machine learning tasks include object detection and image
classification. The following tasks are supported by Inference
Recommender: \code{"IMAGE_CLASSIFICATION"} | \code{"OBJECT_DETECTION"} |
\code{"TEXT_GENERATION"} |\code{"IMAGE_SEGMENTATION"} | \code{"FILL_MASK"} |
\code{"CLASSIFICATION"} | \code{"REGRESSION"} | \code{"OTHER"}.

Specify "OTHER" if none of the tasks listed fit your use case.}

\item{SamplePayloadUrl}{The Amazon Simple Storage Service (Amazon S3) path where the sample
payload is stored. This path must point to a single gzip compressed tar
archive (.tar.gz suffix). This archive can hold multiple files that are
all equally used in the load test. Each file in the archive must satisfy
the size constraints of the
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html#API_runtime_InvokeEndpoint_RequestSyntax}{InvokeEndpoint}
call.}

\item{AdditionalInferenceSpecifications}{An array of additional Inference Specification objects. Each additional
Inference Specification specifies artifacts based on this model package
that can be used on inference endpoints. Generally used with SageMaker
Neo to store the compiled artifacts.}
}
\description{
Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_model_package/} for full documentation.
}
\keyword{internal}
