% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_device_fleet}
\alias{sagemaker_update_device_fleet}
\title{Updates a fleet of devices}
\usage{
sagemaker_update_device_fleet(
  DeviceFleetName,
  RoleArn = NULL,
  Description = NULL,
  OutputConfig,
  EnableIotRoleAlias = NULL
)
}
\arguments{
\item{DeviceFleetName}{[required] The name of the fleet.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the device.}

\item{Description}{Description of the fleet.}

\item{OutputConfig}{[required] Output configuration for storing sample data collected by the fleet.}

\item{EnableIotRoleAlias}{Whether to create an Amazon Web Services IoT Role Alias during device
fleet creation. The name of the role alias generated will match this
pattern: "SageMakerEdge-\{DeviceFleetName\}".

For example, if your device fleet is called "demo-fleet", the name of
the role alias will be "SageMakerEdge-demo-fleet".}
}
\description{
Updates a fleet of devices.

See \url{https://paws-r.github.io/docs/sagemaker/update_device_fleet.html} for full documentation.
}
\keyword{internal}
