% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_custom_labels}
\alias{rekognition_detect_custom_labels}
\title{Detects custom labels in a supplied image by using an Amazon Rekognition
Custom Labels model}
\usage{
rekognition_detect_custom_labels(
  ProjectVersionArn,
  Image,
  MaxResults = NULL,
  MinConfidence = NULL
)
}
\arguments{
\item{ProjectVersionArn}{[required] The ARN of the model version that you want to use.}

\item{Image}{[required]}

\item{MaxResults}{Maximum number of results you want the service to return in the
response. The service returns the specified number of highest confidence
labels ranked from highest confidence to lowest.}

\item{MinConfidence}{Specifies the minimum confidence level for the labels to return.
\code{\link[=rekognition_detect_custom_labels]{detect_custom_labels}} doesn't
return any labels with a confidence value that's lower than this
specified value. If you specify a value of 0,
\code{\link[=rekognition_detect_custom_labels]{detect_custom_labels}} returns all
labels, regardless of the assumed threshold applied to each label. If
you don't specify a value for \code{MinConfidence},
\code{\link[=rekognition_detect_custom_labels]{detect_custom_labels}} returns
labels based on the assumed threshold of each label.}
}
\description{
Detects custom labels in a supplied image by using an Amazon Rekognition Custom Labels model.

See \url{https://paws-r.github.io/docs/rekognition/detect_custom_labels.html} for full documentation.
}
\keyword{internal}
