% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_get_external_models}
\alias{frauddetector_get_external_models}
\title{Gets the details for one or more Amazon SageMaker models that have been
imported into the service}
\usage{
frauddetector_get_external_models(
  modelEndpoint = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{modelEndpoint}{The Amazon SageMaker model endpoint.}

\item{nextToken}{The next page token for the request.}

\item{maxResults}{The maximum number of objects to return for the request.}
}
\description{
Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null \code{maxResults}, this actions retrieves a maximum of 10 records per page. If you provide a \code{maxResults}, the value must be between 5 and 10. To get the next page results, provide the pagination token from the \code{GetExternalModelsResult} as part of your request. A null pagination token fetches the records from the beginning.

See \url{https://paws-r.github.io/docs/frauddetector/get_external_models.html} for full documentation.
}
\keyword{internal}
