# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include personalizeruntime_service.R
NULL

#' Re-ranks a list of recommended items for the given user
#'
#' Re-ranks a list of recommended items for the given user. The first item
#' in the list is deemed the most likely item to be of interest to the
#' user.
#' 
#' The solution backing the campaign must have been created using a recipe
#' of type PERSONALIZED\\_RANKING.
#'
#' @usage
#' personalizeruntime_get_personalized_ranking(campaignArn, inputList,
#'   userId, context)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign to use for generating the
#' personalized ranking.
#' @param inputList &#91;required&#93; A list of items (itemId\'s) to rank. If an item was not included in the
#' training dataset, the item is appended to the end of the reranked list.
#' The maximum is 500.
#' @param userId &#91;required&#93; The user for which you want the campaign to provide a personalized
#' ranking.
#' @param context The contextual metadata to use when getting recommendations. Contextual
#' metadata includes any interaction information that might be relevant
#' when getting a user\'s recommendations, such as the user\'s current
#' location or device type.
#'
#' @section Request syntax:
#' ```
#' svc$get_personalized_ranking(
#'   campaignArn = "string",
#'   inputList = list(
#'     "string"
#'   ),
#'   userId = "string",
#'   context = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalizeruntime_get_personalized_ranking
personalizeruntime_get_personalized_ranking <- function(campaignArn, inputList, userId, context = NULL) {
  op <- new_operation(
    name = "GetPersonalizedRanking",
    http_method = "POST",
    http_path = "/personalize-ranking",
    paginator = list()
  )
  input <- .personalizeruntime$get_personalized_ranking_input(campaignArn = campaignArn, inputList = inputList, userId = userId, context = context)
  output <- .personalizeruntime$get_personalized_ranking_output()
  config <- get_config()
  svc <- .personalizeruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalizeruntime$operations$get_personalized_ranking <- personalizeruntime_get_personalized_ranking

#' Returns a list of recommended items
#'
#' Returns a list of recommended items. The required input depends on the
#' recipe type used to create the solution backing the campaign, as
#' follows:
#' 
#' -   RELATED\\_ITEMS - `itemId` required, `userId` not used
#' 
#' -   USER\\_PERSONALIZATION - `itemId` optional, `userId` required
#' 
#' Campaigns that are backed by a solution created using a recipe of type
#' PERSONALIZED\\_RANKING use the API.
#'
#' @usage
#' personalizeruntime_get_recommendations(campaignArn, itemId, userId,
#'   numResults, context, filterArn)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign to use for getting
#' recommendations.
#' @param itemId The item ID to provide recommendations for.
#' 
#' Required for `RELATED_ITEMS` recipe type.
#' @param userId The user ID to provide recommendations for.
#' 
#' Required for `USER_PERSONALIZATION` recipe type.
#' @param numResults The number of results to return. The default is 25. The maximum is 500.
#' @param context The contextual metadata to use when getting recommendations. Contextual
#' metadata includes any interaction information that might be relevant
#' when getting a user\'s recommendations, such as the user\'s current
#' location or device type.
#' @param filterArn The ARN of the filter to apply to the returned recommendations. For more
#' information, see Using Filters with Amazon Personalize.
#'
#' @section Request syntax:
#' ```
#' svc$get_recommendations(
#'   campaignArn = "string",
#'   itemId = "string",
#'   userId = "string",
#'   numResults = 123,
#'   context = list(
#'     "string"
#'   ),
#'   filterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalizeruntime_get_recommendations
personalizeruntime_get_recommendations <- function(campaignArn, itemId = NULL, userId = NULL, numResults = NULL, context = NULL, filterArn = NULL) {
  op <- new_operation(
    name = "GetRecommendations",
    http_method = "POST",
    http_path = "/recommendations",
    paginator = list()
  )
  input <- .personalizeruntime$get_recommendations_input(campaignArn = campaignArn, itemId = itemId, userId = userId, numResults = numResults, context = context, filterArn = filterArn)
  output <- .personalizeruntime$get_recommendations_output()
  config <- get_config()
  svc <- .personalizeruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalizeruntime$operations$get_recommendations <- personalizeruntime_get_recommendations
