% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_translate_text}
\alias{translate_translate_text}
\title{Translates input text from the source language to the target language}
\usage{
translate_translate_text(Text, TerminologyNames, SourceLanguageCode,
  TargetLanguageCode)
}
\arguments{
\item{Text}{[required] The text to translate. The text string can be a maximum of 5,000 bytes
long. Depending on your character set, this may be fewer than 5,000
characters.}

\item{TerminologyNames}{The name of the terminology list file to be used in the TranslateText
request. You can use 1 terminology list at most in a \code{TranslateText}
request. Terminology lists can contain a maximum of 256 terms.}

\item{SourceLanguageCode}{[required] The language code for the language of the source text. The language must
be a language supported by Amazon Translate. For a list of language
codes, see what-is-languages.

To have Amazon Translate determine the source language of your text, you
can specify \code{auto} in the \code{SourceLanguageCode} field. If you specify
\code{auto}, Amazon Translate will call \href{https://docs.aws.amazon.com/comprehend/latest/dg/comprehend-general.html}{Amazon Comprehend}
to determine the source language.}

\item{TargetLanguageCode}{[required] The language code requested for the language of the target text. The
language must be a language supported by Amazon Translate.}
}
\description{
Translates input text from the source language to the target language.
For a list of available languages and language codes, see
what-is-languages.
}
\section{Request syntax}{
\preformatted{svc$translate_text(
  Text = "string",
  TerminologyNames = list(
    "string"
  ),
  SourceLanguageCode = "string",
  TargetLanguageCode = "string"
)
}
}

\keyword{internal}
