% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_create_evaluation}
\alias{machinelearning_create_evaluation}
\title{Creates a new Evaluation of an MLModel}
\usage{
machinelearning_create_evaluation(EvaluationId, EvaluationName,
  MLModelId, EvaluationDataSourceId)
}
\arguments{
\item{EvaluationId}{[required] A user-supplied ID that uniquely identifies the \code{Evaluation}.}

\item{EvaluationName}{A user-supplied name or description of the \code{Evaluation}.}

\item{MLModelId}{[required] The ID of the \code{MLModel} to evaluate.

The schema used in creating the \code{MLModel} must match the schema of the
\code{DataSource} used in the \code{Evaluation}.}

\item{EvaluationDataSourceId}{[required] The ID of the \code{DataSource} for the evaluation. The schema of the
\code{DataSource} must match the schema used to create the \code{MLModel}.}
}
\description{
Creates a new \code{Evaluation} of an \code{MLModel}. An \code{MLModel} is evaluated on
a set of observations associated to a \code{DataSource}. Like a \code{DataSource}
for an \code{MLModel}, the \code{DataSource} for an \code{Evaluation} contains values
for the \verb{Target Variable}. The \code{Evaluation} compares the predicted
result for each observation to the actual outcome and provides a summary
so that you know how effective the \code{MLModel} functions on the test data.
Evaluation generates a relevant performance metric, such as BinaryAUC,
RegressionRMSE or MulticlassAvgFScore based on the corresponding
\code{MLModelType}: \code{BINARY}, \code{REGRESSION} or \code{MULTICLASS}.

\code{CreateEvaluation} is an asynchronous operation. In response to
\code{CreateEvaluation}, Amazon Machine Learning (Amazon ML) immediately
returns and sets the evaluation status to \code{PENDING}. After the
\code{Evaluation} is created and ready for use, Amazon ML sets the status to
\code{COMPLETED}.

You can use the \code{GetEvaluation} operation to check progress of the
evaluation during the creation operation.
}
\section{Request syntax}{
\preformatted{svc$create_evaluation(
  EvaluationId = "string",
  EvaluationName = "string",
  MLModelId = "string",
  EvaluationDataSourceId = "string"
)
}
}

\keyword{internal}
