% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_update_portal}
\alias{workspacesweb_update_portal}
\title{Updates a web portal}
\usage{
workspacesweb_update_portal(
  authenticationType = NULL,
  displayName = NULL,
  instanceType = NULL,
  maxConcurrentSessions = NULL,
  portalArn
)
}
\arguments{
\item{authenticationType}{The type of authentication integration points used when signing into the
web portal. Defaults to \code{Standard}.

\code{Standard} web portals are authenticated directly through your identity
provider. You need to call
\code{\link[=workspacesweb_create_identity_provider]{create_identity_provider}} to
integrate your identity provider with your web portal. User and group
access to your web portal is controlled through your identity provider.

\verb{IAM Identity Center} web portals are authenticated through IAM Identity
Center (successor to Single Sign-On). Identity sources (including
external identity provider integration), plus user and group access to
your web portal, can be configured in the IAM Identity Center.}

\item{displayName}{The name of the web portal. This is not visible to users who log into
the web portal.}

\item{instanceType}{The type and resources of the underlying instance.}

\item{maxConcurrentSessions}{The maximum number of concurrent sessions for the portal.}

\item{portalArn}{[required] The ARN of the web portal.}
}
\description{
Updates a web portal.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_update_portal/} for full documentation.
}
\keyword{internal}
