% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_create_comment}
\alias{workdocs_create_comment}
\title{Adds a new comment to the specified document version}
\usage{
workdocs_create_comment(AuthenticationToken, DocumentId, VersionId,
  ParentId, ThreadId, Text, Visibility, NotifyCollaborators)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{VersionId}{[required] The ID of the document version.}

\item{ParentId}{The ID of the parent comment.}

\item{ThreadId}{The ID of the root comment in the thread.}

\item{Text}{[required] The text of the comment.}

\item{Visibility}{The visibility of the comment. Options are either PRIVATE, where the
comment is visible only to the comment author and document owner and
co-owners, or PUBLIC, where the comment is visible to document owners,
co-owners, and contributors.}

\item{NotifyCollaborators}{Set this parameter to TRUE to send an email out to the document
collaborators after the comment is created.}
}
\value{
A list with the following syntax:\preformatted{list(
  Comment = list(
    CommentId = "string",
    ParentId = "string",
    ThreadId = "string",
    Text = "string",
    Contributor = list(
      Id = "string",
      Username = "string",
      EmailAddress = "string",
      GivenName = "string",
      Surname = "string",
      OrganizationId = "string",
      RootFolderId = "string",
      RecycleBinFolderId = "string",
      Status = "ACTIVE"|"INACTIVE"|"PENDING",
      Type = "USER"|"ADMIN"|"POWERUSER"|"MINIMALUSER"|"WORKSPACESUSER",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      ModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      TimeZoneId = "string",
      Locale = "en"|"fr"|"ko"|"de"|"es"|"ja"|"ru"|"zh_CN"|"zh_TW"|"pt_BR"|"default",
      Storage = list(
        StorageUtilizedInBytes = 123,
        StorageRule = list(
          StorageAllocatedInBytes = 123,
          StorageType = "UNLIMITED"|"QUOTA"
        )
      )
    ),
    CreatedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    Status = "DRAFT"|"PUBLISHED"|"DELETED",
    Visibility = "PUBLIC"|"PRIVATE",
    RecipientId = "string"
  )
)
}
}
\description{
Adds a new comment to the specified document version.
}
\section{Request syntax}{
\preformatted{svc$create_comment(
  AuthenticationToken = "string",
  DocumentId = "string",
  VersionId = "string",
  ParentId = "string",
  ThreadId = "string",
  Text = "string",
  Visibility = "PUBLIC"|"PRIVATE",
  NotifyCollaborators = TRUE|FALSE
)
}
}

\keyword{internal}
