# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS CodePipeline
#'
#' @description
#' CodePipeline
#' 
#' **Overview**
#' 
#' This is the CodePipeline API Reference. This guide provides descriptions
#' of the actions and data types for CodePipeline. Some functionality for
#' your pipeline can only be configured through the API. For more
#' information, see the [CodePipeline User
#' Guide](https://docs.aws.amazon.com/codepipeline/latest/userguide/welcome.html).
#' 
#' You can use the CodePipeline API to work with pipelines, stages,
#' actions, and transitions.
#' 
#' *Pipelines* are models of automated release processes. Each pipeline is
#' uniquely named, and consists of stages, actions, and transitions.
#' 
#' You can work with pipelines by calling:
#' 
#' -   [`create_pipeline`][codepipeline_create_pipeline], which creates a
#'     uniquely named pipeline.
#' 
#' -   [`delete_pipeline`][codepipeline_delete_pipeline], which deletes the
#'     specified pipeline.
#' 
#' -   [`get_pipeline`][codepipeline_get_pipeline], which returns
#'     information about the pipeline structure and pipeline metadata,
#'     including the pipeline Amazon Resource Name (ARN).
#' 
#' -   [`get_pipeline_execution`][codepipeline_get_pipeline_execution],
#'     which returns information about a specific execution of a pipeline.
#' 
#' -   [`get_pipeline_state`][codepipeline_get_pipeline_state], which
#'     returns information about the current state of the stages and
#'     actions of a pipeline.
#' 
#' -   [`list_action_executions`][codepipeline_list_action_executions],
#'     which returns action-level details for past executions. The details
#'     include full stage and action-level details, including individual
#'     action duration, status, any errors that occurred during the
#'     execution, and input and output artifact location details.
#' 
#' -   [`list_pipelines`][codepipeline_list_pipelines], which gets a
#'     summary of all of the pipelines associated with your account.
#' 
#' -   [`list_pipeline_executions`][codepipeline_list_pipeline_executions],
#'     which gets a summary of the most recent executions for a pipeline.
#' 
#' -   [`start_pipeline_execution`][codepipeline_start_pipeline_execution],
#'     which runs the most recent revision of an artifact through the
#'     pipeline.
#' 
#' -   [`stop_pipeline_execution`][codepipeline_stop_pipeline_execution],
#'     which stops the specified pipeline execution from continuing through
#'     the pipeline.
#' 
#' -   [`update_pipeline`][codepipeline_update_pipeline], which updates a
#'     pipeline with edits or changes to the structure of the pipeline.
#' 
#' Pipelines include *stages*. Each stage contains one or more actions that
#' must complete before the next stage begins. A stage results in success
#' or failure. If a stage fails, the pipeline stops at that stage and
#' remains stopped until either a new version of an artifact appears in the
#' source location, or a user takes action to rerun the most recent
#' artifact through the pipeline. You can call
#' [`get_pipeline_state`][codepipeline_get_pipeline_state], which displays
#' the status of a pipeline, including the status of stages in the
#' pipeline, or [`get_pipeline`][codepipeline_get_pipeline], which returns
#' the entire structure of the pipeline, including the stages of that
#' pipeline. For more information about the structure of stages and
#' actions, see [CodePipeline Pipeline Structure
#' Reference](https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html).
#' 
#' Pipeline stages include *actions* that are categorized into categories
#' such as source or build actions performed in a stage of a pipeline. For
#' example, you can use a source action to import artifacts into a pipeline
#' from a source such as Amazon S3. Like stages, you do not work with
#' actions directly in most cases, but you do define and interact with
#' actions when working with pipeline operations such as
#' [`create_pipeline`][codepipeline_create_pipeline] and
#' [`get_pipeline_state`][codepipeline_get_pipeline_state]. Valid action
#' categories are:
#' 
#' -   Source
#' 
#' -   Build
#' 
#' -   Test
#' 
#' -   Deploy
#' 
#' -   Approval
#' 
#' -   Invoke
#' 
#' Pipelines also include *transitions*, which allow the transition of
#' artifacts from one stage to the next in a pipeline after the actions in
#' one stage complete.
#' 
#' You can work with transitions by calling:
#' 
#' -   [`disable_stage_transition`][codepipeline_disable_stage_transition],
#'     which prevents artifacts from transitioning to the next stage in a
#'     pipeline.
#' 
#' -   [`enable_stage_transition`][codepipeline_enable_stage_transition],
#'     which enables transition of artifacts between stages in a pipeline.
#' 
#' **Using the API to integrate with CodePipeline**
#' 
#' For third-party integrators or developers who want to create their own
#' integrations with CodePipeline, the expected sequence varies from the
#' standard API user. To integrate with CodePipeline, developers need to
#' work with the following items:
#' 
#' **Jobs**, which are instances of an action. For example, a job for a
#' source action might import a revision of an artifact from a source.
#' 
#' You can work with jobs by calling:
#' 
#' -   [`acknowledge_job`][codepipeline_acknowledge_job], which confirms
#'     whether a job worker has received the specified job.
#' 
#' -   [`get_job_details`][codepipeline_get_job_details], which returns the
#'     details of a job.
#' 
#' -   [`poll_for_jobs`][codepipeline_poll_for_jobs], which determines
#'     whether there are any jobs to act on.
#' 
#' -   [`put_job_failure_result`][codepipeline_put_job_failure_result],
#'     which provides details of a job failure.
#' 
#' -   [`put_job_success_result`][codepipeline_put_job_success_result],
#'     which provides details of a job success.
#' 
#' **Third party jobs**, which are instances of an action created by a
#' partner action and integrated into CodePipeline. Partner actions are
#' created by members of the Amazon Web Services Partner Network.
#' 
#' You can work with third party jobs by calling:
#' 
#' -   [`acknowledge_third_party_job`][codepipeline_acknowledge_third_party_job],
#'     which confirms whether a job worker has received the specified job.
#' 
#' -   [`get_third_party_job_details`][codepipeline_get_third_party_job_details],
#'     which requests the details of a job for a partner action.
#' 
#' -   [`poll_for_third_party_jobs`][codepipeline_poll_for_third_party_jobs],
#'     which determines whether there are any jobs to act on.
#' 
#' -   [`put_third_party_job_failure_result`][codepipeline_put_third_party_job_failure_result],
#'     which provides details of a job failure.
#' 
#' -   [`put_third_party_job_success_result`][codepipeline_put_third_party_job_success_result],
#'     which provides details of a job success.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- codepipeline(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- codepipeline()
#' svc$acknowledge_job(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=codepipeline_acknowledge_job]{acknowledge_job} \tab Returns information about a specified job and whether that job has been received by the job worker\cr
#'  \link[=codepipeline_acknowledge_third_party_job]{acknowledge_third_party_job} \tab Confirms a job worker has received the specified job\cr
#'  \link[=codepipeline_create_custom_action_type]{create_custom_action_type} \tab Creates a new custom action that can be used in all pipelines associated with the Amazon Web Services account\cr
#'  \link[=codepipeline_create_pipeline]{create_pipeline} \tab Creates a pipeline\cr
#'  \link[=codepipeline_delete_custom_action_type]{delete_custom_action_type} \tab Marks a custom action as deleted\cr
#'  \link[=codepipeline_delete_pipeline]{delete_pipeline} \tab Deletes the specified pipeline\cr
#'  \link[=codepipeline_delete_webhook]{delete_webhook} \tab Deletes a previously created webhook by name\cr
#'  \link[=codepipeline_deregister_webhook_with_third_party]{deregister_webhook_with_third_party} \tab Removes the connection between the webhook that was created by CodePipeline and the external tool with events to be detected\cr
#'  \link[=codepipeline_disable_stage_transition]{disable_stage_transition} \tab Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline\cr
#'  \link[=codepipeline_enable_stage_transition]{enable_stage_transition} \tab Enables artifacts in a pipeline to transition to a stage in a pipeline\cr
#'  \link[=codepipeline_get_action_type]{get_action_type} \tab Returns information about an action type created for an external provider, where the action is to be used by customers of the external provider\cr
#'  \link[=codepipeline_get_job_details]{get_job_details} \tab Returns information about a job\cr
#'  \link[=codepipeline_get_pipeline]{get_pipeline} \tab Returns the metadata, structure, stages, and actions of a pipeline\cr
#'  \link[=codepipeline_get_pipeline_execution]{get_pipeline_execution} \tab Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution ID, and the name, version, and status of the pipeline\cr
#'  \link[=codepipeline_get_pipeline_state]{get_pipeline_state} \tab Returns information about the state of a pipeline, including the stages and actions\cr
#'  \link[=codepipeline_get_third_party_job_details]{get_third_party_job_details} \tab Requests the details of a job for a third party action\cr
#'  \link[=codepipeline_list_action_executions]{list_action_executions} \tab Lists the action executions that have occurred in a pipeline\cr
#'  \link[=codepipeline_list_action_types]{list_action_types} \tab Gets a summary of all CodePipeline action types associated with your account\cr
#'  \link[=codepipeline_list_pipeline_executions]{list_pipeline_executions} \tab Gets a summary of the most recent executions for a pipeline\cr
#'  \link[=codepipeline_list_pipelines]{list_pipelines} \tab Gets a summary of all of the pipelines associated with your account\cr
#'  \link[=codepipeline_list_tags_for_resource]{list_tags_for_resource} \tab Gets the set of key-value pairs (metadata) that are used to manage the resource\cr
#'  \link[=codepipeline_list_webhooks]{list_webhooks} \tab Gets a listing of all the webhooks in this Amazon Web Services Region for this account\cr
#'  \link[=codepipeline_poll_for_jobs]{poll_for_jobs} \tab Returns information about any jobs for CodePipeline to act on\cr
#'  \link[=codepipeline_poll_for_third_party_jobs]{poll_for_third_party_jobs} \tab Determines whether there are any third party jobs for a job worker to act on\cr
#'  \link[=codepipeline_put_action_revision]{put_action_revision} \tab Provides information to CodePipeline about new revisions to a source\cr
#'  \link[=codepipeline_put_approval_result]{put_approval_result} \tab Provides the response to a manual approval request to CodePipeline\cr
#'  \link[=codepipeline_put_job_failure_result]{put_job_failure_result} \tab Represents the failure of a job as returned to the pipeline by a job worker\cr
#'  \link[=codepipeline_put_job_success_result]{put_job_success_result} \tab Represents the success of a job as returned to the pipeline by a job worker\cr
#'  \link[=codepipeline_put_third_party_job_failure_result]{put_third_party_job_failure_result} \tab Represents the failure of a third party job as returned to the pipeline by a job worker\cr
#'  \link[=codepipeline_put_third_party_job_success_result]{put_third_party_job_success_result} \tab Represents the success of a third party job as returned to the pipeline by a job worker\cr
#'  \link[=codepipeline_put_webhook]{put_webhook} \tab Defines a webhook and returns a unique webhook URL generated by CodePipeline\cr
#'  \link[=codepipeline_register_webhook_with_third_party]{register_webhook_with_third_party} \tab Configures a connection between the webhook that was created and the external tool with events to be detected\cr
#'  \link[=codepipeline_retry_stage_execution]{retry_stage_execution} \tab You can retry a stage that has failed without having to run a pipeline again from the beginning\cr
#'  \link[=codepipeline_rollback_stage]{rollback_stage} \tab Rolls back a stage execution\cr
#'  \link[=codepipeline_start_pipeline_execution]{start_pipeline_execution} \tab Starts the specified pipeline\cr
#'  \link[=codepipeline_stop_pipeline_execution]{stop_pipeline_execution} \tab Stops the specified pipeline execution\cr
#'  \link[=codepipeline_tag_resource]{tag_resource} \tab Adds to or modifies the tags of the given resource\cr
#'  \link[=codepipeline_untag_resource]{untag_resource} \tab Removes tags from an Amazon Web Services resource\cr
#'  \link[=codepipeline_update_action_type]{update_action_type} \tab Updates an action type that was created with any supported integration model, where the action type is to be used by customers of the action type provider\cr
#'  \link[=codepipeline_update_pipeline]{update_pipeline} \tab Updates a specified pipeline with edits or changes to its structure
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname codepipeline
#' @export
codepipeline <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .codepipeline$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.codepipeline <- list()

.codepipeline$operations <- list()

.codepipeline$metadata <- list(
  service_name = "codepipeline",
  endpoints = list("*" = list(endpoint = "codepipeline.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "codepipeline.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "codepipeline.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "codepipeline.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "codepipeline.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "codepipeline.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "CodePipeline",
  api_version = "2015-07-09",
  signing_name = "codepipeline",
  json_version = "1.1",
  target_prefix = "CodePipeline_20150709"
)

.codepipeline$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.codepipeline$metadata, handlers, config)
}
