% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestarconnections_operations.R
\name{codestarconnections_create_host}
\alias{codestarconnections_create_host}
\title{Creates a resource that represents the infrastructure where a
third-party provider is installed}
\usage{
codestarconnections_create_host(
  Name,
  ProviderType,
  ProviderEndpoint,
  VpcConfiguration = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the host to be created. The name must be unique in the
calling AWS account.}

\item{ProviderType}{[required] The name of the installed provider to be associated with your
connection. The host resource represents the infrastructure where your
provider type is installed. The valid provider type is GitHub Enterprise
Server.}

\item{ProviderEndpoint}{[required] The endpoint of the infrastructure to be represented by the host after
it is created.}

\item{VpcConfiguration}{The VPC configuration to be provisioned for the host. A VPC must be
configured and the infrastructure to be represented by the host must
already be connected to the VPC.}

\item{Tags}{}
}
\description{
Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.

See \url{https://www.paws-r-sdk.com/docs/codestarconnections_create_host/} for full documentation.
}
\keyword{internal}
