% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_update_deployment_group}
\alias{codedeploy_update_deployment_group}
\title{Changes information about a deployment group}
\usage{
codedeploy_update_deployment_group(
  applicationName,
  currentDeploymentGroupName,
  newDeploymentGroupName = NULL,
  deploymentConfigName = NULL,
  ec2TagFilters = NULL,
  onPremisesInstanceTagFilters = NULL,
  autoScalingGroups = NULL,
  serviceRoleArn = NULL,
  triggerConfigurations = NULL,
  alarmConfiguration = NULL,
  autoRollbackConfiguration = NULL,
  outdatedInstancesStrategy = NULL,
  deploymentStyle = NULL,
  blueGreenDeploymentConfiguration = NULL,
  loadBalancerInfo = NULL,
  ec2TagSet = NULL,
  ecsServices = NULL,
  onPremisesTagSet = NULL
)
}
\arguments{
\item{applicationName}{[required] The application name that corresponds to the deployment group to update.}

\item{currentDeploymentGroupName}{[required] The current name of the deployment group.}

\item{newDeploymentGroupName}{The new name of the deployment group, if you want to change it.}

\item{deploymentConfigName}{The replacement deployment configuration name to use, if you want to
change it.}

\item{ec2TagFilters}{The replacement set of Amazon EC2 tags on which to filter, if you want
to change them. To keep the existing tags, enter their names. To remove
tags, do not enter any tag names.}

\item{onPremisesInstanceTagFilters}{The replacement set of on-premises instance tags on which to filter, if
you want to change them. To keep the existing tags, enter their names.
To remove tags, do not enter any tag names.}

\item{autoScalingGroups}{The replacement list of Auto Scaling groups to be included in the
deployment group, if you want to change them. To keep the Auto Scaling
groups, enter their names. To remove Auto Scaling groups, do not enter
any Auto Scaling group names.}

\item{serviceRoleArn}{A replacement ARN for the service role, if you want to change it.}

\item{triggerConfigurations}{Information about triggers to change when the deployment group is
updated. For examples, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-edit-trigger.html}{Edit a Trigger in a CodeDeploy Deployment Group}
in the \emph{AWS CodeDeploy User Guide}.}

\item{alarmConfiguration}{Information to add or change about Amazon CloudWatch alarms when the
deployment group is updated.}

\item{autoRollbackConfiguration}{Information for an automatic rollback configuration that is added or
changed when a deployment group is updated.}

\item{outdatedInstancesStrategy}{Indicates what happens when new EC2 instances are launched
mid-deployment and do not receive the deployed application revision.

If this option is set to \code{UPDATE} or is unspecified, CodeDeploy
initiates one or more 'auto-update outdated instances' deployments to
apply the deployed application revision to the new EC2 instances.

If this option is set to \code{IGNORE}, CodeDeploy does not initiate a
deployment to update the new EC2 instances. This may result in instances
having different revisions.}

\item{deploymentStyle}{Information about the type of deployment, either in-place or blue/green,
you want to run and whether to route deployment traffic behind a load
balancer.}

\item{blueGreenDeploymentConfiguration}{Information about blue/green deployment options for a deployment group.}

\item{loadBalancerInfo}{Information about the load balancer used in a deployment.}

\item{ec2TagSet}{Information about groups of tags applied to on-premises instances. The
deployment group includes only EC2 instances identified by all the tag
groups.}

\item{ecsServices}{The target Amazon ECS services in the deployment group. This applies
only to deployment groups that use the Amazon ECS compute platform. A
target Amazon ECS service is specified as an Amazon ECS cluster and
service name pair using the format \verb{<clustername>:<servicename>}.}

\item{onPremisesTagSet}{Information about an on-premises instance tag set. The deployment group
includes only on-premises instances identified by all the tag groups.}
}
\description{
Changes information about a deployment group.

See \url{https://paws-r.github.io/docs/codedeploy/update_deployment_group.html} for full documentation.
}
\keyword{internal}
