% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_delete_repository_permissions_policy}
\alias{codeartifact_delete_repository_permissions_policy}
\title{Deletes the resource policy that is set on a repository}
\usage{
codeartifact_delete_repository_permissions_policy(
  domain,
  domainOwner = NULL,
  repository,
  policyRevision = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository associated with the
resource policy to be deleted.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that is associated with the resource policy
to be deleted}

\item{policyRevision}{The revision of the repository's resource policy to be deleted. This
revision is used for optimistic locking, which prevents others from
accidentally overwriting your changes to the repository's resource
policy.}
}
\description{
Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.

See \url{https://paws-r.github.io/docs/codeartifact/delete_repository_permissions_policy.html} for full documentation.
}
\keyword{internal}
