% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_get_deployment_target}
\alias{codedeploy_get_deployment_target}
\title{Returns information about a deployment target}
\usage{
codedeploy_get_deployment_target(deploymentId, targetId)
}
\arguments{
\item{deploymentId}{The unique ID of a deployment.}

\item{targetId}{The unique ID of a deployment target.}
}
\value{
A list with the following syntax:\preformatted{list(
  deploymentTarget = list(
    deploymentTargetType = "InstanceTarget"|"LambdaTarget"|"ECSTarget"|"CloudFormationTarget",
    instanceTarget = list(
      deploymentId = "string",
      targetId = "string",
      targetArn = "string",
      status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      lifecycleEvents = list(
        list(
          lifecycleEventName = "string",
          diagnostics = list(
            errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
            scriptName = "string",
            message = "string",
            logTail = "string"
          ),
          startTime = as.POSIXct(
            "2015-01-01"
          ),
          endTime = as.POSIXct(
            "2015-01-01"
          ),
          status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
        )
      ),
      instanceLabel = "Blue"|"Green"
    ),
    lambdaTarget = list(
      deploymentId = "string",
      targetId = "string",
      targetArn = "string",
      status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      lifecycleEvents = list(
        list(
          lifecycleEventName = "string",
          diagnostics = list(
            errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
            scriptName = "string",
            message = "string",
            logTail = "string"
          ),
          startTime = as.POSIXct(
            "2015-01-01"
          ),
          endTime = as.POSIXct(
            "2015-01-01"
          ),
          status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
        )
      ),
      lambdaFunctionInfo = list(
        functionName = "string",
        functionAlias = "string",
        currentVersion = "string",
        targetVersion = "string",
        targetVersionWeight = 123.0
      )
    ),
    ecsTarget = list(
      deploymentId = "string",
      targetId = "string",
      targetArn = "string",
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      lifecycleEvents = list(
        list(
          lifecycleEventName = "string",
          diagnostics = list(
            errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
            scriptName = "string",
            message = "string",
            logTail = "string"
          ),
          startTime = as.POSIXct(
            "2015-01-01"
          ),
          endTime = as.POSIXct(
            "2015-01-01"
          ),
          status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
        )
      ),
      status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
      taskSetsInfo = list(
        list(
          identifer = "string",
          desiredCount = 123,
          pendingCount = 123,
          runningCount = 123,
          status = "string",
          trafficWeight = 123.0,
          targetGroup = list(
            name = "string"
          ),
          taskSetLabel = "Blue"|"Green"
        )
      )
    ),
    cloudFormationTarget = list(
      deploymentId = "string",
      targetId = "string",
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      lifecycleEvents = list(
        list(
          lifecycleEventName = "string",
          diagnostics = list(
            errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
            scriptName = "string",
            message = "string",
            logTail = "string"
          ),
          startTime = as.POSIXct(
            "2015-01-01"
          ),
          endTime = as.POSIXct(
            "2015-01-01"
          ),
          status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
        )
      ),
      status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
      resourceType = "string",
      targetVersionWeight = 123.0
    )
  )
)
}
}
\description{
Returns information about a deployment target.
}
\section{Request syntax}{
\preformatted{svc$get_deployment_target(
  deploymentId = "string",
  targetId = "string"
)
}
}

\keyword{internal}
