% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_folder}
\alias{codecommit_get_folder}
\title{Returns the contents of a specified folder in a repository}
\usage{
codecommit_get_folder(repositoryName, commitSpecifier, folderPath)
}
\arguments{
\item{repositoryName}{[required] The name of the repository.}

\item{commitSpecifier}{A fully qualified reference used to identify a commit that contains the
version of the folder's content to return. A fully qualified reference
can be a commit ID, branch name, tag, or reference such as HEAD. If no
specifier is provided, the folder content is returned as it exists in
the HEAD commit.}

\item{folderPath}{[required] The fully qualified path to the folder whose contents are returned,
including the folder name. For example, /examples is a fully-qualified
path to a folder named examples that was created off of the root
directory (/) of a repository.}
}
\value{
A list with the following syntax:\preformatted{list(
  commitId = "string",
  folderPath = "string",
  treeId = "string",
  subFolders = list(
    list(
      treeId = "string",
      absolutePath = "string",
      relativePath = "string"
    )
  ),
  files = list(
    list(
      blobId = "string",
      absolutePath = "string",
      relativePath = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
    )
  ),
  symbolicLinks = list(
    list(
      blobId = "string",
      absolutePath = "string",
      relativePath = "string",
      fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK"
    )
  ),
  subModules = list(
    list(
      commitId = "string",
      absolutePath = "string",
      relativePath = "string"
    )
  )
)
}
}
\description{
Returns the contents of a specified folder in a repository.
}
\section{Request syntax}{
\preformatted{svc$get_folder(
  repositoryName = "string",
  commitSpecifier = "string",
  folderPath = "string"
)
}
}

\keyword{internal}
