% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_describe_pull_request_events}
\alias{codecommit_describe_pull_request_events}
\title{Returns information about one or more pull request events}
\usage{
codecommit_describe_pull_request_events(pullRequestId,
  pullRequestEventType, actorArn, nextToken, maxResults)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request. To get this ID, use
\code{\link[=codecommit_list_pull_requests]{list_pull_requests}}.}

\item{pullRequestEventType}{Optional. The pull request event type about which you want to return
information.}

\item{actorArn}{The Amazon Resource Name (ARN) of the user whose actions resulted in the
event. Examples include updating the pull request with more commits or
changing the status of a pull request.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results. The default is 100 events, which is also the maximum number of
events that can be returned in a result.}
}
\value{
A list with the following syntax:\preformatted{list(
  pullRequestEvents = list(
    list(
      pullRequestId = "string",
      eventDate = as.POSIXct(
        "2015-01-01"
      ),
      pullRequestEventType = "PULL_REQUEST_CREATED"|"PULL_REQUEST_STATUS_CHANGED"|"PULL_REQUEST_SOURCE_REFERENCE_UPDATED"|"PULL_REQUEST_MERGE_STATE_CHANGED"|"PULL_REQUEST_APPROVAL_RULE_CREATED"|"PULL_REQUEST_APPROVAL_RULE_UPDATED"|"PULL_REQUEST_APPROVAL_RULE_DELETED"|"PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN"|"PULL_REQUEST_APPROVAL_STATE_CHANGED",
      actorArn = "string",
      pullRequestCreatedEventMetadata = list(
        repositoryName = "string",
        sourceCommitId = "string",
        destinationCommitId = "string",
        mergeBase = "string"
      ),
      pullRequestStatusChangedEventMetadata = list(
        pullRequestStatus = "OPEN"|"CLOSED"
      ),
      pullRequestSourceReferenceUpdatedEventMetadata = list(
        repositoryName = "string",
        beforeCommitId = "string",
        afterCommitId = "string",
        mergeBase = "string"
      ),
      pullRequestMergedStateChangedEventMetadata = list(
        repositoryName = "string",
        destinationReference = "string",
        mergeMetadata = list(
          isMerged = TRUE|FALSE,
          mergedBy = "string",
          mergeCommitId = "string",
          mergeOption = "FAST_FORWARD_MERGE"|"SQUASH_MERGE"|"THREE_WAY_MERGE"
        )
      ),
      approvalRuleEventMetadata = list(
        approvalRuleName = "string",
        approvalRuleId = "string",
        approvalRuleContent = "string"
      ),
      approvalStateChangedEventMetadata = list(
        revisionId = "string",
        approvalStatus = "APPROVE"|"REVOKE"
      ),
      approvalRuleOverriddenEventMetadata = list(
        revisionId = "string",
        overrideStatus = "OVERRIDE"|"REVOKE"
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns information about one or more pull request events.
}
\section{Request syntax}{
\preformatted{svc$describe_pull_request_events(
  pullRequestId = "string",
  pullRequestEventType = "PULL_REQUEST_CREATED"|"PULL_REQUEST_STATUS_CHANGED"|"PULL_REQUEST_SOURCE_REFERENCE_UPDATED"|"PULL_REQUEST_MERGE_STATE_CHANGED"|"PULL_REQUEST_APPROVAL_RULE_CREATED"|"PULL_REQUEST_APPROVAL_RULE_UPDATED"|"PULL_REQUEST_APPROVAL_RULE_DELETED"|"PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN"|"PULL_REQUEST_APPROVAL_STATE_CHANGED",
  actorArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
