% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_global_cluster}
\alias{rds_create_global_cluster}
\title{Creates an Aurora global database spread across multiple Amazon Web
Services Regions}
\usage{
rds_create_global_cluster(
  GlobalClusterIdentifier = NULL,
  SourceDBClusterIdentifier = NULL,
  Engine = NULL,
  EngineVersion = NULL,
  EngineLifecycleSupport = NULL,
  DeletionProtection = NULL,
  DatabaseName = NULL,
  StorageEncrypted = NULL,
  Tags = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{The cluster identifier for this global database cluster. This parameter
is stored as a lowercase string.}

\item{SourceDBClusterIdentifier}{The Amazon Resource Name (ARN) to use as the primary cluster of the
global database.

If you provide a value for this parameter, don't specify values for the
following settings because Amazon Aurora uses the values from the
specified source DB cluster:
\itemize{
\item \code{DatabaseName}
\item \code{Engine}
\item \code{EngineVersion}
\item \code{StorageEncrypted}
}}

\item{Engine}{The database engine to use for this global database cluster.

Valid Values: \code{aurora-mysql | aurora-postgresql}

Constraints:
\itemize{
\item Can't be specified if \code{SourceDBClusterIdentifier} is specified. In
this case, Amazon Aurora uses the engine of the source DB cluster.
}}

\item{EngineVersion}{The engine version to use for this global database cluster.

Constraints:
\itemize{
\item Can't be specified if \code{SourceDBClusterIdentifier} is specified. In
this case, Amazon Aurora uses the engine version of the source DB
cluster.
}}

\item{EngineLifecycleSupport}{The life cycle type for this global database cluster.

By default, this value is set to \code{open-source-rds-extended-support},
which enrolls your global cluster into Amazon RDS Extended Support. At
the end of standard support, you can avoid charges for Extended Support
by setting the value to \code{open-source-rds-extended-support-disabled}. In
this case, creating the global cluster will fail if the DB major version
is past its end of standard support date.

This setting only applies to Aurora PostgreSQL-based global databases.

You can use this setting to enroll your global cluster into Amazon RDS
Extended Support. With RDS Extended Support, you can run the selected
major engine version on your global cluster past the end of standard
support for that engine version. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html}{Using Amazon RDS Extended Support}
in the \emph{Amazon Aurora User Guide}.

Valid Values:
\code{open-source-rds-extended-support | open-source-rds-extended-support-disabled}

Default: \code{open-source-rds-extended-support}}

\item{DeletionProtection}{Specifies whether to enable deletion protection for the new global
database cluster. The global database can't be deleted when deletion
protection is enabled.}

\item{DatabaseName}{The name for your database of up to 64 alphanumeric characters. If you
don't specify a name, Amazon Aurora doesn't create a database in the
global database cluster.

Constraints:
\itemize{
\item Can't be specified if \code{SourceDBClusterIdentifier} is specified. In
this case, Amazon Aurora uses the database name from the source DB
cluster.
}}

\item{StorageEncrypted}{Specifies whether to enable storage encryption for the new global
database cluster.

Constraints:
\itemize{
\item Can't be specified if \code{SourceDBClusterIdentifier} is specified. In
this case, Amazon Aurora uses the setting from the source DB
cluster.
}}

\item{Tags}{Tags to assign to the global cluster.}
}
\description{
Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.

See \url{https://www.paws-r-sdk.com/docs/rds_create_global_cluster/} for full documentation.
}
\keyword{internal}
