# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include simpledb_service.R
NULL

#' Performs multiple DeleteAttributes operations in a single call, which
#' reduces round trips and latencies
#'
#' @description
#' Performs multiple DeleteAttributes operations in a single call, which reduces round trips and latencies. This enables Amazon SimpleDB to optimize requests, which generally yields better throughput.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_batch_delete_attributes/](https://www.paws-r-sdk.com/docs/simpledb_batch_delete_attributes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain in which the attributes are being deleted.
#' @param Items &#91;required&#93; A list of items on which to perform the operation.
#'
#' @keywords internal
#'
#' @rdname simpledb_batch_delete_attributes
simpledb_batch_delete_attributes <- function(DomainName, Items) {
  op <- new_operation(
    name = "BatchDeleteAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$batch_delete_attributes_input(DomainName = DomainName, Items = Items)
  output <- .simpledb$batch_delete_attributes_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$batch_delete_attributes <- simpledb_batch_delete_attributes

#' The BatchPutAttributes operation creates or replaces attributes within
#' one or more items
#'
#' @description
#' The [`batch_put_attributes`][simpledb_batch_put_attributes] operation creates or replaces attributes within one or more items. By using this operation, the client can perform multiple PutAttribute operation with a single call. This helps yield savings in round trips and latencies, enabling Amazon SimpleDB to optimize requests and generally produce better throughput.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_batch_put_attributes/](https://www.paws-r-sdk.com/docs/simpledb_batch_put_attributes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain in which the attributes are being stored.
#' @param Items &#91;required&#93; A list of items on which to perform the operation.
#'
#' @keywords internal
#'
#' @rdname simpledb_batch_put_attributes
simpledb_batch_put_attributes <- function(DomainName, Items) {
  op <- new_operation(
    name = "BatchPutAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$batch_put_attributes_input(DomainName = DomainName, Items = Items)
  output <- .simpledb$batch_put_attributes_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$batch_put_attributes <- simpledb_batch_put_attributes

#' The CreateDomain operation creates a new domain
#'
#' @description
#' The [`create_domain`][simpledb_create_domain] operation creates a new domain. The domain name should be unique among the domains associated with the Access Key ID provided in the request. The [`create_domain`][simpledb_create_domain] operation may take 10 or more seconds to complete.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_create_domain/](https://www.paws-r-sdk.com/docs/simpledb_create_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain to create. The name can range between 3 and 255
#' characters and can contain the following characters: a-z, A-Z, 0-9,
#' '_', '-', and '.'.
#'
#' @keywords internal
#'
#' @rdname simpledb_create_domain
simpledb_create_domain <- function(DomainName) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$create_domain_input(DomainName = DomainName)
  output <- .simpledb$create_domain_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$create_domain <- simpledb_create_domain

#' Deletes one or more attributes associated with an item
#'
#' @description
#' Deletes one or more attributes associated with an item. If all attributes of the item are deleted, the item is deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_delete_attributes/](https://www.paws-r-sdk.com/docs/simpledb_delete_attributes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain in which to perform the operation.
#' @param ItemName &#91;required&#93; The name of the item. Similar to rows on a spreadsheet, items represent
#' individual objects that contain one or more value-attribute pairs.
#' @param Attributes A list of Attributes. Similar to columns on a spreadsheet, attributes
#' represent categories of data that can be assigned to items.
#' @param Expected The update condition which, if specified, determines whether the
#' specified attributes will be deleted or not. The update condition must
#' be satisfied in order for this request to be processed and the
#' attributes to be deleted.
#'
#' @keywords internal
#'
#' @rdname simpledb_delete_attributes
simpledb_delete_attributes <- function(DomainName, ItemName, Attributes = NULL, Expected = NULL) {
  op <- new_operation(
    name = "DeleteAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$delete_attributes_input(DomainName = DomainName, ItemName = ItemName, Attributes = Attributes, Expected = Expected)
  output <- .simpledb$delete_attributes_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$delete_attributes <- simpledb_delete_attributes

#' The DeleteDomain operation deletes a domain
#'
#' @description
#' The [`delete_domain`][simpledb_delete_domain] operation deletes a domain. Any items (and their attributes) in the domain are deleted as well. The [`delete_domain`][simpledb_delete_domain] operation might take 10 or more seconds to complete.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_delete_domain/](https://www.paws-r-sdk.com/docs/simpledb_delete_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain to delete.
#'
#' @keywords internal
#'
#' @rdname simpledb_delete_domain
simpledb_delete_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$delete_domain_input(DomainName = DomainName)
  output <- .simpledb$delete_domain_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$delete_domain <- simpledb_delete_domain

#' Returns information about the domain, including when the domain was
#' created, the number of items and attributes in the domain, and the size
#' of the attribute names and values
#'
#' @description
#' Returns information about the domain, including when the domain was created, the number of items and attributes in the domain, and the size of the attribute names and values.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_domain_metadata/](https://www.paws-r-sdk.com/docs/simpledb_domain_metadata/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain for which to display the metadata of.
#'
#' @keywords internal
#'
#' @rdname simpledb_domain_metadata
simpledb_domain_metadata <- function(DomainName) {
  op <- new_operation(
    name = "DomainMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$domain_metadata_input(DomainName = DomainName)
  output <- .simpledb$domain_metadata_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$domain_metadata <- simpledb_domain_metadata

#' Returns all of the attributes associated with the specified item
#'
#' @description
#' Returns all of the attributes associated with the specified item. Optionally, the attributes returned can be limited to one or more attributes by specifying an attribute name parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_get_attributes/](https://www.paws-r-sdk.com/docs/simpledb_get_attributes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain in which to perform the operation.
#' @param ItemName &#91;required&#93; The name of the item.
#' @param AttributeNames The names of the attributes.
#' @param ConsistentRead Determines whether or not strong consistency should be enforced when
#' data is read from SimpleDB. If `true`, any data previously written to
#' SimpleDB will be returned. Otherwise, results will be consistent
#' eventually, and the client may not see data that was written immediately
#' before your read.
#'
#' @keywords internal
#'
#' @rdname simpledb_get_attributes
simpledb_get_attributes <- function(DomainName, ItemName, AttributeNames = NULL, ConsistentRead = NULL) {
  op <- new_operation(
    name = "GetAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$get_attributes_input(DomainName = DomainName, ItemName = ItemName, AttributeNames = AttributeNames, ConsistentRead = ConsistentRead)
  output <- .simpledb$get_attributes_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$get_attributes <- simpledb_get_attributes

#' The ListDomains operation lists all domains associated with the Access
#' Key ID
#'
#' @description
#' The [`list_domains`][simpledb_list_domains] operation lists all domains associated with the Access Key ID. It returns domain names up to the limit set by MaxNumberOfDomains. A NextToken is returned if there are more than `MaxNumberOfDomains` domains. Calling [`list_domains`][simpledb_list_domains] successive times with the `NextToken` provided by the operation returns up to `MaxNumberOfDomains` more domain names with each successive operation call.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_list_domains/](https://www.paws-r-sdk.com/docs/simpledb_list_domains/) for full documentation.
#'
#' @param MaxNumberOfDomains The maximum number of domain names you want returned. The range is 1 to
#' 100. The default setting is 100.
#' @param NextToken A string informing Amazon SimpleDB where to start the next list of
#' domain names.
#'
#' @keywords internal
#'
#' @rdname simpledb_list_domains
simpledb_list_domains <- function(MaxNumberOfDomains = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxNumberOfDomains", result_key = "DomainNames"),
    stream_api = FALSE
  )
  input <- .simpledb$list_domains_input(MaxNumberOfDomains = MaxNumberOfDomains, NextToken = NextToken)
  output <- .simpledb$list_domains_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$list_domains <- simpledb_list_domains

#' The PutAttributes operation creates or replaces attributes in an item
#'
#' @description
#' The PutAttributes operation creates or replaces attributes in an item. The client may specify new attributes using a combination of the `Attribute.X.Name` and `Attribute.X.Value` parameters. The client specifies the first attribute by the parameters `Attribute.0.Name` and `Attribute.0.Value`, the second attribute by the parameters `Attribute.1.Name` and `Attribute.1.Value`, and so on.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_put_attributes/](https://www.paws-r-sdk.com/docs/simpledb_put_attributes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain in which to perform the operation.
#' @param ItemName &#91;required&#93; The name of the item.
#' @param Attributes &#91;required&#93; The list of attributes.
#' @param Expected The update condition which, if specified, determines whether the
#' specified attributes will be updated or not. The update condition must
#' be satisfied in order for this request to be processed and the
#' attributes to be updated.
#'
#' @keywords internal
#'
#' @rdname simpledb_put_attributes
simpledb_put_attributes <- function(DomainName, ItemName, Attributes, Expected = NULL) {
  op <- new_operation(
    name = "PutAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .simpledb$put_attributes_input(DomainName = DomainName, ItemName = ItemName, Attributes = Attributes, Expected = Expected)
  output <- .simpledb$put_attributes_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$put_attributes <- simpledb_put_attributes

#' The Select operation returns a set of attributes for ItemNames that
#' match the select expression
#'
#' @description
#' The [`select`][simpledb_select] operation returns a set of attributes for `ItemNames` that match the select expression. [`select`][simpledb_select] is similar to the standard SQL SELECT statement.
#'
#' See [https://www.paws-r-sdk.com/docs/simpledb_select/](https://www.paws-r-sdk.com/docs/simpledb_select/) for full documentation.
#'
#' @param SelectExpression &#91;required&#93; The expression used to query the domain.
#' @param NextToken A string informing Amazon SimpleDB where to start the next list of
#' `ItemNames`.
#' @param ConsistentRead Determines whether or not strong consistency should be enforced when
#' data is read from SimpleDB. If `true`, any data previously written to
#' SimpleDB will be returned. Otherwise, results will be consistent
#' eventually, and the client may not see data that was written immediately
#' before your read.
#'
#' @keywords internal
#'
#' @rdname simpledb_select
simpledb_select <- function(SelectExpression, NextToken = NULL, ConsistentRead = NULL) {
  op <- new_operation(
    name = "Select",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Items"),
    stream_api = FALSE
  )
  input <- .simpledb$select_input(SelectExpression = SelectExpression, NextToken = NextToken, ConsistentRead = ConsistentRead)
  output <- .simpledb$select_output()
  config <- get_config()
  svc <- .simpledb$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.simpledb$operations$select <- simpledb_select
