% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_failover_global_cluster}
\alias{rds_failover_global_cluster}
\title{Initiates the failover process for an Aurora global database
(GlobalCluster)}
\usage{
rds_failover_global_cluster(GlobalClusterIdentifier, TargetDbClusterIdentifier)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] Identifier of the Aurora global database (GlobalCluster) that should be
failed over. The identifier is the unique key assigned by the user when
the Aurora global database was created. In other words, it's the name of
the Aurora global database that you want to fail over.

Constraints:
\itemize{
\item Must match the identifier of an existing GlobalCluster (Aurora
global database).
}}

\item{TargetDbClusterIdentifier}{[required] Identifier of the secondary Aurora DB cluster that you want to promote
to primary for the Aurora global database (GlobalCluster.) Use the
Amazon Resource Name (ARN) for the identifier so that Aurora can locate
the cluster in its Amazon Web Services Region.}
}
\description{
Initiates the failover process for an Aurora global database (GlobalCluster).

See \url{https://www.paws-r-sdk.com/docs/rds_failover_global_cluster/} for full documentation.
}
\keyword{internal}
