% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qldb_operations.R
\name{qldb_list_journal_kinesis_streams_for_ledger}
\alias{qldb_list_journal_kinesis_streams_for_ledger}
\title{Returns an array of all Amazon QLDB journal stream descriptors for a
given ledger}
\usage{
qldb_list_journal_kinesis_streams_for_ledger(
  LedgerName,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{LedgerName}{[required] The name of the ledger.}

\item{MaxResults}{The maximum number of results to return in a single
\code{\link[=qldb_list_journal_kinesis_streams_for_ledger]{list_journal_kinesis_streams_for_ledger}}
request. (The actual number of results returned might be fewer.)}

\item{NextToken}{A pagination token, indicating that you want to retrieve the next page
of results. If you received a value for \code{NextToken} in the response from
a previous
\code{\link[=qldb_list_journal_kinesis_streams_for_ledger]{list_journal_kinesis_streams_for_ledger}}
call, you should use that value as input here.}
}
\description{
Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream descriptor includes the same details that are returned by \code{\link[=qldb_describe_journal_kinesis_stream]{describe_journal_kinesis_stream}}.

See \url{https://paws-r.github.io/docs/qldb/list_journal_kinesis_streams_for_ledger.html} for full documentation.
}
\keyword{internal}
