% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_start_activity_stream}
\alias{rds_start_activity_stream}
\title{Starts a database activity stream to monitor activity on the database}
\usage{
rds_start_activity_stream(ResourceArn, Mode, KmsKeyId, ApplyImmediately)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the DB cluster, for example
\code{arn:aws:rds:us-east-1:12345667890:cluster:das-cluster}.}

\item{Mode}{[required] Specifies the mode of the database activity stream. Database events such
as a change or access generate an activity stream event. The database
session can handle these events either synchronously or asynchronously.}

\item{KmsKeyId}{[required] The AWS KMS key identifier for encrypting messages in the database
activity stream. The key identifier can be either a key ID, a key ARN,
or a key alias.}

\item{ApplyImmediately}{Specifies whether or not the database activity stream is to start as
soon as possible, regardless of the maintenance window for the database.}
}
\description{
Starts a database activity stream to monitor activity on the database.
For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html}{Database Activity Streams}
in the \emph{Amazon Aurora User Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_activity_stream(
  ResourceArn = "string",
  Mode = "sync"|"async",
  KmsKeyId = "string",
  ApplyImmediately = TRUE|FALSE
)
}
}

\keyword{internal}
