# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include docdb_service.R
NULL

#' Adds metadata tags to an Amazon DocumentDB resource
#'
#' Adds metadata tags to an Amazon DocumentDB resource. You can use these
#' tags with cost allocation reporting to track costs that are associated
#' with Amazon DocumentDB resources. or in a `Condition` statement in an
#' AWS Identity and Access Management (IAM) policy for Amazon DocumentDB.
#'
#' @usage
#' docdb_add_tags_to_resource(ResourceName, Tags)
#'
#' @param ResourceName &#91;required&#93; The Amazon DocumentDB resource that the tags are added to. This value is
#' an Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon DocumentDB resource.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_add_tags_to_resource
docdb_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .docdb$add_tags_to_resource_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$add_tags_to_resource <- docdb_add_tags_to_resource

#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance)
#'
#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance).
#'
#' @usage
#' docdb_apply_pending_maintenance_action(ResourceIdentifier, ApplyAction,
#'   OptInType)
#'
#' @param ResourceIdentifier &#91;required&#93; The Amazon Resource Name (ARN) of the resource that the pending
#' maintenance action applies to.
#' @param ApplyAction &#91;required&#93; The pending maintenance action to apply to this resource.
#' 
#' Valid values: `system-update`, `db-upgrade`
#' @param OptInType &#91;required&#93; A value that specifies the type of opt-in request or undoes an opt-in
#' request. An opt-in request of type `immediate` can\'t be undone.
#' 
#' Valid values:
#' 
#' -   `immediate` - Apply the maintenance action immediately.
#' 
#' -   `next-maintenance` - Apply the maintenance action during the next
#'     maintenance window for the resource.
#' 
#' -   `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
#'     requests.
#'
#' @section Request syntax:
#' ```
#' svc$apply_pending_maintenance_action(
#'   ResourceIdentifier = "string",
#'   ApplyAction = "string",
#'   OptInType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_apply_pending_maintenance_action
docdb_apply_pending_maintenance_action <- function(ResourceIdentifier, ApplyAction, OptInType) {
  op <- new_operation(
    name = "ApplyPendingMaintenanceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$apply_pending_maintenance_action_input(ResourceIdentifier = ResourceIdentifier, ApplyAction = ApplyAction, OptInType = OptInType)
  output <- .docdb$apply_pending_maintenance_action_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$apply_pending_maintenance_action <- docdb_apply_pending_maintenance_action

#' Copies the specified DB cluster parameter group
#'
#' Copies the specified DB cluster parameter group.
#'
#' @usage
#' docdb_copy_db_cluster_parameter_group(
#'   SourceDBClusterParameterGroupIdentifier,
#'   TargetDBClusterParameterGroupIdentifier,
#'   TargetDBClusterParameterGroupDescription, Tags)
#'
#' @param SourceDBClusterParameterGroupIdentifier &#91;required&#93; The identifier or Amazon Resource Name (ARN) for the source DB cluster
#' parameter group.
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB cluster parameter group.
#' 
#' -   If the source DB cluster parameter group is in the same AWS Region
#'     as the copy, specify a valid DB parameter group identifier; for
#'     example, `my-db-cluster-param-group`, or a valid ARN.
#' 
#' -   If the source DB parameter group is in a different AWS Region than
#'     the copy, specify a valid DB cluster parameter group ARN; for
#'     example,
#'     `arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1`.
#' @param TargetDBClusterParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank.
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-param-group1`
#' @param TargetDBClusterParameterGroupDescription &#91;required&#93; A description for the copied DB cluster parameter group.
#' @param Tags The tags that are to be assigned to the parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_cluster_parameter_group(
#'   SourceDBClusterParameterGroupIdentifier = "string",
#'   TargetDBClusterParameterGroupIdentifier = "string",
#'   TargetDBClusterParameterGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_copy_db_cluster_parameter_group
docdb_copy_db_cluster_parameter_group <- function(SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$copy_db_cluster_parameter_group_input(SourceDBClusterParameterGroupIdentifier = SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier = TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription = TargetDBClusterParameterGroupDescription, Tags = Tags)
  output <- .docdb$copy_db_cluster_parameter_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$copy_db_cluster_parameter_group <- docdb_copy_db_cluster_parameter_group

#' Copies a snapshot of a DB cluster
#'
#' Copies a snapshot of a DB cluster.
#' 
#' To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
#' `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name
#' (ARN) of the shared DB cluster snapshot.
#' 
#' To cancel the copy operation after it is in progress, delete the target
#' DB cluster snapshot identified by `TargetDBClusterSnapshotIdentifier`
#' while that DB cluster snapshot is in the *copying* status.
#'
#' @usage
#' docdb_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
#'   TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
#'   Tags)
#'
#' @param SourceDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to copy. This parameter is not
#' case sensitive.
#' 
#' You can\'t copy an encrypted, shared DB cluster snapshot from one AWS
#' Region to another.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the \"available\" state.
#' 
#' -   If the source snapshot is in the same AWS Region as the copy,
#'     specify a valid DB snapshot identifier.
#' 
#' -   If the source snapshot is in a different AWS Region than the copy,
#'     specify a valid DB cluster snapshot ARN.
#' 
#' Example: `my-cluster-snapshot1`
#' @param TargetDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the new DB cluster snapshot to create from the source
#' DB cluster snapshot. This parameter is not case sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot2`
#' @param KmsKeyId The AWS KMS key ID for an encrypted DB cluster snapshot. The AWS KMS key
#' ID is the Amazon Resource Name (ARN), AWS KMS key identifier, or the AWS
#' KMS key alias for the AWS KMS encryption key.
#' 
#' If you copy an encrypted DB cluster snapshot from your AWS account, you
#' can specify a value for `KmsKeyId` to encrypt the copy with a new AWS
#' KMS encryption key. If you don\'t specify a value for `KmsKeyId`, then
#' the copy of the DB cluster snapshot is encrypted with the same AWS KMS
#' key as the source DB cluster snapshot.
#' 
#' If you copy an encrypted DB cluster snapshot that is shared from another
#' AWS account, then you must specify a value for `KmsKeyId`.
#' 
#' To copy an encrypted DB cluster snapshot to another AWS Region, set
#' `KmsKeyId` to the AWS KMS key ID that you want to use to encrypt the
#' copy of the DB cluster snapshot in the destination Region. AWS KMS
#' encryption keys are specific to the AWS Region that they are created in,
#' and you can\'t use encryption keys from one Region in another Region.
#' 
#' If you copy an unencrypted DB cluster snapshot and specify a value for
#' the `KmsKeyId` parameter, an error is returned.
#' @param PreSignedUrl The URL that contains a Signature Version 4 signed request for the
#' `CopyDBClusterSnapshot` API action in the AWS Region that contains the
#' source DB cluster snapshot to copy. You must use the `PreSignedUrl`
#' parameter when copying an encrypted DB cluster snapshot from another AWS
#' Region.
#' 
#' The presigned URL must be a valid request for the
#' `CopyDBSClusterSnapshot` API action that can be executed in the source
#' AWS Region that contains the encrypted DB cluster snapshot to be copied.
#' The presigned URL request must contain the following parameter values:
#' 
#' -   `KmsKeyId` - The AWS KMS key identifier for the key to use to
#'     encrypt the copy of the DB cluster snapshot in the destination AWS
#'     Region. This is the same identifier for both the
#'     `CopyDBClusterSnapshot` action that is called in the destination AWS
#'     Region, and the action contained in the presigned URL.
#' 
#' -   `DestinationRegion` - The name of the AWS Region that the DB cluster
#'     snapshot will be created in.
#' 
#' -   `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
#'     identifier for the encrypted DB cluster snapshot to be copied. This
#'     identifier must be in the Amazon Resource Name (ARN) format for the
#'     source AWS Region. For example, if you are copying an encrypted DB
#'     cluster snapshot from the us-west-2 AWS Region, then your
#'     `SourceDBClusterSnapshotIdentifier` looks like the following
#'     example:
#'     `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:my-cluster-snapshot-20161115`.
#' @param CopyTags Set to `true` to copy all tags from the source DB cluster snapshot to
#' the target DB cluster snapshot, and otherwise `false`. The default is
#' `false`.
#' @param Tags The tags to be assigned to the DB cluster snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_cluster_snapshot(
#'   SourceDBClusterSnapshotIdentifier = "string",
#'   TargetDBClusterSnapshotIdentifier = "string",
#'   KmsKeyId = "string",
#'   PreSignedUrl = "string",
#'   CopyTags = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_copy_db_cluster_snapshot
docdb_copy_db_cluster_snapshot <- function(SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier, KmsKeyId = NULL, PreSignedUrl = NULL, CopyTags = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$copy_db_cluster_snapshot_input(SourceDBClusterSnapshotIdentifier = SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier = TargetDBClusterSnapshotIdentifier, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, CopyTags = CopyTags, Tags = Tags)
  output <- .docdb$copy_db_cluster_snapshot_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$copy_db_cluster_snapshot <- docdb_copy_db_cluster_snapshot

#' Creates a new Amazon DocumentDB DB cluster
#'
#' Creates a new Amazon DocumentDB DB cluster.
#'
#' @usage
#' docdb_create_db_cluster(AvailabilityZones, BackupRetentionPeriod,
#'   DBClusterIdentifier, DBClusterParameterGroupName, VpcSecurityGroupIds,
#'   DBSubnetGroupName, Engine, EngineVersion, Port, MasterUsername,
#'   MasterUserPassword, PreferredBackupWindow, PreferredMaintenanceWindow,
#'   Tags, StorageEncrypted, KmsKeyId, EnableCloudwatchLogsExports,
#'   DeletionProtection)
#'
#' @param AvailabilityZones A list of Amazon EC2 Availability Zones that instances in the DB cluster
#' can be created in.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35.
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB cluster.
#' 
#' Constraints: Must match the name of an existing `DBSubnetGroup`. Must
#' not be default.
#' 
#' Example: `mySubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for this DB cluster.
#' 
#' Valid values: `docdb`
#' @param EngineVersion The version number of the database engine to use.
#' @param Port The port number on which the instances in the DB cluster accept
#' connections.
#' @param MasterUsername &#91;required&#93; The name of the master user for the DB cluster.
#' 
#' Constraints:
#' 
#' -   Must be from 1 to 16 letters or numbers.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot be a reserved word for the chosen database engine.
#' @param MasterUserPassword &#91;required&#93; The password for the master database user. This password can contain any
#' printable ASCII character except forward slash (/), double quote (\"),
#' or the \"at\" symbol (@).
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param Tags The tags to be assigned to the DB cluster.
#' @param StorageEncrypted Specifies whether the DB cluster is encrypted.
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB cluster.
#' 
#' The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
#' KMS encryption key. If you are creating a DB cluster using the same AWS
#' account that owns the AWS KMS encryption key that is used to encrypt the
#' new DB cluster, you can use the AWS KMS key alias instead of the ARN for
#' the AWS KMS encryption key.
#' 
#' If an encryption key is not specified in `KmsKeyId`:
#' 
#' -   If `ReplicationSourceIdentifier` identifies an encrypted source,
#'     then Amazon DocumentDB uses the encryption key that is used to
#'     encrypt the source. Otherwise, Amazon DocumentDB uses your default
#'     encryption key.
#' 
#' -   If the `StorageEncrypted` parameter is `true` and
#'     `ReplicationSourceIdentifier` is not specified, Amazon DocumentDB
#'     uses your default encryption key.
#' 
#' AWS KMS creates the default encryption key for your AWS account. Your
#' AWS account has a different default encryption key for each AWS Region.
#' 
#' If you create a replica of an encrypted DB cluster in another AWS
#' Region, you must set `KmsKeyId` to a KMS key ID that is valid in the
#' destination AWS Region. This key is used to encrypt the replica in that
#' AWS Region.
#' @param EnableCloudwatchLogsExports A list of log types that need to be enabled for exporting to Amazon
#' CloudWatch Logs.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   BackupRetentionPeriod = 123,
#'   DBClusterIdentifier = "string",
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   DBSubnetGroupName = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_cluster
docdb_create_db_cluster <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername, MasterUserPassword, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "CreateDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_cluster_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection)
  output <- .docdb$create_db_cluster_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_cluster <- docdb_create_db_cluster

#' Creates a new DB cluster parameter group
#'
#' Creates a new DB cluster parameter group.
#' 
#' Parameters in a DB cluster parameter group apply to all of the instances
#' in a DB cluster.
#' 
#' A DB cluster parameter group is initially created with the default
#' parameters for the database engine used by instances in the DB cluster.
#' To provide custom values for any of the parameters, you must modify the
#' group after you create it. After you create a DB cluster parameter
#' group, you must associate it with your DB cluster. For the new DB
#' cluster parameter group and associated settings to take effect, you must
#' then reboot the DB instances in the DB cluster without failover.
#' 
#' After you create a DB cluster parameter group, you should wait at least
#' 5 minutes before creating your first DB cluster that uses that DB
#' cluster parameter group as the default parameter group. This allows
#' Amazon DocumentDB to fully complete the create action before the DB
#' cluster parameter group is used as the default for a new DB cluster.
#' This step is especially important for parameters that are critical when
#' creating the default database for a DB cluster, such as the character
#' set for the default database defined by the `character_set_database`
#' parameter.
#'
#' @usage
#' docdb_create_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   DBParameterGroupFamily, Description, Tags)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing `DBClusterParameterGroup`.
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB cluster parameter group family name.
#' @param Description &#91;required&#93; The description for the DB cluster parameter group.
#' @param Tags The tags to be assigned to the DB cluster parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   DBParameterGroupFamily = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_cluster_parameter_group
docdb_create_db_cluster_parameter_group <- function(DBClusterParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .docdb$create_db_cluster_parameter_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_cluster_parameter_group <- docdb_create_db_cluster_parameter_group

#' Creates a snapshot of a DB cluster
#'
#' Creates a snapshot of a DB cluster.
#'
#' @usage
#' docdb_create_db_cluster_snapshot(DBClusterSnapshotIdentifier,
#'   DBClusterIdentifier, Tags)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot1`
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster to create a snapshot for. This
#' parameter is not case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' 
#' Example: `my-cluster`
#' @param Tags The tags to be assigned to the DB cluster snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_snapshot(
#'   DBClusterSnapshotIdentifier = "string",
#'   DBClusterIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_cluster_snapshot
docdb_create_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier, DBClusterIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, DBClusterIdentifier = DBClusterIdentifier, Tags = Tags)
  output <- .docdb$create_db_cluster_snapshot_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_cluster_snapshot <- docdb_create_db_cluster_snapshot

#' Creates a new DB instance
#'
#' Creates a new DB instance.
#'
#' @usage
#' docdb_create_db_instance(DBInstanceIdentifier, DBInstanceClass, Engine,
#'   AvailabilityZone, PreferredMaintenanceWindow, AutoMinorVersionUpgrade,
#'   Tags, DBClusterIdentifier, PromotionTier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance; for example,
#' `db.r5.large`.
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Valid value: `docdb`
#' @param AvailabilityZone The Amazon EC2 Availability Zone that the DB instance is created in.
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint\'s
#' AWS Region.
#' 
#' Example: `us-east-1d`
#' 
#' Constraint: The `AvailabilityZone` parameter can\'t be specified if the
#' `MultiAZ` parameter is set to `true`. The specified Availability Zone
#' must be in the same AWS Region as the current endpoint.
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param AutoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB
#' instance during the maintenance window.
#' 
#' Default: `true`
#' @param Tags The tags to be assigned to the DB instance.
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster that the instance will belong to.
#' @param PromotionTier A value that specifies the order in which an Amazon DocumentDB replica
#' is promoted to the primary instance after a failure of the existing
#' primary instance.
#' 
#' Default: 1
#' 
#' Valid values: 0-15
#'
#' @section Request syntax:
#' ```
#' svc$create_db_instance(
#'   DBInstanceIdentifier = "string",
#'   DBInstanceClass = "string",
#'   Engine = "string",
#'   AvailabilityZone = "string",
#'   PreferredMaintenanceWindow = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   DBClusterIdentifier = "string",
#'   PromotionTier = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_instance
docdb_create_db_instance <- function(DBInstanceIdentifier, DBInstanceClass, Engine, AvailabilityZone = NULL, PreferredMaintenanceWindow = NULL, AutoMinorVersionUpgrade = NULL, Tags = NULL, DBClusterIdentifier, PromotionTier = NULL) {
  op <- new_operation(
    name = "CreateDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, DBInstanceClass = DBInstanceClass, Engine = Engine, AvailabilityZone = AvailabilityZone, PreferredMaintenanceWindow = PreferredMaintenanceWindow, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, Tags = Tags, DBClusterIdentifier = DBClusterIdentifier, PromotionTier = PromotionTier)
  output <- .docdb$create_db_instance_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_instance <- docdb_create_db_instance

#' Creates a new DB subnet group
#'
#' Creates a new DB subnet group. DB subnet groups must contain at least
#' one subnet in at least two Availability Zones in the AWS Region.
#'
#' @usage
#' docdb_create_db_subnet_group(DBSubnetGroupName,
#'   DBSubnetGroupDescription, SubnetIds, Tags)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 letters, numbers, periods,
#' underscores, spaces, or hyphens. Must not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription &#91;required&#93; The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The Amazon EC2 subnet IDs for the DB subnet group.
#' @param Tags The tags to be assigned to the DB subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_subnet_group(
#'   DBSubnetGroupName = "string",
#'   DBSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_create_db_subnet_group
docdb_create_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$create_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .docdb$create_db_subnet_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$create_db_subnet_group <- docdb_create_db_subnet_group

#' Deletes a previously provisioned DB cluster
#'
#' Deletes a previously provisioned DB cluster. When you delete a DB
#' cluster, all automated backups for that DB cluster are deleted and
#' can\'t be recovered. Manual DB cluster snapshots of the specified DB
#' cluster are not deleted.
#'
#' @usage
#' docdb_delete_db_cluster(DBClusterIdentifier, SkipFinalSnapshot,
#'   FinalDBSnapshotIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the DB cluster to be deleted. This
#' parameter isn\'t case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing `DBClusterIdentifier`.
#' @param SkipFinalSnapshot Determines whether a final DB cluster snapshot is created before the DB
#' cluster is deleted. If `true` is specified, no DB cluster snapshot is
#' created. If `false` is specified, a DB cluster snapshot is created
#' before the DB cluster is deleted.
#' 
#' If `SkipFinalSnapshot` is `false`, you must specify a
#' `FinalDBSnapshotIdentifier` parameter.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The DB cluster snapshot identifier of the new DB cluster snapshot
#' created when `SkipFinalSnapshot` is set to `false`.
#' 
#' Specifying this parameter and also setting the `SkipFinalShapshot`
#' parameter to `true` results in an error.
#' 
#' Constraints:
#' 
#' -   Must be from 1 to 255 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster(
#'   DBClusterIdentifier = "string",
#'   SkipFinalSnapshot = TRUE|FALSE,
#'   FinalDBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_cluster
docdb_delete_db_cluster <- function(DBClusterIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .docdb$delete_db_cluster_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_cluster <- docdb_delete_db_cluster

#' Deletes a specified DB cluster parameter group
#'
#' Deletes a specified DB cluster parameter group. The DB cluster parameter
#' group to be deleted can\'t be associated with any DB clusters.
#'
#' @usage
#' docdb_delete_db_cluster_parameter_group(DBClusterParameterGroupName)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB cluster parameter group.
#' 
#' -   You can\'t delete a default DB cluster parameter group.
#' 
#' -   Cannot be associated with any DB clusters.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_cluster_parameter_group
docdb_delete_db_cluster_parameter_group <- function(DBClusterParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .docdb$delete_db_cluster_parameter_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_cluster_parameter_group <- docdb_delete_db_cluster_parameter_group

#' Deletes a DB cluster snapshot
#'
#' Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
#' operation is terminated.
#' 
#' The DB cluster snapshot must be in the `available` state to be deleted.
#'
#' @usage
#' docdb_delete_db_cluster_snapshot(DBClusterSnapshotIdentifier)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to delete.
#' 
#' Constraints: Must be the name of an existing DB cluster snapshot in the
#' `available` state.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_snapshot(
#'   DBClusterSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_cluster_snapshot
docdb_delete_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .docdb$delete_db_cluster_snapshot_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_cluster_snapshot <- docdb_delete_db_cluster_snapshot

#' Deletes a previously provisioned DB instance
#'
#' Deletes a previously provisioned DB instance.
#'
#' @usage
#' docdb_delete_db_instance(DBInstanceIdentifier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier for the DB instance to be deleted. This
#' parameter isn\'t case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB instance.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_instance(
#'   DBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_instance
docdb_delete_db_instance <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "DeleteDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .docdb$delete_db_instance_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_instance <- docdb_delete_db_instance

#' Deletes a DB subnet group
#'
#' Deletes a DB subnet group.
#' 
#' The specified database subnet group must not be associated with any DB
#' instances.
#'
#' @usage
#' docdb_delete_db_subnet_group(DBSubnetGroupName)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name of the database subnet group to delete.
#' 
#' You can\'t delete the default subnet group.
#' 
#' Constraints:
#' 
#' Must match the name of an existing `DBSubnetGroup`. Must not be default.
#' 
#' Example: `mySubnetgroup`
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_subnet_group(
#'   DBSubnetGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_delete_db_subnet_group
docdb_delete_db_subnet_group <- function(DBSubnetGroupName) {
  op <- new_operation(
    name = "DeleteDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$delete_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName)
  output <- .docdb$delete_db_subnet_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$delete_db_subnet_group <- docdb_delete_db_subnet_group

#' Returns a list of DBClusterParameterGroup descriptions
#'
#' Returns a list of `DBClusterParameterGroup` descriptions. If a
#' `DBClusterParameterGroupName` parameter is specified, the list contains
#' only the description of the specified DB cluster parameter group.
#'
#' @usage
#' docdb_describe_db_cluster_parameter_groups(DBClusterParameterGroupName,
#'   Filters, MaxRecords, Marker)
#'
#' @param DBClusterParameterGroupName The name of a specific DB cluster parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If provided, must match the name of an existing
#'     `DBClusterParameterGroup`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_parameter_groups(
#'   DBClusterParameterGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_parameter_groups
docdb_describe_db_cluster_parameter_groups <- function(DBClusterParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_parameter_groups_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_cluster_parameter_groups_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_parameter_groups <- docdb_describe_db_cluster_parameter_groups

#' Returns the detailed parameter list for a particular DB cluster
#' parameter group
#'
#' Returns the detailed parameter list for a particular DB cluster
#' parameter group.
#'
#' @usage
#' docdb_describe_db_cluster_parameters(DBClusterParameterGroupName,
#'   Source, Filters, MaxRecords, Marker)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of a specific DB cluster parameter group to return parameter
#' details for.
#' 
#' Constraints:
#' 
#' -   If provided, must match the name of an existing
#'     `DBClusterParameterGroup`.
#' @param Source A value that indicates to return only parameters for a specific source.
#' Parameter sources can be `engine`, `service`, or `customer`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_parameters(
#'   DBClusterParameterGroupName = "string",
#'   Source = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_parameters
docdb_describe_db_cluster_parameters <- function(DBClusterParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_parameters_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_cluster_parameters_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_parameters <- docdb_describe_db_cluster_parameters

#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot
#'
#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot.
#' 
#' When you share snapshots with other AWS accounts,
#' `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute
#' and a list of IDs for the AWS accounts that are authorized to copy or
#' restore the manual DB cluster snapshot. If `all` is included in the list
#' of values for the `restore` attribute, then the manual DB cluster
#' snapshot is public and can be copied or restored by all AWS accounts.
#'
#' @usage
#' docdb_describe_db_cluster_snapshot_attributes(
#'   DBClusterSnapshotIdentifier)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to describe the attributes
#' for.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_snapshot_attributes(
#'   DBClusterSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_snapshot_attributes
docdb_describe_db_cluster_snapshot_attributes <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_snapshot_attributes_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .docdb$describe_db_cluster_snapshot_attributes_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_snapshot_attributes <- docdb_describe_db_cluster_snapshot_attributes

#' Returns information about DB cluster snapshots
#'
#' Returns information about DB cluster snapshots. This API operation
#' supports pagination.
#'
#' @usage
#' docdb_describe_db_cluster_snapshots(DBClusterIdentifier,
#'   DBClusterSnapshotIdentifier, SnapshotType, Filters, MaxRecords, Marker,
#'   IncludeShared, IncludePublic)
#'
#' @param DBClusterIdentifier The ID of the DB cluster to retrieve the list of DB cluster snapshots
#' for. This parameter can\'t be used with the
#' `DBClusterSnapshotIdentifier` parameter. This parameter is not case
#' sensitive.
#' 
#' Constraints:
#' 
#' -   If provided, must match the identifier of an existing `DBCluster`.
#' @param DBClusterSnapshotIdentifier A specific DB cluster snapshot identifier to describe. This parameter
#' can\'t be used with the `DBClusterIdentifier` parameter. This value is
#' stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   If provided, must match the identifier of an existing
#'     `DBClusterSnapshot`.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of DB cluster snapshots to be returned. You can specify one of
#' the following values:
#' 
#' -   `automated` - Return all DB cluster snapshots that Amazon DocumentDB
#'     has automatically created for your AWS account.
#' 
#' -   `manual` - Return all DB cluster snapshots that you have manually
#'     created for your AWS account.
#' 
#' -   `shared` - Return all manual DB cluster snapshots that have been
#'     shared to your AWS account.
#' 
#' -   `public` - Return all DB cluster snapshots that have been marked as
#'     public.
#' 
#' If you don\'t specify a `SnapshotType` value, then both automated and
#' manual DB cluster snapshots are returned. You can include shared DB
#' cluster snapshots with these results by setting the `IncludeShared`
#' parameter to `true`. You can include public DB cluster snapshots with
#' these results by setting the `IncludePublic` parameter to `true`.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don\'t apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn\'t apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn\'t apply when `SnapshotType` is set to
#' `public`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param IncludeShared Set to `true` to include shared manual DB cluster snapshots from other
#' AWS accounts that this AWS account has been given permission to copy or
#' restore, and otherwise `false`. The default is `false`.
#' @param IncludePublic Set to `true` to include manual DB cluster snapshots that are public and
#' can be copied or restored by any AWS account, and otherwise `false`. The
#' default is `false`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_snapshots(
#'   DBClusterIdentifier = "string",
#'   DBClusterSnapshotIdentifier = "string",
#'   SnapshotType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   IncludeShared = TRUE|FALSE,
#'   IncludePublic = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_cluster_snapshots
docdb_describe_db_cluster_snapshots <- function(DBClusterIdentifier = NULL, DBClusterSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_cluster_snapshots_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic)
  output <- .docdb$describe_db_cluster_snapshots_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_cluster_snapshots <- docdb_describe_db_cluster_snapshots

#' Returns information about provisioned Amazon DocumentDB DB clusters
#'
#' Returns information about provisioned Amazon DocumentDB DB clusters.
#' This API operation supports pagination.
#'
#' @usage
#' docdb_describe_db_clusters(DBClusterIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBClusterIdentifier The user-provided DB cluster identifier. If this parameter is specified,
#' information from only the specific DB cluster is returned. This
#' parameter isn\'t case sensitive.
#' 
#' Constraints:
#' 
#' -   If provided, must match an existing `DBClusterIdentifier`.
#' @param Filters A filter that specifies one or more DB clusters to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list only includes
#'     information about the DB clusters identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_clusters(
#'   DBClusterIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_clusters
docdb_describe_db_clusters <- function(DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_clusters_input(DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_clusters_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_clusters <- docdb_describe_db_clusters

#' Returns a list of the available DB engines
#'
#' Returns a list of the available DB engines.
#'
#' @usage
#' docdb_describe_db_engine_versions(Engine, EngineVersion,
#'   DBParameterGroupFamily, Filters, MaxRecords, Marker, DefaultOnly,
#'   ListSupportedCharacterSets, ListSupportedTimezones)
#'
#' @param Engine The database engine to return.
#' @param EngineVersion The database engine version to return.
#' 
#' Example: `5.1.49`
#' @param DBParameterGroupFamily The name of a specific DB parameter group family to return details for.
#' 
#' Constraints:
#' 
#' -   If provided, must match an existing `DBParameterGroupFamily`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param DefaultOnly Indicates that only the default version of the specified engine or
#' engine and major version combination is returned.
#' @param ListSupportedCharacterSets If this parameter is specified and the requested engine supports the
#' `CharacterSetName` parameter for `CreateDBInstance`, the response
#' includes a list of supported character sets for each engine version.
#' @param ListSupportedTimezones If this parameter is specified and the requested engine supports the
#' `TimeZone` parameter for `CreateDBInstance`, the response includes a
#' list of supported time zones for each engine version.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_engine_versions(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   DefaultOnly = TRUE|FALSE,
#'   ListSupportedCharacterSets = TRUE|FALSE,
#'   ListSupportedTimezones = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_engine_versions
docdb_describe_db_engine_versions <- function(Engine = NULL, EngineVersion = NULL, DBParameterGroupFamily = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL, ListSupportedCharacterSets = NULL, ListSupportedTimezones = NULL) {
  op <- new_operation(
    name = "DescribeDBEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly, ListSupportedCharacterSets = ListSupportedCharacterSets, ListSupportedTimezones = ListSupportedTimezones)
  output <- .docdb$describe_db_engine_versions_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_engine_versions <- docdb_describe_db_engine_versions

#' Returns information about provisioned Amazon DocumentDB instances
#'
#' Returns information about provisioned Amazon DocumentDB instances. This
#' API supports pagination.
#'
#' @usage
#' docdb_describe_db_instances(DBInstanceIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBInstanceIdentifier The user-provided instance identifier. If this parameter is specified,
#' information from only the specific DB instance is returned. This
#' parameter isn\'t case sensitive.
#' 
#' Constraints:
#' 
#' -   If provided, must match the identifier of an existing `DBInstance`.
#' @param Filters A filter that specifies one or more DB instances to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list includes only the
#'     information about the DB instances that are associated with the DB
#'     clusters that are identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     ARNs. The results list includes only the information about the DB
#'     instances that are identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_instances(
#'   DBInstanceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_instances
docdb_describe_db_instances <- function(DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_instances_input(DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_instances_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_instances <- docdb_describe_db_instances

#' Returns a list of DBSubnetGroup descriptions
#'
#' Returns a list of `DBSubnetGroup` descriptions. If a `DBSubnetGroupName`
#' is specified, the list will contain only the descriptions of the
#' specified `DBSubnetGroup`.
#'
#' @usage
#' docdb_describe_db_subnet_groups(DBSubnetGroupName, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBSubnetGroupName The name of the DB subnet group to return details for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_subnet_groups(
#'   DBSubnetGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_db_subnet_groups
docdb_describe_db_subnet_groups <- function(DBSubnetGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_db_subnet_groups_input(DBSubnetGroupName = DBSubnetGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_db_subnet_groups_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_db_subnet_groups <- docdb_describe_db_subnet_groups

#' Returns the default engine and system parameter information for the
#' cluster database engine
#'
#' Returns the default engine and system parameter information for the
#' cluster database engine.
#'
#' @usage
#' docdb_describe_engine_default_cluster_parameters(DBParameterGroupFamily,
#'   Filters, MaxRecords, Marker)
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB cluster parameter group family to return the engine
#' parameter information for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_engine_default_cluster_parameters(
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_engine_default_cluster_parameters
docdb_describe_engine_default_cluster_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_engine_default_cluster_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_engine_default_cluster_parameters_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_engine_default_cluster_parameters <- docdb_describe_engine_default_cluster_parameters

#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type
#'
#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type.
#'
#' @usage
#' docdb_describe_event_categories(SourceType, Filters)
#'
#' @param SourceType The type of source that is generating the events.
#' 
#' Valid values: `db-instance`, `db-parameter-group`, `db-security-group`,
#' `db-snapshot`
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_categories(
#'   SourceType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_event_categories
docdb_describe_event_categories <- function(SourceType = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_event_categories_input(SourceType = SourceType, Filters = Filters)
  output <- .docdb$describe_event_categories_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_event_categories <- docdb_describe_event_categories

#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days
#'
#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days. You can obtain
#' events specific to a particular DB instance, DB security group, DB
#' snapshot, or DB parameter group by providing the name as a parameter. By
#' default, the events of the past hour are returned.
#'
#' @usage
#' docdb_describe_events(SourceIdentifier, SourceType, StartTime, EndTime,
#'   Duration, EventCategories, Filters, MaxRecords, Marker)
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, then all sources are included in the response.
#' 
#' Constraints:
#' 
#' -   If `SourceIdentifier` is provided, `SourceType` must also be
#'     provided.
#' 
#' -   If the source type is `DBInstance`, a `DBInstanceIdentifier` must be
#'     provided.
#' 
#' -   If the source type is `DBSecurityGroup`, a `DBSecurityGroupName`
#'     must be provided.
#' 
#' -   If the source type is `DBParameterGroup`, a `DBParameterGroupName`
#'     must be provided.
#' 
#' -   If the source type is `DBSnapshot`, a `DBSnapshotIdentifier` must be
#'     provided.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format.
#' 
#' Example: 2009-07-08T18:00Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format.
#' 
#' Example: 2009-07-08T18:00Z
#' @param Duration The number of minutes to retrieve events for.
#' 
#' Default: 60
#' @param EventCategories A list of event categories that trigger notifications for an event
#' notification subscription.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   SourceIdentifier = "string",
#'   SourceType = "db-instance"|"db-parameter-group"|"db-security-group"|"db-snapshot"|"db-cluster"|"db-cluster-snapshot",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Duration = 123,
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_events
docdb_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, EventCategories = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, EventCategories = EventCategories, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_events_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_events <- docdb_describe_events

#' Returns a list of orderable DB instance options for the specified engine
#'
#' Returns a list of orderable DB instance options for the specified
#' engine.
#'
#' @usage
#' docdb_describe_orderable_db_instance_options(Engine, EngineVersion,
#'   DBInstanceClass, LicenseModel, Vpc, Filters, MaxRecords, Marker)
#'
#' @param Engine &#91;required&#93; The name of the engine to retrieve DB instance options for.
#' @param EngineVersion The engine version filter value. Specify this parameter to show only the
#' available offerings that match the specified engine version.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings that match the specified DB instance class.
#' @param LicenseModel The license model filter value. Specify this parameter to show only the
#' available offerings that match the specified license model.
#' @param Vpc The virtual private cloud (VPC) filter value. Specify this parameter to
#' show only the available VPC or non-VPC offerings.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_orderable_db_instance_options(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DBInstanceClass = "string",
#'   LicenseModel = "string",
#'   Vpc = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_orderable_db_instance_options
docdb_describe_orderable_db_instance_options <- function(Engine, EngineVersion = NULL, DBInstanceClass = NULL, LicenseModel = NULL, Vpc = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableDBInstanceOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_orderable_db_instance_options_input(Engine = Engine, EngineVersion = EngineVersion, DBInstanceClass = DBInstanceClass, LicenseModel = LicenseModel, Vpc = Vpc, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .docdb$describe_orderable_db_instance_options_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_orderable_db_instance_options <- docdb_describe_orderable_db_instance_options

#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action
#'
#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action.
#'
#' @usage
#' docdb_describe_pending_maintenance_actions(ResourceIdentifier, Filters,
#'   Marker, MaxRecords)
#'
#' @param ResourceIdentifier The ARN of a resource to return pending maintenance actions for.
#' @param Filters A filter that specifies one or more resources to return pending
#' maintenance actions for.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list includes only pending
#'     maintenance actions for the DB clusters identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     ARNs. The results list includes only pending maintenance actions for
#'     the DB instances identified by these ARNs.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' (marker) is included in the response so that the remaining results can
#' be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @section Request syntax:
#' ```
#' svc$describe_pending_maintenance_actions(
#'   ResourceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_describe_pending_maintenance_actions
docdb_describe_pending_maintenance_actions <- function(ResourceIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePendingMaintenanceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$describe_pending_maintenance_actions_input(ResourceIdentifier = ResourceIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .docdb$describe_pending_maintenance_actions_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$describe_pending_maintenance_actions <- docdb_describe_pending_maintenance_actions

#' Forces a failover for a DB cluster
#'
#' Forces a failover for a DB cluster.
#' 
#' A failover for a DB cluster promotes one of the Amazon DocumentDB
#' replicas (read-only instances) in the DB cluster to be the primary
#' instance (the cluster writer).
#' 
#' If the primary instance fails, Amazon DocumentDB automatically fails
#' over to an Amazon DocumentDB replica, if one exists. You can force a
#' failover when you want to simulate a failure of a primary instance for
#' testing.
#'
#' @usage
#' docdb_failover_db_cluster(DBClusterIdentifier,
#'   TargetDBInstanceIdentifier)
#'
#' @param DBClusterIdentifier A DB cluster identifier to force a failover for. This parameter is not
#' case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' @param TargetDBInstanceIdentifier The name of the instance to promote to the primary instance.
#' 
#' You must specify the instance identifier for an Amazon DocumentDB
#' replica in the DB cluster. For example, `mydbcluster-replica1`.
#'
#' @section Request syntax:
#' ```
#' svc$failover_db_cluster(
#'   DBClusterIdentifier = "string",
#'   TargetDBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_failover_db_cluster
docdb_failover_db_cluster <- function(DBClusterIdentifier = NULL, TargetDBInstanceIdentifier = NULL) {
  op <- new_operation(
    name = "FailoverDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$failover_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier)
  output <- .docdb$failover_db_cluster_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$failover_db_cluster <- docdb_failover_db_cluster

#' Lists all tags on an Amazon DocumentDB resource
#'
#' Lists all tags on an Amazon DocumentDB resource.
#'
#' @usage
#' docdb_list_tags_for_resource(ResourceName, Filters)
#'
#' @param ResourceName &#91;required&#93; The Amazon DocumentDB resource with tags to be listed. This value is an
#' Amazon Resource Name (ARN).
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_list_tags_for_resource
docdb_list_tags_for_resource <- function(ResourceName, Filters = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$list_tags_for_resource_input(ResourceName = ResourceName, Filters = Filters)
  output <- .docdb$list_tags_for_resource_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$list_tags_for_resource <- docdb_list_tags_for_resource

#' Modifies a setting for an Amazon DocumentDB DB cluster
#'
#' Modifies a setting for an Amazon DocumentDB DB cluster. You can change
#' one or more database configuration parameters by specifying these
#' parameters and the new values in the request.
#'
#' @usage
#' docdb_modify_db_cluster(DBClusterIdentifier, NewDBClusterIdentifier,
#'   ApplyImmediately, BackupRetentionPeriod, DBClusterParameterGroupName,
#'   VpcSecurityGroupIds, Port, MasterUserPassword, PreferredBackupWindow,
#'   PreferredMaintenanceWindow, CloudwatchLogsExportConfiguration,
#'   EngineVersion, DeletionProtection)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster that is being modified. This
#' parameter is not case sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' @param NewDBClusterIdentifier The new DB cluster identifier for the DB cluster when renaming a DB
#' cluster. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster2`
#' @param ApplyImmediately A value that specifies whether the changes in this request and any
#' pending changes are asynchronously applied as soon as possible,
#' regardless of the `PreferredMaintenanceWindow` setting for the DB
#' cluster. If this parameter is set to `false`, changes to the DB cluster
#' are applied during the next maintenance window.
#' 
#' The `ApplyImmediately` parameter affects only the
#' `NewDBClusterIdentifier` and `MasterUserPassword` values. If you set
#' this parameter value to `false`, the changes to the
#' `NewDBClusterIdentifier` and `MasterUserPassword` values are applied
#' during the next maintenance window. All other changes are applied
#' immediately, regardless of the value of the `ApplyImmediately`
#' parameter.
#' 
#' Default: `false`
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to use for the DB cluster.
#' @param VpcSecurityGroupIds A list of virtual private cloud (VPC) security groups that the DB
#' cluster will belong to.
#' @param Port The port number on which the DB cluster accepts connections.
#' 
#' Constraints: Must be a value from `1150` to `65535`.
#' 
#' Default: The same port as the original DB cluster.
#' @param MasterUserPassword The password for the master database user. This password can contain any
#' printable ASCII character except forward slash (/), double quote (\"),
#' or the \"at\" symbol (@).
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' Amazon CloudWatch Logs for a specific DB instance or DB cluster. The
#' `EnableLogTypes` and `DisableLogTypes` arrays determine which logs are
#' exported (or not exported) to CloudWatch Logs.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Changing this parameter results in an outage. The change is applied
#' during the next maintenance window unless the `ApplyImmediately`
#' parameter is set to `true`.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster(
#'   DBClusterIdentifier = "string",
#'   NewDBClusterIdentifier = "string",
#'   ApplyImmediately = TRUE|FALSE,
#'   BackupRetentionPeriod = 123,
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Port = 123,
#'   MasterUserPassword = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   CloudwatchLogsExportConfiguration = list(
#'     EnableLogTypes = list(
#'       "string"
#'     ),
#'     DisableLogTypes = list(
#'       "string"
#'     )
#'   ),
#'   EngineVersion = "string",
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_cluster
docdb_modify_db_cluster <- function(DBClusterIdentifier, NewDBClusterIdentifier = NULL, ApplyImmediately = NULL, BackupRetentionPeriod = NULL, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, Port = NULL, MasterUserPassword = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, CloudwatchLogsExportConfiguration = NULL, EngineVersion = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "ModifyDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, NewDBClusterIdentifier = NewDBClusterIdentifier, ApplyImmediately = ApplyImmediately, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Port = Port, MasterUserPassword = MasterUserPassword, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, EngineVersion = EngineVersion, DeletionProtection = DeletionProtection)
  output <- .docdb$modify_db_cluster_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_cluster <- docdb_modify_db_cluster

#' Modifies the parameters of a DB cluster parameter group
#'
#' Modifies the parameters of a DB cluster parameter group. To modify more
#' than one parameter, submit a list of the following: `ParameterName`,
#' `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be
#' modified in a single request.
#' 
#' Changes to dynamic parameters are applied immediately. Changes to static
#' parameters require a reboot or maintenance window before the change can
#' take effect.
#' 
#' After you create a DB cluster parameter group, you should wait at least
#' 5 minutes before creating your first DB cluster that uses that DB
#' cluster parameter group as the default parameter group. This allows
#' Amazon DocumentDB to fully complete the create action before the
#' parameter group is used as the default for a new DB cluster. This step
#' is especially important for parameters that are critical when creating
#' the default database for a DB cluster, such as the character set for the
#' default database defined by the `character_set_database` parameter.
#'
#' @usage
#' docdb_modify_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   Parameters)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to modify.
#' @param Parameters &#91;required&#93; A list of parameters in the DB cluster parameter group to modify.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_cluster_parameter_group
docdb_modify_db_cluster_parameter_group <- function(DBClusterParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Parameters = Parameters)
  output <- .docdb$modify_db_cluster_parameter_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_cluster_parameter_group <- docdb_modify_db_cluster_parameter_group

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot
#'
#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot.
#' 
#' To share a manual DB cluster snapshot with other AWS accounts, specify
#' `restore` as the `AttributeName`, and use the `ValuesToAdd` parameter to
#' add a list of IDs of the AWS accounts that are authorized to restore the
#' manual DB cluster snapshot. Use the value `all` to make the manual DB
#' cluster snapshot public, which means that it can be copied or restored
#' by all AWS accounts. Do not add the `all` value for any manual DB
#' cluster snapshots that contain private information that you don\'t want
#' available to all AWS accounts. If a manual DB cluster snapshot is
#' encrypted, it can be shared, but only by specifying a list of authorized
#' AWS account IDs for the `ValuesToAdd` parameter. You can\'t use `all` as
#' a value for that parameter in this case.
#'
#' @usage
#' docdb_modify_db_cluster_snapshot_attribute(DBClusterSnapshotIdentifier,
#'   AttributeName, ValuesToAdd, ValuesToRemove)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB cluster snapshot attribute to modify.
#' 
#' To manage authorization for other AWS accounts to copy or restore a
#' manual DB cluster snapshot, set this value to `restore`.
#' @param ValuesToAdd A list of DB cluster snapshot attributes to add to the attribute
#' specified by `AttributeName`.
#' 
#' To authorize other AWS accounts to copy or restore a manual DB cluster
#' snapshot, set this list to include one or more AWS account IDs. To make
#' the manual DB cluster snapshot restorable by any AWS account, set it to
#' `all`. Do not add the `all` value for any manual DB cluster snapshots
#' that contain private information that you don\'t want to be available to
#' all AWS accounts.
#' @param ValuesToRemove A list of DB cluster snapshot attributes to remove from the attribute
#' specified by `AttributeName`.
#' 
#' To remove authorization for other AWS accounts to copy or restore a
#' manual DB cluster snapshot, set this list to include one or more AWS
#' account identifiers. To remove authorization for any AWS account to copy
#' or restore the DB cluster snapshot, set it to `all` . If you specify
#' `all`, an AWS account whose account ID is explicitly added to the
#' `restore` attribute can still copy or restore a manual DB cluster
#' snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_snapshot_attribute(
#'   DBClusterSnapshotIdentifier = "string",
#'   AttributeName = "string",
#'   ValuesToAdd = list(
#'     "string"
#'   ),
#'   ValuesToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_cluster_snapshot_attribute
docdb_modify_db_cluster_snapshot_attribute <- function(DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_cluster_snapshot_attribute_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .docdb$modify_db_cluster_snapshot_attribute_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_cluster_snapshot_attribute <- docdb_modify_db_cluster_snapshot_attribute

#' Modifies settings for a DB instance
#'
#' Modifies settings for a DB instance. You can change one or more database
#' configuration parameters by specifying these parameters and the new
#' values in the request.
#'
#' @usage
#' docdb_modify_db_instance(DBInstanceIdentifier, DBInstanceClass,
#'   ApplyImmediately, PreferredMaintenanceWindow, AutoMinorVersionUpgrade,
#'   NewDBInstanceIdentifier, PromotionTier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBInstance`.
#' @param DBInstanceClass The new compute and memory capacity of the DB instance; for example,
#' `db.r5.large`. Not all DB instance classes are available in all AWS
#' Regions.
#' 
#' If you modify the DB instance class, an outage occurs during the change.
#' The change is applied during the next maintenance window, unless
#' `ApplyImmediately` is specified as `true` for this request.
#' 
#' Default: Uses existing setting.
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the DB instance.
#' 
#' If this parameter is set to `false`, changes to the DB instance are
#' applied during the next maintenance window. Some parameter changes can
#' cause an outage and are applied on the next reboot.
#' 
#' Default: `false`
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can
#' occur, which might result in an outage. Changing this parameter doesn\'t
#' result in an outage except in the following situation, and the change is
#' asynchronously applied as soon as possible. If there are pending actions
#' that cause a reboot, and the maintenance window is changed to include
#' the current time, changing this parameter causes a reboot of the DB
#' instance. If you are moving this window to the current time, there must
#' be at least 30 minutes between the current time and end of the window to
#' ensure that pending changes are applied.
#' 
#' Default: Uses existing setting.
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
#' 
#' Constraints: Must be at least 30 minutes.
#' @param AutoMinorVersionUpgrade Indicates that minor version upgrades are applied automatically to the
#' DB instance during the maintenance window. Changing this parameter
#' doesn\'t result in an outage except in the following case, and the
#' change is asynchronously applied as soon as possible. An outage results
#' if this parameter is set to `true` during the maintenance window, and a
#' newer minor version is available, and Amazon DocumentDB has enabled
#' automatic patching for that engine version.
#' @param NewDBInstanceIdentifier The new DB instance identifier for the DB instance when renaming a DB
#' instance. When you change the DB instance identifier, an instance reboot
#' occurs immediately if you set `Apply Immediately` to `true`. It occurs
#' during the next maintenance window if you set `Apply Immediately` to
#' `false`. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param PromotionTier A value that specifies the order in which an Amazon DocumentDB replica
#' is promoted to the primary instance after a failure of the existing
#' primary instance.
#' 
#' Default: 1
#' 
#' Valid values: 0-15
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_instance(
#'   DBInstanceIdentifier = "string",
#'   DBInstanceClass = "string",
#'   ApplyImmediately = TRUE|FALSE,
#'   PreferredMaintenanceWindow = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   NewDBInstanceIdentifier = "string",
#'   PromotionTier = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_instance
docdb_modify_db_instance <- function(DBInstanceIdentifier, DBInstanceClass = NULL, ApplyImmediately = NULL, PreferredMaintenanceWindow = NULL, AutoMinorVersionUpgrade = NULL, NewDBInstanceIdentifier = NULL, PromotionTier = NULL) {
  op <- new_operation(
    name = "ModifyDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, DBInstanceClass = DBInstanceClass, ApplyImmediately = ApplyImmediately, PreferredMaintenanceWindow = PreferredMaintenanceWindow, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, NewDBInstanceIdentifier = NewDBInstanceIdentifier, PromotionTier = PromotionTier)
  output <- .docdb$modify_db_instance_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_instance <- docdb_modify_db_instance

#' Modifies an existing DB subnet group
#'
#' Modifies an existing DB subnet group. DB subnet groups must contain at
#' least one subnet in at least two Availability Zones in the AWS Region.
#'
#' @usage
#' docdb_modify_db_subnet_group(DBSubnetGroupName,
#'   DBSubnetGroupDescription, SubnetIds)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string. You can\'t modify the default subnet group.
#' 
#' Constraints: Must match the name of an existing `DBSubnetGroup`. Must
#' not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The Amazon EC2 subnet IDs for the DB subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_subnet_group(
#'   DBSubnetGroupName = "string",
#'   DBSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_modify_db_subnet_group
docdb_modify_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$modify_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .docdb$modify_db_subnet_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$modify_db_subnet_group <- docdb_modify_db_subnet_group

#' You might need to reboot your DB instance, usually for maintenance
#' reasons
#'
#' You might need to reboot your DB instance, usually for maintenance
#' reasons. For example, if you make certain changes, or if you change the
#' DB cluster parameter group that is associated with the DB instance, you
#' must reboot the instance for the changes to take effect.
#' 
#' Rebooting a DB instance restarts the database engine service. Rebooting
#' a DB instance results in a momentary outage, during which the DB
#' instance status is set to *rebooting*.
#'
#' @usage
#' docdb_reboot_db_instance(DBInstanceIdentifier, ForceFailover)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBInstance`.
#' @param ForceFailover When `true`, the reboot is conducted through a Multi-AZ failover.
#' 
#' Constraint: You can\'t specify `true` if the instance is not configured
#' for Multi-AZ.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_db_instance(
#'   DBInstanceIdentifier = "string",
#'   ForceFailover = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_reboot_db_instance
docdb_reboot_db_instance <- function(DBInstanceIdentifier, ForceFailover = NULL) {
  op <- new_operation(
    name = "RebootDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$reboot_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, ForceFailover = ForceFailover)
  output <- .docdb$reboot_db_instance_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$reboot_db_instance <- docdb_reboot_db_instance

#' Removes metadata tags from an Amazon DocumentDB resource
#'
#' Removes metadata tags from an Amazon DocumentDB resource.
#'
#' @usage
#' docdb_remove_tags_from_resource(ResourceName, TagKeys)
#'
#' @param ResourceName &#91;required&#93; The Amazon DocumentDB resource that the tags are removed from. This
#' value is an Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_remove_tags_from_resource
docdb_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .docdb$remove_tags_from_resource_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$remove_tags_from_resource <- docdb_remove_tags_from_resource

#' Modifies the parameters of a DB cluster parameter group to the default
#' value
#'
#' Modifies the parameters of a DB cluster parameter group to the default
#' value. To reset specific parameters, submit a list of the following:
#' `ParameterName` and `ApplyMethod`. To reset the entire DB cluster
#' parameter group, specify the `DBClusterParameterGroupName` and
#' `ResetAllParameters` parameters.
#' 
#' When you reset the entire group, dynamic parameters are updated
#' immediately and static parameters are set to `pending-reboot` to take
#' effect on the next DB instance reboot.
#'
#' @usage
#' docdb_reset_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   ResetAllParameters, Parameters)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to reset.
#' @param ResetAllParameters A value that is set to `true` to reset all parameters in the DB cluster
#' parameter group to their default values, and `false` otherwise. You
#' can\'t use this parameter if there is a list of parameter names
#' specified for the `Parameters` parameter.
#' @param Parameters A list of parameter names in the DB cluster parameter group to reset to
#' the default values. You can\'t use this parameter if the
#' `ResetAllParameters` parameter is set to `true`.
#'
#' @section Request syntax:
#' ```
#' svc$reset_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_reset_db_cluster_parameter_group
docdb_reset_db_cluster_parameter_group <- function(DBClusterParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$reset_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .docdb$reset_db_cluster_parameter_group_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$reset_db_cluster_parameter_group <- docdb_reset_db_cluster_parameter_group

#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot
#'
#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
#' 
#' If a DB snapshot is specified, the target DB cluster is created from the
#' source DB snapshot with a default configuration and default security
#' group.
#' 
#' If a DB cluster snapshot is specified, the target DB cluster is created
#' from the source DB cluster restore point with the same configuration as
#' the original source DB cluster, except that the new DB cluster is
#' created with the default security group.
#'
#' @usage
#' docdb_restore_db_cluster_from_snapshot(AvailabilityZones,
#'   DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
#'   DBSubnetGroupName, VpcSecurityGroupIds, Tags, KmsKeyId,
#'   EnableCloudwatchLogsExports, DeletionProtection)
#'
#' @param AvailabilityZones Provides the list of Amazon EC2 Availability Zones that instances in the
#' restored DB cluster can be created in.
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the DB snapshot or DB cluster
#' snapshot. This parameter isn\'t case sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-snapshot-id`
#' @param SnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot or DB cluster snapshot to restore
#' from.
#' 
#' You can use either the name or the Amazon Resource Name (ARN) to specify
#' a DB cluster snapshot. However, you can use only the ARN to specify a DB
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing snapshot.
#' @param Engine &#91;required&#93; The database engine to use for the new DB cluster.
#' 
#' Default: The same as source.
#' 
#' Constraint: Must be compatible with the engine of the source.
#' @param EngineVersion The version of the database engine to use for the new DB cluster.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: Must be a value from `1150` to `65535`.
#' 
#' Default: The same port as the original DB cluster.
#' @param DBSubnetGroupName The name of the DB subnet group to use for the new DB cluster.
#' 
#' Constraints: If provided, must match the name of an existing
#' `DBSubnetGroup`.
#' 
#' Example: `mySubnetgroup`
#' @param VpcSecurityGroupIds A list of virtual private cloud (VPC) security groups that the new DB
#' cluster will belong to.
#' @param Tags The tags to be assigned to the restored DB cluster.
#' @param KmsKeyId The AWS KMS key identifier to use when restoring an encrypted DB cluster
#' from a DB snapshot or DB cluster snapshot.
#' 
#' The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
#' KMS encryption key. If you are restoring a DB cluster with the same AWS
#' account that owns the AWS KMS encryption key used to encrypt the new DB
#' cluster, then you can use the AWS KMS key alias instead of the ARN for
#' the AWS KMS encryption key.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     encrypted, then the restored DB cluster is encrypted using the AWS
#'     KMS key that was used to encrypt the DB snapshot or the DB cluster
#'     snapshot.
#' 
#' -   If the DB snapshot or the DB cluster snapshot in
#'     `SnapshotIdentifier` is not encrypted, then the restored DB cluster
#'     is not encrypted.
#' @param EnableCloudwatchLogsExports A list of log types that must be enabled for exporting to Amazon
#' CloudWatch Logs.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_from_snapshot(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   DBClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   DBSubnetGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_restore_db_cluster_from_snapshot
docdb_restore_db_cluster_from_snapshot <- function(AvailabilityZones = NULL, DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion = NULL, Port = NULL, DBSubnetGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$restore_db_cluster_from_snapshot_input(AvailabilityZones = AvailabilityZones, DBClusterIdentifier = DBClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, Engine = Engine, EngineVersion = EngineVersion, Port = Port, DBSubnetGroupName = DBSubnetGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection)
  output <- .docdb$restore_db_cluster_from_snapshot_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$restore_db_cluster_from_snapshot <- docdb_restore_db_cluster_from_snapshot

#' Restores a DB cluster to an arbitrary point in time
#'
#' Restores a DB cluster to an arbitrary point in time. Users can restore
#' to any point in time before `LatestRestorableTime` for up to
#' `BackupRetentionPeriod` days. The target DB cluster is created from the
#' source DB cluster with the same configuration as the original DB
#' cluster, except that the new DB cluster is created with the default DB
#' security group.
#'
#' @usage
#' docdb_restore_db_cluster_to_point_in_time(DBClusterIdentifier,
#'   SourceDBClusterIdentifier, RestoreToTime, UseLatestRestorableTime, Port,
#'   DBSubnetGroupName, VpcSecurityGroupIds, Tags, KmsKeyId,
#'   EnableCloudwatchLogsExports, DeletionProtection)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the new DB cluster to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SourceDBClusterIdentifier &#91;required&#93; The identifier of the source DB cluster from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing `DBCluster`.
#' @param RestoreToTime The date and time to restore the DB cluster to.
#' 
#' Valid values: A time in Universal Coordinated Time (UTC) format.
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance.
#' 
#' -   Must be specified if the `UseLatestRestorableTime` parameter is not
#'     provided.
#' 
#' -   Cannot be specified if the `UseLatestRestorableTime` parameter is
#'     `true`.
#' 
#' -   Cannot be specified if the `RestoreType` parameter is
#'     `copy-on-write`.
#' 
#' Example: `2015-03-07T23:45:00Z`
#' @param UseLatestRestorableTime A value that is set to `true` to restore the DB cluster to the latest
#' restorable backup time, and `false` otherwise.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if the `RestoreToTime` parameter is
#' provided.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: Must be a value from `1150` to `65535`.
#' 
#' Default: The default port for the engine.
#' @param DBSubnetGroupName The DB subnet group name to use for the new DB cluster.
#' 
#' Constraints: If provided, must match the name of an existing
#' `DBSubnetGroup`.
#' 
#' Example: `mySubnetgroup`
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster belongs to.
#' @param Tags The tags to be assigned to the restored DB cluster.
#' @param KmsKeyId The AWS KMS key identifier to use when restoring an encrypted DB cluster
#' from an encrypted DB cluster.
#' 
#' The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
#' KMS encryption key. If you are restoring a DB cluster with the same AWS
#' account that owns the AWS KMS encryption key used to encrypt the new DB
#' cluster, then you can use the AWS KMS key alias instead of the ARN for
#' the AWS KMS encryption key.
#' 
#' You can restore to a new DB cluster and encrypt the new DB cluster with
#' an AWS KMS key that is different from the AWS KMS key used to encrypt
#' the source DB cluster. The new DB cluster is encrypted with the AWS KMS
#' key identified by the `KmsKeyId` parameter.
#' 
#' If you do not specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the DB cluster is encrypted, then the restored DB cluster is
#'     encrypted using the AWS KMS key that was used to encrypt the source
#'     DB cluster.
#' 
#' -   If the DB cluster is not encrypted, then the restored DB cluster is
#'     not encrypted.
#' 
#' If `DBClusterIdentifier` refers to a DB cluster that is not encrypted,
#' then the restore request is rejected.
#' @param EnableCloudwatchLogsExports A list of log types that must be enabled for exporting to Amazon
#' CloudWatch Logs.
#' @param DeletionProtection Specifies whether this cluster can be deleted. If `DeletionProtection`
#' is enabled, the cluster cannot be deleted unless it is modified and
#' `DeletionProtection` is disabled. `DeletionProtection` protects clusters
#' from being accidentally deleted.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_to_point_in_time(
#'   DBClusterIdentifier = "string",
#'   SourceDBClusterIdentifier = "string",
#'   RestoreToTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UseLatestRestorableTime = TRUE|FALSE,
#'   Port = 123,
#'   DBSubnetGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_restore_db_cluster_to_point_in_time
docdb_restore_db_cluster_to_point_in_time <- function(DBClusterIdentifier, SourceDBClusterIdentifier, RestoreToTime = NULL, UseLatestRestorableTime = NULL, Port = NULL, DBSubnetGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$restore_db_cluster_to_point_in_time_input(DBClusterIdentifier = DBClusterIdentifier, SourceDBClusterIdentifier = SourceDBClusterIdentifier, RestoreToTime = RestoreToTime, UseLatestRestorableTime = UseLatestRestorableTime, Port = Port, DBSubnetGroupName = DBSubnetGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection)
  output <- .docdb$restore_db_cluster_to_point_in_time_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$restore_db_cluster_to_point_in_time <- docdb_restore_db_cluster_to_point_in_time

#' Restarts the stopped cluster that is specified by DBClusterIdentifier
#'
#' Restarts the stopped cluster that is specified by `DBClusterIdentifier`.
#' For more information, see [Stopping and Starting an Amazon DocumentDB
#' Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
#'
#' @usage
#' docdb_start_db_cluster(DBClusterIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the cluster to restart. Example:
#' `docdb-2019-05-28-15-24-52`
#'
#' @section Request syntax:
#' ```
#' svc$start_db_cluster(
#'   DBClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_start_db_cluster
docdb_start_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StartDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$start_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .docdb$start_db_cluster_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$start_db_cluster <- docdb_start_db_cluster

#' Stops the running cluster that is specified by DBClusterIdentifier
#'
#' Stops the running cluster that is specified by `DBClusterIdentifier`.
#' The cluster must be in the *available* state. For more information, see
#' [Stopping and Starting an Amazon DocumentDB
#' Cluster](https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
#'
#' @usage
#' docdb_stop_db_cluster(DBClusterIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the cluster to stop. Example:
#' `docdb-2019-05-28-15-24-52`
#'
#' @section Request syntax:
#' ```
#' svc$stop_db_cluster(
#'   DBClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname docdb_stop_db_cluster
docdb_stop_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StopDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .docdb$stop_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .docdb$stop_db_cluster_output()
  svc <- .docdb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.docdb$operations$stop_db_cluster <- docdb_stop_db_cluster
