% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_instance}
\alias{neptune_modify_db_instance}
\title{Modifies settings for a DB instance}
\usage{
neptune_modify_db_instance(DBInstanceIdentifier, AllocatedStorage,
  DBInstanceClass, DBSubnetGroupName, DBSecurityGroups,
  VpcSecurityGroupIds, ApplyImmediately, MasterUserPassword,
  DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
  PreferredMaintenanceWindow, MultiAZ, EngineVersion,
  AllowMajorVersionUpgrade, AutoMinorVersionUpgrade, LicenseModel, Iops,
  OptionGroupName, NewDBInstanceIdentifier, StorageType, TdeCredentialArn,
  TdeCredentialPassword, CACertificateIdentifier, Domain,
  CopyTagsToSnapshot, MonitoringInterval, DBPortNumber,
  PubliclyAccessible, MonitoringRoleArn, DomainIAMRoleName, PromotionTier,
  EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
  PerformanceInsightsKMSKeyId, CloudwatchLogsExportConfiguration)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{AllocatedStorage}{The new amount of storage (in gibibytes) to allocate for the DB
instance.

Not applicable. Storage is managed by the DB Cluster.}

\item{DBInstanceClass}{The new compute and memory capacity of the DB instance, for example,
\code{db.m4.large}. Not all DB instance classes are available in all AWS
Regions.

If you modify the DB instance class, an outage occurs during the change.
The change is applied during the next maintenance window, unless
\code{ApplyImmediately} is specified as \code{true} for this request.

Default: Uses existing setting}

\item{DBSubnetGroupName}{The new DB subnet group for the DB instance. You can use this parameter
to move your DB instance to a different VPC.

Changing the subnet group causes an outage during the change. The change
is applied during the next maintenance window, unless you specify \code{true}
for the \code{ApplyImmediately} parameter.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetGroup}}

\item{DBSecurityGroups}{A list of DB security groups to authorize on this DB instance. Changing
this setting doesn't result in an outage and the change is
asynchronously applied as soon as possible.

Constraints:
\itemize{
\item If supplied, must match existing DBSecurityGroups.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to authorize on this DB instance. This
change is asynchronously applied as soon as possible.

Not applicable. The associated list of EC2 VPC security groups is
managed by the DB cluster. For more information, see ModifyDBCluster.

Constraints:
\itemize{
\item If supplied, must match existing VpcSecurityGroupIds.
}}

\item{ApplyImmediately}{Specifies whether the modifications in this request and any pending
modifications are asynchronously applied as soon as possible, regardless
of the \code{PreferredMaintenanceWindow} setting for the DB instance.

If this parameter is set to \code{false}, changes to the DB instance are
applied during the next maintenance window. Some parameter changes can
cause an outage and are applied on the next call to RebootDBInstance, or
the next failure reboot.

Default: \code{false}}

\item{MasterUserPassword}{The new password for the master user. The password can include any
printable ASCII character except "/", """, or "@".

Not applicable.

Default: Uses existing setting}

\item{DBParameterGroupName}{The name of the DB parameter group to apply to the DB instance. Changing
this setting doesn't result in an outage. The parameter group name
itself is changed immediately, but the actual parameter changes are not
applied until you reboot the instance without failover. The db instance
will NOT be rebooted automatically and the parameter changes will NOT be
applied during the next maintenance window.

Default: Uses existing setting

Constraints: The DB parameter group must be in the same DB parameter
group family as this DB instance.}

\item{BackupRetentionPeriod}{The number of days to retain automated backups. Setting this parameter
to a positive number enables backups. Setting this parameter to 0
disables automated backups.

Not applicable. The retention period for automated backups is managed by
the DB cluster. For more information, see ModifyDBCluster.

Default: Uses existing setting}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled.

Not applicable. The daily time range for creating automated backups is
managed by the DB cluster. For more information, see ModifyDBCluster.

Constraints:
\itemize{
\item Must be in the format hh24:mi-hh24:mi
\item Must be in Universal Time Coordinated (UTC)
\item Must not conflict with the preferred maintenance window
\item Must be at least 30 minutes
}}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which system maintenance can
occur, which might result in an outage. Changing this parameter doesn't
result in an outage, except in the following situation, and the change
is asynchronously applied as soon as possible. If there are pending
actions that cause a reboot, and the maintenance window is changed to
include the current time, then changing this parameter will cause a
reboot of the DB instance. If moving this window to the current time,
there must be at least 30 minutes between the current time and end of
the window to ensure pending changes are applied.

Default: Uses existing setting

Format: ddd:hh24:mi-ddd:hh24:mi

Valid Days: Mon \| Tue \| Wed \| Thu \| Fri \| Sat \| Sun

Constraints: Must be at least 30 minutes}

\item{MultiAZ}{Specifies if the DB instance is a Multi-AZ deployment. Changing this
parameter doesn't result in an outage and the change is applied during
the next maintenance window unless the \code{ApplyImmediately} parameter is
set to \code{true} for this request.}

\item{EngineVersion}{The version number of the database engine to upgrade to. Changing this
parameter results in an outage and the change is applied during the next
maintenance window unless the \code{ApplyImmediately} parameter is set to
\code{true} for this request.

For major version upgrades, if a nondefault DB parameter group is
currently in use, a new DB parameter group in the DB parameter group
family for the new engine version must be specified. The new DB
parameter group can be the default for that DB parameter group family.}

\item{AllowMajorVersionUpgrade}{Indicates that major version upgrades are allowed. Changing this
parameter doesn't result in an outage and the change is asynchronously
applied as soon as possible.

Constraints: This parameter must be set to true when specifying a value
for the EngineVersion parameter that is a different major version than
the DB instance's current version.}

\item{AutoMinorVersionUpgrade}{Indicates that minor version upgrades are applied automatically to the
DB instance during the maintenance window. Changing this parameter
doesn't result in an outage except in the following case and the change
is asynchronously applied as soon as possible. An outage will result if
this parameter is set to \code{true} during the maintenance window, and a
newer minor version is available, and Neptune has enabled auto patching
for that engine version.}

\item{LicenseModel}{The license model for the DB instance.

Valid values: \code{license-included} \| \code{bring-your-own-license} \|
\code{general-public-license}}

\item{Iops}{The new Provisioned IOPS (I/O operations per second) value for the
instance.

Changing this setting doesn't result in an outage and the change is
applied during the next maintenance window unless the \code{ApplyImmediately}
parameter is set to \code{true} for this request.

Default: Uses existing setting}

\item{OptionGroupName}{Indicates that the DB instance should be associated with the specified
option group. Changing this parameter doesn't result in an outage
except in the following case and the change is applied during the next
maintenance window unless the \code{ApplyImmediately} parameter is set to
\code{true} for this request. If the parameter change results in an option
group that enables OEM, this change can cause a brief (sub-second)
period during which new connections are rejected but existing
connections are not interrupted.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group
can't be removed from a DB instance once it is associated with a DB
instance}

\item{NewDBInstanceIdentifier}{The new DB instance identifier for the DB instance when renaming a DB
instance. When you change the DB instance identifier, an instance reboot
will occur immediately if you set \code{Apply Immediately} to true, or will
occur during the next maintenance window if \code{Apply Immediately} to
false. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

If you specify Provisioned IOPS (\code{io1}), you must also include a value
for the \code{Iops} parameter.

If you choose to migrate your DB instance from using standard storage to
using Provisioned IOPS, or from using Provisioned IOPS to using standard
storage, the process can take time. The duration of the migration
depends on several factors such as database load, storage size, storage
type (standard or Provisioned IOPS), amount of IOPS provisioned (if
any), and the number of prior scale storage operations. Typical
migration times are under 24 hours, but the process can take up to
several days in some cases. During the migration, the DB instance is
available for use, but might experience performance degradation. While
the migration takes place, nightly backups for the instance are
suspended. No other Amazon Neptune operations can take place for the
instance, including modifying the instance, rebooting the instance,
deleting the instance, creating a Read Replica for the instance, and
creating a DB snapshot of the instance.

Valid values: \code{standard | gp2 | io1}

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise
\code{standard}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{CACertificateIdentifier}{Indicates the certificate that needs to be associated with the instance.}

\item{Domain}{Not supported.}

\item{CopyTagsToSnapshot}{True to copy all tags from the DB instance to snapshots of the DB
instance, and otherwise false. The default is false.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0. The default is 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: \code{0, 1, 5, 10, 15, 30, 60}}

\item{DBPortNumber}{The port number on which the database accepts connections.

The value of the \code{DBPortNumber} parameter must not match any of the port
values specified for options in the option group for the DB instance.

Your database will restart when you change the \code{DBPortNumber} value
regardless of the value of the \code{ApplyImmediately} parameter.

Default: \code{8182}}

\item{PubliclyAccessible}{This parameter is not supported.}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits Neptune to send enhanced
monitoring metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}.

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{DomainIAMRoleName}{Not supported}

\item{PromotionTier}{A value that specifies the order in which a Read Replica is promoted to
the primary instance after a failure of the existing primary instance.

Default: 1

Valid Values: 0 - 15}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

You can enable IAM database authentication for the following database
engines

Not applicable. Mapping AWS IAM accounts to database accounts is managed
by the DB cluster. For more information, see ModifyDBCluster.

Default: \code{false}}

\item{EnablePerformanceInsights}{True to enable Performance Insights for the DB instance, and otherwise
false.}

\item{PerformanceInsightsKMSKeyId}{The AWS KMS key identifier for encryption of Performance Insights data.
The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
the KMS key alias for the KMS encryption key.}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB instance or DB cluster.}
}
\description{
Modifies settings for a DB instance. You can change one or more database
configuration parameters by specifying these parameters and the new
values in the request. To learn what modifications you can make to your
DB instance, call DescribeValidDBInstanceModifications before you call
ModifyDBInstance.
}
\section{Request syntax}{
\preformatted{svc$modify_db_instance(
  DBInstanceIdentifier = "string",
  AllocatedStorage = 123,
  DBInstanceClass = "string",
  DBSubnetGroupName = "string",
  DBSecurityGroups = list(
    "string"
  ),
  VpcSecurityGroupIds = list(
    "string"
  ),
  ApplyImmediately = TRUE|FALSE,
  MasterUserPassword = "string",
  DBParameterGroupName = "string",
  BackupRetentionPeriod = 123,
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  MultiAZ = TRUE|FALSE,
  EngineVersion = "string",
  AllowMajorVersionUpgrade = TRUE|FALSE,
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  Iops = 123,
  OptionGroupName = "string",
  NewDBInstanceIdentifier = "string",
  StorageType = "string",
  TdeCredentialArn = "string",
  TdeCredentialPassword = "string",
  CACertificateIdentifier = "string",
  Domain = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  MonitoringInterval = 123,
  DBPortNumber = 123,
  PubliclyAccessible = TRUE|FALSE,
  MonitoringRoleArn = "string",
  DomainIAMRoleName = "string",
  PromotionTier = 123,
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnablePerformanceInsights = TRUE|FALSE,
  PerformanceInsightsKMSKeyId = "string",
  CloudwatchLogsExportConfiguration = list(
    EnableLogTypes = list(
      "string"
    ),
    DisableLogTypes = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
