% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_put_email_identity_dkim_signing_attributes}
\alias{sesv2_put_email_identity_dkim_signing_attributes}
\title{Used to configure or change the DKIM authentication settings for an
email domain identity}
\usage{
sesv2_put_email_identity_dkim_signing_attributes(
  EmailIdentity,
  SigningAttributesOrigin,
  SigningAttributes = NULL
)
}
\arguments{
\item{EmailIdentity}{[required] The email identity.}

\item{SigningAttributesOrigin}{[required] The method to use to configure DKIM for the identity. There are the
following possible values:
\itemize{
\item \code{AWS_SES} – Configure DKIM for the identity by using \href{https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html}{Easy DKIM}.
\item \code{EXTERNAL} – Configure DKIM for the identity by using Bring Your Own
DKIM (BYODKIM).
}}

\item{SigningAttributes}{An object that contains information about the private key and selector
that you want to use to configure DKIM for the identity for Bring Your
Own DKIM (BYODKIM) for the identity, or, configures the key length to be
used for \href{https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html}{Easy DKIM}.}
}
\description{
Used to configure or change the DKIM authentication settings for an email domain identity. You can use this operation to do any of the following:

See \url{https://paws-r.github.io/docs/sesv2/put_email_identity_dkim_signing_attributes.html} for full documentation.
}
\keyword{internal}
