% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_delete_identity_policy}
\alias{ses_delete_identity_policy}
\title{Deletes the specified sending authorization policy for the given
identity (an email address or a domain)}
\usage{
ses_delete_identity_policy(Identity, PolicyName)
}
\arguments{
\item{Identity}{[required] The identity that is associated with the policy that you want to delete.
You can specify the identity by using its name or by using its Amazon
Resource Name (ARN). Examples: \code{user@example.com}, \code{example.com},
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}.

To successfully call this API, you must own the identity.}

\item{PolicyName}{[required] The name of the policy to be deleted.}
}
\value{
An empty list.
}
\description{
Deletes the specified sending authorization policy for the given
identity (an email address or a domain). This API returns successfully
even if a policy with the specified name does not exist.

This API is for the identity owner only. If you have not verified the
identity, this API will return an error.

Sending authorization is a feature that enables an identity owner to
authorize other senders to use its identities. For information about
using sending authorization, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$delete_identity_policy(
  Identity = "string",
  PolicyName = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes a sending authorization policy for an
# identity:
svc$delete_identity_policy(
  Identity = "user@example.com",
  PolicyName = "MyPolicy"
)
}

}
\keyword{internal}
