% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_send_raw_email}
\alias{ses_send_raw_email}
\title{Composes an email message and immediately queues it for sending}
\usage{
ses_send_raw_email(Source, Destinations, RawMessage, FromArn, SourceArn,
  ReturnPathArn, Tags, ConfigurationSetName)
}
\arguments{
\item{Source}{The identity's email address. If you do not provide a value for this
parameter, you must specify a "From" address in the raw text of the
message. (You can also specify both.)

Amazon SES does not support the SMTPUTF8 extension, as described
in\href{https://tools.ietf.org/html/rfc6531}{RFC6531}. For this reason, the
\emph{local part} of a source email address (the part of the email address
that precedes the @ sign) may only contain \href{https://en.wikipedia.org/wiki/Email_address#Local-part}{7-bit ASCII characters}. If
the \emph{domain part} of an address (the part after the @ sign) contains
non-ASCII characters, they must be encoded using Punycode, as described
in \href{https://tools.ietf.org/html/rfc3492.html}{RFC3492}. The sender name
(also known as the \emph{friendly name}) may contain non-ASCII characters.
These characters must be encoded using MIME encoded-word syntax, as
described in \href{https://tools.ietf.org/html/rfc2047}{RFC 2047}. MIME
encoded-word syntax uses the following form:
\code{=?charset?encoding?encoded-text?=}.

If you specify the \code{Source} parameter and have feedback forwarding
enabled, then bounces and complaints will be sent to this email address.
This takes precedence over any Return-Path header that you might include
in the raw text of the message.}

\item{Destinations}{A list of destinations for the message, consisting of To:, CC:, and BCC:
addresses.}

\item{RawMessage}{[required] The raw email message itself. The message has to meet the following
criteria:
\itemize{
\item The message has to contain a header and a body, separated by a blank
line.
\item All of the required header fields must be present in the message.
\item Each part of a multipart MIME message must be formatted properly.
\item Attachments must be of a content type that Amazon SES supports. For
a list on unsupported content types, see \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html}{Unsupported Attachment Types}
in the \emph{Amazon SES Developer Guide}.
\item The entire message must be base64-encoded.
\item If any of the MIME parts in your message contain content that is
outside of the 7-bit ASCII character range, we highly recommend that
you encode that content. For more information, see \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html}{Sending Raw Email}
in the \emph{Amazon SES Developer Guide}.
\item Per \href{https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6}{RFC 5321}, the
maximum length of each line of text, including the \<CRLF\>, must
not exceed 1,000 characters.
}}

\item{FromArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to specify a particular "From" address in the header
of the raw email.

Instead of using this parameter, you can use the X-header
\code{X-SES-FROM-ARN} in the raw message of the email. If you use both the
\code{FromArn} parameter and the corresponding X-header, Amazon SES uses the
value of the \code{FromArn} parameter.

For information about when to use this parameter, see the description of
\code{SendRawEmail} in this guide, or see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html}{Amazon SES Developer Guide}.}

\item{SourceArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to send for the email address specified in the \code{Source}
parameter.

For example, if the owner of \code{example.com} (which has ARN
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}) attaches a
policy to it that authorizes you to send from \code{user@example.com}, then
you would specify the \code{SourceArn} to be
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}, and the
\code{Source} to be \code{user@example.com}.

Instead of using this parameter, you can use the X-header
\code{X-SES-SOURCE-ARN} in the raw message of the email. If you use both the
\code{SourceArn} parameter and the corresponding X-header, Amazon SES uses
the value of the \code{SourceArn} parameter.

For information about when to use this parameter, see the description of
\code{SendRawEmail} in this guide, or see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html}{Amazon SES Developer Guide}.}

\item{ReturnPathArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to use the email address specified in the \code{ReturnPath}
parameter.

For example, if the owner of \code{example.com} (which has ARN
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}) attaches a
policy to it that authorizes you to use \code{feedback@example.com}, then you
would specify the \code{ReturnPathArn} to be
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}, and the
\code{ReturnPath} to be \code{feedback@example.com}.

Instead of using this parameter, you can use the X-header
\code{X-SES-RETURN-PATH-ARN} in the raw message of the email. If you use both
the \code{ReturnPathArn} parameter and the corresponding X-header, Amazon SES
uses the value of the \code{ReturnPathArn} parameter.

For information about when to use this parameter, see the description of
\code{SendRawEmail} in this guide, or see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html}{Amazon SES Developer Guide}.}

\item{Tags}{A list of tags, in the form of name/value pairs, to apply to an email
that you send using \code{SendRawEmail}. Tags correspond to characteristics
of the email that you define, so that you can publish email sending
events.}

\item{ConfigurationSetName}{The name of the configuration set to use when you send an email using
\code{SendRawEmail}.}
}
\description{
Composes an email message and immediately queues it for sending.
}
\details{
This operation is more flexible than the \code{SendEmail} API operation. When
you use the \code{SendRawEmail} operation, you can specify the headers of the
message as well as its content. This flexibility is useful, for example,
when you want to send a multipart MIME email (such a message that
contains both a text and an HTML version). You can also use this
operation to send messages that include attachments.

The \code{SendRawEmail} operation has the following requirements:
\itemize{
\item You can only send email from \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html}{verified email addresses or domains}.
If you try to send email from an address that isn't verified, the
operation results in an "Email address not verified" error.
\item If your account is still in the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/request-production-access.html}{Amazon SES sandbox},
you can only send email to other verified addresses in your account,
or to addresses that are associated with the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mailbox-simulator.html}{Amazon SES mailbox simulator}.
\item The maximum message size, including attachments, is 10 MB.
\item Each message has to include at least one recipient address. A
recipient address includes any address on the To:, CC:, or BCC:
lines.
\item If you send a single message to more than one recipient address, and
one of the recipient addresses isn't in a valid format (that is,
it's not in the format
\emph{UserName@[SubDomain.]Domain.TopLevelDomain}), Amazon SES rejects
the entire message, even if the other addresses are valid.
\item Each message can include up to 50 recipient addresses across the
To:, CC:, or BCC: lines. If you need to send a single message to
more than 50 recipients, you have to split the list of recipient
addresses into groups of less than 50 recipients, and send separate
messages to each group.
\item Amazon SES allows you to specify 8-bit Content-Transfer-Encoding for
MIME message parts. However, if Amazon SES has to modify the
contents of your message (for example, if you use open and click
tracking), 8-bit content isn't preserved. For this reason, we
highly recommend that you encode all content that isn't 7-bit
ASCII. For more information, see \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html#send-email-mime-encoding}{MIME Encoding}
in the \emph{Amazon SES Developer Guide}.
}

Additionally, keep the following considerations in mind when using the
\code{SendRawEmail} operation:
\itemize{
\item Although you can customize the message headers when using the
\code{SendRawEmail} operation, Amazon SES will automatically apply its
own \code{Message-ID} and \code{Date} headers; if you passed these headers
when creating the message, they will be overwritten by the values
that Amazon SES provides.
\item If you are using sending authorization to send on behalf of another
user, \code{SendRawEmail} enables you to specify the cross-account
identity for the email's Source, From, and Return-Path parameters
in one of two ways: you can pass optional parameters \code{SourceArn},
\code{FromArn}, and/or \code{ReturnPathArn} to the API, or you can include the
following X-headers in the header of your raw email:
\item \code{X-SES-SOURCE-ARN}
\item \code{X-SES-FROM-ARN}
\item \code{X-SES-RETURN-PATH-ARN}
}

Do not include these X-headers in the DKIM signature; Amazon SES
will remove them before sending the email.

For most common sending authorization scenarios, we recommend that
you specify the \code{SourceIdentityArn} parameter and not the
\code{FromIdentityArn} or \code{ReturnPathIdentityArn} parameters. If you only
specify the \code{SourceIdentityArn} parameter, Amazon SES will set the
From and Return Path addresses to the identity specified in
\code{SourceIdentityArn}. For more information about sending
authorization, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Using Sending Authorization with Amazon SES}
in the \emph{Amazon SES Developer Guide.}
\itemize{
\item For every message that you send, the total number of recipients
(including each recipient in the To:, CC: and BCC: fields) is
counted against the maximum number of emails you can send in a
24-hour period (your \emph{sending quota}). For more information about
sending quotas in Amazon SES, see \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html}{Managing Your Amazon SES Sending Limits}
in the \emph{Amazon SES Developer Guide.}
}
}
\section{Request syntax}{
\preformatted{svc$send_raw_email(
  Source = "string",
  Destinations = list(
    "string"
  ),
  RawMessage = list(
    Data = raw
  ),
  FromArn = "string",
  SourceArn = "string",
  ReturnPathArn = "string",
  Tags = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  ConfigurationSetName = "string"
)
}
}

\examples{
# The following example sends an email with an attachment:
\donttest{svc$send_raw_email(
  Destinations = list(),
  FromArn = "",
  RawMessage = list(
    Data = "From: sender@example.com\\\\nTo: recipient@example.com\\\\nSubject: Test email (cont..."
  ),
  ReturnPathArn = "",
  Source = "",
  SourceArn = ""
)}

}
\keyword{internal}
