% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_create_anomaly_monitor}
\alias{costexplorer_create_anomaly_monitor}
\title{Creates a new cost anomaly detection monitor with the requested type and
monitor specification}
\usage{
costexplorer_create_anomaly_monitor(AnomalyMonitor)
}
\arguments{
\item{AnomalyMonitor}{[required] The cost anomaly detection monitor object that you want to create.}
}
\description{
Creates a new cost anomaly detection monitor with the requested type and
monitor specification.
}
\section{Request syntax}{
\preformatted{svc$create_anomaly_monitor(
  AnomalyMonitor = list(
    MonitorArn = "string",
    MonitorName = "string",
    CreationDate = "string",
    LastUpdatedDate = "string",
    LastEvaluatedDate = "string",
    MonitorType = "DIMENSIONAL"|"CUSTOM",
    MonitorDimension = "SERVICE",
    MonitorSpecification = list(
      Or = list(
        list()
      ),
      And = list(
        list()
      ),
      Not = list(),
      Dimensions = list(
        Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"LINKED_ACCOUNT_NAME"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"SERVICE_CODE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION"|"AGREEMENT_END_DATE_TIME_AFTER"|"AGREEMENT_END_DATE_TIME_BEFORE",
        Values = list(
          "string"
        ),
        MatchOptions = list(
          "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
        )
      ),
      Tags = list(
        Key = "string",
        Values = list(
          "string"
        ),
        MatchOptions = list(
          "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
        )
      ),
      CostCategories = list(
        Key = "string",
        Values = list(
          "string"
        ),
        MatchOptions = list(
          "EQUALS"|"ABSENT"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CASE_SENSITIVE"|"CASE_INSENSITIVE"
        )
      )
    ),
    DimensionalValueCount = 123
  )
)
}
}

\keyword{internal}
