% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_describe_budgets}
\alias{budgets_describe_budgets}
\title{Lists the budgets that are associated with an account}
\usage{
budgets_describe_budgets(AccountId, MaxResults, NextToken)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budgets that you want
descriptions of.}

\item{MaxResults}{An optional integer that represents how many entries a paginated
response contains. The maximum is 100.}

\item{NextToken}{The pagination token that you include in your request to indicate the
next set of results that you want to retrieve.}
}
\description{
Lists the budgets that are associated with an account.

The Request Syntax section shows the \code{BudgetLimit} syntax. For
\code{PlannedBudgetLimits}, see the
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples}{Examples}
section.
}
\section{Request syntax}{
\preformatted{svc$describe_budgets(
  AccountId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
