% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_start_declarative_policies_report}
\alias{ec2_start_declarative_policies_report}
\title{Generates an account status report}
\usage{
ec2_start_declarative_policies_report(
  DryRun = NULL,
  S3Bucket,
  S3Prefix = NULL,
  TargetId,
  TagSpecifications = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{S3Bucket}{[required] The name of the S3 bucket where the report will be saved. The bucket
must be in the same Region where the report generation request is made.}

\item{S3Prefix}{The prefix for your S3 object.}

\item{TargetId}{[required] The root ID, organizational unit ID, or account ID.

Format:
\itemize{
\item For root: \code{r-ab12}
\item For OU: \code{ou-ab12-cdef1234}
\item For account: \code{123456789012}
}}

\item{TagSpecifications}{The tags to apply.}
}
\description{
Generates an account status report. The report is generated asynchronously, and can take several hours to complete.

See \url{https://www.paws-r-sdk.com/docs/ec2_start_declarative_policies_report/} for full documentation.
}
\keyword{internal}
