% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint}
\alias{ec2_create_vpc_endpoint}
\title{Creates a VPC endpoint}
\usage{
ec2_create_vpc_endpoint(
  DryRun = NULL,
  VpcEndpointType = NULL,
  VpcId,
  ServiceName = NULL,
  PolicyDocument = NULL,
  RouteTableIds = NULL,
  SubnetIds = NULL,
  SecurityGroupIds = NULL,
  IpAddressType = NULL,
  DnsOptions = NULL,
  ClientToken = NULL,
  PrivateDnsEnabled = NULL,
  TagSpecifications = NULL,
  SubnetConfigurations = NULL,
  ServiceNetworkArn = NULL,
  ResourceConfigurationArn = NULL,
  ServiceRegion = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointType}{The type of endpoint.

Default: Gateway}

\item{VpcId}{[required] The ID of the VPC.}

\item{ServiceName}{The name of the endpoint service.}

\item{PolicyDocument}{(Interface and gateway endpoints) A policy to attach to the endpoint
that controls access to the service. The policy must be in valid JSON
format. If this parameter is not specified, we attach a default policy
that allows full access to the service.}

\item{RouteTableIds}{(Gateway endpoint) The route table IDs.}

\item{SubnetIds}{(Interface and Gateway Load Balancer endpoints) The IDs of the subnets
in which to create endpoint network interfaces. For a Gateway Load
Balancer endpoint, you can specify only one subnet.}

\item{SecurityGroupIds}{(Interface endpoint) The IDs of the security groups to associate with
the endpoint network interfaces. If this parameter is not specified, we
use the default security group for the VPC.}

\item{IpAddressType}{The IP address type for the endpoint.}

\item{DnsOptions}{The DNS options for the endpoint.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{How to ensure idempotency}.}

\item{PrivateDnsEnabled}{(Interface endpoint) Indicates whether to associate a private hosted
zone with the specified VPC. The private hosted zone contains a record
set for the default public DNS name for the service for the Region (for
example, \verb{kinesis.us-east-1.amazonaws.com}), which resolves to the
private IP addresses of the endpoint network interfaces in the VPC. This
enables you to make requests to the default public DNS name for the
service instead of the public DNS names that are automatically generated
by the VPC endpoint service.

To use a private hosted zone, you must set the following VPC attributes
to \code{true}: \code{enableDnsHostnames} and \code{enableDnsSupport}. Use
\code{\link[=ec2_modify_vpc_attribute]{modify_vpc_attribute}} to set the VPC
attributes.

Default: \code{true}}

\item{TagSpecifications}{The tags to associate with the endpoint.}

\item{SubnetConfigurations}{The subnet configurations for the endpoint.}

\item{ServiceNetworkArn}{The Amazon Resource Name (ARN) of a service network that will be
associated with the VPC endpoint of type service-network.}

\item{ResourceConfigurationArn}{The Amazon Resource Name (ARN) of a resource configuration that will be
associated with the VPC endpoint of type resource.}

\item{ServiceRegion}{The Region where the service is hosted. The default is the current
Region.}
}
\description{
Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information, see the \href{https://docs.aws.amazon.com/vpc/latest/privatelink/}{Amazon Web Services PrivateLink User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint/} for full documentation.
}
\keyword{internal}
