# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ec2_service.R
NULL

#' Accepts an Elastic IP address transfer
#'
#' @description
#' Accepts an Elastic IP address transfer. For more information, see [Accept a transferred Elastic IP address](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_address_transfer/](https://www.paws-r-sdk.com/docs/ec2_accept_address_transfer/) for full documentation.
#'
#' @param Address &#91;required&#93; The Elastic IP address you are accepting for transfer.
#' @param TagSpecifications `tag`:\<key\> - The key/value combination of a tag assigned to the
#' resource. Use the tag key in the filter name and the tag value as the
#' filter value. For example, to find all resources that have a tag with
#' the key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#' filter name and `TeamA` for the filter value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_address_transfer
ec2_accept_address_transfer <- function(Address, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptAddressTransfer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_address_transfer_input(Address = Address, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$accept_address_transfer_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_address_transfer <- ec2_accept_address_transfer

#' Accepts a request to assign billing of the available capacity of a
#' shared Capacity Reservation to your account
#'
#' @description
#' Accepts a request to assign billing of the available capacity of a shared Capacity Reservation to your account. For more information, see [Billing assignment for shared Amazon EC2 Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_capacity_reservation_billing_ownership/](https://www.paws-r-sdk.com/docs/ec2_accept_capacity_reservation_billing_ownership/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation for which to accept the request.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_capacity_reservation_billing_ownership
ec2_accept_capacity_reservation_billing_ownership <- function(DryRun = NULL, CapacityReservationId) {
  op <- new_operation(
    name = "AcceptCapacityReservationBillingOwnership",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_capacity_reservation_billing_ownership_input(DryRun = DryRun, CapacityReservationId = CapacityReservationId)
  output <- .ec2$accept_capacity_reservation_billing_ownership_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_capacity_reservation_billing_ownership <- ec2_accept_capacity_reservation_billing_ownership

#' Accepts the Convertible Reserved Instance exchange quote described in
#' the GetReservedInstancesExchangeQuote call
#'
#' @description
#' Accepts the Convertible Reserved Instance exchange quote described in the [`get_reserved_instances_exchange_quote`][ec2_get_reserved_instances_exchange_quote] call.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_reserved_instances_exchange_quote/](https://www.paws-r-sdk.com/docs/ec2_accept_reserved_instances_exchange_quote/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstanceIds &#91;required&#93; The IDs of the Convertible Reserved Instances to exchange for another
#' Convertible Reserved Instance of the same or higher value.
#' @param TargetConfigurations The configuration of the target Convertible Reserved Instance to
#' exchange for your current Convertible Reserved Instances.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_reserved_instances_exchange_quote
ec2_accept_reserved_instances_exchange_quote <- function(DryRun = NULL, ReservedInstanceIds, TargetConfigurations = NULL) {
  op <- new_operation(
    name = "AcceptReservedInstancesExchangeQuote",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_reserved_instances_exchange_quote_input(DryRun = DryRun, ReservedInstanceIds = ReservedInstanceIds, TargetConfigurations = TargetConfigurations)
  output <- .ec2$accept_reserved_instances_exchange_quote_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_reserved_instances_exchange_quote <- ec2_accept_reserved_instances_exchange_quote

#' Accepts a request to associate subnets with a transit gateway multicast
#' domain
#'
#' @description
#' Accepts a request to associate subnets with a transit gateway multicast domain.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_transit_gateway_multicast_domain_associations/](https://www.paws-r-sdk.com/docs/ec2_accept_transit_gateway_multicast_domain_associations/) for full documentation.
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param TransitGatewayAttachmentId The ID of the transit gateway attachment.
#' @param SubnetIds The IDs of the subnets to associate with the transit gateway multicast
#' domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_multicast_domain_associations
ec2_accept_transit_gateway_multicast_domain_associations <- function(TransitGatewayMulticastDomainId = NULL, TransitGatewayAttachmentId = NULL, SubnetIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayMulticastDomainAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_transit_gateway_multicast_domain_associations_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, SubnetIds = SubnetIds, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_multicast_domain_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_multicast_domain_associations <- ec2_accept_transit_gateway_multicast_domain_associations

#' Accepts a transit gateway peering attachment request
#'
#' @description
#' Accepts a transit gateway peering attachment request. The peering attachment must be in the `pendingAcceptance` state.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_transit_gateway_peering_attachment/](https://www.paws-r-sdk.com/docs/ec2_accept_transit_gateway_peering_attachment/) for full documentation.
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_peering_attachment
ec2_accept_transit_gateway_peering_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_transit_gateway_peering_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_peering_attachment <- ec2_accept_transit_gateway_peering_attachment

#' Accepts a request to attach a VPC to a transit gateway
#'
#' @description
#' Accepts a request to attach a VPC to a transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_transit_gateway_vpc_attachment/](https://www.paws-r-sdk.com/docs/ec2_accept_transit_gateway_vpc_attachment/) for full documentation.
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_vpc_attachment
ec2_accept_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_vpc_attachment <- ec2_accept_transit_gateway_vpc_attachment

#' Accepts connection requests to your VPC endpoint service
#'
#' @description
#' Accepts connection requests to your VPC endpoint service.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_vpc_endpoint_connections/](https://www.paws-r-sdk.com/docs/ec2_accept_vpc_endpoint_connections/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId &#91;required&#93; The ID of the VPC endpoint service.
#' @param VpcEndpointIds &#91;required&#93; The IDs of the interface VPC endpoints.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_vpc_endpoint_connections
ec2_accept_vpc_endpoint_connections <- function(DryRun = NULL, ServiceId, VpcEndpointIds) {
  op <- new_operation(
    name = "AcceptVpcEndpointConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_vpc_endpoint_connections_input(DryRun = DryRun, ServiceId = ServiceId, VpcEndpointIds = VpcEndpointIds)
  output <- .ec2$accept_vpc_endpoint_connections_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_vpc_endpoint_connections <- ec2_accept_vpc_endpoint_connections

#' Accept a VPC peering connection request
#'
#' @description
#' Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the `pending-acceptance` state, and you must be the owner of the peer VPC. Use [`describe_vpc_peering_connections`][ec2_describe_vpc_peering_connections] to view your outstanding VPC peering connection requests.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_accept_vpc_peering_connection/](https://www.paws-r-sdk.com/docs/ec2_accept_vpc_peering_connection/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionId &#91;required&#93; The ID of the VPC peering connection. You must specify this parameter in
#' the request.
#'
#' @keywords internal
#'
#' @rdname ec2_accept_vpc_peering_connection
ec2_accept_vpc_peering_connection <- function(DryRun = NULL, VpcPeeringConnectionId) {
  op <- new_operation(
    name = "AcceptVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$accept_vpc_peering_connection_input(DryRun = DryRun, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$accept_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_vpc_peering_connection <- ec2_accept_vpc_peering_connection

#' Advertises an IPv4 or IPv6 address range that is provisioned for use
#' with your Amazon Web Services resources through bring your own IP
#' addresses (BYOIP)
#'
#' @description
#' Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_advertise_byoip_cidr/](https://www.paws-r-sdk.com/docs/ec2_advertise_byoip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation. This must be the exact range that
#' you provisioned. You can't advertise only a portion of the provisioned
#' range.
#' @param Asn The public 2-byte or 4-byte ASN that you want to advertise.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkBorderGroup If you have [Local
#' Zones](https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html)
#' enabled, you can choose a network border group for Local Zones when you
#' provision and advertise a BYOIPv4 CIDR. Choose the network border group
#' carefully as the EIP and the Amazon Web Services resource it is
#' associated with must reside in the same network border group.
#' 
#' You can provision BYOIP address ranges to and advertise them in the
#' following Local Zone network border groups:
#' 
#' -   us-east-1-dfw-2
#' 
#' -   us-west-2-lax-1
#' 
#' -   us-west-2-phx-2
#' 
#' You cannot provision or advertise BYOIPv6 address ranges in Local Zones
#' at this time.
#'
#' @keywords internal
#'
#' @rdname ec2_advertise_byoip_cidr
ec2_advertise_byoip_cidr <- function(Cidr, Asn = NULL, DryRun = NULL, NetworkBorderGroup = NULL) {
  op <- new_operation(
    name = "AdvertiseByoipCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$advertise_byoip_cidr_input(Cidr = Cidr, Asn = Asn, DryRun = DryRun, NetworkBorderGroup = NetworkBorderGroup)
  output <- .ec2$advertise_byoip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$advertise_byoip_cidr <- ec2_advertise_byoip_cidr

#' Allocates an Elastic IP address to your Amazon Web Services account
#'
#' @description
#' Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_allocate_address/](https://www.paws-r-sdk.com/docs/ec2_allocate_address/) for full documentation.
#'
#' @param Domain The network (`vpc`).
#' @param Address The Elastic IP address to recover or an IPv4 address from an address
#' pool.
#' @param PublicIpv4Pool The ID of an address pool that you own. Use this parameter to let Amazon
#' EC2 select an address from the address pool. To specify a specific
#' address from the address pool, use the `Address` parameter instead.
#' @param NetworkBorderGroup A unique set of Availability Zones, Local Zones, or Wavelength Zones
#' from which Amazon Web Services advertises IP addresses. Use this
#' parameter to limit the IP address to this location. IP addresses cannot
#' move between network border groups.
#' @param CustomerOwnedIpv4Pool The ID of a customer-owned address pool. Use this parameter to let
#' Amazon EC2 select an address from the address pool. Alternatively,
#' specify a specific address from the address pool.
#' @param TagSpecifications The tags to assign to the Elastic IP address.
#' @param IpamPoolId The ID of an IPAM pool which has an Amazon-provided or BYOIP public IPv4
#' CIDR provisioned to it. For more information, see [Allocate sequential
#' Elastic IP addresses from an IPAM
#' pool](https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-eip-pool.html)
#' in the *Amazon VPC IPAM User Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_address
ec2_allocate_address <- function(Domain = NULL, Address = NULL, PublicIpv4Pool = NULL, NetworkBorderGroup = NULL, CustomerOwnedIpv4Pool = NULL, TagSpecifications = NULL, IpamPoolId = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AllocateAddress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$allocate_address_input(Domain = Domain, Address = Address, PublicIpv4Pool = PublicIpv4Pool, NetworkBorderGroup = NetworkBorderGroup, CustomerOwnedIpv4Pool = CustomerOwnedIpv4Pool, TagSpecifications = TagSpecifications, IpamPoolId = IpamPoolId, DryRun = DryRun)
  output <- .ec2$allocate_address_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_address <- ec2_allocate_address

#' Allocates a Dedicated Host to your account
#'
#' @description
#' Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_allocate_hosts/](https://www.paws-r-sdk.com/docs/ec2_allocate_hosts/) for full documentation.
#'
#' @param InstanceFamily Specifies the instance family to be supported by the Dedicated Hosts. If
#' you specify an instance family, the Dedicated Hosts support multiple
#' instance types within that instance family.
#' 
#' If you want the Dedicated Hosts to support a specific instance type
#' only, omit this parameter and specify **InstanceType** instead. You
#' cannot specify **InstanceFamily** and **InstanceType** in the same
#' request.
#' @param TagSpecifications The tags to apply to the Dedicated Host during creation.
#' @param HostRecovery Indicates whether to enable or disable host recovery for the Dedicated
#' Host. Host recovery is disabled by default. For more information, see
#' [Host
#' recovery](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html)
#' in the *Amazon EC2 User Guide*.
#' 
#' Default: `off`
#' @param OutpostArn The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on
#' which to allocate the Dedicated Host. If you specify **OutpostArn**, you
#' can optionally specify **AssetIds**.
#' 
#' If you are allocating the Dedicated Host in a Region, omit this
#' parameter.
#' @param HostMaintenance Indicates whether to enable or disable host maintenance for the
#' Dedicated Host. For more information, see [Host
#' maintenance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html)
#' in the *Amazon EC2 User Guide*.
#' @param AssetIds The IDs of the Outpost hardware assets on which to allocate the
#' Dedicated Hosts. Targeting specific hardware assets on an Outpost can
#' help to minimize latency between your workloads. This parameter is
#' supported only if you specify **OutpostArn**. If you are allocating the
#' Dedicated Hosts in a Region, omit this parameter.
#' 
#' -   If you specify this parameter, you can omit **Quantity**. In this
#'     case, Amazon EC2 allocates a Dedicated Host on each specified
#'     hardware asset.
#' 
#' -   If you specify both **AssetIds** and **Quantity**, then the value
#'     for **Quantity** must be equal to the number of asset IDs specified.
#' @param AutoPlacement Indicates whether the host accepts any untargeted instance launches that
#' match its instance type configuration, or if it only accepts Host
#' tenancy instance launches that specify its unique host ID. For more
#' information, see [Understanding auto-placement and
#' affinity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/#dedicated-hosts-understanding)
#' in the *Amazon EC2 User Guide*.
#' 
#' Default: `off`
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param InstanceType Specifies the instance type to be supported by the Dedicated Hosts. If
#' you specify an instance type, the Dedicated Hosts support instances of
#' the specified instance type only.
#' 
#' If you want the Dedicated Hosts to support multiple instance types in a
#' specific instance family, omit this parameter and specify
#' **InstanceFamily** instead. You cannot specify **InstanceType** and
#' **InstanceFamily** in the same request.
#' @param Quantity The number of Dedicated Hosts to allocate to your account with these
#' parameters. If you are allocating the Dedicated Hosts on an Outpost, and
#' you specify **AssetIds**, you can omit this parameter. In this case,
#' Amazon EC2 allocates a Dedicated Host on each specified hardware asset.
#' If you specify both **AssetIds** and **Quantity**, then the value that
#' you specify for **Quantity** must be equal to the number of asset IDs
#' specified.
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to allocate the Dedicated Host.
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_hosts
ec2_allocate_hosts <- function(InstanceFamily = NULL, TagSpecifications = NULL, HostRecovery = NULL, OutpostArn = NULL, HostMaintenance = NULL, AssetIds = NULL, AutoPlacement = NULL, ClientToken = NULL, InstanceType = NULL, Quantity = NULL, AvailabilityZone) {
  op <- new_operation(
    name = "AllocateHosts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$allocate_hosts_input(InstanceFamily = InstanceFamily, TagSpecifications = TagSpecifications, HostRecovery = HostRecovery, OutpostArn = OutpostArn, HostMaintenance = HostMaintenance, AssetIds = AssetIds, AutoPlacement = AutoPlacement, ClientToken = ClientToken, InstanceType = InstanceType, Quantity = Quantity, AvailabilityZone = AvailabilityZone)
  output <- .ec2$allocate_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_hosts <- ec2_allocate_hosts

#' Allocate a CIDR from an IPAM pool
#'
#' @description
#' Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon Web Services Region where this IPAM pool is available for allocations.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_allocate_ipam_pool_cidr/](https://www.paws-r-sdk.com/docs/ec2_allocate_ipam_pool_cidr/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamPoolId &#91;required&#93; The ID of the IPAM pool from which you would like to allocate a CIDR.
#' @param Cidr The CIDR you would like to allocate from the IPAM pool. Note the
#' following:
#' 
#' -   If there is no DefaultNetmaskLength allocation rule set on the pool,
#'     you must specify either the NetmaskLength or the CIDR.
#' 
#' -   If the DefaultNetmaskLength allocation rule is set on the pool, you
#'     can specify either the NetmaskLength or the CIDR and the
#'     DefaultNetmaskLength allocation rule will be ignored.
#' 
#' Possible values: Any available IPv4 or IPv6 CIDR.
#' @param NetmaskLength The netmask length of the CIDR you would like to allocate from the IPAM
#' pool. Note the following:
#' 
#' -   If there is no DefaultNetmaskLength allocation rule set on the pool,
#'     you must specify either the NetmaskLength or the CIDR.
#' 
#' -   If the DefaultNetmaskLength allocation rule is set on the pool, you
#'     can specify either the NetmaskLength or the CIDR and the
#'     DefaultNetmaskLength allocation rule will be ignored.
#' 
#' Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask
#' lengths for IPv6 addresses are 0 - 128.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param Description A description for the allocation.
#' @param PreviewNextCidr A preview of the next available CIDR in a pool.
#' @param AllowedCidrs Include a particular CIDR range that can be returned by the pool.
#' Allowed CIDRs are only allowed if using netmask length for allocation.
#' @param DisallowedCidrs Exclude a particular CIDR range from being returned by the pool.
#' Disallowed CIDRs are only allowed if using netmask length for
#' allocation.
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_ipam_pool_cidr
ec2_allocate_ipam_pool_cidr <- function(DryRun = NULL, IpamPoolId, Cidr = NULL, NetmaskLength = NULL, ClientToken = NULL, Description = NULL, PreviewNextCidr = NULL, AllowedCidrs = NULL, DisallowedCidrs = NULL) {
  op <- new_operation(
    name = "AllocateIpamPoolCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$allocate_ipam_pool_cidr_input(DryRun = DryRun, IpamPoolId = IpamPoolId, Cidr = Cidr, NetmaskLength = NetmaskLength, ClientToken = ClientToken, Description = Description, PreviewNextCidr = PreviewNextCidr, AllowedCidrs = AllowedCidrs, DisallowedCidrs = DisallowedCidrs)
  output <- .ec2$allocate_ipam_pool_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_ipam_pool_cidr <- ec2_allocate_ipam_pool_cidr

#' Applies a security group to the association between the target network
#' and the Client VPN endpoint
#'
#' @description
#' Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_apply_security_groups_to_client_vpn_target_network/](https://www.paws-r-sdk.com/docs/ec2_apply_security_groups_to_client_vpn_target_network/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param VpcId &#91;required&#93; The ID of the VPC in which the associated target network is located.
#' @param SecurityGroupIds &#91;required&#93; The IDs of the security groups to apply to the associated target
#' network. Up to 5 security groups can be applied to an associated target
#' network.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_apply_security_groups_to_client_vpn_target_network
ec2_apply_security_groups_to_client_vpn_target_network <- function(ClientVpnEndpointId, VpcId, SecurityGroupIds, DryRun = NULL) {
  op <- new_operation(
    name = "ApplySecurityGroupsToClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$apply_security_groups_to_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, VpcId = VpcId, SecurityGroupIds = SecurityGroupIds, DryRun = DryRun)
  output <- .ec2$apply_security_groups_to_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$apply_security_groups_to_client_vpn_target_network <- ec2_apply_security_groups_to_client_vpn_target_network

#' Assigns one or more IPv6 addresses to the specified network interface
#'
#' @description
#' Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_assign_ipv_6_addresses/](https://www.paws-r-sdk.com/docs/ec2_assign_ipv_6_addresses/) for full documentation.
#'
#' @param Ipv6PrefixCount The number of IPv6 prefixes that Amazon Web Services automatically
#' assigns to the network interface. You cannot use this option if you use
#' the `Ipv6Prefixes` option.
#' @param Ipv6Prefixes One or more IPv6 prefixes assigned to the network interface. You cannot
#' use this option if you use the `Ipv6PrefixCount` option.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param Ipv6Addresses The IPv6 addresses to be assigned to the network interface. You can't
#' use this option if you're specifying a number of IPv6 addresses.
#' @param Ipv6AddressCount The number of additional IPv6 addresses to assign to the network
#' interface. The specified number of IPv6 addresses are assigned in
#' addition to the existing IPv6 addresses that are already assigned to the
#' network interface. Amazon EC2 automatically selects the IPv6 addresses
#' from the subnet range. You can't use this option if specifying specific
#' IPv6 addresses.
#'
#' @keywords internal
#'
#' @rdname ec2_assign_ipv_6_addresses
ec2_assign_ipv_6_addresses <- function(Ipv6PrefixCount = NULL, Ipv6Prefixes = NULL, NetworkInterfaceId, Ipv6Addresses = NULL, Ipv6AddressCount = NULL) {
  op <- new_operation(
    name = "AssignIpv6Addresses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$assign_ipv_6_addresses_input(Ipv6PrefixCount = Ipv6PrefixCount, Ipv6Prefixes = Ipv6Prefixes, NetworkInterfaceId = NetworkInterfaceId, Ipv6Addresses = Ipv6Addresses, Ipv6AddressCount = Ipv6AddressCount)
  output <- .ec2$assign_ipv_6_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_ipv_6_addresses <- ec2_assign_ipv_6_addresses

#' Assigns one or more secondary private IP addresses to the specified
#' network interface
#'
#' @description
#' Assigns one or more secondary private IP addresses to the specified network interface.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_assign_private_ip_addresses/](https://www.paws-r-sdk.com/docs/ec2_assign_private_ip_addresses/) for full documentation.
#'
#' @param Ipv4Prefixes One or more IPv4 prefixes assigned to the network interface. You cannot
#' use this option if you use the `Ipv4PrefixCount` option.
#' @param Ipv4PrefixCount The number of IPv4 prefixes that Amazon Web Services automatically
#' assigns to the network interface. You cannot use this option if you use
#' the `Ipv4 Prefixes` option.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param PrivateIpAddresses The IP addresses to be assigned as a secondary private IP address to the
#' network interface. You can't specify this parameter when also specifying
#' a number of secondary IP addresses.
#' 
#' If you don't specify an IP address, Amazon EC2 automatically selects an
#' IP address within the subnet range.
#' @param SecondaryPrivateIpAddressCount The number of secondary IP addresses to assign to the network interface.
#' You can't specify this parameter when also specifying private IP
#' addresses.
#' @param AllowReassignment Indicates whether to allow an IP address that is already assigned to
#' another network interface or instance to be reassigned to the specified
#' network interface.
#'
#' @keywords internal
#'
#' @rdname ec2_assign_private_ip_addresses
ec2_assign_private_ip_addresses <- function(Ipv4Prefixes = NULL, Ipv4PrefixCount = NULL, NetworkInterfaceId, PrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL, AllowReassignment = NULL) {
  op <- new_operation(
    name = "AssignPrivateIpAddresses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$assign_private_ip_addresses_input(Ipv4Prefixes = Ipv4Prefixes, Ipv4PrefixCount = Ipv4PrefixCount, NetworkInterfaceId = NetworkInterfaceId, PrivateIpAddresses = PrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount, AllowReassignment = AllowReassignment)
  output <- .ec2$assign_private_ip_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_private_ip_addresses <- ec2_assign_private_ip_addresses

#' Assigns private IPv4 addresses to a private NAT gateway
#'
#' @description
#' Assigns private IPv4 addresses to a private NAT gateway. For more information, see [Work with NAT gateways](https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_assign_private_nat_gateway_address/](https://www.paws-r-sdk.com/docs/ec2_assign_private_nat_gateway_address/) for full documentation.
#'
#' @param NatGatewayId &#91;required&#93; The ID of the NAT gateway.
#' @param PrivateIpAddresses The private IPv4 addresses you want to assign to the private NAT
#' gateway.
#' @param PrivateIpAddressCount The number of private IP addresses to assign to the NAT gateway. You
#' can't specify this parameter when also specifying private IP addresses.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_assign_private_nat_gateway_address
ec2_assign_private_nat_gateway_address <- function(NatGatewayId, PrivateIpAddresses = NULL, PrivateIpAddressCount = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssignPrivateNatGatewayAddress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$assign_private_nat_gateway_address_input(NatGatewayId = NatGatewayId, PrivateIpAddresses = PrivateIpAddresses, PrivateIpAddressCount = PrivateIpAddressCount, DryRun = DryRun)
  output <- .ec2$assign_private_nat_gateway_address_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_private_nat_gateway_address <- ec2_assign_private_nat_gateway_address

#' Associates an Elastic IP address, or carrier IP address (for instances
#' that are in subnets in Wavelength Zones) with an instance or a network
#' interface
#'
#' @description
#' Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_address/](https://www.paws-r-sdk.com/docs/ec2_associate_address/) for full documentation.
#'
#' @param AllocationId The allocation ID. This is required.
#' @param InstanceId The ID of the instance. The instance must have exactly one attached
#' network interface. You can specify either the instance ID or the network
#' interface ID, but not both.
#' @param PublicIp Deprecated.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId The ID of the network interface. If the instance has more than one
#' network interface, you must specify a network interface ID.
#' 
#' You can specify either the instance ID or the network interface ID, but
#' not both.
#' @param PrivateIpAddress The primary or secondary private IP address to associate with the
#' Elastic IP address. If no private IP address is specified, the Elastic
#' IP address is associated with the primary private IP address.
#' @param AllowReassociation Reassociation is automatic, but you can specify false to ensure the
#' operation fails if the Elastic IP address is already associated with
#' another resource.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_address
ec2_associate_address <- function(AllocationId = NULL, InstanceId = NULL, PublicIp = NULL, DryRun = NULL, NetworkInterfaceId = NULL, PrivateIpAddress = NULL, AllowReassociation = NULL) {
  op <- new_operation(
    name = "AssociateAddress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_address_input(AllocationId = AllocationId, InstanceId = InstanceId, PublicIp = PublicIp, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId, PrivateIpAddress = PrivateIpAddress, AllowReassociation = AllowReassociation)
  output <- .ec2$associate_address_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_address <- ec2_associate_address

#' Initiates a request to assign billing of the unused capacity of a shared
#' Capacity Reservation to a consumer account that is consolidated under
#' the same Amazon Web Services organizations payer account
#'
#' @description
#' Initiates a request to assign billing of the unused capacity of a shared Capacity Reservation to a consumer account that is consolidated under the same Amazon Web Services organizations payer account. For more information, see [Billing assignment for shared Amazon EC2 Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_capacity_reservation_billing_owner/](https://www.paws-r-sdk.com/docs/ec2_associate_capacity_reservation_billing_owner/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation.
#' @param UnusedReservationBillingOwnerId &#91;required&#93; The ID of the consumer account to which to assign billing.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_capacity_reservation_billing_owner
ec2_associate_capacity_reservation_billing_owner <- function(DryRun = NULL, CapacityReservationId, UnusedReservationBillingOwnerId) {
  op <- new_operation(
    name = "AssociateCapacityReservationBillingOwner",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_capacity_reservation_billing_owner_input(DryRun = DryRun, CapacityReservationId = CapacityReservationId, UnusedReservationBillingOwnerId = UnusedReservationBillingOwnerId)
  output <- .ec2$associate_capacity_reservation_billing_owner_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_capacity_reservation_billing_owner <- ec2_associate_capacity_reservation_billing_owner

#' Associates a target network with a Client VPN endpoint
#'
#' @description
#' Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_client_vpn_target_network/](https://www.paws-r-sdk.com/docs/ec2_associate_client_vpn_target_network/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param SubnetId &#91;required&#93; The ID of the subnet to associate with the Client VPN endpoint.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_client_vpn_target_network
ec2_associate_client_vpn_target_network <- function(ClientVpnEndpointId, SubnetId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, SubnetId = SubnetId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$associate_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_client_vpn_target_network <- ec2_associate_client_vpn_target_network

#' Associates a set of DHCP options (that you've previously created) with
#' the specified VPC, or associates no DHCP options with the VPC
#'
#' @description
#' Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP options with the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_dhcp_options/](https://www.paws-r-sdk.com/docs/ec2_associate_dhcp_options/) for full documentation.
#'
#' @param DhcpOptionsId &#91;required&#93; The ID of the DHCP options set, or `default` to associate no DHCP
#' options with the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_dhcp_options
ec2_associate_dhcp_options <- function(DhcpOptionsId, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateDhcpOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_dhcp_options_input(DhcpOptionsId = DhcpOptionsId, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$associate_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_dhcp_options <- ec2_associate_dhcp_options

#' Associates an Identity and Access Management (IAM) role with an
#' Certificate Manager (ACM) certificate
#'
#' @description
#' Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see [Certificate Manager for Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html) in the *Amazon Web Services Nitro Enclaves User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_enclave_certificate_iam_role/](https://www.paws-r-sdk.com/docs/ec2_associate_enclave_certificate_iam_role/) for full documentation.
#'
#' @param CertificateArn &#91;required&#93; The ARN of the ACM certificate with which to associate the IAM role.
#' @param RoleArn &#91;required&#93; The ARN of the IAM role to associate with the ACM certificate. You can
#' associate up to 16 IAM roles with an ACM certificate.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_enclave_certificate_iam_role
ec2_associate_enclave_certificate_iam_role <- function(CertificateArn, RoleArn, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateEnclaveCertificateIamRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_enclave_certificate_iam_role_input(CertificateArn = CertificateArn, RoleArn = RoleArn, DryRun = DryRun)
  output <- .ec2$associate_enclave_certificate_iam_role_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_enclave_certificate_iam_role <- ec2_associate_enclave_certificate_iam_role

#' Associates an IAM instance profile with a running or stopped instance
#'
#' @description
#' Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_iam_instance_profile/](https://www.paws-r-sdk.com/docs/ec2_associate_iam_instance_profile/) for full documentation.
#'
#' @param IamInstanceProfile &#91;required&#93; The IAM instance profile.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_iam_instance_profile
ec2_associate_iam_instance_profile <- function(IamInstanceProfile, InstanceId) {
  op <- new_operation(
    name = "AssociateIamInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_iam_instance_profile_input(IamInstanceProfile = IamInstanceProfile, InstanceId = InstanceId)
  output <- .ec2$associate_iam_instance_profile_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_iam_instance_profile <- ec2_associate_iam_instance_profile

#' Associates one or more targets with an event window
#'
#' @description
#' Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs, or tags) can be specified with an event window.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_instance_event_window/](https://www.paws-r-sdk.com/docs/ec2_associate_instance_event_window/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceEventWindowId &#91;required&#93; The ID of the event window.
#' @param AssociationTarget &#91;required&#93; One or more targets associated with the specified event window.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_instance_event_window
ec2_associate_instance_event_window <- function(DryRun = NULL, InstanceEventWindowId, AssociationTarget) {
  op <- new_operation(
    name = "AssociateInstanceEventWindow",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_instance_event_window_input(DryRun = DryRun, InstanceEventWindowId = InstanceEventWindowId, AssociationTarget = AssociationTarget)
  output <- .ec2$associate_instance_event_window_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_instance_event_window <- ec2_associate_instance_event_window

#' Associates your Autonomous System Number (ASN) with a BYOIP CIDR that
#' you own in the same Amazon Web Services Region
#'
#' @description
#' Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services Region. For more information, see [Tutorial: Bring your ASN to IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html) in the *Amazon VPC IPAM guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_ipam_byoasn/](https://www.paws-r-sdk.com/docs/ec2_associate_ipam_byoasn/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Asn &#91;required&#93; A public 2-byte or 4-byte ASN.
#' @param Cidr &#91;required&#93; The BYOIP CIDR you want to associate with an ASN.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_ipam_byoasn
ec2_associate_ipam_byoasn <- function(DryRun = NULL, Asn, Cidr) {
  op <- new_operation(
    name = "AssociateIpamByoasn",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_ipam_byoasn_input(DryRun = DryRun, Asn = Asn, Cidr = Cidr)
  output <- .ec2$associate_ipam_byoasn_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_ipam_byoasn <- ec2_associate_ipam_byoasn

#' Associates an IPAM resource discovery with an Amazon VPC IPAM
#'
#' @description
#' Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_ipam_resource_discovery/](https://www.paws-r-sdk.com/docs/ec2_associate_ipam_resource_discovery/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamId &#91;required&#93; An IPAM ID.
#' @param IpamResourceDiscoveryId &#91;required&#93; A resource discovery ID.
#' @param TagSpecifications Tag specifications.
#' @param ClientToken A client token.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_ipam_resource_discovery
ec2_associate_ipam_resource_discovery <- function(DryRun = NULL, IpamId, IpamResourceDiscoveryId, TagSpecifications = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "AssociateIpamResourceDiscovery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_ipam_resource_discovery_input(DryRun = DryRun, IpamId = IpamId, IpamResourceDiscoveryId = IpamResourceDiscoveryId, TagSpecifications = TagSpecifications, ClientToken = ClientToken)
  output <- .ec2$associate_ipam_resource_discovery_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_ipam_resource_discovery <- ec2_associate_ipam_resource_discovery

#' Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a
#' public NAT gateway
#'
#' @description
#' Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more information, see [Work with NAT gateways](https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_nat_gateway_address/](https://www.paws-r-sdk.com/docs/ec2_associate_nat_gateway_address/) for full documentation.
#'
#' @param NatGatewayId &#91;required&#93; The ID of the NAT gateway.
#' @param AllocationIds &#91;required&#93; The allocation IDs of EIPs that you want to associate with your NAT
#' gateway.
#' @param PrivateIpAddresses The private IPv4 addresses that you want to assign to the NAT gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_nat_gateway_address
ec2_associate_nat_gateway_address <- function(NatGatewayId, AllocationIds, PrivateIpAddresses = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateNatGatewayAddress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_nat_gateway_address_input(NatGatewayId = NatGatewayId, AllocationIds = AllocationIds, PrivateIpAddresses = PrivateIpAddresses, DryRun = DryRun)
  output <- .ec2$associate_nat_gateway_address_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_nat_gateway_address <- ec2_associate_nat_gateway_address

#' Associates a subnet in your VPC or an internet gateway or virtual
#' private gateway attached to your VPC with a route table in your VPC
#'
#' @description
#' Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table later. A route table can be associated with multiple subnets.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_route_table/](https://www.paws-r-sdk.com/docs/ec2_associate_route_table/) for full documentation.
#'
#' @param GatewayId The ID of the internet gateway or virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SubnetId The ID of the subnet.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_route_table
ec2_associate_route_table <- function(GatewayId = NULL, DryRun = NULL, SubnetId = NULL, RouteTableId) {
  op <- new_operation(
    name = "AssociateRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_route_table_input(GatewayId = GatewayId, DryRun = DryRun, SubnetId = SubnetId, RouteTableId = RouteTableId)
  output <- .ec2$associate_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_route_table <- ec2_associate_route_table

#' Associates a security group with another VPC in the same Region
#'
#' @description
#' Associates a security group with another VPC in the same Region. This enables you to use the same security group with network interfaces and instances in the specified VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_security_group_vpc/](https://www.paws-r-sdk.com/docs/ec2_associate_security_group_vpc/) for full documentation.
#'
#' @param GroupId &#91;required&#93; A security group ID.
#' @param VpcId &#91;required&#93; A VPC ID.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_security_group_vpc
ec2_associate_security_group_vpc <- function(GroupId, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateSecurityGroupVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_security_group_vpc_input(GroupId = GroupId, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$associate_security_group_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_security_group_vpc <- ec2_associate_security_group_vpc

#' Associates a CIDR block with your subnet
#'
#' @description
#' Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_subnet_cidr_block/](https://www.paws-r-sdk.com/docs/ec2_associate_subnet_cidr_block/) for full documentation.
#'
#' @param Ipv6IpamPoolId An IPv6 IPAM pool ID.
#' @param Ipv6NetmaskLength An IPv6 netmask length.
#' @param SubnetId &#91;required&#93; The ID of your subnet.
#' @param Ipv6CidrBlock The IPv6 CIDR block for your subnet.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_subnet_cidr_block
ec2_associate_subnet_cidr_block <- function(Ipv6IpamPoolId = NULL, Ipv6NetmaskLength = NULL, SubnetId, Ipv6CidrBlock = NULL) {
  op <- new_operation(
    name = "AssociateSubnetCidrBlock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_subnet_cidr_block_input(Ipv6IpamPoolId = Ipv6IpamPoolId, Ipv6NetmaskLength = Ipv6NetmaskLength, SubnetId = SubnetId, Ipv6CidrBlock = Ipv6CidrBlock)
  output <- .ec2$associate_subnet_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_subnet_cidr_block <- ec2_associate_subnet_cidr_block

#' Associates the specified subnets and transit gateway attachments with
#' the specified transit gateway multicast domain
#'
#' @description
#' Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_transit_gateway_multicast_domain/](https://www.paws-r-sdk.com/docs/ec2_associate_transit_gateway_multicast_domain/) for full documentation.
#'
#' @param TransitGatewayMulticastDomainId &#91;required&#93; The ID of the transit gateway multicast domain.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment to associate with the transit
#' gateway multicast domain.
#' @param SubnetIds &#91;required&#93; The IDs of the subnets to associate with the transit gateway multicast
#' domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_multicast_domain
ec2_associate_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, SubnetIds = SubnetIds, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_multicast_domain <- ec2_associate_transit_gateway_multicast_domain

#' Associates the specified transit gateway attachment with a transit
#' gateway policy table
#'
#' @description
#' Associates the specified transit gateway attachment with a transit gateway policy table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_transit_gateway_policy_table/](https://www.paws-r-sdk.com/docs/ec2_associate_transit_gateway_policy_table/) for full documentation.
#'
#' @param TransitGatewayPolicyTableId &#91;required&#93; The ID of the transit gateway policy table to associate with the transit
#' gateway attachment.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment to associate with the policy
#' table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_policy_table
ec2_associate_transit_gateway_policy_table <- function(TransitGatewayPolicyTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayPolicyTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_transit_gateway_policy_table_input(TransitGatewayPolicyTableId = TransitGatewayPolicyTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_policy_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_policy_table <- ec2_associate_transit_gateway_policy_table

#' Associates the specified attachment with the specified transit gateway
#' route table
#'
#' @description
#' Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_transit_gateway_route_table/](https://www.paws-r-sdk.com/docs/ec2_associate_transit_gateway_route_table/) for full documentation.
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_route_table
ec2_associate_transit_gateway_route_table <- function(TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_route_table <- ec2_associate_transit_gateway_route_table

#' Associates a branch network interface with a trunk network interface
#'
#' @description
#' Associates a branch network interface with a trunk network interface.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_trunk_interface/](https://www.paws-r-sdk.com/docs/ec2_associate_trunk_interface/) for full documentation.
#'
#' @param BranchInterfaceId &#91;required&#93; The ID of the branch network interface.
#' @param TrunkInterfaceId &#91;required&#93; The ID of the trunk network interface.
#' @param VlanId The ID of the VLAN. This applies to the VLAN protocol.
#' @param GreKey The application key. This applies to the GRE protocol.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_trunk_interface
ec2_associate_trunk_interface <- function(BranchInterfaceId, TrunkInterfaceId, VlanId = NULL, GreKey = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTrunkInterface",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_trunk_interface_input(BranchInterfaceId = BranchInterfaceId, TrunkInterfaceId = TrunkInterfaceId, VlanId = VlanId, GreKey = GreKey, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$associate_trunk_interface_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_trunk_interface <- ec2_associate_trunk_interface

#' Associates a CIDR block with your VPC
#'
#' @description
#' Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses ([BYOIP](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_associate_vpc_cidr_block/](https://www.paws-r-sdk.com/docs/ec2_associate_vpc_cidr_block/) for full documentation.
#'
#' @param CidrBlock An IPv4 CIDR block to associate with the VPC.
#' @param Ipv6CidrBlockNetworkBorderGroup The name of the location from which we advertise the IPV6 CIDR block.
#' Use this parameter to limit the CIDR block to this location.
#' 
#' You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
#' parameter.
#' 
#' You can have one IPv6 CIDR block association per network border group.
#' @param Ipv6Pool The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
#' block.
#' @param Ipv6CidrBlock An IPv6 CIDR block from the IPv6 address pool. You must also specify
#' `Ipv6Pool` in the request.
#' 
#' To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
#' @param Ipv4IpamPoolId Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more
#' information about Amazon VPC IP Address Manager (IPAM), see [What is
#' IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/) in the *Amazon VPC
#' IPAM User Guide*.
#' @param Ipv4NetmaskLength The netmask length of the IPv4 CIDR you would like to associate from an
#' Amazon VPC IP Address Manager (IPAM) pool. For more information about
#' IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/)
#' in the *Amazon VPC IPAM User Guide*.
#' @param Ipv6IpamPoolId Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more
#' information about Amazon VPC IP Address Manager (IPAM), see [What is
#' IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/) in the *Amazon VPC
#' IPAM User Guide*.
#' @param Ipv6NetmaskLength The netmask length of the IPv6 CIDR you would like to associate from an
#' Amazon VPC IP Address Manager (IPAM) pool. For more information about
#' IPAM, see [What is IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/)
#' in the *Amazon VPC IPAM User Guide*.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param AmazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
#' the VPC. You cannot specify the range of IPv6 addresses or the size of
#' the CIDR block.
#'
#' @keywords internal
#'
#' @rdname ec2_associate_vpc_cidr_block
ec2_associate_vpc_cidr_block <- function(CidrBlock = NULL, Ipv6CidrBlockNetworkBorderGroup = NULL, Ipv6Pool = NULL, Ipv6CidrBlock = NULL, Ipv4IpamPoolId = NULL, Ipv4NetmaskLength = NULL, Ipv6IpamPoolId = NULL, Ipv6NetmaskLength = NULL, VpcId, AmazonProvidedIpv6CidrBlock = NULL) {
  op <- new_operation(
    name = "AssociateVpcCidrBlock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$associate_vpc_cidr_block_input(CidrBlock = CidrBlock, Ipv6CidrBlockNetworkBorderGroup = Ipv6CidrBlockNetworkBorderGroup, Ipv6Pool = Ipv6Pool, Ipv6CidrBlock = Ipv6CidrBlock, Ipv4IpamPoolId = Ipv4IpamPoolId, Ipv4NetmaskLength = Ipv4NetmaskLength, Ipv6IpamPoolId = Ipv6IpamPoolId, Ipv6NetmaskLength = Ipv6NetmaskLength, VpcId = VpcId, AmazonProvidedIpv6CidrBlock = AmazonProvidedIpv6CidrBlock)
  output <- .ec2$associate_vpc_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_vpc_cidr_block <- ec2_associate_vpc_cidr_block

#' This action is deprecated
#'
#' @description
#' This action is deprecated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_attach_classic_link_vpc/](https://www.paws-r-sdk.com/docs/ec2_attach_classic_link_vpc/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the EC2-Classic instance.
#' @param VpcId &#91;required&#93; The ID of the ClassicLink-enabled VPC.
#' @param Groups &#91;required&#93; The IDs of the security groups. You cannot specify security groups from
#' a different VPC.
#'
#' @keywords internal
#'
#' @rdname ec2_attach_classic_link_vpc
ec2_attach_classic_link_vpc <- function(DryRun = NULL, InstanceId, VpcId, Groups) {
  op <- new_operation(
    name = "AttachClassicLinkVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$attach_classic_link_vpc_input(DryRun = DryRun, InstanceId = InstanceId, VpcId = VpcId, Groups = Groups)
  output <- .ec2$attach_classic_link_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_classic_link_vpc <- ec2_attach_classic_link_vpc

#' Attaches an internet gateway or a virtual private gateway to a VPC,
#' enabling connectivity between the internet and the VPC
#'
#' @description
#' Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information, see [Internet gateways](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_attach_internet_gateway/](https://www.paws-r-sdk.com/docs/ec2_attach_internet_gateway/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname ec2_attach_internet_gateway
ec2_attach_internet_gateway <- function(DryRun = NULL, InternetGatewayId, VpcId) {
  op <- new_operation(
    name = "AttachInternetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$attach_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId, VpcId = VpcId)
  output <- .ec2$attach_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_internet_gateway <- ec2_attach_internet_gateway

#' Attaches a network interface to an instance
#'
#' @description
#' Attaches a network interface to an instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_attach_network_interface/](https://www.paws-r-sdk.com/docs/ec2_attach_network_interface/) for full documentation.
#'
#' @param NetworkCardIndex The index of the network card. Some instance types support multiple
#' network cards. The primary network interface must be assigned to network
#' card index 0. The default is network card index 0.
#' @param EnaSrdSpecification Configures ENA Express for the network interface that this action
#' attaches to the instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param DeviceIndex &#91;required&#93; The index of the device for the network interface attachment.
#'
#' @keywords internal
#'
#' @rdname ec2_attach_network_interface
ec2_attach_network_interface <- function(NetworkCardIndex = NULL, EnaSrdSpecification = NULL, DryRun = NULL, NetworkInterfaceId, InstanceId, DeviceIndex) {
  op <- new_operation(
    name = "AttachNetworkInterface",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$attach_network_interface_input(NetworkCardIndex = NetworkCardIndex, EnaSrdSpecification = EnaSrdSpecification, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId, InstanceId = InstanceId, DeviceIndex = DeviceIndex)
  output <- .ec2$attach_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_network_interface <- ec2_attach_network_interface

#' Attaches the specified Amazon Web Services Verified Access trust
#' provider to the specified Amazon Web Services Verified Access instance
#'
#' @description
#' Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services Verified Access instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_attach_verified_access_trust_provider/](https://www.paws-r-sdk.com/docs/ec2_attach_verified_access_trust_provider/) for full documentation.
#'
#' @param VerifiedAccessInstanceId &#91;required&#93; The ID of the Verified Access instance.
#' @param VerifiedAccessTrustProviderId &#91;required&#93; The ID of the Verified Access trust provider.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_attach_verified_access_trust_provider
ec2_attach_verified_access_trust_provider <- function(VerifiedAccessInstanceId, VerifiedAccessTrustProviderId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVerifiedAccessTrustProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$attach_verified_access_trust_provider_input(VerifiedAccessInstanceId = VerifiedAccessInstanceId, VerifiedAccessTrustProviderId = VerifiedAccessTrustProviderId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$attach_verified_access_trust_provider_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_verified_access_trust_provider <- ec2_attach_verified_access_trust_provider

#' Attaches an EBS volume to a running or stopped instance and exposes it
#' to the instance with the specified device name
#'
#' @description
#' Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_attach_volume/](https://www.paws-r-sdk.com/docs/ec2_attach_volume/) for full documentation.
#'
#' @param Device &#91;required&#93; The device name (for example, `/dev/sdh` or `xvdh`).
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param VolumeId &#91;required&#93; The ID of the EBS volume. The volume and instance must be within the
#' same Availability Zone.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_attach_volume
ec2_attach_volume <- function(Device, InstanceId, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$attach_volume_input(Device = Device, InstanceId = InstanceId, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$attach_volume_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_volume <- ec2_attach_volume

#' Attaches an available virtual private gateway to a VPC
#'
#' @description
#' Attaches an available virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_attach_vpn_gateway/](https://www.paws-r-sdk.com/docs/ec2_attach_vpn_gateway/) for full documentation.
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_attach_vpn_gateway
ec2_attach_vpn_gateway <- function(VpcId, VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVpnGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$attach_vpn_gateway_input(VpcId = VpcId, VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$attach_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_vpn_gateway <- ec2_attach_vpn_gateway

#' Adds an ingress authorization rule to a Client VPN endpoint
#'
#' @description
#' Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in Amazon Web Services or on-premises networks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_authorize_client_vpn_ingress/](https://www.paws-r-sdk.com/docs/ec2_authorize_client_vpn_ingress/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param TargetNetworkCidr &#91;required&#93; The IPv4 address range, in CIDR notation, of the network for which
#' access is being authorized.
#' @param AccessGroupId The ID of the group to grant access to, for example, the Active
#' Directory group or identity provider (IdP) group. Required if
#' `AuthorizeAllGroups` is `false` or not specified.
#' @param AuthorizeAllGroups Indicates whether to grant access to all clients. Specify `true` to
#' grant all clients who successfully establish a VPN connection access to
#' the network. Must be set to `true` if `AccessGroupId` is not specified.
#' @param Description A brief description of the authorization rule.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_client_vpn_ingress
ec2_authorize_client_vpn_ingress <- function(ClientVpnEndpointId, TargetNetworkCidr, AccessGroupId = NULL, AuthorizeAllGroups = NULL, Description = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AuthorizeClientVpnIngress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$authorize_client_vpn_ingress_input(ClientVpnEndpointId = ClientVpnEndpointId, TargetNetworkCidr = TargetNetworkCidr, AccessGroupId = AccessGroupId, AuthorizeAllGroups = AuthorizeAllGroups, Description = Description, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$authorize_client_vpn_ingress_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_client_vpn_ingress <- ec2_authorize_client_vpn_ingress

#' Adds the specified outbound (egress) rules to a security group
#'
#' @description
#' Adds the specified outbound (egress) rules to a security group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_authorize_security_group_egress/](https://www.paws-r-sdk.com/docs/ec2_authorize_security_group_egress/) for full documentation.
#'
#' @param TagSpecifications The tags applied to the security group rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupId &#91;required&#93; The ID of the security group.
#' @param SourceSecurityGroupName Not supported. Use IP permissions instead.
#' @param SourceSecurityGroupOwnerId Not supported. Use IP permissions instead.
#' @param IpProtocol Not supported. Use IP permissions instead.
#' @param FromPort Not supported. Use IP permissions instead.
#' @param ToPort Not supported. Use IP permissions instead.
#' @param CidrIp Not supported. Use IP permissions instead.
#' @param IpPermissions The permissions for the security group rules.
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_security_group_egress
ec2_authorize_security_group_egress <- function(TagSpecifications = NULL, DryRun = NULL, GroupId, SourceSecurityGroupName = NULL, SourceSecurityGroupOwnerId = NULL, IpProtocol = NULL, FromPort = NULL, ToPort = NULL, CidrIp = NULL, IpPermissions = NULL) {
  op <- new_operation(
    name = "AuthorizeSecurityGroupEgress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$authorize_security_group_egress_input(TagSpecifications = TagSpecifications, DryRun = DryRun, GroupId = GroupId, SourceSecurityGroupName = SourceSecurityGroupName, SourceSecurityGroupOwnerId = SourceSecurityGroupOwnerId, IpProtocol = IpProtocol, FromPort = FromPort, ToPort = ToPort, CidrIp = CidrIp, IpPermissions = IpPermissions)
  output <- .ec2$authorize_security_group_egress_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_security_group_egress <- ec2_authorize_security_group_egress

#' Adds the specified inbound (ingress) rules to a security group
#'
#' @description
#' Adds the specified inbound (ingress) rules to a security group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_authorize_security_group_ingress/](https://www.paws-r-sdk.com/docs/ec2_authorize_security_group_ingress/) for full documentation.
#'
#' @param CidrIp The IPv4 address range, in CIDR format.
#' 
#' To specify an IPv6 address range, use IP permissions instead.
#' 
#' To specify multiple rules and descriptions for the rules, use IP
#' permissions instead.
#' @param FromPort If the protocol is TCP or UDP, this is the start of the port range. If
#' the protocol is ICMP, this is the ICMP type or -1 (all ICMP types).
#' 
#' To specify multiple rules and descriptions for the rules, use IP
#' permissions instead.
#' @param GroupId The ID of the security group.
#' @param GroupName \[Default VPC\] The name of the security group. For security groups for
#' a default VPC you can specify either the ID or the name of the security
#' group. For security groups for a nondefault VPC, you must specify the ID
#' of the security group.
#' @param IpPermissions The permissions for the security group rules.
#' @param IpProtocol The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
#' Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
#' To specify all protocols, use `-1`.
#' 
#' To specify `icmpv6`, use IP permissions instead.
#' 
#' If you specify a protocol other than one of the supported values,
#' traffic is allowed on all ports, regardless of any ports that you
#' specify.
#' 
#' To specify multiple rules and descriptions for the rules, use IP
#' permissions instead.
#' @param SourceSecurityGroupName \[Default VPC\] The name of the source security group.
#' 
#' The rule grants full ICMP, UDP, and TCP access. To create a rule with a
#' specific protocol and port range, specify a set of IP permissions
#' instead.
#' @param SourceSecurityGroupOwnerId The Amazon Web Services account ID for the source security group, if the
#' source security group is in a different account.
#' 
#' The rule grants full ICMP, UDP, and TCP access. To create a rule with a
#' specific protocol and port range, use IP permissions instead.
#' @param ToPort If the protocol is TCP or UDP, this is the end of the port range. If the
#' protocol is ICMP, this is the ICMP code or -1 (all ICMP codes). If the
#' start port is -1 (all ICMP types), then the end port must be -1 (all
#' ICMP codes).
#' 
#' To specify multiple rules and descriptions for the rules, use IP
#' permissions instead.
#' @param TagSpecifications The tags applied to the security group rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_security_group_ingress
ec2_authorize_security_group_ingress <- function(CidrIp = NULL, FromPort = NULL, GroupId = NULL, GroupName = NULL, IpPermissions = NULL, IpProtocol = NULL, SourceSecurityGroupName = NULL, SourceSecurityGroupOwnerId = NULL, ToPort = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AuthorizeSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$authorize_security_group_ingress_input(CidrIp = CidrIp, FromPort = FromPort, GroupId = GroupId, GroupName = GroupName, IpPermissions = IpPermissions, IpProtocol = IpProtocol, SourceSecurityGroupName = SourceSecurityGroupName, SourceSecurityGroupOwnerId = SourceSecurityGroupOwnerId, ToPort = ToPort, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$authorize_security_group_ingress_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_security_group_ingress <- ec2_authorize_security_group_ingress

#' Bundles an Amazon instance store-backed Windows instance
#'
#' @description
#' Bundles an Amazon instance store-backed Windows instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_bundle_instance/](https://www.paws-r-sdk.com/docs/ec2_bundle_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the instance to bundle.
#' 
#' Default: None
#' @param Storage &#91;required&#93; The bucket in which to store the AMI. You can specify a bucket that you
#' already own or a new bucket that Amazon EC2 creates on your behalf. If
#' you specify a bucket that belongs to someone else, Amazon EC2 returns an
#' error.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_bundle_instance
ec2_bundle_instance <- function(InstanceId, Storage, DryRun = NULL) {
  op <- new_operation(
    name = "BundleInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$bundle_instance_input(InstanceId = InstanceId, Storage = Storage, DryRun = DryRun)
  output <- .ec2$bundle_instance_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$bundle_instance <- ec2_bundle_instance

#' Cancels a bundling operation for an instance store-backed Windows
#' instance
#'
#' @description
#' Cancels a bundling operation for an instance store-backed Windows instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_bundle_task/](https://www.paws-r-sdk.com/docs/ec2_cancel_bundle_task/) for full documentation.
#'
#' @param BundleId &#91;required&#93; The ID of the bundle task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_bundle_task
ec2_cancel_bundle_task <- function(BundleId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelBundleTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_bundle_task_input(BundleId = BundleId, DryRun = DryRun)
  output <- .ec2$cancel_bundle_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_bundle_task <- ec2_cancel_bundle_task

#' Cancels the specified Capacity Reservation, releases the reserved
#' capacity, and changes the Capacity Reservation's state to cancelled
#'
#' @description
#' Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation's state to `cancelled`.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_capacity_reservation/](https://www.paws-r-sdk.com/docs/ec2_cancel_capacity_reservation/) for full documentation.
#'
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation to be cancelled.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_capacity_reservation
ec2_cancel_capacity_reservation <- function(CapacityReservationId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelCapacityReservation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_capacity_reservation_input(CapacityReservationId = CapacityReservationId, DryRun = DryRun)
  output <- .ec2$cancel_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_capacity_reservation <- ec2_cancel_capacity_reservation

#' Cancels one or more Capacity Reservation Fleets
#'
#' @description
#' Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following happens:
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_capacity_reservation_fleets/](https://www.paws-r-sdk.com/docs/ec2_cancel_capacity_reservation_fleets/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CapacityReservationFleetIds &#91;required&#93; The IDs of the Capacity Reservation Fleets to cancel.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_capacity_reservation_fleets
ec2_cancel_capacity_reservation_fleets <- function(DryRun = NULL, CapacityReservationFleetIds) {
  op <- new_operation(
    name = "CancelCapacityReservationFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_capacity_reservation_fleets_input(DryRun = DryRun, CapacityReservationFleetIds = CapacityReservationFleetIds)
  output <- .ec2$cancel_capacity_reservation_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_capacity_reservation_fleets <- ec2_cancel_capacity_reservation_fleets

#' Cancels an active conversion task
#'
#' @description
#' Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_conversion_task/](https://www.paws-r-sdk.com/docs/ec2_cancel_conversion_task/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConversionTaskId &#91;required&#93; The ID of the conversion task.
#' @param ReasonMessage The reason for canceling the conversion task.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_conversion_task
ec2_cancel_conversion_task <- function(DryRun = NULL, ConversionTaskId, ReasonMessage = NULL) {
  op <- new_operation(
    name = "CancelConversionTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_conversion_task_input(DryRun = DryRun, ConversionTaskId = ConversionTaskId, ReasonMessage = ReasonMessage)
  output <- .ec2$cancel_conversion_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_conversion_task <- ec2_cancel_conversion_task

#' Cancels the generation of an account status report
#'
#' @description
#' Cancels the generation of an account status report.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_declarative_policies_report/](https://www.paws-r-sdk.com/docs/ec2_cancel_declarative_policies_report/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReportId &#91;required&#93; The ID of the report.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_declarative_policies_report
ec2_cancel_declarative_policies_report <- function(DryRun = NULL, ReportId) {
  op <- new_operation(
    name = "CancelDeclarativePoliciesReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_declarative_policies_report_input(DryRun = DryRun, ReportId = ReportId)
  output <- .ec2$cancel_declarative_policies_report_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_declarative_policies_report <- ec2_cancel_declarative_policies_report

#' Cancels an active export task
#'
#' @description
#' Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_export_task/](https://www.paws-r-sdk.com/docs/ec2_cancel_export_task/) for full documentation.
#'
#' @param ExportTaskId &#91;required&#93; The ID of the export task. This is the ID returned by the
#' [`create_instance_export_task`][ec2_create_instance_export_task] and
#' [`export_image`][ec2_export_image] operations.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_export_task
ec2_cancel_export_task <- function(ExportTaskId) {
  op <- new_operation(
    name = "CancelExportTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_export_task_input(ExportTaskId = ExportTaskId)
  output <- .ec2$cancel_export_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_export_task <- ec2_cancel_export_task

#' Removes your Amazon Web Services account from the launch permissions for
#' the specified AMI
#'
#' @description
#' Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information, see [Cancel having an AMI shared with your Amazon Web Services account](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_image_launch_permission/](https://www.paws-r-sdk.com/docs/ec2_cancel_image_launch_permission/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The ID of the AMI that was shared with your Amazon Web Services account.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_image_launch_permission
ec2_cancel_image_launch_permission <- function(ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelImageLaunchPermission",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_image_launch_permission_input(ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$cancel_image_launch_permission_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_image_launch_permission <- ec2_cancel_image_launch_permission

#' Cancels an in-process import virtual machine or import snapshot task
#'
#' @description
#' Cancels an in-process import virtual machine or import snapshot task.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_import_task/](https://www.paws-r-sdk.com/docs/ec2_cancel_import_task/) for full documentation.
#'
#' @param CancelReason The reason for canceling the task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ImportTaskId The ID of the import image or import snapshot task to be canceled.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_import_task
ec2_cancel_import_task <- function(CancelReason = NULL, DryRun = NULL, ImportTaskId = NULL) {
  op <- new_operation(
    name = "CancelImportTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_import_task_input(CancelReason = CancelReason, DryRun = DryRun, ImportTaskId = ImportTaskId)
  output <- .ec2$cancel_import_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_import_task <- ec2_cancel_import_task

#' Cancels the specified Reserved Instance listing in the Reserved Instance
#' Marketplace
#'
#' @description
#' Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_reserved_instances_listing/](https://www.paws-r-sdk.com/docs/ec2_cancel_reserved_instances_listing/) for full documentation.
#'
#' @param ReservedInstancesListingId &#91;required&#93; The ID of the Reserved Instance listing.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_reserved_instances_listing
ec2_cancel_reserved_instances_listing <- function(ReservedInstancesListingId) {
  op <- new_operation(
    name = "CancelReservedInstancesListing",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_reserved_instances_listing_input(ReservedInstancesListingId = ReservedInstancesListingId)
  output <- .ec2$cancel_reserved_instances_listing_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_reserved_instances_listing <- ec2_cancel_reserved_instances_listing

#' Cancels the specified Spot Fleet requests
#'
#' @description
#' Cancels the specified Spot Fleet requests.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_spot_fleet_requests/](https://www.paws-r-sdk.com/docs/ec2_cancel_spot_fleet_requests/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotFleetRequestIds &#91;required&#93; The IDs of the Spot Fleet requests.
#' 
#' Constraint: You can specify up to 100 IDs in a single request.
#' @param TerminateInstances &#91;required&#93; Indicates whether to terminate the associated instances when the Spot
#' Fleet request is canceled. The default is to terminate the instances.
#' 
#' To let the instances continue to run after the Spot Fleet request is
#' canceled, specify `no-terminate-instances`.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_spot_fleet_requests
ec2_cancel_spot_fleet_requests <- function(DryRun = NULL, SpotFleetRequestIds, TerminateInstances) {
  op <- new_operation(
    name = "CancelSpotFleetRequests",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_spot_fleet_requests_input(DryRun = DryRun, SpotFleetRequestIds = SpotFleetRequestIds, TerminateInstances = TerminateInstances)
  output <- .ec2$cancel_spot_fleet_requests_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_spot_fleet_requests <- ec2_cancel_spot_fleet_requests

#' Cancels one or more Spot Instance requests
#'
#' @description
#' Cancels one or more Spot Instance requests.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_cancel_spot_instance_requests/](https://www.paws-r-sdk.com/docs/ec2_cancel_spot_instance_requests/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotInstanceRequestIds &#91;required&#93; The IDs of the Spot Instance requests.
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_spot_instance_requests
ec2_cancel_spot_instance_requests <- function(DryRun = NULL, SpotInstanceRequestIds) {
  op <- new_operation(
    name = "CancelSpotInstanceRequests",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$cancel_spot_instance_requests_input(DryRun = DryRun, SpotInstanceRequestIds = SpotInstanceRequestIds)
  output <- .ec2$cancel_spot_instance_requests_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_spot_instance_requests <- ec2_cancel_spot_instance_requests

#' Determines whether a product code is associated with an instance
#'
#' @description
#' Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user's instance is eligible for support.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_confirm_product_instance/](https://www.paws-r-sdk.com/docs/ec2_confirm_product_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param ProductCode &#91;required&#93; The product code. This must be a product code that you own.
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_confirm_product_instance
ec2_confirm_product_instance <- function(InstanceId, ProductCode, DryRun = NULL) {
  op <- new_operation(
    name = "ConfirmProductInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$confirm_product_instance_input(InstanceId = InstanceId, ProductCode = ProductCode, DryRun = DryRun)
  output <- .ec2$confirm_product_instance_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$confirm_product_instance <- ec2_confirm_product_instance

#' Copies the specified Amazon FPGA Image (AFI) to the current Region
#'
#' @description
#' Copies the specified Amazon FPGA Image (AFI) to the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_copy_fpga_image/](https://www.paws-r-sdk.com/docs/ec2_copy_fpga_image/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SourceFpgaImageId &#91;required&#93; The ID of the source AFI.
#' @param Description The description for the new AFI.
#' @param Name The name for the new AFI. The default is the name of the source AFI.
#' @param SourceRegion &#91;required&#93; The Region that contains the source AFI.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_copy_fpga_image
ec2_copy_fpga_image <- function(DryRun = NULL, SourceFpgaImageId, Description = NULL, Name = NULL, SourceRegion, ClientToken = NULL) {
  op <- new_operation(
    name = "CopyFpgaImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$copy_fpga_image_input(DryRun = DryRun, SourceFpgaImageId = SourceFpgaImageId, Description = Description, Name = Name, SourceRegion = SourceRegion, ClientToken = ClientToken)
  output <- .ec2$copy_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_fpga_image <- ec2_copy_fpga_image

#' Initiates an AMI copy operation
#'
#' @description
#' Initiates an AMI copy operation. You can copy an AMI from one Region to another, or from a Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy an AMI to another partition, see [`create_store_image_task`][ec2_create_store_image_task].
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_copy_image/](https://www.paws-r-sdk.com/docs/ec2_copy_image/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure idempotency of
#' the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html)
#' in the *Amazon EC2 API Reference*.
#' @param Description A description for the new AMI in the destination Region.
#' @param Encrypted Specifies whether the destination snapshots of the copied image should
#' be encrypted. You can encrypt a copy of an unencrypted snapshot, but you
#' cannot create an unencrypted copy of an encrypted snapshot. The default
#' KMS key for Amazon EBS is used unless you specify a non-default Key
#' Management Service (KMS) KMS key using `KmsKeyId`. For more information,
#' see [Use encryption with EBS-backed
#' AMIs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html)
#' in the *Amazon EC2 User Guide*.
#' @param KmsKeyId The identifier of the symmetric Key Management Service (KMS) KMS key to
#' use when creating encrypted volumes. If this parameter is not specified,
#' your Amazon Web Services managed KMS key for Amazon EBS is used. If you
#' specify a KMS key, you must also set the encrypted state to `true`.
#' 
#' You can specify a KMS key using any of the following:
#' 
#' -   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
#' 
#' Amazon Web Services authenticates the KMS key asynchronously. Therefore,
#' if you specify an identifier that is not valid, the action can appear to
#' complete, but eventually fails.
#' 
#' The specified KMS key must exist in the destination Region.
#' 
#' Amazon EBS does not support asymmetric KMS keys.
#' @param Name &#91;required&#93; The name of the new AMI in the destination Region.
#' @param SourceImageId &#91;required&#93; The ID of the AMI to copy.
#' @param SourceRegion &#91;required&#93; The name of the Region that contains the AMI to copy.
#' @param DestinationOutpostArn The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI.
#' Only specify this parameter when copying an AMI from an Amazon Web
#' Services Region to an Outpost. The AMI must be in the Region of the
#' destination Outpost. You cannot copy an AMI from an Outpost to a Region,
#' from one Outpost to another, or within the same Outpost.
#' 
#' For more information, see [Copy AMIs from an Amazon Web Services Region
#' to an
#' Outpost](https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-amis)
#' in the *Amazon EBS User Guide*.
#' @param CopyImageTags Indicates whether to include your user-defined AMI tags when copying the
#' AMI.
#' 
#' The following tags will not be copied:
#' 
#' -   System tags (prefixed with `aws:`)
#' 
#' -   For public and shared AMIs, user-defined tags that are attached by
#'     other Amazon Web Services accounts
#' 
#' Default: Your user-defined AMI tags are not copied.
#' @param TagSpecifications The tags to apply to the new AMI and new snapshots. You can tag the AMI,
#' the snapshots, or both.
#' 
#' -   To tag the new AMI, the value for `ResourceType` must be `image`.
#' 
#' -   To tag the new snapshots, the value for `ResourceType` must be
#'     `snapshot`. The same tag is applied to all the new snapshots.
#' 
#' If you specify other values for `ResourceType`, the request fails.
#' 
#' To tag an AMI or snapshot after it has been created, see
#' [`create_tags`][ec2_create_tags].
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_copy_image
ec2_copy_image <- function(ClientToken = NULL, Description = NULL, Encrypted = NULL, KmsKeyId = NULL, Name, SourceImageId, SourceRegion, DestinationOutpostArn = NULL, CopyImageTags = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CopyImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$copy_image_input(ClientToken = ClientToken, Description = Description, Encrypted = Encrypted, KmsKeyId = KmsKeyId, Name = Name, SourceImageId = SourceImageId, SourceRegion = SourceRegion, DestinationOutpostArn = DestinationOutpostArn, CopyImageTags = CopyImageTags, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$copy_image_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_image <- ec2_copy_image

#' Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
#' S3
#'
#' @description
#' Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an Outpost to a Region, from one Outpost to another, or within the same Outpost.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_copy_snapshot/](https://www.paws-r-sdk.com/docs/ec2_copy_snapshot/) for full documentation.
#'
#' @param Description A description for the EBS snapshot.
#' @param DestinationOutpostArn The Amazon Resource Name (ARN) of the Outpost to which to copy the
#' snapshot. Only specify this parameter when copying a snapshot from an
#' Amazon Web Services Region to an Outpost. The snapshot must be in the
#' Region for the destination Outpost. You cannot copy a snapshot from an
#' Outpost to a Region, from one Outpost to another, or within the same
#' Outpost.
#' 
#' For more information, see [Copy snapshots from an Amazon Web Services
#' Region to an
#' Outpost](https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-snapshots)
#' in the *Amazon EBS User Guide*.
#' @param DestinationRegion The destination Region to use in the `PresignedUrl` parameter of a
#' snapshot copy operation. This parameter is only valid for specifying the
#' destination Region in a `PresignedUrl` parameter, where it is required.
#' 
#' The snapshot copy is sent to the regional endpoint that you sent the
#' HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With the
#' CLI, this is specified using the `--region` parameter or the default
#' Region in your Amazon Web Services configuration file.
#' @param Encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is
#' not enabled, enable encryption using this parameter. Otherwise, omit
#' this parameter. Encrypted snapshots are encrypted, even if you omit this
#' parameter and encryption by default is not enabled. You cannot set this
#' parameter to false. For more information, see [Amazon EBS
#' encryption](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html)
#' in the *Amazon EBS User Guide*.
#' @param KmsKeyId The identifier of the KMS key to use for Amazon EBS encryption. If this
#' parameter is not specified, your KMS key for Amazon EBS is used. If
#' `KmsKeyId` is specified, the encrypted state must be `true`.
#' 
#' You can specify the KMS key using any of the following:
#' 
#' -   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
#' 
#' Amazon Web Services authenticates the KMS key asynchronously. Therefore,
#' if you specify an ID, alias, or ARN that is not valid, the action can
#' appear to complete, but eventually fails.
#' @param PresignedUrl When you copy an encrypted source snapshot using the Amazon EC2 Query
#' API, you must supply a pre-signed URL. This parameter is optional for
#' unencrypted snapshots. For more information, see [Query
#' requests](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html).
#' 
#' The `PresignedUrl` should use the snapshot source endpoint, the
#' [`copy_snapshot`][ec2_copy_snapshot] action, and include the
#' `SourceRegion`, `SourceSnapshotId`, and `DestinationRegion` parameters.
#' The `PresignedUrl` must be signed using Amazon Web Services Signature
#' Version 4. Because EBS snapshots are stored in Amazon S3, the signing
#' algorithm for this parameter uses the same logic that is described in
#' [Authenticating Requests: Using Query Parameters (Amazon Web Services
#' Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' in the *Amazon S3 API Reference*. An invalid or improperly signed
#' `PresignedUrl` will cause the copy operation to fail asynchronously, and
#' the snapshot will move to an `error` state.
#' @param SourceRegion &#91;required&#93; The ID of the Region that contains the snapshot to be copied.
#' @param SourceSnapshotId &#91;required&#93; The ID of the EBS snapshot to copy.
#' @param TagSpecifications The tags to apply to the new snapshot.
#' @param CompletionDurationMinutes Specify a completion duration, in 15 minute increments, to initiate a
#' time-based snapshot copy. Time-based snapshot copy operations complete
#' within the specified duration. For more information, see [Time-based
#' copies](https://docs.aws.amazon.com/ebs/latest/userguide/time-based-copies.html).
#' 
#' If you do not specify a value, the snapshot copy operation is completed
#' on a best-effort basis.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_copy_snapshot
ec2_copy_snapshot <- function(Description = NULL, DestinationOutpostArn = NULL, DestinationRegion = NULL, Encrypted = NULL, KmsKeyId = NULL, PresignedUrl = NULL, SourceRegion, SourceSnapshotId, TagSpecifications = NULL, CompletionDurationMinutes = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$copy_snapshot_input(Description = Description, DestinationOutpostArn = DestinationOutpostArn, DestinationRegion = DestinationRegion, Encrypted = Encrypted, KmsKeyId = KmsKeyId, PresignedUrl = PresignedUrl, SourceRegion = SourceRegion, SourceSnapshotId = SourceSnapshotId, TagSpecifications = TagSpecifications, CompletionDurationMinutes = CompletionDurationMinutes, DryRun = DryRun)
  output <- .ec2$copy_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_snapshot <- ec2_copy_snapshot

#' Creates a new Capacity Reservation with the specified attributes
#'
#' @description
#' Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation/](https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensure
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param InstanceType &#91;required&#93; The instance type for which to reserve capacity.
#' 
#' You can request future-dated Capacity Reservations for instance types in
#' the C, M, R, I, and T instance families only.
#' 
#' For more information, see [Instance
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon EC2 User Guide*.
#' @param InstancePlatform &#91;required&#93; The type of operating system for which to reserve capacity.
#' @param AvailabilityZone The Availability Zone in which to create the Capacity Reservation.
#' @param AvailabilityZoneId The ID of the Availability Zone in which to create the Capacity
#' Reservation.
#' @param Tenancy Indicates the tenancy of the Capacity Reservation. A Capacity
#' Reservation can have one of the following tenancy settings:
#' 
#' -   `default` - The Capacity Reservation is created on hardware that is
#'     shared with other Amazon Web Services accounts.
#' 
#' -   `dedicated` - The Capacity Reservation is created on single-tenant
#'     hardware that is dedicated to a single Amazon Web Services account.
#' @param InstanceCount &#91;required&#93; The number of instances for which to reserve capacity.
#' 
#' You can request future-dated Capacity Reservations for an instance count
#' with a minimum of 100 VPUs. For example, if you request a future-dated
#' Capacity Reservation for `m5.xlarge` instances, you must request at
#' least 25 instances (*25 * m5.xlarge = 100 vCPUs*).
#' 
#' Valid range: 1 - 1000
#' @param EbsOptimized Indicates whether the Capacity Reservation supports EBS-optimized
#' instances. This optimization provides dedicated throughput to Amazon EBS
#' and an optimized configuration stack to provide optimal I/O performance.
#' This optimization isn't available with all instance types. Additional
#' usage charges apply when using an EBS- optimized instance.
#' @param EphemeralStorage *Deprecated.*
#' @param EndDate The date and time at which the Capacity Reservation expires. When a
#' Capacity Reservation expires, the reserved capacity is released and you
#' can no longer launch instances into it. The Capacity Reservation's state
#' changes to `expired` when it reaches its end date and time.
#' 
#' You must provide an `EndDate` value if `EndDateType` is `limited`. Omit
#' `EndDate` if `EndDateType` is `unlimited`.
#' 
#' If the `EndDateType` is `limited`, the Capacity Reservation is cancelled
#' within an hour from the specified time. For example, if you specify
#' 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end
#' between 13:30:55 and 14:30:55 on 5/31/2019.
#' 
#' If you are requesting a future-dated Capacity Reservation, you can't
#' specify an end date and time that is within the commitment duration.
#' @param EndDateType Indicates the way in which the Capacity Reservation ends. A Capacity
#' Reservation can have one of the following end types:
#' 
#' -   `unlimited` - The Capacity Reservation remains active until you
#'     explicitly cancel it. Do not provide an `EndDate` if the
#'     `EndDateType` is `unlimited`.
#' 
#' -   `limited` - The Capacity Reservation expires automatically at a
#'     specified date and time. You must provide an `EndDate` value if the
#'     `EndDateType` value is `limited`.
#' @param InstanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation
#' accepts. The options include:
#' 
#' -   `open` - The Capacity Reservation automatically matches all
#'     instances that have matching attributes (instance type, platform,
#'     and Availability Zone). Instances that have matching attributes run
#'     in the Capacity Reservation automatically without specifying any
#'     additional parameters.
#' 
#' -   `targeted` - The Capacity Reservation only accepts instances that
#'     have matching attributes (instance type, platform, and Availability
#'     Zone), and explicitly target the Capacity Reservation. This ensures
#'     that only permitted instances can use the reserved capacity.
#' 
#' If you are requesting a future-dated Capacity Reservation, you must
#' specify `targeted`.
#' 
#' Default: `open`
#' @param TagSpecifications The tags to apply to the Capacity Reservation during launch.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param OutpostArn Not supported for future-dated Capacity Reservations.
#' 
#' The Amazon Resource Name (ARN) of the Outpost on which to create the
#' Capacity Reservation.
#' @param PlacementGroupArn Not supported for future-dated Capacity Reservations.
#' 
#' The Amazon Resource Name (ARN) of the cluster placement group in which
#' to create the Capacity Reservation. For more information, see [Capacity
#' Reservations for cluster placement
#' groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html)
#' in the *Amazon EC2 User Guide*.
#' @param StartDate Required for future-dated Capacity Reservations only. To create a
#' Capacity Reservation for immediate use, omit this parameter.
#' 
#' The date and time at which the future-dated Capacity Reservation should
#' become available for use, in the ISO8601 format in the UTC time zone
#' (`YYYY-MM-DDThh:mm:ss.sssZ`).
#' 
#' You can request a future-dated Capacity Reservation between 5 and 120
#' days in advance.
#' @param CommitmentDuration Required for future-dated Capacity Reservations only. To create a
#' Capacity Reservation for immediate use, omit this parameter.
#' 
#' Specify a commitment duration, in seconds, for the future-dated Capacity
#' Reservation.
#' 
#' The commitment duration is a minimum duration for which you commit to
#' having the future-dated Capacity Reservation in the `active` state in
#' your account after it has been delivered.
#' 
#' For more information, see [Commitment
#' duration](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration).
#' @param DeliveryPreference Required for future-dated Capacity Reservations only. To create a
#' Capacity Reservation for immediate use, omit this parameter.
#' 
#' Indicates that the requested capacity will be delivered in addition to
#' any running instances or reserved capacity that you have in your account
#' at the requested date and time.
#' 
#' The only supported value is `incremental`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_capacity_reservation
ec2_create_capacity_reservation <- function(ClientToken = NULL, InstanceType, InstancePlatform, AvailabilityZone = NULL, AvailabilityZoneId = NULL, Tenancy = NULL, InstanceCount, EbsOptimized = NULL, EphemeralStorage = NULL, EndDate = NULL, EndDateType = NULL, InstanceMatchCriteria = NULL, TagSpecifications = NULL, DryRun = NULL, OutpostArn = NULL, PlacementGroupArn = NULL, StartDate = NULL, CommitmentDuration = NULL, DeliveryPreference = NULL) {
  op <- new_operation(
    name = "CreateCapacityReservation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_capacity_reservation_input(ClientToken = ClientToken, InstanceType = InstanceType, InstancePlatform = InstancePlatform, AvailabilityZone = AvailabilityZone, AvailabilityZoneId = AvailabilityZoneId, Tenancy = Tenancy, InstanceCount = InstanceCount, EbsOptimized = EbsOptimized, EphemeralStorage = EphemeralStorage, EndDate = EndDate, EndDateType = EndDateType, InstanceMatchCriteria = InstanceMatchCriteria, TagSpecifications = TagSpecifications, DryRun = DryRun, OutpostArn = OutpostArn, PlacementGroupArn = PlacementGroupArn, StartDate = StartDate, CommitmentDuration = CommitmentDuration, DeliveryPreference = DeliveryPreference)
  output <- .ec2$create_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_capacity_reservation <- ec2_create_capacity_reservation

#' Create a new Capacity Reservation by splitting the capacity of the
#' source Capacity Reservation
#'
#' @description
#' Create a new Capacity Reservation by splitting the capacity of the source Capacity Reservation. The new Capacity Reservation will have the same attributes as the source Capacity Reservation except for tags. The source Capacity Reservation must be `active` and owned by your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation_by_splitting/](https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation_by_splitting/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensure
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param SourceCapacityReservationId &#91;required&#93; The ID of the Capacity Reservation from which you want to split the
#' capacity.
#' @param InstanceCount &#91;required&#93; The number of instances to split from the source Capacity Reservation.
#' @param TagSpecifications The tags to apply to the new Capacity Reservation.
#'
#' @keywords internal
#'
#' @rdname ec2_create_capacity_reservation_by_splitting
ec2_create_capacity_reservation_by_splitting <- function(DryRun = NULL, ClientToken = NULL, SourceCapacityReservationId, InstanceCount, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateCapacityReservationBySplitting",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_capacity_reservation_by_splitting_input(DryRun = DryRun, ClientToken = ClientToken, SourceCapacityReservationId = SourceCapacityReservationId, InstanceCount = InstanceCount, TagSpecifications = TagSpecifications)
  output <- .ec2$create_capacity_reservation_by_splitting_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_capacity_reservation_by_splitting <- ec2_create_capacity_reservation_by_splitting

#' Creates a Capacity Reservation Fleet
#'
#' @description
#' Creates a Capacity Reservation Fleet. For more information, see [Create a Capacity Reservation Fleet](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#create-crfleet) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation_fleet/](https://www.paws-r-sdk.com/docs/ec2_create_capacity_reservation_fleet/) for full documentation.
#'
#' @param AllocationStrategy The strategy used by the Capacity Reservation Fleet to determine which
#' of the specified instance types to use. Currently, only the
#' `prioritized` allocation strategy is supported. For more information,
#' see [Allocation
#' strategy](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy)
#' in the *Amazon EC2 User Guide*.
#' 
#' Valid values: `prioritized`
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensure
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param InstanceTypeSpecifications &#91;required&#93; Information about the instance types for which to reserve the capacity.
#' @param Tenancy Indicates the tenancy of the Capacity Reservation Fleet. All Capacity
#' Reservations in the Fleet inherit this tenancy. The Capacity Reservation
#' Fleet can have one of the following tenancy settings:
#' 
#' -   `default` - The Capacity Reservation Fleet is created on hardware
#'     that is shared with other Amazon Web Services accounts.
#' 
#' -   `dedicated` - The Capacity Reservations are created on single-tenant
#'     hardware that is dedicated to a single Amazon Web Services account.
#' @param TotalTargetCapacity &#91;required&#93; The total number of capacity units to be reserved by the Capacity
#' Reservation Fleet. This value, together with the instance type weights
#' that you assign to each instance type used by the Fleet determine the
#' number of instances for which the Fleet reserves capacity. Both values
#' are based on units that make sense for your workload. For more
#' information, see [Total target
#' capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity)
#' in the *Amazon EC2 User Guide*.
#' @param EndDate The date and time at which the Capacity Reservation Fleet expires. When
#' the Capacity Reservation Fleet expires, its state changes to `expired`
#' and all of the Capacity Reservations in the Fleet expire.
#' 
#' The Capacity Reservation Fleet expires within an hour after the
#' specified time. For example, if you specify `5/31/2019`, `13:30:55`, the
#' Capacity Reservation Fleet is guaranteed to expire between `13:30:55`
#' and `14:30:55` on `5/31/2019`.
#' @param InstanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation
#' Fleet accepts. All Capacity Reservations in the Fleet inherit this
#' instance matching criteria.
#' 
#' Currently, Capacity Reservation Fleets support `open` instance matching
#' criteria only. This means that instances that have matching attributes
#' (instance type, platform, and Availability Zone) run in the Capacity
#' Reservations automatically. Instances do not need to explicitly target a
#' Capacity Reservation Fleet to use its reserved capacity.
#' @param TagSpecifications The tags to assign to the Capacity Reservation Fleet. The tags are
#' automatically assigned to the Capacity Reservations in the Fleet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_capacity_reservation_fleet
ec2_create_capacity_reservation_fleet <- function(AllocationStrategy = NULL, ClientToken = NULL, InstanceTypeSpecifications, Tenancy = NULL, TotalTargetCapacity, EndDate = NULL, InstanceMatchCriteria = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCapacityReservationFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_capacity_reservation_fleet_input(AllocationStrategy = AllocationStrategy, ClientToken = ClientToken, InstanceTypeSpecifications = InstanceTypeSpecifications, Tenancy = Tenancy, TotalTargetCapacity = TotalTargetCapacity, EndDate = EndDate, InstanceMatchCriteria = InstanceMatchCriteria, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_capacity_reservation_fleet_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_capacity_reservation_fleet <- ec2_create_capacity_reservation_fleet

#' Creates a carrier gateway
#'
#' @description
#' Creates a carrier gateway. For more information about carrier gateways, see [Carrier gateways](https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway) in the *Amazon Web Services Wavelength Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_carrier_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_carrier_gateway/) for full documentation.
#'
#' @param VpcId &#91;required&#93; The ID of the VPC to associate with the carrier gateway.
#' @param TagSpecifications The tags to associate with the carrier gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_carrier_gateway
ec2_create_carrier_gateway <- function(VpcId, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateCarrierGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_carrier_gateway_input(VpcId = VpcId, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_carrier_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_carrier_gateway <- ec2_create_carrier_gateway

#' Creates a Client VPN endpoint
#'
#' @description
#' Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_client_vpn_endpoint/](https://www.paws-r-sdk.com/docs/ec2_create_client_vpn_endpoint/) for full documentation.
#'
#' @param ClientCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, from which to assign client IP
#' addresses. The address range cannot overlap with the local CIDR of the
#' VPC in which the associated subnet is located, or the routes that you
#' add manually. The address range cannot be changed after the Client VPN
#' endpoint has been created. Client CIDR range must have a size of at
#' least /22 and must not be greater than /12.
#' @param ServerCertificateArn &#91;required&#93; The ARN of the server certificate. For more information, see the
#' [Certificate Manager User
#' Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
#' @param AuthenticationOptions &#91;required&#93; Information about the authentication method to be used to authenticate
#' clients.
#' @param ConnectionLogOptions &#91;required&#93; Information about the client connection logging options.
#' 
#' If you enable client connection logging, data about client connections
#' is sent to a Cloudwatch Logs log stream. The following information is
#' logged:
#' 
#' -   Client connection requests
#' 
#' -   Client connection results (successful and unsuccessful)
#' 
#' -   Reasons for unsuccessful client connection requests
#' 
#' -   Client connection termination time
#' @param DnsServers Information about the DNS servers to be used for DNS resolution. A
#' Client VPN endpoint can have up to two DNS servers. If no DNS server is
#' specified, the DNS address configured on the device is used for the DNS
#' server.
#' @param TransportProtocol The transport protocol to be used by the VPN session.
#' 
#' Default value: `udp`
#' @param VpnPort The port number to assign to the Client VPN endpoint for TCP and UDP
#' traffic.
#' 
#' Valid Values: `443` | `1194`
#' 
#' Default Value: `443`
#' @param Description A brief description of the Client VPN endpoint.
#' @param SplitTunnel Indicates whether split-tunnel is enabled on the Client VPN endpoint.
#' 
#' By default, split-tunnel on a VPN endpoint is disabled.
#' 
#' For information about split-tunnel VPN endpoints, see [Split-tunnel
#' Client VPN
#' endpoint](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html)
#' in the *Client VPN Administrator Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param TagSpecifications The tags to apply to the Client VPN endpoint during creation.
#' @param SecurityGroupIds The IDs of one or more security groups to apply to the target network.
#' You must also specify the ID of the VPC that contains the security
#' groups.
#' @param VpcId The ID of the VPC to associate with the Client VPN endpoint. If no
#' security group IDs are specified in the request, the default security
#' group for the VPC is applied.
#' @param SelfServicePortal Specify whether to enable the self-service portal for the Client VPN
#' endpoint.
#' 
#' Default Value: `enabled`
#' @param ClientConnectOptions The options for managing connection authorization for new client
#' connections.
#' @param SessionTimeoutHours The maximum VPN session duration time in hours.
#' 
#' Valid values: `8 | 10 | 12 | 24`
#' 
#' Default value: `24`
#' @param ClientLoginBannerOptions Options for enabling a customizable text banner that will be displayed
#' on Amazon Web Services provided clients when a VPN session is
#' established.
#' @param DisconnectOnSessionTimeout Indicates whether the client VPN session is disconnected after the
#' maximum timeout specified in `SessionTimeoutHours` is reached. If
#' `true`, users are prompted to reconnect client VPN. If `false`, client
#' VPN attempts to reconnect automatically. The default value is `false`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_client_vpn_endpoint
ec2_create_client_vpn_endpoint <- function(ClientCidrBlock, ServerCertificateArn, AuthenticationOptions, ConnectionLogOptions, DnsServers = NULL, TransportProtocol = NULL, VpnPort = NULL, Description = NULL, SplitTunnel = NULL, DryRun = NULL, ClientToken = NULL, TagSpecifications = NULL, SecurityGroupIds = NULL, VpcId = NULL, SelfServicePortal = NULL, ClientConnectOptions = NULL, SessionTimeoutHours = NULL, ClientLoginBannerOptions = NULL, DisconnectOnSessionTimeout = NULL) {
  op <- new_operation(
    name = "CreateClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_client_vpn_endpoint_input(ClientCidrBlock = ClientCidrBlock, ServerCertificateArn = ServerCertificateArn, AuthenticationOptions = AuthenticationOptions, ConnectionLogOptions = ConnectionLogOptions, DnsServers = DnsServers, TransportProtocol = TransportProtocol, VpnPort = VpnPort, Description = Description, SplitTunnel = SplitTunnel, DryRun = DryRun, ClientToken = ClientToken, TagSpecifications = TagSpecifications, SecurityGroupIds = SecurityGroupIds, VpcId = VpcId, SelfServicePortal = SelfServicePortal, ClientConnectOptions = ClientConnectOptions, SessionTimeoutHours = SessionTimeoutHours, ClientLoginBannerOptions = ClientLoginBannerOptions, DisconnectOnSessionTimeout = DisconnectOnSessionTimeout)
  output <- .ec2$create_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_client_vpn_endpoint <- ec2_create_client_vpn_endpoint

#' Adds a route to a network to a Client VPN endpoint
#'
#' @description
#' Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to specific resources or networks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_client_vpn_route/](https://www.paws-r-sdk.com/docs/ec2_create_client_vpn_route/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint to which to add the route.
#' @param DestinationCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, of the route destination. For
#' example:
#' 
#' -   To add a route for Internet access, enter `0.0.0.0/0`
#' 
#' -   To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
#'     range
#' 
#' -   To add a route for an on-premises network, enter the Amazon Web
#'     Services Site-to-Site VPN connection's IPv4 CIDR range
#' 
#' -   To add a route for the local network, enter the client CIDR range
#' @param TargetVpcSubnetId &#91;required&#93; The ID of the subnet through which you want to route traffic. The
#' specified subnet must be an existing target network of the Client VPN
#' endpoint.
#' 
#' Alternatively, if you're adding a route for the local network, specify
#' `local`.
#' @param Description A brief description of the route.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_client_vpn_route
ec2_create_client_vpn_route <- function(ClientVpnEndpointId, DestinationCidrBlock, TargetVpcSubnetId, Description = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateClientVpnRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_client_vpn_route_input(ClientVpnEndpointId = ClientVpnEndpointId, DestinationCidrBlock = DestinationCidrBlock, TargetVpcSubnetId = TargetVpcSubnetId, Description = Description, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$create_client_vpn_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_client_vpn_route <- ec2_create_client_vpn_route

#' Creates a range of customer-owned IP addresses
#'
#' @description
#' Creates a range of customer-owned IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_coip_cidr/](https://www.paws-r-sdk.com/docs/ec2_create_coip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; A customer-owned IP address range to create.
#' @param CoipPoolId &#91;required&#93; The ID of the address pool.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_coip_cidr
ec2_create_coip_cidr <- function(Cidr, CoipPoolId, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCoipCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_coip_cidr_input(Cidr = Cidr, CoipPoolId = CoipPoolId, DryRun = DryRun)
  output <- .ec2$create_coip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_coip_cidr <- ec2_create_coip_cidr

#' Creates a pool of customer-owned IP (CoIP) addresses
#'
#' @description
#' Creates a pool of customer-owned IP (CoIP) addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_coip_pool/](https://www.paws-r-sdk.com/docs/ec2_create_coip_pool/) for full documentation.
#'
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param TagSpecifications The tags to assign to the CoIP address pool.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_coip_pool
ec2_create_coip_pool <- function(LocalGatewayRouteTableId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCoipPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_coip_pool_input(LocalGatewayRouteTableId = LocalGatewayRouteTableId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_coip_pool_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_coip_pool <- ec2_create_coip_pool

#' Provides information to Amazon Web Services about your customer gateway
#' device
#'
#' @description
#' Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s external interface. The IP address must be static and can be behind a device performing network address translation (NAT).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_customer_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_customer_gateway/) for full documentation.
#'
#' @param BgpAsn For customer gateway devices that support BGP, specify the device's ASN.
#' You must specify either `BgpAsn` or `BgpAsnExtended` when creating the
#' customer gateway. If the ASN is larger than `2,147,483,647`, you must
#' use `BgpAsnExtended`.
#' 
#' Default: 65000
#' 
#' Valid values: `1` to `2,147,483,647`
#' @param PublicIp *This member has been deprecated.* The Internet-routable IP address for
#' the customer gateway's outside interface. The address must be static.
#' @param CertificateArn The Amazon Resource Name (ARN) for the customer gateway certificate.
#' @param Type &#91;required&#93; The type of VPN connection that this customer gateway supports
#' (`ipsec.1`).
#' @param TagSpecifications The tags to apply to the customer gateway.
#' @param DeviceName A name for the customer gateway device.
#' 
#' Length Constraints: Up to 255 characters.
#' @param IpAddress IPv4 address for the customer gateway device's outside interface. The
#' address must be static. If `OutsideIpAddressType` in your VPN connection
#' options is set to `PrivateIpv4`, you can use an RFC6598 or RFC1918
#' private IPv4 address. If `OutsideIpAddressType` is set to `PublicIpv4`,
#' you can use a public IPv4 address.
#' @param BgpAsnExtended For customer gateway devices that support BGP, specify the device's ASN.
#' You must specify either `BgpAsn` or `BgpAsnExtended` when creating the
#' customer gateway. If the ASN is larger than `2,147,483,647`, you must
#' use `BgpAsnExtended`.
#' 
#' Valid values: `2,147,483,648` to `4,294,967,295`
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_customer_gateway
ec2_create_customer_gateway <- function(BgpAsn = NULL, PublicIp = NULL, CertificateArn = NULL, Type, TagSpecifications = NULL, DeviceName = NULL, IpAddress = NULL, BgpAsnExtended = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCustomerGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_customer_gateway_input(BgpAsn = BgpAsn, PublicIp = PublicIp, CertificateArn = CertificateArn, Type = Type, TagSpecifications = TagSpecifications, DeviceName = DeviceName, IpAddress = IpAddress, BgpAsnExtended = BgpAsnExtended, DryRun = DryRun)
  output <- .ec2$create_customer_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_customer_gateway <- ec2_create_customer_gateway

#' Creates a default subnet with a size /20 IPv4 CIDR block in the
#' specified Availability Zone in your default VPC
#'
#' @description
#' Creates a default subnet with a size `/20` IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see [Create a default subnet](https://docs.aws.amazon.com/vpc/latest/userguide/work-with-default-vpc.html#create-default-subnet) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_default_subnet/](https://www.paws-r-sdk.com/docs/ec2_create_default_subnet/) for full documentation.
#'
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to create the default subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Ipv6Native Indicates whether to create an IPv6 only subnet. If you already have a
#' default subnet for this Availability Zone, you must delete it before you
#' can create an IPv6 only subnet.
#'
#' @keywords internal
#'
#' @rdname ec2_create_default_subnet
ec2_create_default_subnet <- function(AvailabilityZone, DryRun = NULL, Ipv6Native = NULL) {
  op <- new_operation(
    name = "CreateDefaultSubnet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_default_subnet_input(AvailabilityZone = AvailabilityZone, DryRun = DryRun, Ipv6Native = Ipv6Native)
  output <- .ec2$create_default_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_default_subnet <- ec2_create_default_subnet

#' Creates a default VPC with a size /16 IPv4 CIDR block and a default
#' subnet in each Availability Zone
#'
#' @description
#' Creates a default VPC with a size `/16` IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see [Default VPCs](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html) in the *Amazon VPC User Guide*. You cannot specify the components of the default VPC yourself.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_default_vpc/](https://www.paws-r-sdk.com/docs/ec2_create_default_vpc/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_default_vpc
ec2_create_default_vpc <- function(DryRun = NULL) {
  op <- new_operation(
    name = "CreateDefaultVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_default_vpc_input(DryRun = DryRun)
  output <- .ec2$create_default_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_default_vpc <- ec2_create_default_vpc

#' Creates a custom set of DHCP options
#'
#' @description
#' Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP options.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_dhcp_options/](https://www.paws-r-sdk.com/docs/ec2_create_dhcp_options/) for full documentation.
#'
#' @param DhcpConfigurations &#91;required&#93; A DHCP configuration option.
#' @param TagSpecifications The tags to assign to the DHCP option.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_dhcp_options
ec2_create_dhcp_options <- function(DhcpConfigurations, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateDhcpOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_dhcp_options_input(DhcpConfigurations = DhcpConfigurations, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_dhcp_options <- ec2_create_dhcp_options

#' &#91;IPv6 only&#93; Creates an egress-only internet gateway for your VPC
#'
#' @description
#' \[IPv6 only\] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_egress_only_internet_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_egress_only_internet_gateway/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC for which to create the egress-only internet gateway.
#' @param TagSpecifications The tags to assign to the egress-only internet gateway.
#'
#' @keywords internal
#'
#' @rdname ec2_create_egress_only_internet_gateway
ec2_create_egress_only_internet_gateway <- function(ClientToken = NULL, DryRun = NULL, VpcId, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateEgressOnlyInternetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_egress_only_internet_gateway_input(ClientToken = ClientToken, DryRun = DryRun, VpcId = VpcId, TagSpecifications = TagSpecifications)
  output <- .ec2$create_egress_only_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_egress_only_internet_gateway <- ec2_create_egress_only_internet_gateway

#' Creates an EC2 Fleet that contains the configuration information for
#' On-Demand Instances and Spot Instances
#'
#' @description
#' Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances. Instances are launched immediately if there is available capacity.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_fleet/](https://www.paws-r-sdk.com/docs/ec2_create_fleet/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param SpotOptions Describes the configuration of Spot Instances in an EC2 Fleet.
#' @param OnDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet.
#' @param ExcessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total
#' target capacity of the EC2 Fleet is decreased below the current size of
#' the EC2 Fleet.
#' 
#' Supported only for fleets of type `maintain`.
#' @param LaunchTemplateConfigs &#91;required&#93; The configuration for the EC2 Fleet.
#' @param TargetCapacitySpecification &#91;required&#93; The number of units to request.
#' @param TerminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2
#' Fleet expires.
#' @param Type The fleet type. The default value is `maintain`.
#' 
#' -   `maintain` - The EC2 Fleet places an asynchronous request for your
#'     desired capacity, and continues to maintain your desired Spot
#'     capacity by replenishing interrupted Spot Instances.
#' 
#' -   `request` - The EC2 Fleet places an asynchronous one-time request
#'     for your desired capacity, but does submit Spot requests in
#'     alternative capacity pools if Spot capacity is unavailable, and does
#'     not maintain Spot capacity if Spot Instances are interrupted.
#' 
#' -   `instant` - The EC2 Fleet places a synchronous one-time request for
#'     your desired capacity, and returns errors for any instances that
#'     could not be launched.
#' 
#' For more information, see [EC2 Fleet request
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html)
#' in the *Amazon EC2 User Guide*.
#' @param ValidFrom The start date and time of the request, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). The default is to start fulfilling
#' the request immediately.
#' @param ValidUntil The end date and time of the request, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). At this point, no new EC2 Fleet
#' requests are placed or able to fulfill the request. If no value is
#' specified, the request remains until you cancel it.
#' @param ReplaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
#' Supported only for fleets of type `maintain`. For more information, see
#' [EC2 Fleet health
#' checks](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks)
#' in the *Amazon EC2 User Guide*.
#' @param TagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. For
#' more information, see [Tag your
#' resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources).
#' 
#' If the fleet type is `instant`, specify a resource type of `fleet` to
#' tag the fleet or `instance` to tag the instances at launch.
#' 
#' If the fleet type is `maintain` or `request`, specify a resource type of
#' `fleet` to tag the fleet. You cannot specify a resource type of
#' `instance`. To tag instances at launch, specify the tags in a [launch
#' template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template).
#' @param Context Reserved.
#'
#' @keywords internal
#'
#' @rdname ec2_create_fleet
ec2_create_fleet <- function(DryRun = NULL, ClientToken = NULL, SpotOptions = NULL, OnDemandOptions = NULL, ExcessCapacityTerminationPolicy = NULL, LaunchTemplateConfigs, TargetCapacitySpecification, TerminateInstancesWithExpiration = NULL, Type = NULL, ValidFrom = NULL, ValidUntil = NULL, ReplaceUnhealthyInstances = NULL, TagSpecifications = NULL, Context = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_fleet_input(DryRun = DryRun, ClientToken = ClientToken, SpotOptions = SpotOptions, OnDemandOptions = OnDemandOptions, ExcessCapacityTerminationPolicy = ExcessCapacityTerminationPolicy, LaunchTemplateConfigs = LaunchTemplateConfigs, TargetCapacitySpecification = TargetCapacitySpecification, TerminateInstancesWithExpiration = TerminateInstancesWithExpiration, Type = Type, ValidFrom = ValidFrom, ValidUntil = ValidUntil, ReplaceUnhealthyInstances = ReplaceUnhealthyInstances, TagSpecifications = TagSpecifications, Context = Context)
  output <- .ec2$create_fleet_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_fleet <- ec2_create_fleet

#' Creates one or more flow logs to capture information about IP traffic
#' for a specific network interface, subnet, or VPC
#'
#' @description
#' Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_flow_logs/](https://www.paws-r-sdk.com/docs/ec2_create_flow_logs/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DeliverLogsPermissionArn The ARN of the IAM role that allows Amazon EC2 to publish flow logs to
#' the log destination.
#' 
#' This parameter is required if the destination type is
#' `cloud-watch-logs`, or if the destination type is
#' `kinesis-data-firehose` and the delivery stream and the resources to
#' monitor are in different accounts.
#' @param DeliverCrossAccountRole The ARN of the IAM role that allows Amazon EC2 to publish flow logs
#' across accounts.
#' @param LogGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2
#' publishes your flow logs.
#' 
#' This parameter is valid only if the destination type is
#' `cloud-watch-logs`.
#' @param ResourceIds &#91;required&#93; The IDs of the resources to monitor. For example, if the resource type
#' is `VPC`, specify the IDs of the VPCs.
#' 
#' Constraints: Maximum of 25 for transit gateway resource types. Maximum
#' of 1000 for the other resource types.
#' @param ResourceType &#91;required&#93; The type of resource to monitor.
#' @param TrafficType The type of traffic to monitor (accepted traffic, rejected traffic, or
#' all traffic). This parameter is not supported for transit gateway
#' resource types. It is required for the other resource types.
#' @param LogDestinationType The type of destination for the flow log data.
#' 
#' Default: `cloud-watch-logs`
#' @param LogDestination The destination for the flow log data. The meaning of this parameter
#' depends on the destination type.
#' 
#' -   If the destination type is `cloud-watch-logs`, specify the ARN of a
#'     CloudWatch Logs log group. For example:
#' 
#'     arn:aws:logs:*region*:*account_id*:log-group:*my_group*
#' 
#'     Alternatively, use the `LogGroupName` parameter.
#' 
#' -   If the destination type is `s3`, specify the ARN of an S3 bucket.
#'     For example:
#' 
#'     arn:aws:s3:::*my_bucket*/*my_subfolder*/
#' 
#'     The subfolder is optional. Note that you can't use `AWSLogs` as a
#'     subfolder name.
#' 
#' -   If the destination type is `kinesis-data-firehose`, specify the ARN
#'     of a Kinesis Data Firehose delivery stream. For example:
#' 
#'     arn:aws:firehose:*region*:*account_id*:deliverystream:*my_stream*
#' @param LogFormat The fields to include in the flow log record. List the fields in the
#' order in which they should appear. If you omit this parameter, the flow
#' log is created using the default format. If you specify this parameter,
#' you must include at least one field. For more information about the
#' available fields, see [Flow log
#' records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html)
#' in the *Amazon VPC User Guide* or [Transit Gateway Flow Log
#' records](https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records)
#' in the *Amazon Web Services Transit Gateway Guide*.
#' 
#' Specify the fields using the `${field-id}` format, separated by spaces.
#' @param TagSpecifications The tags to apply to the flow logs.
#' @param MaxAggregationInterval The maximum interval of time during which a flow of packets is captured
#' and aggregated into a flow log record. The possible values are 60
#' seconds (1 minute) or 600 seconds (10 minutes). This parameter must be
#' 60 seconds for transit gateway resource types.
#' 
#' When a network interface is attached to a [Nitro-based
#' instance](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html),
#' the aggregation interval is always 60 seconds or less, regardless of the
#' value that you specify.
#' 
#' Default: 600
#' @param DestinationOptions The destination options.
#'
#' @keywords internal
#'
#' @rdname ec2_create_flow_logs
ec2_create_flow_logs <- function(DryRun = NULL, ClientToken = NULL, DeliverLogsPermissionArn = NULL, DeliverCrossAccountRole = NULL, LogGroupName = NULL, ResourceIds, ResourceType, TrafficType = NULL, LogDestinationType = NULL, LogDestination = NULL, LogFormat = NULL, TagSpecifications = NULL, MaxAggregationInterval = NULL, DestinationOptions = NULL) {
  op <- new_operation(
    name = "CreateFlowLogs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_flow_logs_input(DryRun = DryRun, ClientToken = ClientToken, DeliverLogsPermissionArn = DeliverLogsPermissionArn, DeliverCrossAccountRole = DeliverCrossAccountRole, LogGroupName = LogGroupName, ResourceIds = ResourceIds, ResourceType = ResourceType, TrafficType = TrafficType, LogDestinationType = LogDestinationType, LogDestination = LogDestination, LogFormat = LogFormat, TagSpecifications = TagSpecifications, MaxAggregationInterval = MaxAggregationInterval, DestinationOptions = DestinationOptions)
  output <- .ec2$create_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_flow_logs <- ec2_create_flow_logs

#' Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
#' (DCP)
#'
#' @description
#' Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_fpga_image/](https://www.paws-r-sdk.com/docs/ec2_create_fpga_image/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InputStorageLocation &#91;required&#93; The location of the encrypted design checkpoint in Amazon S3. The input
#' must be a tarball.
#' @param LogsStorageLocation The location in Amazon S3 for the output logs.
#' @param Description A description for the AFI.
#' @param Name A name for the AFI.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param TagSpecifications The tags to apply to the FPGA image during creation.
#'
#' @keywords internal
#'
#' @rdname ec2_create_fpga_image
ec2_create_fpga_image <- function(DryRun = NULL, InputStorageLocation, LogsStorageLocation = NULL, Description = NULL, Name = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateFpgaImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_fpga_image_input(DryRun = DryRun, InputStorageLocation = InputStorageLocation, LogsStorageLocation = LogsStorageLocation, Description = Description, Name = Name, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_fpga_image <- ec2_create_fpga_image

#' Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
#' is either running or stopped
#'
#' @description
#' Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_image/](https://www.paws-r-sdk.com/docs/ec2_create_image/) for full documentation.
#'
#' @param TagSpecifications The tags to apply to the AMI and snapshots on creation. You can tag the
#' AMI, the snapshots, or both.
#' 
#' -   To tag the AMI, the value for `ResourceType` must be `image`.
#' 
#' -   To tag the snapshots that are created of the root volume and of
#'     other Amazon EBS volumes that are attached to the instance, the
#'     value for `ResourceType` must be `snapshot`. The same tag is applied
#'     to all of the snapshots that are created.
#' 
#' If you specify other values for `ResourceType`, the request fails.
#' 
#' To tag an AMI or snapshot after it has been created, see
#' [`create_tags`][ec2_create_tags].
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param Name &#91;required&#93; A name for the new image.
#' 
#' Constraints: 3-128 alphanumeric characters, parentheses (()), square
#' brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
#' single quotes ('), at-signs (@@), or underscores(_)
#' @param Description A description for the new image.
#' @param NoReboot Indicates whether or not the instance should be automatically rebooted
#' before creating the image. Specify one of the following values:
#' 
#' -   `true` - The instance is not rebooted before creating the image.
#'     This creates crash-consistent snapshots that include only the data
#'     that has been written to the volumes at the time the snapshots are
#'     created. Buffered data and data in memory that has not yet been
#'     written to the volumes is not included in the snapshots.
#' 
#' -   `false` - The instance is rebooted before creating the image. This
#'     ensures that all buffered data and data in memory is written to the
#'     volumes before the snapshots are created.
#' 
#' Default: `false`
#' @param BlockDeviceMappings The block device mappings.
#' 
#' When using the CreateImage action:
#' 
#' -   You can't change the volume size using the VolumeSize parameter. If
#'     you want a different volume size, you must first change the volume
#'     size of the source instance.
#' 
#' -   You can't modify the encryption status of existing volumes or
#'     snapshots. To create an AMI with volumes or snapshots that have a
#'     different encryption status (for example, where the source volume
#'     and snapshots are unencrypted, and you want to create an AMI with
#'     encrypted volumes or snapshots), use the
#'     [`copy_image`][ec2_copy_image] action.
#' 
#' -   The only option that can be changed for existing mappings or
#'     snapshots is `DeleteOnTermination`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_image
ec2_create_image <- function(TagSpecifications = NULL, DryRun = NULL, InstanceId, Name, Description = NULL, NoReboot = NULL, BlockDeviceMappings = NULL) {
  op <- new_operation(
    name = "CreateImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_image_input(TagSpecifications = TagSpecifications, DryRun = DryRun, InstanceId = InstanceId, Name = Name, Description = Description, NoReboot = NoReboot, BlockDeviceMappings = BlockDeviceMappings)
  output <- .ec2$create_image_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_image <- ec2_create_image

#' Creates an EC2 Instance Connect Endpoint
#'
#' @description
#' Creates an EC2 Instance Connect Endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_instance_connect_endpoint/](https://www.paws-r-sdk.com/docs/ec2_create_instance_connect_endpoint/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SubnetId &#91;required&#93; The ID of the subnet in which to create the EC2 Instance Connect
#' Endpoint.
#' @param SecurityGroupIds One or more security groups to associate with the endpoint. If you don't
#' specify a security group, the default security group for your VPC will
#' be associated with the endpoint.
#' @param PreserveClientIp Indicates whether the client IP address is preserved as the source. The
#' following are the possible values.
#' 
#' -   `true` - Use the client IP address as the source.
#' 
#' -   `false` - Use the network interface IP address as the source.
#' 
#' Default: `false`
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param TagSpecifications The tags to apply to the EC2 Instance Connect Endpoint during creation.
#'
#' @keywords internal
#'
#' @rdname ec2_create_instance_connect_endpoint
ec2_create_instance_connect_endpoint <- function(DryRun = NULL, SubnetId, SecurityGroupIds = NULL, PreserveClientIp = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateInstanceConnectEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_instance_connect_endpoint_input(DryRun = DryRun, SubnetId = SubnetId, SecurityGroupIds = SecurityGroupIds, PreserveClientIp = PreserveClientIp, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_instance_connect_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_instance_connect_endpoint <- ec2_create_instance_connect_endpoint

#' Creates an event window in which scheduled events for the associated
#' Amazon EC2 instances can run
#'
#' @description
#' Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_instance_event_window/](https://www.paws-r-sdk.com/docs/ec2_create_instance_event_window/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Name The name of the event window.
#' @param TimeRanges The time range for the event window. If you specify a time range, you
#' can't specify a cron expression.
#' @param CronExpression The cron expression for the event window, for example,
#' `* 0-4,20-23 * * 1,5`. If you specify a cron expression, you can't
#' specify a time range.
#' 
#' Constraints:
#' 
#' -   Only hour and day of the week values are supported.
#' 
#' -   For day of the week values, you can specify either integers `0`
#'     through `6`, or alternative single values `SUN` through `SAT`.
#' 
#' -   The minute, month, and year must be specified by `*`.
#' 
#' -   The hour value must be one or a multiple range, for example, `0-4`
#'     or `0-4,20-23`.
#' 
#' -   Each hour range must be \>= 2 hours, for example, `0-2` or `20-23`.
#' 
#' -   The event window must be \>= 4 hours. The combined total time ranges
#'     in the event window must be \>= 4 hours.
#' 
#' For more information about cron expressions, see
#' [cron](https://en.wikipedia.org/wiki/Cron) on the *Wikipedia website*.
#' @param TagSpecifications The tags to apply to the event window.
#'
#' @keywords internal
#'
#' @rdname ec2_create_instance_event_window
ec2_create_instance_event_window <- function(DryRun = NULL, Name = NULL, TimeRanges = NULL, CronExpression = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateInstanceEventWindow",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_instance_event_window_input(DryRun = DryRun, Name = Name, TimeRanges = TimeRanges, CronExpression = CronExpression, TagSpecifications = TagSpecifications)
  output <- .ec2$create_instance_event_window_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_instance_event_window <- ec2_create_instance_event_window

#' Exports a running or stopped instance to an Amazon S3 bucket
#'
#' @description
#' Exports a running or stopped instance to an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_instance_export_task/](https://www.paws-r-sdk.com/docs/ec2_create_instance_export_task/) for full documentation.
#'
#' @param TagSpecifications The tags to apply to the export instance task during creation.
#' @param Description A description for the conversion task or the resource being exported.
#' The maximum length is 255 characters.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param TargetEnvironment &#91;required&#93; The target virtualization environment.
#' @param ExportToS3Task &#91;required&#93; The format and location for an export instance task.
#'
#' @keywords internal
#'
#' @rdname ec2_create_instance_export_task
ec2_create_instance_export_task <- function(TagSpecifications = NULL, Description = NULL, InstanceId, TargetEnvironment, ExportToS3Task) {
  op <- new_operation(
    name = "CreateInstanceExportTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_instance_export_task_input(TagSpecifications = TagSpecifications, Description = Description, InstanceId = InstanceId, TargetEnvironment = TargetEnvironment, ExportToS3Task = ExportToS3Task)
  output <- .ec2$create_instance_export_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_instance_export_task <- ec2_create_instance_export_task

#' Creates an internet gateway for use with a VPC
#'
#' @description
#' Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using [`attach_internet_gateway`][ec2_attach_internet_gateway].
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_internet_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_internet_gateway/) for full documentation.
#'
#' @param TagSpecifications The tags to assign to the internet gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_internet_gateway
ec2_create_internet_gateway <- function(TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateInternetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_internet_gateway_input(TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_internet_gateway <- ec2_create_internet_gateway

#' Create an IPAM
#'
#' @description
#' Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_ipam/](https://www.paws-r-sdk.com/docs/ec2_create_ipam/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Description A description for the IPAM.
#' @param OperatingRegions The operating Regions for the IPAM. Operating Regions are Amazon Web
#' Services Regions where the IPAM is allowed to manage IP address CIDRs.
#' IPAM only discovers and monitors resources in the Amazon Web Services
#' Regions you select as operating Regions.
#' 
#' For more information about operating Regions, see [Create an
#' IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html) in
#' the *Amazon VPC IPAM User Guide*.
#' @param TagSpecifications The key/value combination of a tag assigned to the resource. Use the tag
#' key in the filter name and the tag value as the filter value. For
#' example, to find all resources that have a tag with the key `Owner` and
#' the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA`
#' for the filter value.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param Tier IPAM is offered in a Free Tier and an Advanced Tier. For more
#' information about the features available in each tier and the costs
#' associated with the tiers, see [Amazon VPC pricing \> IPAM
#' tab](https://aws.amazon.com/vpc/pricing/).
#' @param EnablePrivateGua Enable this option to use your own GUA ranges as private IPv6 addresses.
#' This option is disabled by default.
#'
#' @keywords internal
#'
#' @rdname ec2_create_ipam
ec2_create_ipam <- function(DryRun = NULL, Description = NULL, OperatingRegions = NULL, TagSpecifications = NULL, ClientToken = NULL, Tier = NULL, EnablePrivateGua = NULL) {
  op <- new_operation(
    name = "CreateIpam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_ipam_input(DryRun = DryRun, Description = Description, OperatingRegions = OperatingRegions, TagSpecifications = TagSpecifications, ClientToken = ClientToken, Tier = Tier, EnablePrivateGua = EnablePrivateGua)
  output <- .ec2$create_ipam_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_ipam <- ec2_create_ipam

#' Create a verification token
#'
#' @description
#' Create a verification token. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_ipam_external_resource_verification_token/](https://www.paws-r-sdk.com/docs/ec2_create_ipam_external_resource_verification_token/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamId &#91;required&#93; The ID of the IPAM that will create the token.
#' @param TagSpecifications Token tags.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_ipam_external_resource_verification_token
ec2_create_ipam_external_resource_verification_token <- function(DryRun = NULL, IpamId, TagSpecifications = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateIpamExternalResourceVerificationToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_ipam_external_resource_verification_token_input(DryRun = DryRun, IpamId = IpamId, TagSpecifications = TagSpecifications, ClientToken = ClientToken)
  output <- .ec2$create_ipam_external_resource_verification_token_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_ipam_external_resource_verification_token <- ec2_create_ipam_external_resource_verification_token

#' Create an IP address pool for Amazon VPC IP Address Manager (IPAM)
#'
#' @description
#' Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_ipam_pool/](https://www.paws-r-sdk.com/docs/ec2_create_ipam_pool/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamScopeId &#91;required&#93; The ID of the scope in which you would like to create the IPAM pool.
#' @param Locale The locale for the pool should be one of the following:
#' 
#' -   An Amazon Web Services Region where you want this IPAM pool to be
#'     available for allocations.
#' 
#' -   The network border group for an Amazon Web Services Local Zone where
#'     you want this IPAM pool to be available for allocations ([supported
#'     Local
#'     Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail)).
#'     This option is only available for IPAM IPv4 pools in the public
#'     scope.
#' 
#' Possible values: Any Amazon Web Services Region or supported Amazon Web
#' Services Local Zone. Default is `none` and means any locale.
#' @param SourceIpamPoolId The ID of the source IPAM pool. Use this option to create a pool within
#' an existing pool. Note that the CIDR you provision for the pool within
#' the source pool must be available in the source pool's CIDR range.
#' @param Description A description for the IPAM pool.
#' @param AddressFamily &#91;required&#93; The IP protocol assigned to this IPAM pool. You must choose either IPv4
#' or IPv6 protocol for a pool.
#' @param AutoImport If selected, IPAM will continuously look for resources within the CIDR
#' range of this pool and automatically import them as allocations into
#' your IPAM. The CIDRs that will be allocated for these resources must not
#' already be allocated to other resources in order for the import to
#' succeed. IPAM will import a CIDR regardless of its compliance with the
#' pool's allocation rules, so a resource might be imported and
#' subsequently marked as noncompliant. If IPAM discovers multiple CIDRs
#' that overlap, IPAM will import the largest CIDR only. If IPAM discovers
#' multiple CIDRs with matching CIDRs, IPAM will randomly import one of
#' them only.
#' 
#' A locale must be set on the pool for this feature to work.
#' @param PubliclyAdvertisable Determines if the pool is publicly advertisable. The request can only
#' contain `PubliclyAdvertisable` if `AddressFamily` is `ipv6` and
#' `PublicIpSource` is `byoip`.
#' @param AllocationMinNetmaskLength The minimum netmask length required for CIDR allocations in this IPAM
#' pool to be compliant. The minimum netmask length must be less than the
#' maximum netmask length. Possible netmask lengths for IPv4 addresses are
#' 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
#' @param AllocationMaxNetmaskLength The maximum netmask length possible for CIDR allocations in this IPAM
#' pool to be compliant. The maximum netmask length must be greater than
#' the minimum netmask length. Possible netmask lengths for IPv4 addresses
#' are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
#' @param AllocationDefaultNetmaskLength The default netmask length for allocations added to this pool. If, for
#' example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16
#' here, new allocations will default to 10.0.0.0/16.
#' @param AllocationResourceTags Tags that are required for resources that use CIDRs from this IPAM pool.
#' Resources that do not have these tags will not be allowed to allocate
#' space from the pool. If the resources have their tags changed after they
#' have allocated space or if the allocation tagging requirements are
#' changed on the pool, the resource may be marked as noncompliant.
#' @param TagSpecifications The key/value combination of a tag assigned to the resource. Use the tag
#' key in the filter name and the tag value as the filter value. For
#' example, to find all resources that have a tag with the key `Owner` and
#' the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA`
#' for the filter value.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param AwsService Limits which service in Amazon Web Services that the pool can be used
#' in. "ec2", for example, allows users to use space for Elastic IP
#' addresses and VPCs.
#' @param PublicIpSource The IP address source for pools in the public scope. Only used for
#' provisioning IP address CIDRs to pools in the public scope. Default is
#' `byoip`. For more information, see [Create IPv6
#' pools](https://docs.aws.amazon.com/vpc/latest/ipam/intro-create-ipv6-pools.html)
#' in the *Amazon VPC IPAM User Guide*. By default, you can add only one
#' Amazon-provided IPv6 CIDR block to a top-level IPv6 pool if
#' PublicIpSource is `amazon`. For information on increasing the default
#' limit, see [Quotas for your
#' IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html) in
#' the *Amazon VPC IPAM User Guide*.
#' @param SourceResource The resource used to provision CIDRs to a resource planning pool.
#'
#' @keywords internal
#'
#' @rdname ec2_create_ipam_pool
ec2_create_ipam_pool <- function(DryRun = NULL, IpamScopeId, Locale = NULL, SourceIpamPoolId = NULL, Description = NULL, AddressFamily, AutoImport = NULL, PubliclyAdvertisable = NULL, AllocationMinNetmaskLength = NULL, AllocationMaxNetmaskLength = NULL, AllocationDefaultNetmaskLength = NULL, AllocationResourceTags = NULL, TagSpecifications = NULL, ClientToken = NULL, AwsService = NULL, PublicIpSource = NULL, SourceResource = NULL) {
  op <- new_operation(
    name = "CreateIpamPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_ipam_pool_input(DryRun = DryRun, IpamScopeId = IpamScopeId, Locale = Locale, SourceIpamPoolId = SourceIpamPoolId, Description = Description, AddressFamily = AddressFamily, AutoImport = AutoImport, PubliclyAdvertisable = PubliclyAdvertisable, AllocationMinNetmaskLength = AllocationMinNetmaskLength, AllocationMaxNetmaskLength = AllocationMaxNetmaskLength, AllocationDefaultNetmaskLength = AllocationDefaultNetmaskLength, AllocationResourceTags = AllocationResourceTags, TagSpecifications = TagSpecifications, ClientToken = ClientToken, AwsService = AwsService, PublicIpSource = PublicIpSource, SourceResource = SourceResource)
  output <- .ec2$create_ipam_pool_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_ipam_pool <- ec2_create_ipam_pool

#' Creates an IPAM resource discovery
#'
#' @description
#' Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_ipam_resource_discovery/](https://www.paws-r-sdk.com/docs/ec2_create_ipam_resource_discovery/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Description A description for the IPAM resource discovery.
#' @param OperatingRegions Operating Regions for the IPAM resource discovery. Operating Regions are
#' Amazon Web Services Regions where the IPAM is allowed to manage IP
#' address CIDRs. IPAM only discovers and monitors resources in the Amazon
#' Web Services Regions you select as operating Regions.
#' @param TagSpecifications Tag specifications for the IPAM resource discovery.
#' @param ClientToken A client token for the IPAM resource discovery.
#'
#' @keywords internal
#'
#' @rdname ec2_create_ipam_resource_discovery
ec2_create_ipam_resource_discovery <- function(DryRun = NULL, Description = NULL, OperatingRegions = NULL, TagSpecifications = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateIpamResourceDiscovery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_ipam_resource_discovery_input(DryRun = DryRun, Description = Description, OperatingRegions = OperatingRegions, TagSpecifications = TagSpecifications, ClientToken = ClientToken)
  output <- .ec2$create_ipam_resource_discovery_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_ipam_resource_discovery <- ec2_create_ipam_resource_discovery

#' Create an IPAM scope
#'
#' @description
#' Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_ipam_scope/](https://www.paws-r-sdk.com/docs/ec2_create_ipam_scope/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamId &#91;required&#93; The ID of the IPAM for which you're creating this scope.
#' @param Description A description for the scope you're creating.
#' @param TagSpecifications The key/value combination of a tag assigned to the resource. Use the tag
#' key in the filter name and the tag value as the filter value. For
#' example, to find all resources that have a tag with the key `Owner` and
#' the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA`
#' for the filter value.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_ipam_scope
ec2_create_ipam_scope <- function(DryRun = NULL, IpamId, Description = NULL, TagSpecifications = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateIpamScope",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_ipam_scope_input(DryRun = DryRun, IpamId = IpamId, Description = Description, TagSpecifications = TagSpecifications, ClientToken = ClientToken)
  output <- .ec2$create_ipam_scope_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_ipam_scope <- ec2_create_ipam_scope

#' Creates an ED25519 or 2048-bit RSA key pair with the specified name and
#' in the specified format
#'
#' @description
#' Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified format. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_key_pair/](https://www.paws-r-sdk.com/docs/ec2_create_key_pair/) for full documentation.
#'
#' @param KeyName &#91;required&#93; A unique name for the key pair.
#' 
#' Constraints: Up to 255 ASCII characters
#' @param KeyType The type of key pair. Note that ED25519 keys are not supported for
#' Windows instances.
#' 
#' Default: `rsa`
#' @param TagSpecifications The tags to apply to the new key pair.
#' @param KeyFormat The format of the key pair.
#' 
#' Default: `pem`
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_key_pair
ec2_create_key_pair <- function(KeyName, KeyType = NULL, TagSpecifications = NULL, KeyFormat = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_key_pair_input(KeyName = KeyName, KeyType = KeyType, TagSpecifications = TagSpecifications, KeyFormat = KeyFormat, DryRun = DryRun)
  output <- .ec2$create_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_key_pair <- ec2_create_key_pair

#' Creates a launch template
#'
#' @description
#' Creates a launch template.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_launch_template/](https://www.paws-r-sdk.com/docs/ec2_create_launch_template/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateName &#91;required&#93; A name for the launch template.
#' @param VersionDescription A description for the first version of the launch template.
#' @param LaunchTemplateData &#91;required&#93; The information for the launch template.
#' @param Operator Reserved for internal use.
#' @param TagSpecifications The tags to apply to the launch template on creation. To tag the launch
#' template, the resource type must be `launch-template`.
#' 
#' To specify the tags for the resources that are created when an instance
#' is launched, you must use the `TagSpecifications` parameter in the
#' [launch template
#' data](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html)
#' structure.
#'
#' @keywords internal
#'
#' @rdname ec2_create_launch_template
ec2_create_launch_template <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateName, VersionDescription = NULL, LaunchTemplateData, Operator = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_launch_template_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateName = LaunchTemplateName, VersionDescription = VersionDescription, LaunchTemplateData = LaunchTemplateData, Operator = Operator, TagSpecifications = TagSpecifications)
  output <- .ec2$create_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_launch_template <- ec2_create_launch_template

#' Creates a new version of a launch template
#'
#' @description
#' Creates a new version of a launch template. You must specify an existing launch template, either by name or ID. You can determine whether the new version inherits parameters from a source version, and add or overwrite parameters as needed.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_launch_template_version/](https://www.paws-r-sdk.com/docs/ec2_create_launch_template_version/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateId The ID of the launch template.
#' 
#' You must specify either the launch template ID or the launch template
#' name, but not both.
#' @param LaunchTemplateName The name of the launch template.
#' 
#' You must specify either the launch template ID or the launch template
#' name, but not both.
#' @param SourceVersion The version of the launch template on which to base the new version.
#' Snapshots applied to the block device mapping are ignored when creating
#' a new version unless they are explicitly included.
#' 
#' If you specify this parameter, the new version inherits the launch
#' parameters from the source version. If you specify additional launch
#' parameters for the new version, they overwrite any corresponding launch
#' parameters inherited from the source version.
#' 
#' If you omit this parameter, the new version contains only the launch
#' parameters that you specify for the new version.
#' @param VersionDescription A description for the version of the launch template.
#' @param LaunchTemplateData &#91;required&#93; The information for the launch template.
#' @param ResolveAlias If `true`, and if a Systems Manager parameter is specified for
#' `ImageId`, the AMI ID is displayed in the response for `imageID`. For
#' more information, see [Use a Systems Manager parameter instead of an AMI
#' ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#use-an-ssm-parameter-instead-of-an-ami-id)
#' in the *Amazon EC2 User Guide*.
#' 
#' Default: `false`
#'
#' @keywords internal
#'
#' @rdname ec2_create_launch_template_version
ec2_create_launch_template_version <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, SourceVersion = NULL, VersionDescription = NULL, LaunchTemplateData, ResolveAlias = NULL) {
  op <- new_operation(
    name = "CreateLaunchTemplateVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_launch_template_version_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, SourceVersion = SourceVersion, VersionDescription = VersionDescription, LaunchTemplateData = LaunchTemplateData, ResolveAlias = ResolveAlias)
  output <- .ec2$create_launch_template_version_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_launch_template_version <- ec2_create_launch_template_version

#' Creates a static route for the specified local gateway route table
#'
#' @description
#' Creates a static route for the specified local gateway route table. You must specify one of the following targets:
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route/](https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route/) for full documentation.
#'
#' @param DestinationCidrBlock The CIDR range used for destination matches. Routing decisions are based
#' on the most specific match.
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param LocalGatewayVirtualInterfaceGroupId The ID of the virtual interface group.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId The ID of the network interface.
#' @param DestinationPrefixListId The ID of the prefix list. Use a prefix list in place of
#' `DestinationCidrBlock`. You cannot use `DestinationPrefixListId` and
#' `DestinationCidrBlock` in the same request.
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route
ec2_create_local_gateway_route <- function(DestinationCidrBlock = NULL, LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId = NULL, DryRun = NULL, NetworkInterfaceId = NULL, DestinationPrefixListId = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_local_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, LocalGatewayRouteTableId = LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId = LocalGatewayVirtualInterfaceGroupId, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId, DestinationPrefixListId = DestinationPrefixListId)
  output <- .ec2$create_local_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route <- ec2_create_local_gateway_route

#' Creates a local gateway route table
#'
#' @description
#' Creates a local gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route_table/](https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route_table/) for full documentation.
#'
#' @param LocalGatewayId &#91;required&#93; The ID of the local gateway.
#' @param Mode The mode of the local gateway route table.
#' @param TagSpecifications The tags assigned to the local gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route_table
ec2_create_local_gateway_route_table <- function(LocalGatewayId, Mode = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_local_gateway_route_table_input(LocalGatewayId = LocalGatewayId, Mode = Mode, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route_table <- ec2_create_local_gateway_route_table

#' Creates a local gateway route table virtual interface group association
#'
#' @description
#' Creates a local gateway route table virtual interface group association.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route_table_virtual_interface_group_association/](https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route_table_virtual_interface_group_association/) for full documentation.
#'
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param LocalGatewayVirtualInterfaceGroupId &#91;required&#93; The ID of the local gateway route table virtual interface group
#' association.
#' @param TagSpecifications The tags assigned to the local gateway route table virtual interface
#' group association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_creat_local_gatew_route_table_virtu_inter_group_assoc
ec2_create_local_gateway_route_table_virtual_interface_group_association <- function(LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_local_gateway_route_table_virtual_interface_group_association_input(LocalGatewayRouteTableId = LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId = LocalGatewayVirtualInterfaceGroupId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_table_virtual_interface_group_association_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route_table_virtual_interface_group_association <- ec2_create_local_gateway_route_table_virtual_interface_group_association

#' Associates the specified VPC with the specified local gateway route
#' table
#'
#' @description
#' Associates the specified VPC with the specified local gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route_table_vpc_association/](https://www.paws-r-sdk.com/docs/ec2_create_local_gateway_route_table_vpc_association/) for full documentation.
#'
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param TagSpecifications The tags to assign to the local gateway route table VPC association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route_table_vpc_association
ec2_create_local_gateway_route_table_vpc_association <- function(LocalGatewayRouteTableId, VpcId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRouteTableVpcAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_local_gateway_route_table_vpc_association_input(LocalGatewayRouteTableId = LocalGatewayRouteTableId, VpcId = VpcId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_table_vpc_association_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route_table_vpc_association <- ec2_create_local_gateway_route_table_vpc_association

#' Creates a managed prefix list
#'
#' @description
#' Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_managed_prefix_list/](https://www.paws-r-sdk.com/docs/ec2_create_managed_prefix_list/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PrefixListName &#91;required&#93; A name for the prefix list.
#' 
#' Constraints: Up to 255 characters in length. The name cannot start with
#' `com.amazonaws`.
#' @param Entries One or more entries for the prefix list.
#' @param MaxEntries &#91;required&#93; The maximum number of entries for the prefix list.
#' @param TagSpecifications The tags to apply to the prefix list during creation.
#' @param AddressFamily &#91;required&#93; The IP address type.
#' 
#' Valid Values: `IPv4` | `IPv6`
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' 
#' Constraints: Up to 255 UTF-8 characters in length.
#'
#' @keywords internal
#'
#' @rdname ec2_create_managed_prefix_list
ec2_create_managed_prefix_list <- function(DryRun = NULL, PrefixListName, Entries = NULL, MaxEntries, TagSpecifications = NULL, AddressFamily, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateManagedPrefixList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_managed_prefix_list_input(DryRun = DryRun, PrefixListName = PrefixListName, Entries = Entries, MaxEntries = MaxEntries, TagSpecifications = TagSpecifications, AddressFamily = AddressFamily, ClientToken = ClientToken)
  output <- .ec2$create_managed_prefix_list_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_managed_prefix_list <- ec2_create_managed_prefix_list

#' Creates a NAT gateway in the specified subnet
#'
#' @description
#' Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_nat_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_nat_gateway/) for full documentation.
#'
#' @param AllocationId \[Public NAT gateways only\] The allocation ID of an Elastic IP address
#' to associate with the NAT gateway. You cannot specify an Elastic IP
#' address with a private NAT gateway. If the Elastic IP address is
#' associated with another resource, you must first disassociate it.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' 
#' Constraint: Maximum 64 ASCII characters.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SubnetId &#91;required&#93; The ID of the subnet in which to create the NAT gateway.
#' @param TagSpecifications The tags to assign to the NAT gateway.
#' @param ConnectivityType Indicates whether the NAT gateway supports public or private
#' connectivity. The default is public connectivity.
#' @param PrivateIpAddress The private IPv4 address to assign to the NAT gateway. If you don't
#' provide an address, a private IPv4 address will be automatically
#' assigned.
#' @param SecondaryAllocationIds Secondary EIP allocation IDs. For more information, see [Create a NAT
#' gateway](https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html)
#' in the *Amazon VPC User Guide*.
#' @param SecondaryPrivateIpAddresses Secondary private IPv4 addresses. For more information about secondary
#' addresses, see [Create a NAT
#' gateway](https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html)
#' in the *Amazon VPC User Guide*.
#' @param SecondaryPrivateIpAddressCount \[Private NAT gateway only\] The number of secondary private IPv4
#' addresses you want to assign to the NAT gateway. For more information
#' about secondary addresses, see [Create a NAT
#' gateway](https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html)
#' in the *Amazon VPC User Guide*.
#'
#' @keywords internal
#'
#' @rdname ec2_create_nat_gateway
ec2_create_nat_gateway <- function(AllocationId = NULL, ClientToken = NULL, DryRun = NULL, SubnetId, TagSpecifications = NULL, ConnectivityType = NULL, PrivateIpAddress = NULL, SecondaryAllocationIds = NULL, SecondaryPrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL) {
  op <- new_operation(
    name = "CreateNatGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_nat_gateway_input(AllocationId = AllocationId, ClientToken = ClientToken, DryRun = DryRun, SubnetId = SubnetId, TagSpecifications = TagSpecifications, ConnectivityType = ConnectivityType, PrivateIpAddress = PrivateIpAddress, SecondaryAllocationIds = SecondaryAllocationIds, SecondaryPrivateIpAddresses = SecondaryPrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount)
  output <- .ec2$create_nat_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_nat_gateway <- ec2_create_nat_gateway

#' Creates a network ACL in a VPC
#'
#' @description
#' Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_network_acl/](https://www.paws-r-sdk.com/docs/ec2_create_network_acl/) for full documentation.
#'
#' @param TagSpecifications The tags to assign to the network ACL.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_acl
ec2_create_network_acl <- function(TagSpecifications = NULL, ClientToken = NULL, DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "CreateNetworkAcl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_network_acl_input(TagSpecifications = TagSpecifications, ClientToken = ClientToken, DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$create_network_acl_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_acl <- ec2_create_network_acl

#' Creates an entry (a rule) in a network ACL with the specified rule
#' number
#'
#' @description
#' Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_network_acl_entry/](https://www.paws-r-sdk.com/docs/ec2_create_network_acl_entry/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#' @param RuleNumber &#91;required&#93; The rule number for the entry (for example, 100). ACL entries are
#' processed in ascending order by rule number.
#' 
#' Constraints: Positive integer from 1 to 32766. The range 32767 to 65535
#' is reserved for internal use.
#' @param Protocol &#91;required&#93; The protocol number. A value of "-1" means all protocols. If you specify
#' "-1" or a protocol number other than "6" (TCP), "17" (UDP), or "1"
#' (ICMP), traffic on all ports is allowed, regardless of any ports or ICMP
#' types or codes that you specify. If you specify protocol "58" (ICMPv6)
#' and specify an IPv4 CIDR block, traffic for all ICMP types and codes
#' allowed, regardless of any that you specify. If you specify protocol
#' "58" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP
#' type and code.
#' @param RuleAction &#91;required&#93; Indicates whether to allow or deny the traffic that matches the rule.
#' @param Egress &#91;required&#93; Indicates whether this is an egress rule (rule is applied to traffic
#' leaving the subnet).
#' @param CidrBlock The IPv4 network range to allow or deny, in CIDR notation (for example
#' `172.16.0.0/24`). We modify the specified CIDR block to its canonical
#' form; for example, if you specify `100.68.0.18/18`, we modify it to
#' `100.68.0.0/18`.
#' @param Ipv6CidrBlock The IPv6 network range to allow or deny, in CIDR notation (for example
#' `2001:db8:1234:1a00::/64`).
#' @param IcmpTypeCode ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying
#' protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
#' @param PortRange TCP or UDP protocols: The range of ports the rule applies to. Required
#' if specifying protocol 6 (TCP) or 17 (UDP).
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_acl_entry
ec2_create_network_acl_entry <- function(DryRun = NULL, NetworkAclId, RuleNumber, Protocol, RuleAction, Egress, CidrBlock = NULL, Ipv6CidrBlock = NULL, IcmpTypeCode = NULL, PortRange = NULL) {
  op <- new_operation(
    name = "CreateNetworkAclEntry",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_network_acl_entry_input(DryRun = DryRun, NetworkAclId = NetworkAclId, RuleNumber = RuleNumber, Protocol = Protocol, RuleAction = RuleAction, Egress = Egress, CidrBlock = CidrBlock, Ipv6CidrBlock = Ipv6CidrBlock, IcmpTypeCode = IcmpTypeCode, PortRange = PortRange)
  output <- .ec2$create_network_acl_entry_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_acl_entry <- ec2_create_network_acl_entry

#' Creates a Network Access Scope
#'
#' @description
#' Creates a Network Access Scope.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_network_insights_access_scope/](https://www.paws-r-sdk.com/docs/ec2_create_network_insights_access_scope/) for full documentation.
#'
#' @param MatchPaths The paths to match.
#' @param ExcludePaths The paths to exclude.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param TagSpecifications The tags to apply.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_insights_access_scope
ec2_create_network_insights_access_scope <- function(MatchPaths = NULL, ExcludePaths = NULL, ClientToken, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateNetworkInsightsAccessScope",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_network_insights_access_scope_input(MatchPaths = MatchPaths, ExcludePaths = ExcludePaths, ClientToken = ClientToken, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_network_insights_access_scope_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_insights_access_scope <- ec2_create_network_insights_access_scope

#' Creates a path to analyze for reachability
#'
#' @description
#' Creates a path to analyze for reachability.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_network_insights_path/](https://www.paws-r-sdk.com/docs/ec2_create_network_insights_path/) for full documentation.
#'
#' @param SourceIp The IP address of the source.
#' @param DestinationIp The IP address of the destination.
#' @param Source &#91;required&#93; The ID or ARN of the source. If the resource is in another account, you
#' must specify an ARN.
#' @param Destination The ID or ARN of the destination. If the resource is in another account,
#' you must specify an ARN.
#' @param Protocol &#91;required&#93; The protocol.
#' @param DestinationPort The destination port.
#' @param TagSpecifications The tags to add to the path.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param FilterAtSource Scopes the analysis to network paths that match specific filters at the
#' source. If you specify this parameter, you can't specify the parameters
#' for the source IP address or the destination port.
#' @param FilterAtDestination Scopes the analysis to network paths that match specific filters at the
#' destination. If you specify this parameter, you can't specify the
#' parameter for the destination IP address.
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_insights_path
ec2_create_network_insights_path <- function(SourceIp = NULL, DestinationIp = NULL, Source, Destination = NULL, Protocol, DestinationPort = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken, FilterAtSource = NULL, FilterAtDestination = NULL) {
  op <- new_operation(
    name = "CreateNetworkInsightsPath",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_network_insights_path_input(SourceIp = SourceIp, DestinationIp = DestinationIp, Source = Source, Destination = Destination, Protocol = Protocol, DestinationPort = DestinationPort, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken, FilterAtSource = FilterAtSource, FilterAtDestination = FilterAtDestination)
  output <- .ec2$create_network_insights_path_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_insights_path <- ec2_create_network_insights_path

#' Creates a network interface in the specified subnet
#'
#' @description
#' Creates a network interface in the specified subnet.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_network_interface/](https://www.paws-r-sdk.com/docs/ec2_create_network_interface/) for full documentation.
#'
#' @param Ipv4Prefixes The IPv4 prefixes assigned to the network interface.
#' 
#' You can't specify IPv4 prefixes if you've specified one of the
#' following: a count of IPv4 prefixes, specific private IPv4 addresses, or
#' a count of private IPv4 addresses.
#' @param Ipv4PrefixCount The number of IPv4 prefixes that Amazon Web Services automatically
#' assigns to the network interface.
#' 
#' You can't specify a count of IPv4 prefixes if you've specified one of
#' the following: specific IPv4 prefixes, specific private IPv4 addresses,
#' or a count of private IPv4 addresses.
#' @param Ipv6Prefixes The IPv6 prefixes assigned to the network interface.
#' 
#' You can't specify IPv6 prefixes if you've specified one of the
#' following: a count of IPv6 prefixes, specific IPv6 addresses, or a count
#' of IPv6 addresses.
#' @param Ipv6PrefixCount The number of IPv6 prefixes that Amazon Web Services automatically
#' assigns to the network interface.
#' 
#' You can't specify a count of IPv6 prefixes if you've specified one of
#' the following: specific IPv6 prefixes, specific IPv6 addresses, or a
#' count of IPv6 addresses.
#' @param InterfaceType The type of network interface. The default is `interface`.
#' 
#' If you specify `efa-only`, do not assign any IP addresses to the network
#' interface. EFA-only network interfaces do not support IP addresses.
#' 
#' The only supported values are `interface`, `efa`, `efa-only`, and
#' `trunk`.
#' @param TagSpecifications The tags to apply to the new network interface.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param EnablePrimaryIpv6 If you’re creating a network interface in a dual-stack or IPv6-only
#' subnet, you have the option to assign a primary IPv6 IP address. A
#' primary IPv6 address is an IPv6 GUA address associated with an ENI that
#' you have enabled to use a primary IPv6 address. Use this option if the
#' instance that this ENI will be attached to relies on its IPv6 address
#' not changing. Amazon Web Services will automatically assign an IPv6
#' address associated with the ENI attached to your instance to be the
#' primary IPv6 address. Once you enable an IPv6 GUA address to be a
#' primary IPv6, you cannot disable it. When you enable an IPv6 GUA address
#' to be a primary IPv6, the first IPv6 GUA will be made the primary IPv6
#' address until the instance is terminated or the network interface is
#' detached. If you have multiple IPv6 addresses associated with an ENI
#' attached to your instance and you enable a primary IPv6 address, the
#' first IPv6 GUA address associated with the ENI becomes the primary IPv6
#' address.
#' @param ConnectionTrackingSpecification A connection tracking specification for the network interface.
#' @param Operator Reserved for internal use.
#' @param SubnetId &#91;required&#93; The ID of the subnet to associate with the network interface.
#' @param Description A description for the network interface.
#' @param PrivateIpAddress The primary private IPv4 address of the network interface. If you don't
#' specify an IPv4 address, Amazon EC2 selects one for you from the
#' subnet's IPv4 CIDR range. If you specify an IP address, you cannot
#' indicate any IP addresses specified in `privateIpAddresses` as primary
#' (only one IP address can be designated as primary).
#' @param Groups The IDs of one or more security groups.
#' @param PrivateIpAddresses The private IPv4 addresses.
#' 
#' You can't specify private IPv4 addresses if you've specified one of the
#' following: a count of private IPv4 addresses, specific IPv4 prefixes, or
#' a count of IPv4 prefixes.
#' @param SecondaryPrivateIpAddressCount The number of secondary private IPv4 addresses to assign to a network
#' interface. When you specify a number of secondary IPv4 addresses, Amazon
#' EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You
#' can't specify this option and specify more than one private IP address
#' using `privateIpAddresses`.
#' 
#' You can't specify a count of private IPv4 addresses if you've specified
#' one of the following: specific private IPv4 addresses, specific IPv4
#' prefixes, or a count of IPv4 prefixes.
#' @param Ipv6Addresses The IPv6 addresses from the IPv6 CIDR block range of your subnet.
#' 
#' You can't specify IPv6 addresses using this parameter if you've
#' specified one of the following: a count of IPv6 addresses, specific IPv6
#' prefixes, or a count of IPv6 prefixes.
#' @param Ipv6AddressCount The number of IPv6 addresses to assign to a network interface. Amazon
#' EC2 automatically selects the IPv6 addresses from the subnet range.
#' 
#' You can't specify a count of IPv6 addresses using this parameter if
#' you've specified one of the following: specific IPv6 addresses, specific
#' IPv6 prefixes, or a count of IPv6 prefixes.
#' 
#' If your subnet has the `AssignIpv6AddressOnCreation` attribute set, you
#' can override that setting by specifying 0 as the IPv6 address count.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_interface
ec2_create_network_interface <- function(Ipv4Prefixes = NULL, Ipv4PrefixCount = NULL, Ipv6Prefixes = NULL, Ipv6PrefixCount = NULL, InterfaceType = NULL, TagSpecifications = NULL, ClientToken = NULL, EnablePrimaryIpv6 = NULL, ConnectionTrackingSpecification = NULL, Operator = NULL, SubnetId, Description = NULL, PrivateIpAddress = NULL, Groups = NULL, PrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL, Ipv6Addresses = NULL, Ipv6AddressCount = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateNetworkInterface",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_network_interface_input(Ipv4Prefixes = Ipv4Prefixes, Ipv4PrefixCount = Ipv4PrefixCount, Ipv6Prefixes = Ipv6Prefixes, Ipv6PrefixCount = Ipv6PrefixCount, InterfaceType = InterfaceType, TagSpecifications = TagSpecifications, ClientToken = ClientToken, EnablePrimaryIpv6 = EnablePrimaryIpv6, ConnectionTrackingSpecification = ConnectionTrackingSpecification, Operator = Operator, SubnetId = SubnetId, Description = Description, PrivateIpAddress = PrivateIpAddress, Groups = Groups, PrivateIpAddresses = PrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount, Ipv6Addresses = Ipv6Addresses, Ipv6AddressCount = Ipv6AddressCount, DryRun = DryRun)
  output <- .ec2$create_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_interface <- ec2_create_network_interface

#' Grants an Amazon Web Services-authorized account permission to attach
#' the specified network interface to an instance in their account
#'
#' @description
#' Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_network_interface_permission/](https://www.paws-r-sdk.com/docs/ec2_create_network_interface_permission/) for full documentation.
#'
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param AwsAccountId The Amazon Web Services account ID.
#' @param AwsService The Amazon Web Services service. Currently not supported.
#' @param Permission &#91;required&#93; The type of permission to grant.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_interface_permission
ec2_create_network_interface_permission <- function(NetworkInterfaceId, AwsAccountId = NULL, AwsService = NULL, Permission, DryRun = NULL) {
  op <- new_operation(
    name = "CreateNetworkInterfacePermission",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_network_interface_permission_input(NetworkInterfaceId = NetworkInterfaceId, AwsAccountId = AwsAccountId, AwsService = AwsService, Permission = Permission, DryRun = DryRun)
  output <- .ec2$create_network_interface_permission_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_interface_permission <- ec2_create_network_interface_permission

#' Creates a placement group in which to launch instances
#'
#' @description
#' Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_placement_group/](https://www.paws-r-sdk.com/docs/ec2_create_placement_group/) for full documentation.
#'
#' @param PartitionCount The number of partitions. Valid only when **Strategy** is set to
#' `partition`.
#' @param TagSpecifications The tags to apply to the new placement group.
#' @param SpreadLevel Determines how placement groups spread instances.
#' 
#' -   Host – You can use `host` only with Outpost placement groups.
#' 
#' -   Rack – No usage restrictions.
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param GroupName A name for the placement group. Must be unique within the scope of your
#' account for the Region.
#' 
#' Constraints: Up to 255 ASCII characters
#' @param Strategy The placement strategy.
#'
#' @keywords internal
#'
#' @rdname ec2_create_placement_group
ec2_create_placement_group <- function(PartitionCount = NULL, TagSpecifications = NULL, SpreadLevel = NULL, DryRun = NULL, GroupName = NULL, Strategy = NULL) {
  op <- new_operation(
    name = "CreatePlacementGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_placement_group_input(PartitionCount = PartitionCount, TagSpecifications = TagSpecifications, SpreadLevel = SpreadLevel, DryRun = DryRun, GroupName = GroupName, Strategy = Strategy)
  output <- .ec2$create_placement_group_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_placement_group <- ec2_create_placement_group

#' Creates a public IPv4 address pool
#'
#' @description
#' Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use [`describe_public_ipv_4_pools`][ec2_describe_public_ipv_4_pools].
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_public_ipv_4_pool/](https://www.paws-r-sdk.com/docs/ec2_create_public_ipv_4_pool/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The key/value combination of a tag assigned to the resource. Use the tag
#' key in the filter name and the tag value as the filter value. For
#' example, to find all resources that have a tag with the key `Owner` and
#' the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA`
#' for the filter value.
#' @param NetworkBorderGroup The Availability Zone (AZ) or Local Zone (LZ) network border group that
#' the resource that the IP address is assigned to is in. Defaults to an AZ
#' network border group. For more information on available Local Zones, see
#' [Local Zone
#' availability](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail)
#' in the *Amazon EC2 User Guide*.
#'
#' @keywords internal
#'
#' @rdname ec2_create_public_ipv_4_pool
ec2_create_public_ipv_4_pool <- function(DryRun = NULL, TagSpecifications = NULL, NetworkBorderGroup = NULL) {
  op <- new_operation(
    name = "CreatePublicIpv4Pool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_public_ipv_4_pool_input(DryRun = DryRun, TagSpecifications = TagSpecifications, NetworkBorderGroup = NetworkBorderGroup)
  output <- .ec2$create_public_ipv_4_pool_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_public_ipv_4_pool <- ec2_create_public_ipv_4_pool

#' Replaces the EBS-backed root volume for a running instance with a new
#' volume that is restored to the original root volume's launch state, that
#' is restored to a specific snapshot taken from the original root volume,
#' or that is restored from an AMI that has the same key characteristics as
#' that of the instance
#'
#' @description
#' Replaces the EBS-backed root volume for a `running` instance with a new volume that is restored to the original root volume's launch state, that is restored to a specific snapshot taken from the original root volume, or that is restored from an AMI that has the same key characteristics as that of the instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_replace_root_volume_task/](https://www.paws-r-sdk.com/docs/ec2_create_replace_root_volume_task/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the instance for which to replace the root volume.
#' @param SnapshotId The ID of the snapshot from which to restore the replacement root
#' volume. The specified snapshot must be a snapshot that you previously
#' created from the original root volume.
#' 
#' If you want to restore the replacement root volume to the initial launch
#' state, or if you want to restore the replacement root volume from an
#' AMI, omit this parameter.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you do not specify a client token, a randomly
#' generated token is used for the request to ensure idempotency. For more
#' information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The tags to apply to the root volume replacement task.
#' @param ImageId The ID of the AMI to use to restore the root volume. The specified AMI
#' must have the same product code, billing information, architecture type,
#' and virtualization type as that of the instance.
#' 
#' If you want to restore the replacement volume from a specific snapshot,
#' or if you want to restore it to its launch state, omit this parameter.
#' @param DeleteReplacedRootVolume Indicates whether to automatically delete the original root volume after
#' the root volume replacement task completes. To delete the original root
#' volume, specify `true`. If you choose to keep the original root volume
#' after the replacement task completes, you must manually delete it when
#' you no longer need it.
#'
#' @keywords internal
#'
#' @rdname ec2_create_replace_root_volume_task
ec2_create_replace_root_volume_task <- function(InstanceId, SnapshotId = NULL, ClientToken = NULL, DryRun = NULL, TagSpecifications = NULL, ImageId = NULL, DeleteReplacedRootVolume = NULL) {
  op <- new_operation(
    name = "CreateReplaceRootVolumeTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_replace_root_volume_task_input(InstanceId = InstanceId, SnapshotId = SnapshotId, ClientToken = ClientToken, DryRun = DryRun, TagSpecifications = TagSpecifications, ImageId = ImageId, DeleteReplacedRootVolume = DeleteReplacedRootVolume)
  output <- .ec2$create_replace_root_volume_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_replace_root_volume_task <- ec2_create_replace_root_volume_task

#' Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
#' in the Reserved Instance Marketplace
#'
#' @description
#' Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the [`describe_reserved_instances`][ec2_describe_reserved_instances] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_reserved_instances_listing/](https://www.paws-r-sdk.com/docs/ec2_create_reserved_instances_listing/) for full documentation.
#'
#' @param ReservedInstancesId &#91;required&#93; The ID of the active Standard Reserved Instance.
#' @param InstanceCount &#91;required&#93; The number of instances that are a part of a Reserved Instance account
#' to be listed in the Reserved Instance Marketplace. This number should be
#' less than or equal to the instance count associated with the Reserved
#' Instance ID specified in this call.
#' @param PriceSchedules &#91;required&#93; A list specifying the price of the Standard Reserved Instance for each
#' month remaining in the Reserved Instance term.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier you provide to ensure idempotency of
#' your listings. This helps avoid duplicate listings. For more
#' information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_reserved_instances_listing
ec2_create_reserved_instances_listing <- function(ReservedInstancesId, InstanceCount, PriceSchedules, ClientToken) {
  op <- new_operation(
    name = "CreateReservedInstancesListing",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_reserved_instances_listing_input(ReservedInstancesId = ReservedInstancesId, InstanceCount = InstanceCount, PriceSchedules = PriceSchedules, ClientToken = ClientToken)
  output <- .ec2$create_reserved_instances_listing_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_reserved_instances_listing <- ec2_create_reserved_instances_listing

#' Starts a task that restores an AMI from an Amazon S3 object that was
#' previously created by using CreateStoreImageTask
#'
#' @description
#' Starts a task that restores an AMI from an Amazon S3 object that was previously created by using [`create_store_image_task`][ec2_create_store_image_task].
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_restore_image_task/](https://www.paws-r-sdk.com/docs/ec2_create_restore_image_task/) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket that contains the stored AMI object.
#' @param ObjectKey &#91;required&#93; The name of the stored AMI object in the bucket.
#' @param Name The name for the restored AMI. The name must be unique for AMIs in the
#' Region for this account. If you do not provide a name, the new AMI gets
#' the same name as the original AMI.
#' @param TagSpecifications The tags to apply to the AMI and snapshots on restoration. You can tag
#' the AMI, the snapshots, or both.
#' 
#' -   To tag the AMI, the value for `ResourceType` must be `image`.
#' 
#' -   To tag the snapshots, the value for `ResourceType` must be
#'     `snapshot`. The same tag is applied to all of the snapshots that are
#'     created.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_restore_image_task
ec2_create_restore_image_task <- function(Bucket, ObjectKey, Name = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateRestoreImageTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_restore_image_task_input(Bucket = Bucket, ObjectKey = ObjectKey, Name = Name, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_restore_image_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_restore_image_task <- ec2_create_restore_image_task

#' Creates a route in a route table within a VPC
#'
#' @description
#' Creates a route in a route table within a VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_route/](https://www.paws-r-sdk.com/docs/ec2_create_route/) for full documentation.
#'
#' @param DestinationPrefixListId The ID of a prefix list used for the destination match.
#' @param VpcEndpointId The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints
#' only.
#' @param TransitGatewayId The ID of a transit gateway.
#' @param LocalGatewayId The ID of the local gateway.
#' @param CarrierGatewayId The ID of the carrier gateway.
#' 
#' You can only use this option when the VPC contains a subnet which is
#' associated with a Wavelength Zone.
#' @param CoreNetworkArn The Amazon Resource Name (ARN) of the core network.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table for the route.
#' @param DestinationCidrBlock The IPv4 CIDR address block used for the destination match. Routing
#' decisions are based on the most specific match. We modify the specified
#' CIDR block to its canonical form; for example, if you specify
#' `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
#' @param GatewayId The ID of an internet gateway or virtual private gateway attached to
#' your VPC.
#' @param DestinationIpv6CidrBlock The IPv6 CIDR block used for the destination match. Routing decisions
#' are based on the most specific match.
#' @param EgressOnlyInternetGatewayId \[IPv6 traffic only\] The ID of an egress-only internet gateway.
#' @param InstanceId The ID of a NAT instance in your VPC. The operation fails if you specify
#' an instance ID unless exactly one network interface is attached.
#' @param NetworkInterfaceId The ID of a network interface.
#' @param VpcPeeringConnectionId The ID of a VPC peering connection.
#' @param NatGatewayId \[IPv4 traffic only\] The ID of a NAT gateway.
#'
#' @keywords internal
#'
#' @rdname ec2_create_route
ec2_create_route <- function(DestinationPrefixListId = NULL, VpcEndpointId = NULL, TransitGatewayId = NULL, LocalGatewayId = NULL, CarrierGatewayId = NULL, CoreNetworkArn = NULL, DryRun = NULL, RouteTableId, DestinationCidrBlock = NULL, GatewayId = NULL, DestinationIpv6CidrBlock = NULL, EgressOnlyInternetGatewayId = NULL, InstanceId = NULL, NetworkInterfaceId = NULL, VpcPeeringConnectionId = NULL, NatGatewayId = NULL) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_route_input(DestinationPrefixListId = DestinationPrefixListId, VpcEndpointId = VpcEndpointId, TransitGatewayId = TransitGatewayId, LocalGatewayId = LocalGatewayId, CarrierGatewayId = CarrierGatewayId, CoreNetworkArn = CoreNetworkArn, DryRun = DryRun, RouteTableId = RouteTableId, DestinationCidrBlock = DestinationCidrBlock, GatewayId = GatewayId, DestinationIpv6CidrBlock = DestinationIpv6CidrBlock, EgressOnlyInternetGatewayId = EgressOnlyInternetGatewayId, InstanceId = InstanceId, NetworkInterfaceId = NetworkInterfaceId, VpcPeeringConnectionId = VpcPeeringConnectionId, NatGatewayId = NatGatewayId)
  output <- .ec2$create_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_route <- ec2_create_route

#' Creates a route table for the specified VPC
#'
#' @description
#' Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_route_table/](https://www.paws-r-sdk.com/docs/ec2_create_route_table/) for full documentation.
#'
#' @param TagSpecifications The tags to assign to the route table.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname ec2_create_route_table
ec2_create_route_table <- function(TagSpecifications = NULL, ClientToken = NULL, DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "CreateRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_route_table_input(TagSpecifications = TagSpecifications, ClientToken = ClientToken, DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$create_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_route_table <- ec2_create_route_table

#' Creates a security group
#'
#' @description
#' Creates a security group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_security_group/](https://www.paws-r-sdk.com/docs/ec2_create_security_group/) for full documentation.
#'
#' @param Description &#91;required&#93; A description for the security group.
#' 
#' Constraints: Up to 255 characters in length
#' 
#' Valid characters: a-z, A-Z, 0-9, spaces, and
#' ._-:/()#,@@\[\]+=&;\{\}!$*
#' @param GroupName &#91;required&#93; The name of the security group.
#' 
#' Constraints: Up to 255 characters in length. Cannot start with `sg-`.
#' 
#' Valid characters: a-z, A-Z, 0-9, spaces, and
#' ._-:/()#,@@\[\]+=&;\{\}!$*
#' @param VpcId The ID of the VPC. Required for a nondefault VPC.
#' @param TagSpecifications The tags to assign to the security group.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_security_group
ec2_create_security_group <- function(Description, GroupName, VpcId = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSecurityGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_security_group_input(Description = Description, GroupName = GroupName, VpcId = VpcId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_security_group_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_security_group <- ec2_create_security_group

#' Creates a snapshot of an EBS volume and stores it in Amazon S3
#'
#' @description
#' Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_snapshot/](https://www.paws-r-sdk.com/docs/ec2_create_snapshot/) for full documentation.
#'
#' @param Description A description for the snapshot.
#' @param OutpostArn Only supported for volumes on Outposts. If the source volume is not on
#' an Outpost, omit this parameter.
#' 
#' -   To create the snapshot on the same Outpost as the source volume,
#'     specify the ARN of that Outpost. The snapshot must be created on the
#'     same Outpost as the volume.
#' 
#' -   To create the snapshot in the parent Region of the Outpost, omit
#'     this parameter.
#' 
#' For more information, see [Create local snapshots from volumes on an
#' Outpost](https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot)
#' in the *Amazon EBS User Guide*.
#' @param VolumeId &#91;required&#93; The ID of the Amazon EBS volume.
#' @param TagSpecifications The tags to apply to the snapshot during creation.
#' @param Location Only supported for volumes in Local Zones. If the source volume is not
#' in a Local Zone, omit this parameter.
#' 
#' -   To create a local snapshot in the same Local Zone as the source
#'     volume, specify `local`.
#' 
#' -   To create a regional snapshot in the parent Region of the Local
#'     Zone, specify `regional` or omit this parameter.
#' 
#' Default value: `regional`
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_snapshot
ec2_create_snapshot <- function(Description = NULL, OutpostArn = NULL, VolumeId, TagSpecifications = NULL, Location = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_snapshot_input(Description = Description, OutpostArn = OutpostArn, VolumeId = VolumeId, TagSpecifications = TagSpecifications, Location = Location, DryRun = DryRun)
  output <- .ec2$create_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_snapshot <- ec2_create_snapshot

#' Creates crash-consistent snapshots of multiple EBS volumes attached to
#' an Amazon EC2 instance
#'
#' @description
#' Creates crash-consistent snapshots of multiple EBS volumes attached to an Amazon EC2 instance. Volumes are chosen by specifying an instance. Each volume attached to the specified instance will produce one snapshot that is crash-consistent across the instance. You can include all of the volumes currently attached to the instance, or you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_snapshots/](https://www.paws-r-sdk.com/docs/ec2_create_snapshots/) for full documentation.
#'
#' @param Description A description propagated to every snapshot specified by the instance.
#' @param InstanceSpecification &#91;required&#93; The instance to specify which volumes should be included in the
#' snapshots.
#' @param OutpostArn Only supported for instances on Outposts. If the source instance is not
#' on an Outpost, omit this parameter.
#' 
#' -   To create the snapshots on the same Outpost as the source instance,
#'     specify the ARN of that Outpost. The snapshots must be created on
#'     the same Outpost as the instance.
#' 
#' -   To create the snapshots in the parent Region of the Outpost, omit
#'     this parameter.
#' 
#' For more information, see [Create local snapshots from volumes on an
#' Outpost](https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot)
#' in the *Amazon EBS User Guide*.
#' @param TagSpecifications Tags to apply to every snapshot specified by the instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CopyTagsFromSource Copies the tags from the specified volume to corresponding snapshot.
#' @param Location Only supported for instances in Local Zones. If the source instance is
#' not in a Local Zone, omit this parameter.
#' 
#' -   To create local snapshots in the same Local Zone as the source
#'     instance, specify `local`.
#' 
#' -   To create a regional snapshots in the parent Region of the Local
#'     Zone, specify `regional` or omit this parameter.
#' 
#' Default value: `regional`
#'
#' @keywords internal
#'
#' @rdname ec2_create_snapshots
ec2_create_snapshots <- function(Description = NULL, InstanceSpecification, OutpostArn = NULL, TagSpecifications = NULL, DryRun = NULL, CopyTagsFromSource = NULL, Location = NULL) {
  op <- new_operation(
    name = "CreateSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_snapshots_input(Description = Description, InstanceSpecification = InstanceSpecification, OutpostArn = OutpostArn, TagSpecifications = TagSpecifications, DryRun = DryRun, CopyTagsFromSource = CopyTagsFromSource, Location = Location)
  output <- .ec2$create_snapshots_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_snapshots <- ec2_create_snapshots

#' Creates a data feed for Spot Instances, enabling you to view Spot
#' Instance usage logs
#'
#' @description
#' Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see [Spot Instance data feed](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_spot_datafeed_subscription/](https://www.paws-r-sdk.com/docs/ec2_create_spot_datafeed_subscription/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket in which to store the Spot Instance
#' data feed. For more information about bucket names, see [Bucket naming
#' rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html)
#' in the *Amazon S3 User Guide*.
#' @param Prefix The prefix for the data feed file names.
#'
#' @keywords internal
#'
#' @rdname ec2_create_spot_datafeed_subscription
ec2_create_spot_datafeed_subscription <- function(DryRun = NULL, Bucket, Prefix = NULL) {
  op <- new_operation(
    name = "CreateSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_spot_datafeed_subscription_input(DryRun = DryRun, Bucket = Bucket, Prefix = Prefix)
  output <- .ec2$create_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_spot_datafeed_subscription <- ec2_create_spot_datafeed_subscription

#' Stores an AMI as a single object in an Amazon S3 bucket
#'
#' @description
#' Stores an AMI as a single object in an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_store_image_task/](https://www.paws-r-sdk.com/docs/ec2_create_store_image_task/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket in which the AMI object will be stored.
#' The bucket must be in the Region in which the request is being made. The
#' AMI object appears in the bucket only after the upload task has
#' completed.
#' @param S3ObjectTags The tags to apply to the AMI object that will be stored in the Amazon S3
#' bucket.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_store_image_task
ec2_create_store_image_task <- function(ImageId, Bucket, S3ObjectTags = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateStoreImageTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_store_image_task_input(ImageId = ImageId, Bucket = Bucket, S3ObjectTags = S3ObjectTags, DryRun = DryRun)
  output <- .ec2$create_store_image_task_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_store_image_task <- ec2_create_store_image_task

#' Creates a subnet in the specified VPC
#'
#' @description
#' Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet, specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_subnet/](https://www.paws-r-sdk.com/docs/ec2_create_subnet/) for full documentation.
#'
#' @param TagSpecifications The tags to assign to the subnet.
#' @param AvailabilityZone The Availability Zone or Local Zone for the subnet.
#' 
#' Default: Amazon Web Services selects one for you. If you create more
#' than one subnet in your VPC, we do not necessarily select a different
#' zone for each subnet.
#' 
#' To create a subnet in a Local Zone, set this value to the Local Zone ID,
#' for example `us-west-2-lax-1a`. For information about the Regions that
#' support Local Zones, see [Available Local
#' Zones](https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html).
#' 
#' To create a subnet in an Outpost, set this value to the Availability
#' Zone for the Outpost and specify the Outpost ARN.
#' @param AvailabilityZoneId The AZ ID or the Local Zone ID of the subnet.
#' @param CidrBlock The IPv4 network range for the subnet, in CIDR notation. For example,
#' `10.0.0.0/24`. We modify the specified CIDR block to its canonical form;
#' for example, if you specify `100.68.0.18/18`, we modify it to
#' `100.68.0.0/18`.
#' 
#' This parameter is not supported for an IPv6 only subnet.
#' @param Ipv6CidrBlock The IPv6 network range for the subnet, in CIDR notation. This parameter
#' is required for an IPv6 only subnet.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost
#' ARN, you must also specify the Availability Zone of the Outpost subnet.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param Ipv6Native Indicates whether to create an IPv6 only subnet.
#' @param Ipv4IpamPoolId An IPv4 IPAM pool ID for the subnet.
#' @param Ipv4NetmaskLength An IPv4 netmask length for the subnet.
#' @param Ipv6IpamPoolId An IPv6 IPAM pool ID for the subnet.
#' @param Ipv6NetmaskLength An IPv6 netmask length for the subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_subnet
ec2_create_subnet <- function(TagSpecifications = NULL, AvailabilityZone = NULL, AvailabilityZoneId = NULL, CidrBlock = NULL, Ipv6CidrBlock = NULL, OutpostArn = NULL, VpcId, Ipv6Native = NULL, Ipv4IpamPoolId = NULL, Ipv4NetmaskLength = NULL, Ipv6IpamPoolId = NULL, Ipv6NetmaskLength = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSubnet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_subnet_input(TagSpecifications = TagSpecifications, AvailabilityZone = AvailabilityZone, AvailabilityZoneId = AvailabilityZoneId, CidrBlock = CidrBlock, Ipv6CidrBlock = Ipv6CidrBlock, OutpostArn = OutpostArn, VpcId = VpcId, Ipv6Native = Ipv6Native, Ipv4IpamPoolId = Ipv4IpamPoolId, Ipv4NetmaskLength = Ipv4NetmaskLength, Ipv6IpamPoolId = Ipv6IpamPoolId, Ipv6NetmaskLength = Ipv6NetmaskLength, DryRun = DryRun)
  output <- .ec2$create_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_subnet <- ec2_create_subnet

#' Creates a subnet CIDR reservation
#'
#' @description
#' Creates a subnet CIDR reservation. For more information, see [Subnet CIDR reservations](https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html) in the *Amazon VPC User Guide* and [Manage prefixes for your network interfaces](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-prefixes.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_subnet_cidr_reservation/](https://www.paws-r-sdk.com/docs/ec2_create_subnet_cidr_reservation/) for full documentation.
#'
#' @param SubnetId &#91;required&#93; The ID of the subnet.
#' @param Cidr &#91;required&#93; The IPv4 or IPV6 CIDR range to reserve.
#' @param ReservationType &#91;required&#93; The type of reservation. The reservation type determines how the
#' reserved IP addresses are assigned to resources.
#' 
#' -   `prefix` - Amazon Web Services assigns the reserved IP addresses to
#'     network interfaces.
#' 
#' -   `explicit` - You assign the reserved IP addresses to network
#'     interfaces.
#' @param Description The description to assign to the subnet CIDR reservation.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The tags to assign to the subnet CIDR reservation.
#'
#' @keywords internal
#'
#' @rdname ec2_create_subnet_cidr_reservation
ec2_create_subnet_cidr_reservation <- function(SubnetId, Cidr, ReservationType, Description = NULL, DryRun = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateSubnetCidrReservation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_subnet_cidr_reservation_input(SubnetId = SubnetId, Cidr = Cidr, ReservationType = ReservationType, Description = Description, DryRun = DryRun, TagSpecifications = TagSpecifications)
  output <- .ec2$create_subnet_cidr_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_subnet_cidr_reservation <- ec2_create_subnet_cidr_reservation

#' Adds or overwrites only the specified tags for the specified Amazon EC2
#' resource or resources
#'
#' @description
#' Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_tags/](https://www.paws-r-sdk.com/docs/ec2_create_tags/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources &#91;required&#93; The IDs of the resources, separated by spaces.
#' 
#' Constraints: Up to 1000 resource IDs. We recommend breaking up this
#' request into smaller batches.
#' @param Tags &#91;required&#93; The tags. The `value` parameter is required, but if you don't want the
#' tag to have a value, specify the parameter with no value, and we set the
#' value to an empty string.
#'
#' @keywords internal
#'
#' @rdname ec2_create_tags
ec2_create_tags <- function(DryRun = NULL, Resources, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_tags_input(DryRun = DryRun, Resources = Resources, Tags = Tags)
  output <- .ec2$create_tags_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_tags <- ec2_create_tags

#' Creates a Traffic Mirror filter
#'
#' @description
#' Creates a Traffic Mirror filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_filter/](https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_filter/) for full documentation.
#'
#' @param Description The description of the Traffic Mirror filter.
#' @param TagSpecifications The tags to assign to a Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_filter
ec2_create_traffic_mirror_filter <- function(Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_traffic_mirror_filter_input(Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_filter_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_filter <- ec2_create_traffic_mirror_filter

#' Creates a Traffic Mirror filter rule
#'
#' @description
#' Creates a Traffic Mirror filter rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_filter_rule/](https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_filter_rule/) for full documentation.
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the filter that this rule is associated with.
#' @param TrafficDirection &#91;required&#93; The type of traffic.
#' @param RuleNumber &#91;required&#93; The number of the Traffic Mirror rule. This number must be unique for
#' each Traffic Mirror rule in a given direction. The rules are processed
#' in ascending order by rule number.
#' @param RuleAction &#91;required&#93; The action to take on the filtered traffic.
#' @param DestinationPortRange The destination port range.
#' @param SourcePortRange The source port range.
#' @param Protocol The protocol, for example UDP, to assign to the Traffic Mirror rule.
#' 
#' For information about the protocol value, see [Protocol
#' Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
#' on the Internet Assigned Numbers Authority (IANA) website.
#' @param DestinationCidrBlock &#91;required&#93; The destination CIDR block to assign to the Traffic Mirror rule.
#' @param SourceCidrBlock &#91;required&#93; The source CIDR block to assign to the Traffic Mirror rule.
#' @param Description The description of the Traffic Mirror rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param TagSpecifications Traffic Mirroring tags specifications.
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_filter_rule
ec2_create_traffic_mirror_filter_rule <- function(TrafficMirrorFilterId, TrafficDirection, RuleNumber, RuleAction, DestinationPortRange = NULL, SourcePortRange = NULL, Protocol = NULL, DestinationCidrBlock, SourceCidrBlock, Description = NULL, DryRun = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_traffic_mirror_filter_rule_input(TrafficMirrorFilterId = TrafficMirrorFilterId, TrafficDirection = TrafficDirection, RuleNumber = RuleNumber, RuleAction = RuleAction, DestinationPortRange = DestinationPortRange, SourcePortRange = SourcePortRange, Protocol = Protocol, DestinationCidrBlock = DestinationCidrBlock, SourceCidrBlock = SourceCidrBlock, Description = Description, DryRun = DryRun, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_filter_rule <- ec2_create_traffic_mirror_filter_rule

#' Creates a Traffic Mirror session
#'
#' @description
#' Creates a Traffic Mirror session.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_session/](https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_session/) for full documentation.
#'
#' @param NetworkInterfaceId &#91;required&#93; The ID of the source network interface.
#' @param TrafficMirrorTargetId &#91;required&#93; The ID of the Traffic Mirror target.
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param PacketLength The number of bytes in each packet to mirror. These are bytes after the
#' VXLAN header. Do not specify this parameter when you want to mirror the
#' entire packet. To mirror a subset of the packet, set this to the length
#' (in bytes) that you want to mirror. For example, if you set this value
#' to 100, then the first 100 bytes that meet the filter criteria are
#' copied to the target.
#' 
#' If you do not want to mirror the entire packet, use the `PacketLength`
#' parameter to specify the number of bytes in each packet to mirror.
#' 
#' For sessions with Network Load Balancer (NLB) Traffic Mirror targets the
#' default `PacketLength` will be set to 8500. Valid values are 1-8500.
#' Setting a `PacketLength` greater than 8500 will result in an error
#' response.
#' @param SessionNumber &#91;required&#93; The session number determines the order in which sessions are evaluated
#' when an interface is used by multiple sessions. The first session with a
#' matching filter is the one that mirrors the packets.
#' 
#' Valid values are 1-32766.
#' @param VirtualNetworkId The VXLAN ID for the Traffic Mirror session. For more information about
#' the VXLAN protocol, see [RFC
#' 7348](https://datatracker.ietf.org/doc/html/rfc7348). If you do not
#' specify a `VirtualNetworkId`, an account-wide unique ID is chosen at
#' random.
#' @param Description The description of the Traffic Mirror session.
#' @param TagSpecifications The tags to assign to a Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_session
ec2_create_traffic_mirror_session <- function(NetworkInterfaceId, TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength = NULL, SessionNumber, VirtualNetworkId = NULL, Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_traffic_mirror_session_input(NetworkInterfaceId = NetworkInterfaceId, TrafficMirrorTargetId = TrafficMirrorTargetId, TrafficMirrorFilterId = TrafficMirrorFilterId, PacketLength = PacketLength, SessionNumber = SessionNumber, VirtualNetworkId = VirtualNetworkId, Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_session <- ec2_create_traffic_mirror_session

#' Creates a target for your Traffic Mirror session
#'
#' @description
#' Creates a target for your Traffic Mirror session.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_target/](https://www.paws-r-sdk.com/docs/ec2_create_traffic_mirror_target/) for full documentation.
#'
#' @param NetworkInterfaceId The network interface ID that is associated with the target.
#' @param NetworkLoadBalancerArn The Amazon Resource Name (ARN) of the Network Load Balancer that is
#' associated with the target.
#' @param Description The description of the Traffic Mirror target.
#' @param TagSpecifications The tags to assign to the Traffic Mirror target.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param GatewayLoadBalancerEndpointId The ID of the Gateway Load Balancer endpoint.
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_target
ec2_create_traffic_mirror_target <- function(NetworkInterfaceId = NULL, NetworkLoadBalancerArn = NULL, Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL, GatewayLoadBalancerEndpointId = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorTarget",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_traffic_mirror_target_input(NetworkInterfaceId = NetworkInterfaceId, NetworkLoadBalancerArn = NetworkLoadBalancerArn, Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken, GatewayLoadBalancerEndpointId = GatewayLoadBalancerEndpointId)
  output <- .ec2$create_traffic_mirror_target_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_target <- ec2_create_traffic_mirror_target

#' Creates a transit gateway
#'
#' @description
#' Creates a transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway/) for full documentation.
#'
#' @param Description A description of the transit gateway.
#' @param Options The transit gateway options.
#' @param TagSpecifications The tags to apply to the transit gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway
ec2_create_transit_gateway <- function(Description = NULL, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_input(Description = Description, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway <- ec2_create_transit_gateway

#' Creates a Connect attachment from a specified transit gateway attachment
#'
#' @description
#' Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_connect/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_connect/) for full documentation.
#'
#' @param TransportTransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment. You can specify a VPC
#' attachment or Amazon Web Services Direct Connect attachment.
#' @param Options &#91;required&#93; The Connect attachment options.
#' @param TagSpecifications The tags to apply to the Connect attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_connect
ec2_create_transit_gateway_connect <- function(TransportTransitGatewayAttachmentId, Options, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayConnect",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_connect_input(TransportTransitGatewayAttachmentId = TransportTransitGatewayAttachmentId, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_connect_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_connect <- ec2_create_transit_gateway_connect

#' Creates a Connect peer for a specified transit gateway Connect
#' attachment between a transit gateway and an appliance
#'
#' @description
#' Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an appliance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_connect_peer/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_connect_peer/) for full documentation.
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the Connect attachment.
#' @param TransitGatewayAddress The peer IP address (GRE outer IP address) on the transit gateway side
#' of the Connect peer, which must be specified from a transit gateway CIDR
#' block. If not specified, Amazon automatically assigns the first
#' available IP address from the transit gateway CIDR block.
#' @param PeerAddress &#91;required&#93; The peer IP address (GRE outer IP address) on the appliance side of the
#' Connect peer.
#' @param BgpOptions The BGP options for the Connect peer.
#' @param InsideCidrBlocks &#91;required&#93; The range of inside IP addresses that are used for BGP peering. You must
#' specify a size /29 IPv4 CIDR block from the `169.254.0.0/16` range. The
#' first address from the range must be configured on the appliance as the
#' BGP IP address. You can also optionally specify a size /125 IPv6 CIDR
#' block from the `fd00::/8` range.
#' @param TagSpecifications The tags to apply to the Connect peer.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_connect_peer
ec2_create_transit_gateway_connect_peer <- function(TransitGatewayAttachmentId, TransitGatewayAddress = NULL, PeerAddress, BgpOptions = NULL, InsideCidrBlocks, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayConnectPeer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_connect_peer_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, TransitGatewayAddress = TransitGatewayAddress, PeerAddress = PeerAddress, BgpOptions = BgpOptions, InsideCidrBlocks = InsideCidrBlocks, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_connect_peer_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_connect_peer <- ec2_create_transit_gateway_connect_peer

#' Creates a multicast domain using the specified transit gateway
#'
#' @description
#' Creates a multicast domain using the specified transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_multicast_domain/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_multicast_domain/) for full documentation.
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param Options The options for the transit gateway multicast domain.
#' @param TagSpecifications The tags for the transit gateway multicast domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_multicast_domain
ec2_create_transit_gateway_multicast_domain <- function(TransitGatewayId, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_multicast_domain_input(TransitGatewayId = TransitGatewayId, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_multicast_domain <- ec2_create_transit_gateway_multicast_domain

#' Requests a transit gateway peering attachment between the specified
#' transit gateway (requester) and a peer transit gateway (accepter)
#'
#' @description
#' Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_peering_attachment/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_peering_attachment/) for full documentation.
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param PeerTransitGatewayId &#91;required&#93; The ID of the peer transit gateway with which to create the peering
#' attachment.
#' @param PeerAccountId &#91;required&#93; The ID of the Amazon Web Services account that owns the peer transit
#' gateway.
#' @param PeerRegion &#91;required&#93; The Region where the peer transit gateway is located.
#' @param Options Requests a transit gateway peering attachment.
#' @param TagSpecifications The tags to apply to the transit gateway peering attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_peering_attachment
ec2_create_transit_gateway_peering_attachment <- function(TransitGatewayId, PeerTransitGatewayId, PeerAccountId, PeerRegion, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_peering_attachment_input(TransitGatewayId = TransitGatewayId, PeerTransitGatewayId = PeerTransitGatewayId, PeerAccountId = PeerAccountId, PeerRegion = PeerRegion, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_peering_attachment <- ec2_create_transit_gateway_peering_attachment

#' Creates a transit gateway policy table
#'
#' @description
#' Creates a transit gateway policy table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_policy_table/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_policy_table/) for full documentation.
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway used for the policy table.
#' @param TagSpecifications The tags specification for the transit gateway policy table created
#' during the request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_policy_table
ec2_create_transit_gateway_policy_table <- function(TransitGatewayId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPolicyTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_policy_table_input(TransitGatewayId = TransitGatewayId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_policy_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_policy_table <- ec2_create_transit_gateway_policy_table

#' Creates a reference (route) to a prefix list in a specified transit
#' gateway route table
#'
#' @description
#' Creates a reference (route) to a prefix list in a specified transit gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_prefix_list_reference/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_prefix_list_reference/) for full documentation.
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param PrefixListId &#91;required&#93; The ID of the prefix list that is used for destination matches.
#' @param TransitGatewayAttachmentId The ID of the attachment to which traffic is routed.
#' @param Blackhole Indicates whether to drop traffic that matches this route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_prefix_list_reference
ec2_create_transit_gateway_prefix_list_reference <- function(TransitGatewayRouteTableId, PrefixListId, TransitGatewayAttachmentId = NULL, Blackhole = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPrefixListReference",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_prefix_list_reference_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, PrefixListId = PrefixListId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, Blackhole = Blackhole, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_prefix_list_reference_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_prefix_list_reference <- ec2_create_transit_gateway_prefix_list_reference

#' Creates a static route for the specified transit gateway route table
#'
#' @description
#' Creates a static route for the specified transit gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_route/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_route/) for full documentation.
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range used for destination matches. Routing decisions are based
#' on the most specific match.
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId The ID of the attachment.
#' @param Blackhole Indicates whether to drop traffic that matches this route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route
ec2_create_transit_gateway_route <- function(DestinationCidrBlock, TransitGatewayRouteTableId, TransitGatewayAttachmentId = NULL, Blackhole = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, Blackhole = Blackhole, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route <- ec2_create_transit_gateway_route

#' Creates a route table for the specified transit gateway
#'
#' @description
#' Creates a route table for the specified transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_route_table/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_route_table/) for full documentation.
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param TagSpecifications The tags to apply to the transit gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route_table
ec2_create_transit_gateway_route_table <- function(TransitGatewayId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_route_table_input(TransitGatewayId = TransitGatewayId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route_table <- ec2_create_transit_gateway_route_table

#' Advertises a new transit gateway route table
#'
#' @description
#' Advertises a new transit gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_route_table_announcement/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_route_table_announcement/) for full documentation.
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param PeeringAttachmentId &#91;required&#93; The ID of the peering attachment.
#' @param TagSpecifications The tags specifications applied to the transit gateway route table
#' announcement.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route_table_announcement
ec2_create_transit_gateway_route_table_announcement <- function(TransitGatewayRouteTableId, PeeringAttachmentId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRouteTableAnnouncement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_route_table_announcement_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, PeeringAttachmentId = PeeringAttachmentId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_table_announcement_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route_table_announcement <- ec2_create_transit_gateway_route_table_announcement

#' Attaches the specified VPC to the specified transit gateway
#'
#' @description
#' Attaches the specified VPC to the specified transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_vpc_attachment/](https://www.paws-r-sdk.com/docs/ec2_create_transit_gateway_vpc_attachment/) for full documentation.
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param SubnetIds &#91;required&#93; The IDs of one or more subnets. You can specify only one subnet per
#' Availability Zone. You must specify at least one subnet, but we
#' recommend that you specify two subnets for better availability. The
#' transit gateway uses one IP address from each specified subnet.
#' @param Options The VPC attachment options.
#' @param TagSpecifications The tags to apply to the VPC attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_vpc_attachment
ec2_create_transit_gateway_vpc_attachment <- function(TransitGatewayId, VpcId, SubnetIds, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_transit_gateway_vpc_attachment_input(TransitGatewayId = TransitGatewayId, VpcId = VpcId, SubnetIds = SubnetIds, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_vpc_attachment <- ec2_create_transit_gateway_vpc_attachment

#' An Amazon Web Services Verified Access endpoint is where you define your
#' application along with an optional endpoint-level access policy
#'
#' @description
#' An Amazon Web Services Verified Access endpoint is where you define your application along with an optional endpoint-level access policy.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_verified_access_endpoint/](https://www.paws-r-sdk.com/docs/ec2_create_verified_access_endpoint/) for full documentation.
#'
#' @param VerifiedAccessGroupId &#91;required&#93; The ID of the Verified Access group to associate the endpoint with.
#' @param EndpointType &#91;required&#93; The type of Verified Access endpoint to create.
#' @param AttachmentType &#91;required&#93; The type of attachment.
#' @param DomainCertificateArn The ARN of the public TLS/SSL certificate in Amazon Web Services
#' Certificate Manager to associate with the endpoint. The CN in the
#' certificate must match the DNS name your end users will use to reach
#' your application.
#' @param ApplicationDomain The DNS name for users to reach your application.
#' @param EndpointDomainPrefix A custom identifier that is prepended to the DNS name that is generated
#' for the endpoint.
#' @param SecurityGroupIds The IDs of the security groups to associate with the Verified Access
#' endpoint. Required if `AttachmentType` is set to `vpc`.
#' @param LoadBalancerOptions The load balancer details. This parameter is required if the endpoint
#' type is `load-balancer`.
#' @param NetworkInterfaceOptions The network interface details. This parameter is required if the
#' endpoint type is `network-interface`.
#' @param Description A description for the Verified Access endpoint.
#' @param PolicyDocument The Verified Access policy document.
#' @param TagSpecifications The tags to assign to the Verified Access endpoint.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SseSpecification The options for server side encryption.
#' @param RdsOptions The RDS details. This parameter is required if the endpoint type is
#' `rds`.
#' @param CidrOptions The CIDR options. This parameter is required if the endpoint type is
#' `cidr`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_verified_access_endpoint
ec2_create_verified_access_endpoint <- function(VerifiedAccessGroupId, EndpointType, AttachmentType, DomainCertificateArn = NULL, ApplicationDomain = NULL, EndpointDomainPrefix = NULL, SecurityGroupIds = NULL, LoadBalancerOptions = NULL, NetworkInterfaceOptions = NULL, Description = NULL, PolicyDocument = NULL, TagSpecifications = NULL, ClientToken = NULL, DryRun = NULL, SseSpecification = NULL, RdsOptions = NULL, CidrOptions = NULL) {
  op <- new_operation(
    name = "CreateVerifiedAccessEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_verified_access_endpoint_input(VerifiedAccessGroupId = VerifiedAccessGroupId, EndpointType = EndpointType, AttachmentType = AttachmentType, DomainCertificateArn = DomainCertificateArn, ApplicationDomain = ApplicationDomain, EndpointDomainPrefix = EndpointDomainPrefix, SecurityGroupIds = SecurityGroupIds, LoadBalancerOptions = LoadBalancerOptions, NetworkInterfaceOptions = NetworkInterfaceOptions, Description = Description, PolicyDocument = PolicyDocument, TagSpecifications = TagSpecifications, ClientToken = ClientToken, DryRun = DryRun, SseSpecification = SseSpecification, RdsOptions = RdsOptions, CidrOptions = CidrOptions)
  output <- .ec2$create_verified_access_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_verified_access_endpoint <- ec2_create_verified_access_endpoint

#' An Amazon Web Services Verified Access group is a collection of Amazon
#' Web Services Verified Access endpoints who's associated applications
#' have similar security requirements
#'
#' @description
#' An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints who's associated applications have similar security requirements. Each instance within a Verified Access group shares an Verified Access policy. For example, you can group all Verified Access instances associated with "sales" applications together and use one common Verified Access policy.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_verified_access_group/](https://www.paws-r-sdk.com/docs/ec2_create_verified_access_group/) for full documentation.
#'
#' @param VerifiedAccessInstanceId &#91;required&#93; The ID of the Verified Access instance.
#' @param Description A description for the Verified Access group.
#' @param PolicyDocument The Verified Access policy document.
#' @param TagSpecifications The tags to assign to the Verified Access group.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SseSpecification The options for server side encryption.
#'
#' @keywords internal
#'
#' @rdname ec2_create_verified_access_group
ec2_create_verified_access_group <- function(VerifiedAccessInstanceId, Description = NULL, PolicyDocument = NULL, TagSpecifications = NULL, ClientToken = NULL, DryRun = NULL, SseSpecification = NULL) {
  op <- new_operation(
    name = "CreateVerifiedAccessGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_verified_access_group_input(VerifiedAccessInstanceId = VerifiedAccessInstanceId, Description = Description, PolicyDocument = PolicyDocument, TagSpecifications = TagSpecifications, ClientToken = ClientToken, DryRun = DryRun, SseSpecification = SseSpecification)
  output <- .ec2$create_verified_access_group_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_verified_access_group <- ec2_create_verified_access_group

#' An Amazon Web Services Verified Access instance is a regional entity
#' that evaluates application requests and grants access only when your
#' security requirements are met
#'
#' @description
#' An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and grants access only when your security requirements are met.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_verified_access_instance/](https://www.paws-r-sdk.com/docs/ec2_create_verified_access_instance/) for full documentation.
#'
#' @param Description A description for the Verified Access instance.
#' @param TagSpecifications The tags to assign to the Verified Access instance.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FIPSEnabled Enable or disable support for Federal Information Processing Standards
#' (FIPS) on the instance.
#' @param CidrEndpointsCustomSubDomain The custom subdomain.
#'
#' @keywords internal
#'
#' @rdname ec2_create_verified_access_instance
ec2_create_verified_access_instance <- function(Description = NULL, TagSpecifications = NULL, ClientToken = NULL, DryRun = NULL, FIPSEnabled = NULL, CidrEndpointsCustomSubDomain = NULL) {
  op <- new_operation(
    name = "CreateVerifiedAccessInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_verified_access_instance_input(Description = Description, TagSpecifications = TagSpecifications, ClientToken = ClientToken, DryRun = DryRun, FIPSEnabled = FIPSEnabled, CidrEndpointsCustomSubDomain = CidrEndpointsCustomSubDomain)
  output <- .ec2$create_verified_access_instance_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_verified_access_instance <- ec2_create_verified_access_instance

#' A trust provider is a third-party entity that creates, maintains, and
#' manages identity information for users and devices
#'
#' @description
#' A trust provider is a third-party entity that creates, maintains, and manages identity information for users and devices. When an application request is made, the identity information sent by the trust provider is evaluated by Verified Access before allowing or denying the application request.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_verified_access_trust_provider/](https://www.paws-r-sdk.com/docs/ec2_create_verified_access_trust_provider/) for full documentation.
#'
#' @param TrustProviderType &#91;required&#93; The type of trust provider.
#' @param UserTrustProviderType The type of user-based trust provider. This parameter is required when
#' the provider type is `user`.
#' @param DeviceTrustProviderType The type of device-based trust provider. This parameter is required when
#' the provider type is `device`.
#' @param OidcOptions The options for a OpenID Connect-compatible user-identity trust
#' provider. This parameter is required when the provider type is `user`.
#' @param DeviceOptions The options for a device-based trust provider. This parameter is
#' required when the provider type is `device`.
#' @param PolicyReferenceName &#91;required&#93; The identifier to be used when working with policy rules.
#' @param Description A description for the Verified Access trust provider.
#' @param TagSpecifications The tags to assign to the Verified Access trust provider.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SseSpecification The options for server side encryption.
#' @param NativeApplicationOidcOptions The OpenID Connect (OIDC) options.
#'
#' @keywords internal
#'
#' @rdname ec2_create_verified_access_trust_provider
ec2_create_verified_access_trust_provider <- function(TrustProviderType, UserTrustProviderType = NULL, DeviceTrustProviderType = NULL, OidcOptions = NULL, DeviceOptions = NULL, PolicyReferenceName, Description = NULL, TagSpecifications = NULL, ClientToken = NULL, DryRun = NULL, SseSpecification = NULL, NativeApplicationOidcOptions = NULL) {
  op <- new_operation(
    name = "CreateVerifiedAccessTrustProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_verified_access_trust_provider_input(TrustProviderType = TrustProviderType, UserTrustProviderType = UserTrustProviderType, DeviceTrustProviderType = DeviceTrustProviderType, OidcOptions = OidcOptions, DeviceOptions = DeviceOptions, PolicyReferenceName = PolicyReferenceName, Description = Description, TagSpecifications = TagSpecifications, ClientToken = ClientToken, DryRun = DryRun, SseSpecification = SseSpecification, NativeApplicationOidcOptions = NativeApplicationOidcOptions)
  output <- .ec2$create_verified_access_trust_provider_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_verified_access_trust_provider <- ec2_create_verified_access_trust_provider

#' Creates an EBS volume that can be attached to an instance in the same
#' Availability Zone
#'
#' @description
#' Creates an EBS volume that can be attached to an instance in the same Availability Zone.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_volume/](https://www.paws-r-sdk.com/docs/ec2_create_volume/) for full documentation.
#'
#' @param AvailabilityZone &#91;required&#93; The ID of the Availability Zone in which to create the volume. For
#' example, `us-east-1a`.
#' @param Encrypted Indicates whether the volume should be encrypted. The effect of setting
#' the encryption state to `true` depends on the volume origin (new or from
#' a snapshot), starting encryption state, ownership, and whether
#' encryption by default is enabled. For more information, see [Encryption
#' by
#' default](https://docs.aws.amazon.com/ebs/latest/userguide/#encryption-by-default)
#' in the *Amazon EBS User Guide*.
#' 
#' Encrypted Amazon EBS volumes must be attached to instances that support
#' Amazon EBS encryption. For more information, see [Supported instance
#' types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances).
#' @param Iops The number of I/O operations per second (IOPS). For `gp3`, `io1`, and
#' `io2` volumes, this represents the number of IOPS that are provisioned
#' for the volume. For `gp2` volumes, this represents the baseline
#' performance of the volume and the rate at which the volume accumulates
#' I/O credits for bursting.
#' 
#' The following are the supported values for each volume type:
#' 
#' -   `gp3`: 3,000 - 16,000 IOPS
#' 
#' -   `io1`: 100 - 64,000 IOPS
#' 
#' -   `io2`: 100 - 256,000 IOPS
#' 
#' For `io2` volumes, you can achieve up to 256,000 IOPS on [instances
#' built on the Nitro
#' System](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html).
#' On other instances, you can achieve performance up to 32,000 IOPS.
#' 
#' This parameter is required for `io1` and `io2` volumes. The default for
#' `gp3` volumes is 3,000 IOPS. This parameter is not supported for `gp2`,
#' `st1`, `sc1`, or `standard` volumes.
#' @param KmsKeyId The identifier of the KMS key to use for Amazon EBS encryption. If this
#' parameter is not specified, your KMS key for Amazon EBS is used. If
#' `KmsKeyId` is specified, the encrypted state must be `true`.
#' 
#' You can specify the KMS key using any of the following:
#' 
#' -   Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
#' 
#' Amazon Web Services authenticates the KMS key asynchronously. Therefore,
#' if you specify an ID, alias, or ARN that is not valid, the action can
#' appear to complete, but eventually fails.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost on which to create the
#' volume.
#' 
#' If you intend to use a volume with an instance running on an outpost,
#' then you must create the volume on the same outpost as the instance. You
#' can't use a volume created in an Amazon Web Services Region with an
#' instance on an Amazon Web Services outpost, or the other way around.
#' @param Size The size of the volume, in GiBs. You must specify either a snapshot ID
#' or a volume size. If you specify a snapshot, the default is the snapshot
#' size. You can specify a volume size that is equal to or larger than the
#' snapshot size.
#' 
#' The following are the supported volumes sizes for each volume type:
#' 
#' -   `gp2` and `gp3`: 1 - 16,384 GiB
#' 
#' -   `io1`: 4 - 16,384 GiB
#' 
#' -   `io2`: 4 - 65,536 GiB
#' 
#' -   `st1` and `sc1`: 125 - 16,384 GiB
#' 
#' -   `standard`: 1 - 1024 GiB
#' @param SnapshotId The snapshot from which to create the volume. You must specify either a
#' snapshot ID or a volume size.
#' @param VolumeType The volume type. This parameter can be one of the following values:
#' 
#' -   General Purpose SSD: `gp2` | `gp3`
#' 
#' -   Provisioned IOPS SSD: `io1` | `io2`
#' 
#' -   Throughput Optimized HDD: `st1`
#' 
#' -   Cold HDD: `sc1`
#' 
#' -   Magnetic: `standard`
#' 
#' Throughput Optimized HDD (`st1`) and Cold HDD (`sc1`) volumes can't be
#' used as boot volumes.
#' 
#' For more information, see [Amazon EBS volume
#' types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html)
#' in the *Amazon EBS User Guide*.
#' 
#' Default: `gp2`
#' @param TagSpecifications The tags to apply to the volume during creation.
#' @param MultiAttachEnabled Indicates whether to enable Amazon EBS Multi-Attach. If you enable
#' Multi-Attach, you can attach the volume to up to 16 [Instances built on
#' the Nitro
#' System](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html)
#' in the same Availability Zone. This parameter is supported with `io1`
#' and `io2` volumes only. For more information, see [Amazon EBS
#' Multi-Attach](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html)
#' in the *Amazon EBS User Guide*.
#' @param Throughput The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
#' 
#' This parameter is valid only for `gp3` volumes.
#' 
#' Valid Range: Minimum value of 125. Maximum value of 1000.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensure
#' Idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param Operator Reserved for internal use.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_volume
ec2_create_volume <- function(AvailabilityZone, Encrypted = NULL, Iops = NULL, KmsKeyId = NULL, OutpostArn = NULL, Size = NULL, SnapshotId = NULL, VolumeType = NULL, TagSpecifications = NULL, MultiAttachEnabled = NULL, Throughput = NULL, ClientToken = NULL, Operator = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_volume_input(AvailabilityZone = AvailabilityZone, Encrypted = Encrypted, Iops = Iops, KmsKeyId = KmsKeyId, OutpostArn = OutpostArn, Size = Size, SnapshotId = SnapshotId, VolumeType = VolumeType, TagSpecifications = TagSpecifications, MultiAttachEnabled = MultiAttachEnabled, Throughput = Throughput, ClientToken = ClientToken, Operator = Operator, DryRun = DryRun)
  output <- .ec2$create_volume_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_volume <- ec2_create_volume

#' Creates a VPC with the specified CIDR blocks
#'
#' @description
#' Creates a VPC with the specified CIDR blocks. For more information, see [IP addressing for your VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpc/](https://www.paws-r-sdk.com/docs/ec2_create_vpc/) for full documentation.
#'
#' @param CidrBlock The IPv4 network range for the VPC, in CIDR notation. For example,
#' `10.0.0.0/16`. We modify the specified CIDR block to its canonical form;
#' for example, if you specify `100.68.0.18/18`, we modify it to
#' `100.68.0.0/18`.
#' @param Ipv6Pool The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
#' block.
#' @param Ipv6CidrBlock The IPv6 CIDR block from the IPv6 address pool. You must also specify
#' `Ipv6Pool` in the request.
#' 
#' To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
#' @param Ipv4IpamPoolId The ID of an IPv4 IPAM pool you want to use for allocating this VPC's
#' CIDR. For more information, see [What is
#' IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/) in the *Amazon VPC
#' IPAM User Guide*.
#' @param Ipv4NetmaskLength The netmask length of the IPv4 CIDR you want to allocate to this VPC
#' from an Amazon VPC IP Address Manager (IPAM) pool. For more information
#' about IPAM, see [What is
#' IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/) in the *Amazon VPC
#' IPAM User Guide*.
#' @param Ipv6IpamPoolId The ID of an IPv6 IPAM pool which will be used to allocate this VPC an
#' IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP
#' address management workflows including assigning, tracking,
#' troubleshooting, and auditing IP addresses across Amazon Web Services
#' Regions and accounts throughout your Amazon Web Services Organization.
#' For more information, see [What is
#' IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/) in the *Amazon VPC
#' IPAM User Guide*.
#' @param Ipv6NetmaskLength The netmask length of the IPv6 CIDR you want to allocate to this VPC
#' from an Amazon VPC IP Address Manager (IPAM) pool. For more information
#' about IPAM, see [What is
#' IPAM?](https://docs.aws.amazon.com/vpc/latest/ipam/) in the *Amazon VPC
#' IPAM User Guide*.
#' @param Ipv6CidrBlockNetworkBorderGroup The name of the location from which we advertise the IPV6 CIDR block.
#' Use this parameter to limit the address to this location.
#' 
#' You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
#' parameter.
#' @param TagSpecifications The tags to assign to the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTenancy The tenancy options for instances launched into the VPC. For `default`,
#' instances are launched with shared tenancy by default. You can launch
#' instances with any tenancy into a shared tenancy VPC. For `dedicated`,
#' instances are launched as dedicated tenancy instances by default. You
#' can only launch instances with a tenancy of `dedicated` or `host` into a
#' dedicated tenancy VPC.
#' 
#' **Important:** The `host` value cannot be used with this parameter. Use
#' the `default` or `dedicated` values only.
#' 
#' Default: `default`
#' @param AmazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
#' the VPC. You cannot specify the range of IP addresses, or the size of
#' the CIDR block.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc
ec2_create_vpc <- function(CidrBlock = NULL, Ipv6Pool = NULL, Ipv6CidrBlock = NULL, Ipv4IpamPoolId = NULL, Ipv4NetmaskLength = NULL, Ipv6IpamPoolId = NULL, Ipv6NetmaskLength = NULL, Ipv6CidrBlockNetworkBorderGroup = NULL, TagSpecifications = NULL, DryRun = NULL, InstanceTenancy = NULL, AmazonProvidedIpv6CidrBlock = NULL) {
  op <- new_operation(
    name = "CreateVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpc_input(CidrBlock = CidrBlock, Ipv6Pool = Ipv6Pool, Ipv6CidrBlock = Ipv6CidrBlock, Ipv4IpamPoolId = Ipv4IpamPoolId, Ipv4NetmaskLength = Ipv4NetmaskLength, Ipv6IpamPoolId = Ipv6IpamPoolId, Ipv6NetmaskLength = Ipv6NetmaskLength, Ipv6CidrBlockNetworkBorderGroup = Ipv6CidrBlockNetworkBorderGroup, TagSpecifications = TagSpecifications, DryRun = DryRun, InstanceTenancy = InstanceTenancy, AmazonProvidedIpv6CidrBlock = AmazonProvidedIpv6CidrBlock)
  output <- .ec2$create_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc <- ec2_create_vpc

#' Create a VPC Block Public Access (BPA) exclusion
#'
#' @description
#' Create a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see [Block public access to VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpc_block_public_access_exclusion/](https://www.paws-r-sdk.com/docs/ec2_create_vpc_block_public_access_exclusion/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SubnetId A subnet ID.
#' @param VpcId A VPC ID.
#' @param InternetGatewayExclusionMode &#91;required&#93; The exclusion mode for internet gateway traffic.
#' 
#' -   `allow-bidirectional`: Allow all internet traffic to and from the
#'     excluded VPCs and subnets.
#' 
#' -   `allow-egress`: Allow outbound internet traffic from the excluded
#'     VPCs and subnets. Block inbound internet traffic to the excluded
#'     VPCs and subnets. Only applies when VPC Block Public Access is set
#'     to Bidirectional.
#' @param TagSpecifications `tag` - The key/value combination of a tag assigned to the resource. Use
#' the tag key in the filter name and the tag value as the filter value.
#' For example, to find all resources that have a tag with the key `Owner`
#' and the value `TeamA`, specify `tag:Owner` for the filter name and
#' `TeamA` for the filter value.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_block_public_access_exclusion
ec2_create_vpc_block_public_access_exclusion <- function(DryRun = NULL, SubnetId = NULL, VpcId = NULL, InternetGatewayExclusionMode, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpcBlockPublicAccessExclusion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpc_block_public_access_exclusion_input(DryRun = DryRun, SubnetId = SubnetId, VpcId = VpcId, InternetGatewayExclusionMode = InternetGatewayExclusionMode, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpc_block_public_access_exclusion_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_block_public_access_exclusion <- ec2_create_vpc_block_public_access_exclusion

#' Creates a VPC endpoint
#'
#' @description
#' Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services account. For more information, see the [Amazon Web Services PrivateLink User Guide](https://docs.aws.amazon.com/vpc/latest/privatelink/).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint/](https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointType The type of endpoint.
#' 
#' Default: Gateway
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param ServiceName The name of the endpoint service.
#' @param PolicyDocument (Interface and gateway endpoints) A policy to attach to the endpoint
#' that controls access to the service. The policy must be in valid JSON
#' format. If this parameter is not specified, we attach a default policy
#' that allows full access to the service.
#' @param RouteTableIds (Gateway endpoint) The route table IDs.
#' @param SubnetIds (Interface and Gateway Load Balancer endpoints) The IDs of the subnets
#' in which to create endpoint network interfaces. For a Gateway Load
#' Balancer endpoint, you can specify only one subnet.
#' @param SecurityGroupIds (Interface endpoint) The IDs of the security groups to associate with
#' the endpoint network interfaces. If this parameter is not specified, we
#' use the default security group for the VPC.
#' @param IpAddressType The IP address type for the endpoint.
#' @param DnsOptions The DNS options for the endpoint.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param PrivateDnsEnabled (Interface endpoint) Indicates whether to associate a private hosted
#' zone with the specified VPC. The private hosted zone contains a record
#' set for the default public DNS name for the service for the Region (for
#' example, `kinesis.us-east-1.amazonaws.com`), which resolves to the
#' private IP addresses of the endpoint network interfaces in the VPC. This
#' enables you to make requests to the default public DNS name for the
#' service instead of the public DNS names that are automatically generated
#' by the VPC endpoint service.
#' 
#' To use a private hosted zone, you must set the following VPC attributes
#' to `true`: `enableDnsHostnames` and `enableDnsSupport`. Use
#' [`modify_vpc_attribute`][ec2_modify_vpc_attribute] to set the VPC
#' attributes.
#' 
#' Default: `true`
#' @param TagSpecifications The tags to associate with the endpoint.
#' @param SubnetConfigurations The subnet configurations for the endpoint.
#' @param ServiceNetworkArn The Amazon Resource Name (ARN) of a service network that will be
#' associated with the VPC endpoint of type service-network.
#' @param ResourceConfigurationArn The Amazon Resource Name (ARN) of a resource configuration that will be
#' associated with the VPC endpoint of type resource.
#' @param ServiceRegion The Region where the service is hosted. The default is the current
#' Region.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint
ec2_create_vpc_endpoint <- function(DryRun = NULL, VpcEndpointType = NULL, VpcId, ServiceName = NULL, PolicyDocument = NULL, RouteTableIds = NULL, SubnetIds = NULL, SecurityGroupIds = NULL, IpAddressType = NULL, DnsOptions = NULL, ClientToken = NULL, PrivateDnsEnabled = NULL, TagSpecifications = NULL, SubnetConfigurations = NULL, ServiceNetworkArn = NULL, ResourceConfigurationArn = NULL, ServiceRegion = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpc_endpoint_input(DryRun = DryRun, VpcEndpointType = VpcEndpointType, VpcId = VpcId, ServiceName = ServiceName, PolicyDocument = PolicyDocument, RouteTableIds = RouteTableIds, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, IpAddressType = IpAddressType, DnsOptions = DnsOptions, ClientToken = ClientToken, PrivateDnsEnabled = PrivateDnsEnabled, TagSpecifications = TagSpecifications, SubnetConfigurations = SubnetConfigurations, ServiceNetworkArn = ServiceNetworkArn, ResourceConfigurationArn = ResourceConfigurationArn, ServiceRegion = ServiceRegion)
  output <- .ec2$create_vpc_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint <- ec2_create_vpc_endpoint

#' Creates a connection notification for a specified VPC endpoint or VPC
#' endpoint service
#'
#' @description
#' Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see [Creating an Amazon SNS topic](https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html) in the *Amazon SNS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint_connection_notification/](https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint_connection_notification/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId The ID of the endpoint service.
#' @param VpcEndpointId The ID of the endpoint.
#' @param ConnectionNotificationArn &#91;required&#93; The ARN of the SNS topic for the notifications.
#' @param ConnectionEvents &#91;required&#93; The endpoint events for which to receive notifications. Valid values are
#' `Accept`, `Connect`, `Delete`, and `Reject`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint_connection_notification
ec2_create_vpc_endpoint_connection_notification <- function(DryRun = NULL, ServiceId = NULL, VpcEndpointId = NULL, ConnectionNotificationArn, ConnectionEvents, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpointConnectionNotification",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpc_endpoint_connection_notification_input(DryRun = DryRun, ServiceId = ServiceId, VpcEndpointId = VpcEndpointId, ConnectionNotificationArn = ConnectionNotificationArn, ConnectionEvents = ConnectionEvents, ClientToken = ClientToken)
  output <- .ec2$create_vpc_endpoint_connection_notification_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint_connection_notification <- ec2_create_vpc_endpoint_connection_notification

#' Creates a VPC endpoint service to which service consumers (Amazon Web
#' Services accounts, users, and IAM roles) can connect
#'
#' @description
#' Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles) can connect.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint_service_configuration/](https://www.paws-r-sdk.com/docs/ec2_create_vpc_endpoint_service_configuration/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AcceptanceRequired Indicates whether requests from service consumers to create an endpoint
#' to your service must be accepted manually.
#' @param PrivateDnsName (Interface endpoint configuration) The private DNS name to assign to the
#' VPC endpoint service.
#' @param NetworkLoadBalancerArns The Amazon Resource Names (ARNs) of the Network Load Balancers.
#' @param GatewayLoadBalancerArns The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
#' @param SupportedIpAddressTypes The supported IP address types. The possible values are `ipv4` and
#' `ipv6`.
#' @param SupportedRegions The Regions from which service consumers can access the service.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to ensure
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param TagSpecifications The tags to associate with the service.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint_service_configuration
ec2_create_vpc_endpoint_service_configuration <- function(DryRun = NULL, AcceptanceRequired = NULL, PrivateDnsName = NULL, NetworkLoadBalancerArns = NULL, GatewayLoadBalancerArns = NULL, SupportedIpAddressTypes = NULL, SupportedRegions = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpointServiceConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpc_endpoint_service_configuration_input(DryRun = DryRun, AcceptanceRequired = AcceptanceRequired, PrivateDnsName = PrivateDnsName, NetworkLoadBalancerArns = NetworkLoadBalancerArns, GatewayLoadBalancerArns = GatewayLoadBalancerArns, SupportedIpAddressTypes = SupportedIpAddressTypes, SupportedRegions = SupportedRegions, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_vpc_endpoint_service_configuration_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint_service_configuration <- ec2_create_vpc_endpoint_service_configuration

#' Requests a VPC peering connection between two VPCs: a requester VPC that
#' you own and an accepter VPC with which to create the connection
#'
#' @description
#' Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpc_peering_connection/](https://www.paws-r-sdk.com/docs/ec2_create_vpc_peering_connection/) for full documentation.
#'
#' @param PeerRegion The Region code for the accepter VPC, if the accepter VPC is located in
#' a Region other than the Region in which you make the request.
#' 
#' Default: The Region in which you make the request.
#' @param TagSpecifications The tags to assign to the peering connection.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the requester VPC. You must specify this parameter in the
#' request.
#' @param PeerVpcId The ID of the VPC with which you are creating the VPC peering
#' connection. You must specify this parameter in the request.
#' @param PeerOwnerId The Amazon Web Services account ID of the owner of the accepter VPC.
#' 
#' Default: Your Amazon Web Services account ID
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_peering_connection
ec2_create_vpc_peering_connection <- function(PeerRegion = NULL, TagSpecifications = NULL, DryRun = NULL, VpcId, PeerVpcId = NULL, PeerOwnerId = NULL) {
  op <- new_operation(
    name = "CreateVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpc_peering_connection_input(PeerRegion = PeerRegion, TagSpecifications = TagSpecifications, DryRun = DryRun, VpcId = VpcId, PeerVpcId = PeerVpcId, PeerOwnerId = PeerOwnerId)
  output <- .ec2$create_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_peering_connection <- ec2_create_vpc_peering_connection

#' Creates a VPN connection between an existing virtual private gateway or
#' transit gateway and a customer gateway
#'
#' @description
#' Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway. The supported connection type is `ipsec.1`.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpn_connection/](https://www.paws-r-sdk.com/docs/ec2_create_vpn_connection/) for full documentation.
#'
#' @param CustomerGatewayId &#91;required&#93; The ID of the customer gateway.
#' @param Type &#91;required&#93; The type of VPN connection (`ipsec.1`).
#' @param VpnGatewayId The ID of the virtual private gateway. If you specify a virtual private
#' gateway, you cannot specify a transit gateway.
#' @param TransitGatewayId The ID of the transit gateway. If you specify a transit gateway, you
#' cannot specify a virtual private gateway.
#' @param TagSpecifications The tags to apply to the VPN connection.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Options The options for the VPN connection.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_connection
ec2_create_vpn_connection <- function(CustomerGatewayId, Type, VpnGatewayId = NULL, TransitGatewayId = NULL, TagSpecifications = NULL, DryRun = NULL, Options = NULL) {
  op <- new_operation(
    name = "CreateVpnConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpn_connection_input(CustomerGatewayId = CustomerGatewayId, Type = Type, VpnGatewayId = VpnGatewayId, TransitGatewayId = TransitGatewayId, TagSpecifications = TagSpecifications, DryRun = DryRun, Options = Options)
  output <- .ec2$create_vpn_connection_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_connection <- ec2_create_vpn_connection

#' Creates a static route associated with a VPN connection between an
#' existing virtual private gateway and a VPN customer gateway
#'
#' @description
#' Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpn_connection_route/](https://www.paws-r-sdk.com/docs/ec2_create_vpn_connection_route/) for full documentation.
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR block associated with the local subnet of the customer network.
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_connection_route
ec2_create_vpn_connection_route <- function(DestinationCidrBlock, VpnConnectionId) {
  op <- new_operation(
    name = "CreateVpnConnectionRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpn_connection_route_input(DestinationCidrBlock = DestinationCidrBlock, VpnConnectionId = VpnConnectionId)
  output <- .ec2$create_vpn_connection_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_connection_route <- ec2_create_vpn_connection_route

#' Creates a virtual private gateway
#'
#' @description
#' Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN connection. You can create a virtual private gateway before creating the VPC itself.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_create_vpn_gateway/](https://www.paws-r-sdk.com/docs/ec2_create_vpn_gateway/) for full documentation.
#'
#' @param AvailabilityZone The Availability Zone for the virtual private gateway.
#' @param Type &#91;required&#93; The type of VPN connection this virtual private gateway supports.
#' @param TagSpecifications The tags to apply to the virtual private gateway.
#' @param AmazonSideAsn A private Autonomous System Number (ASN) for the Amazon side of a BGP
#' session. If you're using a 16-bit ASN, it must be in the 64512 to 65534
#' range. If you're using a 32-bit ASN, it must be in the 4200000000 to
#' 4294967294 range.
#' 
#' Default: 64512
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_gateway
ec2_create_vpn_gateway <- function(AvailabilityZone = NULL, Type, TagSpecifications = NULL, AmazonSideAsn = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateVpnGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$create_vpn_gateway_input(AvailabilityZone = AvailabilityZone, Type = Type, TagSpecifications = TagSpecifications, AmazonSideAsn = AmazonSideAsn, DryRun = DryRun)
  output <- .ec2$create_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_gateway <- ec2_create_vpn_gateway

#' Deletes a carrier gateway
#'
#' @description
#' Deletes a carrier gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_carrier_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_carrier_gateway/) for full documentation.
#'
#' @param CarrierGatewayId &#91;required&#93; The ID of the carrier gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_carrier_gateway
ec2_delete_carrier_gateway <- function(CarrierGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCarrierGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_carrier_gateway_input(CarrierGatewayId = CarrierGatewayId, DryRun = DryRun)
  output <- .ec2$delete_carrier_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_carrier_gateway <- ec2_delete_carrier_gateway

#' Deletes the specified Client VPN endpoint
#'
#' @description
#' Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a Client VPN endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_client_vpn_endpoint/](https://www.paws-r-sdk.com/docs/ec2_delete_client_vpn_endpoint/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN to be deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_client_vpn_endpoint
ec2_delete_client_vpn_endpoint <- function(ClientVpnEndpointId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_client_vpn_endpoint_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun)
  output <- .ec2$delete_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_client_vpn_endpoint <- ec2_delete_client_vpn_endpoint

#' Deletes a route from a Client VPN endpoint
#'
#' @description
#' Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the **CreateClientVpnRoute** action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_client_vpn_route/](https://www.paws-r-sdk.com/docs/ec2_delete_client_vpn_route/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint from which the route is to be deleted.
#' @param TargetVpcSubnetId The ID of the target subnet used by the route.
#' @param DestinationCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, of the route to be deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_client_vpn_route
ec2_delete_client_vpn_route <- function(ClientVpnEndpointId, TargetVpcSubnetId = NULL, DestinationCidrBlock, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteClientVpnRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_client_vpn_route_input(ClientVpnEndpointId = ClientVpnEndpointId, TargetVpcSubnetId = TargetVpcSubnetId, DestinationCidrBlock = DestinationCidrBlock, DryRun = DryRun)
  output <- .ec2$delete_client_vpn_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_client_vpn_route <- ec2_delete_client_vpn_route

#' Deletes a range of customer-owned IP addresses
#'
#' @description
#' Deletes a range of customer-owned IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_coip_cidr/](https://www.paws-r-sdk.com/docs/ec2_delete_coip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; A customer-owned IP address range that you want to delete.
#' @param CoipPoolId &#91;required&#93; The ID of the customer-owned address pool.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_coip_cidr
ec2_delete_coip_cidr <- function(Cidr, CoipPoolId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCoipCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_coip_cidr_input(Cidr = Cidr, CoipPoolId = CoipPoolId, DryRun = DryRun)
  output <- .ec2$delete_coip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_coip_cidr <- ec2_delete_coip_cidr

#' Deletes a pool of customer-owned IP (CoIP) addresses
#'
#' @description
#' Deletes a pool of customer-owned IP (CoIP) addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_coip_pool/](https://www.paws-r-sdk.com/docs/ec2_delete_coip_pool/) for full documentation.
#'
#' @param CoipPoolId &#91;required&#93; The ID of the CoIP pool that you want to delete.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_coip_pool
ec2_delete_coip_pool <- function(CoipPoolId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCoipPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_coip_pool_input(CoipPoolId = CoipPoolId, DryRun = DryRun)
  output <- .ec2$delete_coip_pool_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_coip_pool <- ec2_delete_coip_pool

#' Deletes the specified customer gateway
#'
#' @description
#' Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_customer_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_customer_gateway/) for full documentation.
#'
#' @param CustomerGatewayId &#91;required&#93; The ID of the customer gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_customer_gateway
ec2_delete_customer_gateway <- function(CustomerGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCustomerGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_customer_gateway_input(CustomerGatewayId = CustomerGatewayId, DryRun = DryRun)
  output <- .ec2$delete_customer_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_customer_gateway <- ec2_delete_customer_gateway

#' Deletes the specified set of DHCP options
#'
#' @description
#' Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_dhcp_options/](https://www.paws-r-sdk.com/docs/ec2_delete_dhcp_options/) for full documentation.
#'
#' @param DhcpOptionsId &#91;required&#93; The ID of the DHCP options set.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_dhcp_options
ec2_delete_dhcp_options <- function(DhcpOptionsId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteDhcpOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_dhcp_options_input(DhcpOptionsId = DhcpOptionsId, DryRun = DryRun)
  output <- .ec2$delete_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_dhcp_options <- ec2_delete_dhcp_options

#' Deletes an egress-only internet gateway
#'
#' @description
#' Deletes an egress-only internet gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_egress_only_internet_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_egress_only_internet_gateway/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayId &#91;required&#93; The ID of the egress-only internet gateway.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_egress_only_internet_gateway
ec2_delete_egress_only_internet_gateway <- function(DryRun = NULL, EgressOnlyInternetGatewayId) {
  op <- new_operation(
    name = "DeleteEgressOnlyInternetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_egress_only_internet_gateway_input(DryRun = DryRun, EgressOnlyInternetGatewayId = EgressOnlyInternetGatewayId)
  output <- .ec2$delete_egress_only_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_egress_only_internet_gateway <- ec2_delete_egress_only_internet_gateway

#' Deletes the specified EC2 Fleets
#'
#' @description
#' Deletes the specified EC2 Fleets.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_fleets/](https://www.paws-r-sdk.com/docs/ec2_delete_fleets/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FleetIds &#91;required&#93; The IDs of the EC2 Fleets.
#' 
#' Constraints: In a single request, you can specify up to 25 `instant`
#' fleet IDs and up to 100 `maintain` or `request` fleet IDs.
#' @param TerminateInstances &#91;required&#93; Indicates whether to terminate the associated instances when the EC2
#' Fleet is deleted. The default is to terminate the instances.
#' 
#' To let the instances continue to run after the EC2 Fleet is deleted,
#' specify `no-terminate-instances`. Supported only for fleets of type
#' `maintain` and `request`.
#' 
#' For `instant` fleets, you cannot specify `NoTerminateInstances`. A
#' deleted `instant` fleet with running instances is not supported.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_fleets
ec2_delete_fleets <- function(DryRun = NULL, FleetIds, TerminateInstances) {
  op <- new_operation(
    name = "DeleteFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_fleets_input(DryRun = DryRun, FleetIds = FleetIds, TerminateInstances = TerminateInstances)
  output <- .ec2$delete_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_fleets <- ec2_delete_fleets

#' Deletes one or more flow logs
#'
#' @description
#' Deletes one or more flow logs.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_flow_logs/](https://www.paws-r-sdk.com/docs/ec2_delete_flow_logs/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FlowLogIds &#91;required&#93; One or more flow log IDs.
#' 
#' Constraint: Maximum of 1000 flow log IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_flow_logs
ec2_delete_flow_logs <- function(DryRun = NULL, FlowLogIds) {
  op <- new_operation(
    name = "DeleteFlowLogs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_flow_logs_input(DryRun = DryRun, FlowLogIds = FlowLogIds)
  output <- .ec2$delete_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_flow_logs <- ec2_delete_flow_logs

#' Deletes the specified Amazon FPGA Image (AFI)
#'
#' @description
#' Deletes the specified Amazon FPGA Image (AFI).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_fpga_image/](https://www.paws-r-sdk.com/docs/ec2_delete_fpga_image/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_fpga_image
ec2_delete_fpga_image <- function(DryRun = NULL, FpgaImageId) {
  op <- new_operation(
    name = "DeleteFpgaImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_fpga_image_input(DryRun = DryRun, FpgaImageId = FpgaImageId)
  output <- .ec2$delete_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_fpga_image <- ec2_delete_fpga_image

#' Deletes the specified EC2 Instance Connect Endpoint
#'
#' @description
#' Deletes the specified EC2 Instance Connect Endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_instance_connect_endpoint/](https://www.paws-r-sdk.com/docs/ec2_delete_instance_connect_endpoint/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceConnectEndpointId &#91;required&#93; The ID of the EC2 Instance Connect Endpoint to delete.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_instance_connect_endpoint
ec2_delete_instance_connect_endpoint <- function(DryRun = NULL, InstanceConnectEndpointId) {
  op <- new_operation(
    name = "DeleteInstanceConnectEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_instance_connect_endpoint_input(DryRun = DryRun, InstanceConnectEndpointId = InstanceConnectEndpointId)
  output <- .ec2$delete_instance_connect_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_instance_connect_endpoint <- ec2_delete_instance_connect_endpoint

#' Deletes the specified event window
#'
#' @description
#' Deletes the specified event window.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_instance_event_window/](https://www.paws-r-sdk.com/docs/ec2_delete_instance_event_window/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ForceDelete Specify `true` to force delete the event window. Use the force delete
#' parameter if the event window is currently associated with targets.
#' @param InstanceEventWindowId &#91;required&#93; The ID of the event window.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_instance_event_window
ec2_delete_instance_event_window <- function(DryRun = NULL, ForceDelete = NULL, InstanceEventWindowId) {
  op <- new_operation(
    name = "DeleteInstanceEventWindow",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_instance_event_window_input(DryRun = DryRun, ForceDelete = ForceDelete, InstanceEventWindowId = InstanceEventWindowId)
  output <- .ec2$delete_instance_event_window_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_instance_event_window <- ec2_delete_instance_event_window

#' Deletes the specified internet gateway
#'
#' @description
#' Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete it.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_internet_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_internet_gateway/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_internet_gateway
ec2_delete_internet_gateway <- function(DryRun = NULL, InternetGatewayId) {
  op <- new_operation(
    name = "DeleteInternetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId)
  output <- .ec2$delete_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_internet_gateway <- ec2_delete_internet_gateway

#' Delete an IPAM
#'
#' @description
#' Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical data for CIDRs.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_ipam/](https://www.paws-r-sdk.com/docs/ec2_delete_ipam/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamId &#91;required&#93; The ID of the IPAM to delete.
#' @param Cascade Enables you to quickly delete an IPAM, private scopes, pools in private
#' scopes, and any allocations in the pools in private scopes. You cannot
#' delete the IPAM with this option if there is a pool in your public
#' scope. If you use this option, IPAM does the following:
#' 
#' -   Deallocates any CIDRs allocated to VPC resources (such as VPCs) in
#'     pools in private scopes.
#' 
#'     No VPC resources are deleted as a result of enabling this option.
#'     The CIDR associated with the resource will no longer be allocated
#'     from an IPAM pool, but the CIDR itself will remain unchanged.
#' 
#' -   Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private
#'     scopes.
#' 
#' -   Deletes all IPAM pools in private scopes.
#' 
#' -   Deletes all non-default private scopes in the IPAM.
#' 
#' -   Deletes the default public and private scopes and the IPAM.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_ipam
ec2_delete_ipam <- function(DryRun = NULL, IpamId, Cascade = NULL) {
  op <- new_operation(
    name = "DeleteIpam",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_ipam_input(DryRun = DryRun, IpamId = IpamId, Cascade = Cascade)
  output <- .ec2$delete_ipam_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_ipam <- ec2_delete_ipam

#' Delete a verification token
#'
#' @description
#' Delete a verification token. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_ipam_external_resource_verification_token/](https://www.paws-r-sdk.com/docs/ec2_delete_ipam_external_resource_verification_token/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamExternalResourceVerificationTokenId &#91;required&#93; The token ID.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_ipam_external_resource_verification_token
ec2_delete_ipam_external_resource_verification_token <- function(DryRun = NULL, IpamExternalResourceVerificationTokenId) {
  op <- new_operation(
    name = "DeleteIpamExternalResourceVerificationToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_ipam_external_resource_verification_token_input(DryRun = DryRun, IpamExternalResourceVerificationTokenId = IpamExternalResourceVerificationTokenId)
  output <- .ec2$delete_ipam_external_resource_verification_token_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_ipam_external_resource_verification_token <- ec2_delete_ipam_external_resource_verification_token

#' Delete an IPAM pool
#'
#' @description
#' Delete an IPAM pool.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_ipam_pool/](https://www.paws-r-sdk.com/docs/ec2_delete_ipam_pool/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamPoolId &#91;required&#93; The ID of the pool to delete.
#' @param Cascade Enables you to quickly delete an IPAM pool and all resources within that
#' pool, including provisioned CIDRs, allocations, and other pools.
#' 
#' You can only use this option to delete pools in the private scope or
#' pools in the public scope with a source resource. A source resource is a
#' resource used to provision CIDRs to a resource planning pool.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_ipam_pool
ec2_delete_ipam_pool <- function(DryRun = NULL, IpamPoolId, Cascade = NULL) {
  op <- new_operation(
    name = "DeleteIpamPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_ipam_pool_input(DryRun = DryRun, IpamPoolId = IpamPoolId, Cascade = Cascade)
  output <- .ec2$delete_ipam_pool_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_ipam_pool <- ec2_delete_ipam_pool

#' Deletes an IPAM resource discovery
#'
#' @description
#' Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_ipam_resource_discovery/](https://www.paws-r-sdk.com/docs/ec2_delete_ipam_resource_discovery/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamResourceDiscoveryId &#91;required&#93; The IPAM resource discovery ID.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_ipam_resource_discovery
ec2_delete_ipam_resource_discovery <- function(DryRun = NULL, IpamResourceDiscoveryId) {
  op <- new_operation(
    name = "DeleteIpamResourceDiscovery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_ipam_resource_discovery_input(DryRun = DryRun, IpamResourceDiscoveryId = IpamResourceDiscoveryId)
  output <- .ec2$delete_ipam_resource_discovery_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_ipam_resource_discovery <- ec2_delete_ipam_resource_discovery

#' Delete the scope for an IPAM
#'
#' @description
#' Delete the scope for an IPAM. You cannot delete the default scopes.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_ipam_scope/](https://www.paws-r-sdk.com/docs/ec2_delete_ipam_scope/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamScopeId &#91;required&#93; The ID of the scope to delete.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_ipam_scope
ec2_delete_ipam_scope <- function(DryRun = NULL, IpamScopeId) {
  op <- new_operation(
    name = "DeleteIpamScope",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_ipam_scope_input(DryRun = DryRun, IpamScopeId = IpamScopeId)
  output <- .ec2$delete_ipam_scope_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_ipam_scope <- ec2_delete_ipam_scope

#' Deletes the specified key pair, by removing the public key from Amazon
#' EC2
#'
#' @description
#' Deletes the specified key pair, by removing the public key from Amazon EC2.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_key_pair/](https://www.paws-r-sdk.com/docs/ec2_delete_key_pair/) for full documentation.
#'
#' @param KeyName The name of the key pair.
#' @param KeyPairId The ID of the key pair.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_key_pair
ec2_delete_key_pair <- function(KeyName = NULL, KeyPairId = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteKeyPair",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_key_pair_input(KeyName = KeyName, KeyPairId = KeyPairId, DryRun = DryRun)
  output <- .ec2$delete_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_key_pair <- ec2_delete_key_pair

#' Deletes a launch template
#'
#' @description
#' Deletes a launch template. Deleting a launch template deletes all of its versions.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_launch_template/](https://www.paws-r-sdk.com/docs/ec2_delete_launch_template/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template.
#' 
#' You must specify either the launch template ID or the launch template
#' name, but not both.
#' @param LaunchTemplateName The name of the launch template.
#' 
#' You must specify either the launch template ID or the launch template
#' name, but not both.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_launch_template
ec2_delete_launch_template <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL) {
  op <- new_operation(
    name = "DeleteLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_launch_template_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName)
  output <- .ec2$delete_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_launch_template <- ec2_delete_launch_template

#' Deletes one or more versions of a launch template
#'
#' @description
#' Deletes one or more versions of a launch template.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_launch_template_versions/](https://www.paws-r-sdk.com/docs/ec2_delete_launch_template_versions/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template.
#' 
#' You must specify either the launch template ID or the launch template
#' name, but not both.
#' @param LaunchTemplateName The name of the launch template.
#' 
#' You must specify either the launch template ID or the launch template
#' name, but not both.
#' @param Versions &#91;required&#93; The version numbers of one or more launch template versions to delete.
#' You can specify up to 200 launch template version numbers.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_launch_template_versions
ec2_delete_launch_template_versions <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, Versions) {
  op <- new_operation(
    name = "DeleteLaunchTemplateVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_launch_template_versions_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, Versions = Versions)
  output <- .ec2$delete_launch_template_versions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_launch_template_versions <- ec2_delete_launch_template_versions

#' Deletes the specified route from the specified local gateway route table
#'
#' @description
#' Deletes the specified route from the specified local gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route/](https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route/) for full documentation.
#'
#' @param DestinationCidrBlock The CIDR range for the route. This must match the CIDR for the route
#' exactly.
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param DestinationPrefixListId Use a prefix list in place of `DestinationCidrBlock`. You cannot use
#' `DestinationPrefixListId` and `DestinationCidrBlock` in the same
#' request.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route
ec2_delete_local_gateway_route <- function(DestinationCidrBlock = NULL, LocalGatewayRouteTableId, DryRun = NULL, DestinationPrefixListId = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_local_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, LocalGatewayRouteTableId = LocalGatewayRouteTableId, DryRun = DryRun, DestinationPrefixListId = DestinationPrefixListId)
  output <- .ec2$delete_local_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route <- ec2_delete_local_gateway_route

#' Deletes a local gateway route table
#'
#' @description
#' Deletes a local gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route_table/](https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route_table/) for full documentation.
#'
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route_table
ec2_delete_local_gateway_route_table <- function(LocalGatewayRouteTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_local_gateway_route_table_input(LocalGatewayRouteTableId = LocalGatewayRouteTableId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route_table <- ec2_delete_local_gateway_route_table

#' Deletes a local gateway route table virtual interface group association
#'
#' @description
#' Deletes a local gateway route table virtual interface group association.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route_table_virtual_interface_group_association/](https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route_table_virtual_interface_group_association/) for full documentation.
#'
#' @param LocalGatewayRouteTableVirtualInterfaceGroupAssociationId &#91;required&#93; The ID of the local gateway route table virtual interface group
#' association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delet_local_gatew_route_table_virtu_inter_group_assoc
ec2_delete_local_gateway_route_table_virtual_interface_group_association <- function(LocalGatewayRouteTableVirtualInterfaceGroupAssociationId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_local_gateway_route_table_virtual_interface_group_association_input(LocalGatewayRouteTableVirtualInterfaceGroupAssociationId = LocalGatewayRouteTableVirtualInterfaceGroupAssociationId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_table_virtual_interface_group_association_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route_table_virtual_interface_group_association <- ec2_delete_local_gateway_route_table_virtual_interface_group_association

#' Deletes the specified association between a VPC and local gateway route
#' table
#'
#' @description
#' Deletes the specified association between a VPC and local gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route_table_vpc_association/](https://www.paws-r-sdk.com/docs/ec2_delete_local_gateway_route_table_vpc_association/) for full documentation.
#'
#' @param LocalGatewayRouteTableVpcAssociationId &#91;required&#93; The ID of the association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route_table_vpc_association
ec2_delete_local_gateway_route_table_vpc_association <- function(LocalGatewayRouteTableVpcAssociationId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRouteTableVpcAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_local_gateway_route_table_vpc_association_input(LocalGatewayRouteTableVpcAssociationId = LocalGatewayRouteTableVpcAssociationId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_table_vpc_association_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route_table_vpc_association <- ec2_delete_local_gateway_route_table_vpc_association

#' Deletes the specified managed prefix list
#'
#' @description
#' Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_managed_prefix_list/](https://www.paws-r-sdk.com/docs/ec2_delete_managed_prefix_list/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PrefixListId &#91;required&#93; The ID of the prefix list.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_managed_prefix_list
ec2_delete_managed_prefix_list <- function(DryRun = NULL, PrefixListId) {
  op <- new_operation(
    name = "DeleteManagedPrefixList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_managed_prefix_list_input(DryRun = DryRun, PrefixListId = PrefixListId)
  output <- .ec2$delete_managed_prefix_list_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_managed_prefix_list <- ec2_delete_managed_prefix_list

#' Deletes the specified NAT gateway
#'
#' @description
#' Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_nat_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_nat_gateway/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NatGatewayId &#91;required&#93; The ID of the NAT gateway.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_nat_gateway
ec2_delete_nat_gateway <- function(DryRun = NULL, NatGatewayId) {
  op <- new_operation(
    name = "DeleteNatGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_nat_gateway_input(DryRun = DryRun, NatGatewayId = NatGatewayId)
  output <- .ec2$delete_nat_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_nat_gateway <- ec2_delete_nat_gateway

#' Deletes the specified network ACL
#'
#' @description
#' Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete the default network ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_acl/](https://www.paws-r-sdk.com/docs/ec2_delete_network_acl/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_acl
ec2_delete_network_acl <- function(DryRun = NULL, NetworkAclId) {
  op <- new_operation(
    name = "DeleteNetworkAcl",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_acl_input(DryRun = DryRun, NetworkAclId = NetworkAclId)
  output <- .ec2$delete_network_acl_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_acl <- ec2_delete_network_acl

#' Deletes the specified ingress or egress entry (rule) from the specified
#' network ACL
#'
#' @description
#' Deletes the specified ingress or egress entry (rule) from the specified network ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_acl_entry/](https://www.paws-r-sdk.com/docs/ec2_delete_network_acl_entry/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#' @param RuleNumber &#91;required&#93; The rule number of the entry to delete.
#' @param Egress &#91;required&#93; Indicates whether the rule is an egress rule.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_acl_entry
ec2_delete_network_acl_entry <- function(DryRun = NULL, NetworkAclId, RuleNumber, Egress) {
  op <- new_operation(
    name = "DeleteNetworkAclEntry",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_acl_entry_input(DryRun = DryRun, NetworkAclId = NetworkAclId, RuleNumber = RuleNumber, Egress = Egress)
  output <- .ec2$delete_network_acl_entry_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_acl_entry <- ec2_delete_network_acl_entry

#' Deletes the specified Network Access Scope
#'
#' @description
#' Deletes the specified Network Access Scope.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_access_scope/](https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_access_scope/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInsightsAccessScopeId &#91;required&#93; The ID of the Network Access Scope.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_insights_access_scope
ec2_delete_network_insights_access_scope <- function(DryRun = NULL, NetworkInsightsAccessScopeId) {
  op <- new_operation(
    name = "DeleteNetworkInsightsAccessScope",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_insights_access_scope_input(DryRun = DryRun, NetworkInsightsAccessScopeId = NetworkInsightsAccessScopeId)
  output <- .ec2$delete_network_insights_access_scope_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_insights_access_scope <- ec2_delete_network_insights_access_scope

#' Deletes the specified Network Access Scope analysis
#'
#' @description
#' Deletes the specified Network Access Scope analysis.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_access_scope_analysis/](https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_access_scope_analysis/) for full documentation.
#'
#' @param NetworkInsightsAccessScopeAnalysisId &#91;required&#93; The ID of the Network Access Scope analysis.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_insights_access_scope_analysis
ec2_delete_network_insights_access_scope_analysis <- function(NetworkInsightsAccessScopeAnalysisId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteNetworkInsightsAccessScopeAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_insights_access_scope_analysis_input(NetworkInsightsAccessScopeAnalysisId = NetworkInsightsAccessScopeAnalysisId, DryRun = DryRun)
  output <- .ec2$delete_network_insights_access_scope_analysis_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_insights_access_scope_analysis <- ec2_delete_network_insights_access_scope_analysis

#' Deletes the specified network insights analysis
#'
#' @description
#' Deletes the specified network insights analysis.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_analysis/](https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_analysis/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInsightsAnalysisId &#91;required&#93; The ID of the network insights analysis.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_insights_analysis
ec2_delete_network_insights_analysis <- function(DryRun = NULL, NetworkInsightsAnalysisId) {
  op <- new_operation(
    name = "DeleteNetworkInsightsAnalysis",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_insights_analysis_input(DryRun = DryRun, NetworkInsightsAnalysisId = NetworkInsightsAnalysisId)
  output <- .ec2$delete_network_insights_analysis_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_insights_analysis <- ec2_delete_network_insights_analysis

#' Deletes the specified path
#'
#' @description
#' Deletes the specified path.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_path/](https://www.paws-r-sdk.com/docs/ec2_delete_network_insights_path/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInsightsPathId &#91;required&#93; The ID of the path.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_insights_path
ec2_delete_network_insights_path <- function(DryRun = NULL, NetworkInsightsPathId) {
  op <- new_operation(
    name = "DeleteNetworkInsightsPath",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_insights_path_input(DryRun = DryRun, NetworkInsightsPathId = NetworkInsightsPathId)
  output <- .ec2$delete_network_insights_path_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_insights_path <- ec2_delete_network_insights_path

#' Deletes the specified network interface
#'
#' @description
#' Deletes the specified network interface. You must detach the network interface before you can delete it.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_interface/](https://www.paws-r-sdk.com/docs/ec2_delete_network_interface/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_interface
ec2_delete_network_interface <- function(DryRun = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "DeleteNetworkInterface",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_interface_input(DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$delete_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_interface <- ec2_delete_network_interface

#' Deletes a permission for a network interface
#'
#' @description
#' Deletes a permission for a network interface. By default, you cannot delete the permission if the account for which you're removing the permission has attached the network interface to an instance. However, you can force delete the permission, regardless of any attachment.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_network_interface_permission/](https://www.paws-r-sdk.com/docs/ec2_delete_network_interface_permission/) for full documentation.
#'
#' @param NetworkInterfacePermissionId &#91;required&#93; The ID of the network interface permission.
#' @param Force Specify `true` to remove the permission even if the network interface is
#' attached to an instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_interface_permission
ec2_delete_network_interface_permission <- function(NetworkInterfacePermissionId, Force = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteNetworkInterfacePermission",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_network_interface_permission_input(NetworkInterfacePermissionId = NetworkInterfacePermissionId, Force = Force, DryRun = DryRun)
  output <- .ec2$delete_network_interface_permission_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_interface_permission <- ec2_delete_network_interface_permission

#' Deletes the specified placement group
#'
#' @description
#' Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information, see [Placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_placement_group/](https://www.paws-r-sdk.com/docs/ec2_delete_placement_group/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param GroupName &#91;required&#93; The name of the placement group.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_placement_group
ec2_delete_placement_group <- function(DryRun = NULL, GroupName) {
  op <- new_operation(
    name = "DeletePlacementGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_placement_group_input(DryRun = DryRun, GroupName = GroupName)
  output <- .ec2$delete_placement_group_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_placement_group <- ec2_delete_placement_group

#' Delete a public IPv4 pool
#'
#' @description
#' Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_public_ipv_4_pool/](https://www.paws-r-sdk.com/docs/ec2_delete_public_ipv_4_pool/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param PoolId &#91;required&#93; The ID of the public IPv4 pool you want to delete.
#' @param NetworkBorderGroup The Availability Zone (AZ) or Local Zone (LZ) network border group that
#' the resource that the IP address is assigned to is in. Defaults to an AZ
#' network border group. For more information on available Local Zones, see
#' [Local Zone
#' availability](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail)
#' in the *Amazon EC2 User Guide*.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_public_ipv_4_pool
ec2_delete_public_ipv_4_pool <- function(DryRun = NULL, PoolId, NetworkBorderGroup = NULL) {
  op <- new_operation(
    name = "DeletePublicIpv4Pool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_public_ipv_4_pool_input(DryRun = DryRun, PoolId = PoolId, NetworkBorderGroup = NetworkBorderGroup)
  output <- .ec2$delete_public_ipv_4_pool_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_public_ipv_4_pool <- ec2_delete_public_ipv_4_pool

#' Deletes the queued purchases for the specified Reserved Instances
#'
#' @description
#' Deletes the queued purchases for the specified Reserved Instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_queued_reserved_instances/](https://www.paws-r-sdk.com/docs/ec2_delete_queued_reserved_instances/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstancesIds &#91;required&#93; The IDs of the Reserved Instances.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_queued_reserved_instances
ec2_delete_queued_reserved_instances <- function(DryRun = NULL, ReservedInstancesIds) {
  op <- new_operation(
    name = "DeleteQueuedReservedInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_queued_reserved_instances_input(DryRun = DryRun, ReservedInstancesIds = ReservedInstancesIds)
  output <- .ec2$delete_queued_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_queued_reserved_instances <- ec2_delete_queued_reserved_instances

#' Deletes the specified route from the specified route table
#'
#' @description
#' Deletes the specified route from the specified route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_route/](https://www.paws-r-sdk.com/docs/ec2_delete_route/) for full documentation.
#'
#' @param DestinationPrefixListId The ID of the prefix list for the route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#' @param DestinationCidrBlock The IPv4 CIDR range for the route. The value you specify must match the
#' CIDR for the route exactly.
#' @param DestinationIpv6CidrBlock The IPv6 CIDR range for the route. The value you specify must match the
#' CIDR for the route exactly.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_route
ec2_delete_route <- function(DestinationPrefixListId = NULL, DryRun = NULL, RouteTableId, DestinationCidrBlock = NULL, DestinationIpv6CidrBlock = NULL) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_route_input(DestinationPrefixListId = DestinationPrefixListId, DryRun = DryRun, RouteTableId = RouteTableId, DestinationCidrBlock = DestinationCidrBlock, DestinationIpv6CidrBlock = DestinationIpv6CidrBlock)
  output <- .ec2$delete_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_route <- ec2_delete_route

#' Deletes the specified route table
#'
#' @description
#' Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can't delete the main route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_route_table/](https://www.paws-r-sdk.com/docs/ec2_delete_route_table/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_route_table
ec2_delete_route_table <- function(DryRun = NULL, RouteTableId) {
  op <- new_operation(
    name = "DeleteRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_route_table_input(DryRun = DryRun, RouteTableId = RouteTableId)
  output <- .ec2$delete_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_route_table <- ec2_delete_route_table

#' Deletes a security group
#'
#' @description
#' Deletes a security group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_security_group/](https://www.paws-r-sdk.com/docs/ec2_delete_security_group/) for full documentation.
#'
#' @param GroupId The ID of the security group.
#' @param GroupName \[Default VPC\] The name of the security group. You can specify either
#' the security group name or the security group ID. For security groups in
#' a nondefault VPC, you must specify the security group ID.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_security_group
ec2_delete_security_group <- function(GroupId = NULL, GroupName = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSecurityGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_security_group_input(GroupId = GroupId, GroupName = GroupName, DryRun = DryRun)
  output <- .ec2$delete_security_group_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_security_group <- ec2_delete_security_group

#' Deletes the specified snapshot
#'
#' @description
#' Deletes the specified snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_snapshot/](https://www.paws-r-sdk.com/docs/ec2_delete_snapshot/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The ID of the EBS snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_snapshot
ec2_delete_snapshot <- function(SnapshotId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_snapshot_input(SnapshotId = SnapshotId, DryRun = DryRun)
  output <- .ec2$delete_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_snapshot <- ec2_delete_snapshot

#' Deletes the data feed for Spot Instances
#'
#' @description
#' Deletes the data feed for Spot Instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_spot_datafeed_subscription/](https://www.paws-r-sdk.com/docs/ec2_delete_spot_datafeed_subscription/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_spot_datafeed_subscription
ec2_delete_spot_datafeed_subscription <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_spot_datafeed_subscription_input(DryRun = DryRun)
  output <- .ec2$delete_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_spot_datafeed_subscription <- ec2_delete_spot_datafeed_subscription

#' Deletes the specified subnet
#'
#' @description
#' Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_subnet/](https://www.paws-r-sdk.com/docs/ec2_delete_subnet/) for full documentation.
#'
#' @param SubnetId &#91;required&#93; The ID of the subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_subnet
ec2_delete_subnet <- function(SubnetId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSubnet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_subnet_input(SubnetId = SubnetId, DryRun = DryRun)
  output <- .ec2$delete_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_subnet <- ec2_delete_subnet

#' Deletes a subnet CIDR reservation
#'
#' @description
#' Deletes a subnet CIDR reservation.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_subnet_cidr_reservation/](https://www.paws-r-sdk.com/docs/ec2_delete_subnet_cidr_reservation/) for full documentation.
#'
#' @param SubnetCidrReservationId &#91;required&#93; The ID of the subnet CIDR reservation.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_subnet_cidr_reservation
ec2_delete_subnet_cidr_reservation <- function(SubnetCidrReservationId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSubnetCidrReservation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_subnet_cidr_reservation_input(SubnetCidrReservationId = SubnetCidrReservationId, DryRun = DryRun)
  output <- .ec2$delete_subnet_cidr_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_subnet_cidr_reservation <- ec2_delete_subnet_cidr_reservation

#' Deletes the specified set of tags from the specified set of resources
#'
#' @description
#' Deletes the specified set of tags from the specified set of resources.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_tags/](https://www.paws-r-sdk.com/docs/ec2_delete_tags/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources &#91;required&#93; The IDs of the resources, separated by spaces.
#' 
#' Constraints: Up to 1000 resource IDs. We recommend breaking up this
#' request into smaller batches.
#' @param Tags The tags to delete. Specify a tag key and an optional tag value to
#' delete specific tags. If you specify a tag key without a tag value, we
#' delete any tag with this key regardless of its value. If you specify a
#' tag key with an empty string as the tag value, we delete the tag only if
#' its value is an empty string.
#' 
#' If you omit this parameter, we delete all user-defined tags for the
#' specified resources. We do not delete Amazon Web Services-generated tags
#' (tags that have the `aws:` prefix).
#' 
#' Constraints: Up to 1000 tags.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_tags
ec2_delete_tags <- function(DryRun = NULL, Resources, Tags = NULL) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_tags_input(DryRun = DryRun, Resources = Resources, Tags = Tags)
  output <- .ec2$delete_tags_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_tags <- ec2_delete_tags

#' Deletes the specified Traffic Mirror filter
#'
#' @description
#' Deletes the specified Traffic Mirror filter.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_filter/](https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_filter/) for full documentation.
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_filter
ec2_delete_traffic_mirror_filter <- function(TrafficMirrorFilterId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorFilter",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_traffic_mirror_filter_input(TrafficMirrorFilterId = TrafficMirrorFilterId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_filter_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_filter <- ec2_delete_traffic_mirror_filter

#' Deletes the specified Traffic Mirror rule
#'
#' @description
#' Deletes the specified Traffic Mirror rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_filter_rule/](https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_filter_rule/) for full documentation.
#'
#' @param TrafficMirrorFilterRuleId &#91;required&#93; The ID of the Traffic Mirror rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_filter_rule
ec2_delete_traffic_mirror_filter_rule <- function(TrafficMirrorFilterRuleId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_traffic_mirror_filter_rule_input(TrafficMirrorFilterRuleId = TrafficMirrorFilterRuleId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_filter_rule <- ec2_delete_traffic_mirror_filter_rule

#' Deletes the specified Traffic Mirror session
#'
#' @description
#' Deletes the specified Traffic Mirror session.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_session/](https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_session/) for full documentation.
#'
#' @param TrafficMirrorSessionId &#91;required&#93; The ID of the Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_session
ec2_delete_traffic_mirror_session <- function(TrafficMirrorSessionId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_traffic_mirror_session_input(TrafficMirrorSessionId = TrafficMirrorSessionId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_session <- ec2_delete_traffic_mirror_session

#' Deletes the specified Traffic Mirror target
#'
#' @description
#' Deletes the specified Traffic Mirror target.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_target/](https://www.paws-r-sdk.com/docs/ec2_delete_traffic_mirror_target/) for full documentation.
#'
#' @param TrafficMirrorTargetId &#91;required&#93; The ID of the Traffic Mirror target.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_target
ec2_delete_traffic_mirror_target <- function(TrafficMirrorTargetId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorTarget",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_traffic_mirror_target_input(TrafficMirrorTargetId = TrafficMirrorTargetId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_target_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_target <- ec2_delete_traffic_mirror_target

#' Deletes the specified transit gateway
#'
#' @description
#' Deletes the specified transit gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway/) for full documentation.
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway
ec2_delete_transit_gateway <- function(TransitGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_input(TransitGatewayId = TransitGatewayId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway <- ec2_delete_transit_gateway

#' Deletes the specified Connect attachment
#'
#' @description
#' Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_connect/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_connect/) for full documentation.
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the Connect attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_connect
ec2_delete_transit_gateway_connect <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayConnect",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_connect_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_connect_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_connect <- ec2_delete_transit_gateway_connect

#' Deletes the specified Connect peer
#'
#' @description
#' Deletes the specified Connect peer.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_connect_peer/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_connect_peer/) for full documentation.
#'
#' @param TransitGatewayConnectPeerId &#91;required&#93; The ID of the Connect peer.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_connect_peer
ec2_delete_transit_gateway_connect_peer <- function(TransitGatewayConnectPeerId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayConnectPeer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_connect_peer_input(TransitGatewayConnectPeerId = TransitGatewayConnectPeerId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_connect_peer_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_connect_peer <- ec2_delete_transit_gateway_connect_peer

#' Deletes the specified transit gateway multicast domain
#'
#' @description
#' Deletes the specified transit gateway multicast domain.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_multicast_domain/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_multicast_domain/) for full documentation.
#'
#' @param TransitGatewayMulticastDomainId &#91;required&#93; The ID of the transit gateway multicast domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_multicast_domain
ec2_delete_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_multicast_domain <- ec2_delete_transit_gateway_multicast_domain

#' Deletes a transit gateway peering attachment
#'
#' @description
#' Deletes a transit gateway peering attachment.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_peering_attachment/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_peering_attachment/) for full documentation.
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway peering attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_peering_attachment
ec2_delete_transit_gateway_peering_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_peering_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_peering_attachment <- ec2_delete_transit_gateway_peering_attachment

#' Deletes the specified transit gateway policy table
#'
#' @description
#' Deletes the specified transit gateway policy table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_policy_table/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_policy_table/) for full documentation.
#'
#' @param TransitGatewayPolicyTableId &#91;required&#93; The transit gateway policy table to delete.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_policy_table
ec2_delete_transit_gateway_policy_table <- function(TransitGatewayPolicyTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayPolicyTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_policy_table_input(TransitGatewayPolicyTableId = TransitGatewayPolicyTableId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_policy_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_policy_table <- ec2_delete_transit_gateway_policy_table

#' Deletes a reference (route) to a prefix list in a specified transit
#' gateway route table
#'
#' @description
#' Deletes a reference (route) to a prefix list in a specified transit gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_prefix_list_reference/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_prefix_list_reference/) for full documentation.
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the route table.
#' @param PrefixListId &#91;required&#93; The ID of the prefix list.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_prefix_list_reference
ec2_delete_transit_gateway_prefix_list_reference <- function(TransitGatewayRouteTableId, PrefixListId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayPrefixListReference",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_prefix_list_reference_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, PrefixListId = PrefixListId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_prefix_list_reference_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_prefix_list_reference <- ec2_delete_transit_gateway_prefix_list_reference

#' Deletes the specified route from the specified transit gateway route
#' table
#'
#' @description
#' Deletes the specified route from the specified transit gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_route/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_route/) for full documentation.
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range for the route. This must match the CIDR for the route
#' exactly.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route
ec2_delete_transit_gateway_route <- function(TransitGatewayRouteTableId, DestinationCidrBlock, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_route_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, DestinationCidrBlock = DestinationCidrBlock, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route <- ec2_delete_transit_gateway_route

#' Deletes the specified transit gateway route table
#'
#' @description
#' Deletes the specified transit gateway route table. If there are any route tables associated with the transit gateway route table, you must first run [`disassociate_route_table`][ec2_disassociate_route_table] before you can delete the transit gateway route table. This removes any route tables associated with the transit gateway route table.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_route_table/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_route_table/) for full documentation.
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route_table
ec2_delete_transit_gateway_route_table <- function(TransitGatewayRouteTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route_table <- ec2_delete_transit_gateway_route_table

#' Advertises to the transit gateway that a transit gateway route table is
#' deleted
#'
#' @description
#' Advertises to the transit gateway that a transit gateway route table is deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_route_table_announcement/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_route_table_announcement/) for full documentation.
#'
#' @param TransitGatewayRouteTableAnnouncementId &#91;required&#93; The transit gateway route table ID that's being deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route_table_announcement
ec2_delete_transit_gateway_route_table_announcement <- function(TransitGatewayRouteTableAnnouncementId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRouteTableAnnouncement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_route_table_announcement_input(TransitGatewayRouteTableAnnouncementId = TransitGatewayRouteTableAnnouncementId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_table_announcement_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route_table_announcement <- ec2_delete_transit_gateway_route_table_announcement

#' Deletes the specified VPC attachment
#'
#' @description
#' Deletes the specified VPC attachment.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_vpc_attachment/](https://www.paws-r-sdk.com/docs/ec2_delete_transit_gateway_vpc_attachment/) for full documentation.
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_vpc_attachment
ec2_delete_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_vpc_attachment <- ec2_delete_transit_gateway_vpc_attachment

#' Delete an Amazon Web Services Verified Access endpoint
#'
#' @description
#' Delete an Amazon Web Services Verified Access endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_endpoint/](https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_endpoint/) for full documentation.
#'
#' @param VerifiedAccessEndpointId &#91;required&#93; The ID of the Verified Access endpoint.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_verified_access_endpoint
ec2_delete_verified_access_endpoint <- function(VerifiedAccessEndpointId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVerifiedAccessEndpoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_verified_access_endpoint_input(VerifiedAccessEndpointId = VerifiedAccessEndpointId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$delete_verified_access_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_verified_access_endpoint <- ec2_delete_verified_access_endpoint

#' Delete an Amazon Web Services Verified Access group
#'
#' @description
#' Delete an Amazon Web Services Verified Access group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_group/](https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_group/) for full documentation.
#'
#' @param VerifiedAccessGroupId &#91;required&#93; The ID of the Verified Access group.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_verified_access_group
ec2_delete_verified_access_group <- function(VerifiedAccessGroupId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVerifiedAccessGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_verified_access_group_input(VerifiedAccessGroupId = VerifiedAccessGroupId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$delete_verified_access_group_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_verified_access_group <- ec2_delete_verified_access_group

#' Delete an Amazon Web Services Verified Access instance
#'
#' @description
#' Delete an Amazon Web Services Verified Access instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_instance/](https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_instance/) for full documentation.
#'
#' @param VerifiedAccessInstanceId &#91;required&#93; The ID of the Verified Access instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_delete_verified_access_instance
ec2_delete_verified_access_instance <- function(VerifiedAccessInstanceId, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "DeleteVerifiedAccessInstance",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_verified_access_instance_input(VerifiedAccessInstanceId = VerifiedAccessInstanceId, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$delete_verified_access_instance_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_verified_access_instance <- ec2_delete_verified_access_instance

#' Delete an Amazon Web Services Verified Access trust provider
#'
#' @description
#' Delete an Amazon Web Services Verified Access trust provider.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_trust_provider/](https://www.paws-r-sdk.com/docs/ec2_delete_verified_access_trust_provider/) for full documentation.
#'
#' @param VerifiedAccessTrustProviderId &#91;required&#93; The ID of the Verified Access trust provider.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#'
#' @keywords internal
#'
#' @rdname ec2_delete_verified_access_trust_provider
ec2_delete_verified_access_trust_provider <- function(VerifiedAccessTrustProviderId, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "DeleteVerifiedAccessTrustProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_verified_access_trust_provider_input(VerifiedAccessTrustProviderId = VerifiedAccessTrustProviderId, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$delete_verified_access_trust_provider_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_verified_access_trust_provider <- ec2_delete_verified_access_trust_provider

#' Deletes the specified EBS volume
#'
#' @description
#' Deletes the specified EBS volume. The volume must be in the `available` state (not attached to an instance).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_volume/](https://www.paws-r-sdk.com/docs/ec2_delete_volume/) for full documentation.
#'
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_volume
ec2_delete_volume <- function(VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_volume_input(VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$delete_volume_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_volume <- ec2_delete_volume

#' Deletes the specified VPC
#'
#' @description
#' Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on. When you delete the VPC, it deletes the default security group, network ACL, and route table for the VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpc/](https://www.paws-r-sdk.com/docs/ec2_delete_vpc/) for full documentation.
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc
ec2_delete_vpc <- function(VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpc_input(VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$delete_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc <- ec2_delete_vpc

#' Delete a VPC Block Public Access (BPA) exclusion
#'
#' @description
#' Delete a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see [Block public access to VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpc_block_public_access_exclusion/](https://www.paws-r-sdk.com/docs/ec2_delete_vpc_block_public_access_exclusion/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ExclusionId &#91;required&#93; The ID of the exclusion.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_block_public_access_exclusion
ec2_delete_vpc_block_public_access_exclusion <- function(DryRun = NULL, ExclusionId) {
  op <- new_operation(
    name = "DeleteVpcBlockPublicAccessExclusion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpc_block_public_access_exclusion_input(DryRun = DryRun, ExclusionId = ExclusionId)
  output <- .ec2$delete_vpc_block_public_access_exclusion_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_block_public_access_exclusion <- ec2_delete_vpc_block_public_access_exclusion

#' Deletes the specified VPC endpoint connection notifications
#'
#' @description
#' Deletes the specified VPC endpoint connection notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpc_endpoint_connection_notifications/](https://www.paws-r-sdk.com/docs/ec2_delete_vpc_endpoint_connection_notifications/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConnectionNotificationIds &#91;required&#93; The IDs of the notifications.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoint_connection_notifications
ec2_delete_vpc_endpoint_connection_notifications <- function(DryRun = NULL, ConnectionNotificationIds) {
  op <- new_operation(
    name = "DeleteVpcEndpointConnectionNotifications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpc_endpoint_connection_notifications_input(DryRun = DryRun, ConnectionNotificationIds = ConnectionNotificationIds)
  output <- .ec2$delete_vpc_endpoint_connection_notifications_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoint_connection_notifications <- ec2_delete_vpc_endpoint_connection_notifications

#' Deletes the specified VPC endpoint service configurations
#'
#' @description
#' Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service configuration, you must reject any `Available` or `PendingAcceptance` interface endpoint connections that are attached to the service.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpc_endpoint_service_configurations/](https://www.paws-r-sdk.com/docs/ec2_delete_vpc_endpoint_service_configurations/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceIds &#91;required&#93; The IDs of the services.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoint_service_configurations
ec2_delete_vpc_endpoint_service_configurations <- function(DryRun = NULL, ServiceIds) {
  op <- new_operation(
    name = "DeleteVpcEndpointServiceConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpc_endpoint_service_configurations_input(DryRun = DryRun, ServiceIds = ServiceIds)
  output <- .ec2$delete_vpc_endpoint_service_configurations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoint_service_configurations <- ec2_delete_vpc_endpoint_service_configurations

#' Deletes the specified VPC endpoints
#'
#' @description
#' Deletes the specified VPC endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpc_endpoints/](https://www.paws-r-sdk.com/docs/ec2_delete_vpc_endpoints/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointIds &#91;required&#93; The IDs of the VPC endpoints.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoints
ec2_delete_vpc_endpoints <- function(DryRun = NULL, VpcEndpointIds) {
  op <- new_operation(
    name = "DeleteVpcEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpc_endpoints_input(DryRun = DryRun, VpcEndpointIds = VpcEndpointIds)
  output <- .ec2$delete_vpc_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoints <- ec2_delete_vpc_endpoints

#' Deletes a VPC peering connection
#'
#' @description
#' Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can delete the VPC peering connection if it's in the `active` state. The owner of the requester VPC can delete a VPC peering connection in the `pending-acceptance` state. You cannot delete a VPC peering connection that's in the `failed` or `rejected` state.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpc_peering_connection/](https://www.paws-r-sdk.com/docs/ec2_delete_vpc_peering_connection/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionId &#91;required&#93; The ID of the VPC peering connection.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_peering_connection
ec2_delete_vpc_peering_connection <- function(DryRun = NULL, VpcPeeringConnectionId) {
  op <- new_operation(
    name = "DeleteVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpc_peering_connection_input(DryRun = DryRun, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$delete_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_peering_connection <- ec2_delete_vpc_peering_connection

#' Deletes the specified VPN connection
#'
#' @description
#' Deletes the specified VPN connection.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpn_connection/](https://www.paws-r-sdk.com/docs/ec2_delete_vpn_connection/) for full documentation.
#'
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_connection
ec2_delete_vpn_connection <- function(VpnConnectionId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpnConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpn_connection_input(VpnConnectionId = VpnConnectionId, DryRun = DryRun)
  output <- .ec2$delete_vpn_connection_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_connection <- ec2_delete_vpn_connection

#' Deletes the specified static route associated with a VPN connection
#' between an existing virtual private gateway and a VPN customer gateway
#'
#' @description
#' Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpn_connection_route/](https://www.paws-r-sdk.com/docs/ec2_delete_vpn_connection_route/) for full documentation.
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR block associated with the local subnet of the customer network.
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_connection_route
ec2_delete_vpn_connection_route <- function(DestinationCidrBlock, VpnConnectionId) {
  op <- new_operation(
    name = "DeleteVpnConnectionRoute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpn_connection_route_input(DestinationCidrBlock = DestinationCidrBlock, VpnConnectionId = VpnConnectionId)
  output <- .ec2$delete_vpn_connection_route_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_connection_route <- ec2_delete_vpn_connection_route

#' Deletes the specified virtual private gateway
#'
#' @description
#' Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC. Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN connection between your VPC and your network.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_delete_vpn_gateway/](https://www.paws-r-sdk.com/docs/ec2_delete_vpn_gateway/) for full documentation.
#'
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_gateway
ec2_delete_vpn_gateway <- function(VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpnGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$delete_vpn_gateway_input(VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$delete_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_gateway <- ec2_delete_vpn_gateway

#' Releases the specified address range that you provisioned for use with
#' your Amazon Web Services resources through bring your own IP addresses
#' (BYOIP) and deletes the corresponding address pool
#'
#' @description
#' Releases the specified address range that you provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deprovision_byoip_cidr/](https://www.paws-r-sdk.com/docs/ec2_deprovision_byoip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation. The prefix must be the same prefix
#' that you specified when you provisioned the address range.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_deprovision_byoip_cidr
ec2_deprovision_byoip_cidr <- function(Cidr, DryRun = NULL) {
  op <- new_operation(
    name = "DeprovisionByoipCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deprovision_byoip_cidr_input(Cidr = Cidr, DryRun = DryRun)
  output <- .ec2$deprovision_byoip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deprovision_byoip_cidr <- ec2_deprovision_byoip_cidr

#' Deprovisions your Autonomous System Number (ASN) from your Amazon Web
#' Services account
#'
#' @description
#' Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be called after any BYOIP CIDR associations are removed from your Amazon Web Services account with [`disassociate_ipam_byoasn`][ec2_disassociate_ipam_byoasn]. For more information, see [Tutorial: Bring your ASN to IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html) in the *Amazon VPC IPAM guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deprovision_ipam_byoasn/](https://www.paws-r-sdk.com/docs/ec2_deprovision_ipam_byoasn/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param IpamId &#91;required&#93; The IPAM ID.
#' @param Asn &#91;required&#93; An ASN.
#'
#' @keywords internal
#'
#' @rdname ec2_deprovision_ipam_byoasn
ec2_deprovision_ipam_byoasn <- function(DryRun = NULL, IpamId, Asn) {
  op <- new_operation(
    name = "DeprovisionIpamByoasn",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deprovision_ipam_byoasn_input(DryRun = DryRun, IpamId = IpamId, Asn = Asn)
  output <- .ec2$deprovision_ipam_byoasn_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deprovision_ipam_byoasn <- ec2_deprovision_ipam_byoasn

#' Deprovision a CIDR provisioned from an IPAM pool
#'
#' @description
#' Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool, the CIDR is recycled back into the source pool. For more information, see [Deprovision pool CIDRs](https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html) in the *Amazon VPC IPAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deprovision_ipam_pool_cidr/](https://www.paws-r-sdk.com/docs/ec2_deprovision_ipam_pool_cidr/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamPoolId &#91;required&#93; The ID of the pool that has the CIDR you want to deprovision.
#' @param Cidr The CIDR which you want to deprovision from the pool.
#'
#' @keywords internal
#'
#' @rdname ec2_deprovision_ipam_pool_cidr
ec2_deprovision_ipam_pool_cidr <- function(DryRun = NULL, IpamPoolId, Cidr = NULL) {
  op <- new_operation(
    name = "DeprovisionIpamPoolCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deprovision_ipam_pool_cidr_input(DryRun = DryRun, IpamPoolId = IpamPoolId, Cidr = Cidr)
  output <- .ec2$deprovision_ipam_pool_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deprovision_ipam_pool_cidr <- ec2_deprovision_ipam_pool_cidr

#' Deprovision a CIDR from a public IPv4 pool
#'
#' @description
#' Deprovision a CIDR from a public IPv4 pool.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deprovision_public_ipv_4_pool_cidr/](https://www.paws-r-sdk.com/docs/ec2_deprovision_public_ipv_4_pool_cidr/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param PoolId &#91;required&#93; The ID of the pool that you want to deprovision the CIDR from.
#' @param Cidr &#91;required&#93; The CIDR you want to deprovision from the pool. Enter the CIDR you want
#' to deprovision with a netmask of `/32`. You must rerun this command for
#' each IP address in the CIDR range. If your CIDR is a `/24`, you will
#' have to run this command to deprovision each of the 256 IP addresses in
#' the `/24` CIDR.
#'
#' @keywords internal
#'
#' @rdname ec2_deprovision_public_ipv_4_pool_cidr
ec2_deprovision_public_ipv_4_pool_cidr <- function(DryRun = NULL, PoolId, Cidr) {
  op <- new_operation(
    name = "DeprovisionPublicIpv4PoolCidr",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deprovision_public_ipv_4_pool_cidr_input(DryRun = DryRun, PoolId = PoolId, Cidr = Cidr)
  output <- .ec2$deprovision_public_ipv_4_pool_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deprovision_public_ipv_4_pool_cidr <- ec2_deprovision_public_ipv_4_pool_cidr

#' Deregisters the specified AMI
#'
#' @description
#' Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deregister_image/](https://www.paws-r-sdk.com/docs/ec2_deregister_image/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_image
ec2_deregister_image <- function(ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deregister_image_input(ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$deregister_image_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_image <- ec2_deregister_image

#' Deregisters tag keys to prevent tags that have the specified tag keys
#' from being included in scheduled event notifications for resources in
#' the Region
#'
#' @description
#' Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event notifications for resources in the Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deregister_instance_event_notification_attributes/](https://www.paws-r-sdk.com/docs/ec2_deregister_instance_event_notification_attributes/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTagAttribute &#91;required&#93; Information about the tag keys to deregister.
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_instance_event_notification_attributes
ec2_deregister_instance_event_notification_attributes <- function(DryRun = NULL, InstanceTagAttribute) {
  op <- new_operation(
    name = "DeregisterInstanceEventNotificationAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deregister_instance_event_notification_attributes_input(DryRun = DryRun, InstanceTagAttribute = InstanceTagAttribute)
  output <- .ec2$deregister_instance_event_notification_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_instance_event_notification_attributes <- ec2_deregister_instance_event_notification_attributes

#' Deregisters the specified members (network interfaces) from the transit
#' gateway multicast group
#'
#' @description
#' Deregisters the specified members (network interfaces) from the transit gateway multicast group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deregister_transit_gateway_multicast_group_members/](https://www.paws-r-sdk.com/docs/ec2_deregister_transit_gateway_multicast_group_members/) for full documentation.
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param GroupIpAddress The IP address assigned to the transit gateway multicast group.
#' @param NetworkInterfaceIds The IDs of the group members' network interfaces.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_transit_gateway_multicast_group_members
ec2_deregister_transit_gateway_multicast_group_members <- function(TransitGatewayMulticastDomainId = NULL, GroupIpAddress = NULL, NetworkInterfaceIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterTransitGatewayMulticastGroupMembers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deregister_transit_gateway_multicast_group_members_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, GroupIpAddress = GroupIpAddress, NetworkInterfaceIds = NetworkInterfaceIds, DryRun = DryRun)
  output <- .ec2$deregister_transit_gateway_multicast_group_members_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_transit_gateway_multicast_group_members <- ec2_deregister_transit_gateway_multicast_group_members

#' Deregisters the specified sources (network interfaces) from the transit
#' gateway multicast group
#'
#' @description
#' Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_deregister_transit_gateway_multicast_group_sources/](https://www.paws-r-sdk.com/docs/ec2_deregister_transit_gateway_multicast_group_sources/) for full documentation.
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param GroupIpAddress The IP address assigned to the transit gateway multicast group.
#' @param NetworkInterfaceIds The IDs of the group sources' network interfaces.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_transit_gateway_multicast_group_sources
ec2_deregister_transit_gateway_multicast_group_sources <- function(TransitGatewayMulticastDomainId = NULL, GroupIpAddress = NULL, NetworkInterfaceIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterTransitGatewayMulticastGroupSources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$deregister_transit_gateway_multicast_group_sources_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, GroupIpAddress = GroupIpAddress, NetworkInterfaceIds = NetworkInterfaceIds, DryRun = DryRun)
  output <- .ec2$deregister_transit_gateway_multicast_group_sources_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_transit_gateway_multicast_group_sources <- ec2_deregister_transit_gateway_multicast_group_sources

#' Describes attributes of your Amazon Web Services account
#'
#' @description
#' Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_account_attributes/](https://www.paws-r-sdk.com/docs/ec2_describe_account_attributes/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AttributeNames The account attribute names.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_account_attributes
ec2_describe_account_attributes <- function(DryRun = NULL, AttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_account_attributes_input(DryRun = DryRun, AttributeNames = AttributeNames)
  output <- .ec2$describe_account_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_account_attributes <- ec2_describe_account_attributes

#' Describes an Elastic IP address transfer
#'
#' @description
#' Describes an Elastic IP address transfer. For more information, see [Transfer Elastic IP addresses](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_address_transfers/](https://www.paws-r-sdk.com/docs/ec2_describe_address_transfers/) for full documentation.
#'
#' @param AllocationIds The allocation IDs of Elastic IP addresses.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param MaxResults The maximum number of address transfers to return in one page of
#' results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_address_transfers
ec2_describe_address_transfers <- function(AllocationIds = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAddressTransfers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AddressTransfers"),
    stream_api = FALSE
  )
  input <- .ec2$describe_address_transfers_input(AllocationIds = AllocationIds, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_address_transfers_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_address_transfers <- ec2_describe_address_transfers

#' Describes the specified Elastic IP addresses or all of your Elastic IP
#' addresses
#'
#' @description
#' Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_addresses/](https://www.paws-r-sdk.com/docs/ec2_describe_addresses/) for full documentation.
#'
#' @param PublicIps One or more Elastic IP addresses.
#' 
#' Default: Describes all your Elastic IP addresses.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `allocation-id` - The allocation ID for the address.
#' 
#' -   `association-id` - The association ID for the address.
#' 
#' -   `instance-id` - The ID of the instance the address is associated
#'     with, if any.
#' 
#' -   `network-border-group` - A unique set of Availability Zones, Local
#'     Zones, or Wavelength Zones from where Amazon Web Services advertises
#'     IP addresses.
#' 
#' -   `network-interface-id` - The ID of the network interface that the
#'     address is associated with, if any.
#' 
#' -   `network-interface-owner-id` - The Amazon Web Services account ID of
#'     the owner.
#' 
#' -   `private-ip-address` - The private IP address associated with the
#'     Elastic IP address.
#' 
#' -   `public-ip` - The Elastic IP address, or the carrier IP address.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param AllocationIds Information about the allocation IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_addresses
ec2_describe_addresses <- function(PublicIps = NULL, DryRun = NULL, Filters = NULL, AllocationIds = NULL) {
  op <- new_operation(
    name = "DescribeAddresses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_addresses_input(PublicIps = PublicIps, DryRun = DryRun, Filters = Filters, AllocationIds = AllocationIds)
  output <- .ec2$describe_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_addresses <- ec2_describe_addresses

#' Describes the attributes of the specified Elastic IP addresses
#'
#' @description
#' Describes the attributes of the specified Elastic IP addresses. For requirements, see [Using reverse DNS for email applications](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_addresses_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_addresses_attribute/) for full documentation.
#'
#' @param AllocationIds \[EC2-VPC\] The allocation IDs.
#' @param Attribute The attribute of the IP address.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_addresses_attribute
ec2_describe_addresses_attribute <- function(AllocationIds = NULL, Attribute = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAddressesAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Addresses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_addresses_attribute_input(AllocationIds = AllocationIds, Attribute = Attribute, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_addresses_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_addresses_attribute <- ec2_describe_addresses_attribute

#' Describes the longer ID format settings for all resource types in a
#' specific Region
#'
#' @description
#' Describes the longer ID format settings for all resource types in a specific Region. This request is useful for performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character IDs).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_aggregate_id_format/](https://www.paws-r-sdk.com/docs/ec2_describe_aggregate_id_format/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_aggregate_id_format
ec2_describe_aggregate_id_format <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAggregateIdFormat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_aggregate_id_format_input(DryRun = DryRun)
  output <- .ec2$describe_aggregate_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_aggregate_id_format <- ec2_describe_aggregate_id_format

#' Describes the Availability Zones, Local Zones, and Wavelength Zones that
#' are available to you
#'
#' @description
#' Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an event impacting a zone, you can use this request to view the state and any provided messages for that zone.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_availability_zones/](https://www.paws-r-sdk.com/docs/ec2_describe_availability_zones/) for full documentation.
#'
#' @param ZoneNames The names of the Availability Zones, Local Zones, and Wavelength Zones.
#' @param ZoneIds The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
#' @param AllAvailabilityZones Include all Availability Zones, Local Zones, and Wavelength Zones
#' regardless of your opt-in status.
#' 
#' If you do not use this parameter, the results include only the zones for
#' the Regions where you have chosen the option to opt in.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `group-name` - For Availability Zones, use the Region name. For
#'     Local Zones, use the name of the group associated with the Local
#'     Zone (for example, `us-west-2-lax-1`) For Wavelength Zones, use the
#'     name of the group associated with the Wavelength Zone (for example,
#'     `us-east-1-wl1`).
#' 
#' -   `message` - The Zone message.
#' 
#' -   `opt-in-status` - The opt-in status (`opted-in` | `not-opted-in` |
#'     `opt-in-not-required`).
#' 
#' -   `parent-zone-id` - The ID of the zone that handles some of the Local
#'     Zone and Wavelength Zone control plane operations, such as API
#'     calls.
#' 
#' -   `parent-zone-name` - The ID of the zone that handles some of the
#'     Local Zone and Wavelength Zone control plane operations, such as API
#'     calls.
#' 
#' -   `region-name` - The name of the Region for the Zone (for example,
#'     `us-east-1`).
#' 
#' -   `state` - The state of the Availability Zone, the Local Zone, or the
#'     Wavelength Zone (`available`).
#' 
#' -   `zone-id` - The ID of the Availability Zone (for example,
#'     `use1-az1`), the Local Zone (for example, `usw2-lax1-az1`), or the
#'     Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
#' 
#' -   `zone-name` - The name of the Availability Zone (for example,
#'     `us-east-1a`), the Local Zone (for example, `us-west-2-lax-1a`), or
#'     the Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
#' 
#' -   `zone-type` - The type of zone (`availability-zone` | `local-zone` |
#'     `wavelength-zone`).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_availability_zones
ec2_describe_availability_zones <- function(ZoneNames = NULL, ZoneIds = NULL, AllAvailabilityZones = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeAvailabilityZones",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_availability_zones_input(ZoneNames = ZoneNames, ZoneIds = ZoneIds, AllAvailabilityZones = AllAvailabilityZones, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_availability_zones_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_availability_zones <- ec2_describe_availability_zones

#' Describes the current Infrastructure Performance metric subscriptions
#'
#' @description
#' Describes the current Infrastructure Performance metric subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_aws_network_performance_metric_subscriptions/](https://www.paws-r-sdk.com/docs/ec2_describe_aws_network_performance_metric_subscriptions/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_aws_network_performance_metric_subscriptions
ec2_describe_aws_network_performance_metric_subscriptions <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAwsNetworkPerformanceMetricSubscriptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Subscriptions"),
    stream_api = FALSE
  )
  input <- .ec2$describe_aws_network_performance_metric_subscriptions_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_aws_network_performance_metric_subscriptions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_aws_network_performance_metric_subscriptions <- ec2_describe_aws_network_performance_metric_subscriptions

#' Describes the specified bundle tasks or all of your bundle tasks
#'
#' @description
#' Describes the specified bundle tasks or all of your bundle tasks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_bundle_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_bundle_tasks/) for full documentation.
#'
#' @param BundleIds The bundle task IDs.
#' 
#' Default: Describes all your bundle tasks.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `bundle-id` - The ID of the bundle task.
#' 
#' -   `error-code` - If the task failed, the error code returned.
#' 
#' -   `error-message` - If the task failed, the error message returned.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `progress` - The level of task completion, as a percentage (for
#'     example, 20%).
#' 
#' -   `s3-bucket` - The Amazon S3 bucket to store the AMI.
#' 
#' -   `s3-prefix` - The beginning of the AMI name.
#' 
#' -   `start-time` - The time the task started (for example,
#'     2013-09-15T17:15:20.000Z).
#' 
#' -   `state` - The state of the task (`pending` | `waiting-for-shutdown`
#'     | `bundling` | `storing` | `cancelling` | `complete` | `failed`).
#' 
#' -   `update-time` - The time of the most recent update for the task.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_bundle_tasks
ec2_describe_bundle_tasks <- function(BundleIds = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeBundleTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_bundle_tasks_input(BundleIds = BundleIds, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_bundle_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_bundle_tasks <- ec2_describe_bundle_tasks

#' Describes the IP address ranges that were specified in calls to
#' ProvisionByoipCidr
#'
#' @description
#' Describes the IP address ranges that were specified in calls to [`provision_byoip_cidr`][ec2_provision_byoip_cidr].
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_byoip_cidrs/](https://www.paws-r-sdk.com/docs/ec2_describe_byoip_cidrs/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults &#91;required&#93; The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_byoip_cidrs
ec2_describe_byoip_cidrs <- function(DryRun = NULL, MaxResults, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeByoipCidrs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ByoipCidrs"),
    stream_api = FALSE
  )
  input <- .ec2$describe_byoip_cidrs_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_byoip_cidrs_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_byoip_cidrs <- ec2_describe_byoip_cidrs

#' Describes the events for the specified Capacity Block extension during
#' the specified time
#'
#' @description
#' Describes the events for the specified Capacity Block extension during the specified time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_extension_history/](https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_extension_history/) for full documentation.
#'
#' @param CapacityReservationIds The IDs of Capacity Block reservations that you want to display the
#' history for.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param Filters One or more filters
#' 
#' -   `availability-zone` - The Availability Zone of the extension.
#' 
#' -   `availability-zone-id` - The Availability Zone ID of the extension.
#' 
#' -   `capacity-block-extension-offering-id` - The ID of the extension
#'     offering.
#' 
#' -   `capacity-block-extension-status` - The status of the extension
#'     (`payment-pending` | `payment-failed` | `payment-succeeded`).
#' 
#' -   `capacity-reservation-id` - The reservation ID of the extension.
#' 
#' -   `instance-type` - The instance type of the extension.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_block_extension_history
ec2_describe_capacity_block_extension_history <- function(CapacityReservationIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCapacityBlockExtensionHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CapacityBlockExtensions"),
    stream_api = FALSE
  )
  input <- .ec2$describe_capacity_block_extension_history_input(CapacityReservationIds = CapacityReservationIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_capacity_block_extension_history_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_block_extension_history <- ec2_describe_capacity_block_extension_history

#' Describes Capacity Block extension offerings available for purchase in
#' the Amazon Web Services Region that you're currently using
#'
#' @description
#' Describes Capacity Block extension offerings available for purchase in the Amazon Web Services Region that you're currently using.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_extension_offerings/](https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_extension_offerings/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CapacityBlockExtensionDurationHours &#91;required&#93; The duration of the Capacity Block extension offering in hours.
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity reservation to be extended.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_block_extension_offerings
ec2_describe_capacity_block_extension_offerings <- function(DryRun = NULL, CapacityBlockExtensionDurationHours, CapacityReservationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeCapacityBlockExtensionOfferings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CapacityBlockExtensionOfferings"),
    stream_api = FALSE
  )
  input <- .ec2$describe_capacity_block_extension_offerings_input(DryRun = DryRun, CapacityBlockExtensionDurationHours = CapacityBlockExtensionDurationHours, CapacityReservationId = CapacityReservationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_capacity_block_extension_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_block_extension_offerings <- ec2_describe_capacity_block_extension_offerings

#' Describes Capacity Block offerings available for purchase in the Amazon
#' Web Services Region that you're currently using
#'
#' @description
#' Describes Capacity Block offerings available for purchase in the Amazon Web Services Region that you're currently using. With Capacity Blocks, you purchase a specific instance type for a period of time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_offerings/](https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_offerings/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceType The type of instance for which the Capacity Block offering reserves
#' capacity.
#' @param InstanceCount The number of instances for which to reserve capacity.
#' @param StartDateRange The earliest start date for the Capacity Block offering.
#' @param EndDateRange The latest end date for the Capacity Block offering.
#' @param CapacityDurationHours &#91;required&#93; The number of hours for which to reserve Capacity Block.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_block_offerings
ec2_describe_capacity_block_offerings <- function(DryRun = NULL, InstanceType = NULL, InstanceCount = NULL, StartDateRange = NULL, EndDateRange = NULL, CapacityDurationHours, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeCapacityBlockOfferings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CapacityBlockOfferings"),
    stream_api = FALSE
  )
  input <- .ec2$describe_capacity_block_offerings_input(DryRun = DryRun, InstanceType = InstanceType, InstanceCount = InstanceCount, StartDateRange = StartDateRange, EndDateRange = EndDateRange, CapacityDurationHours = CapacityDurationHours, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_capacity_block_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_block_offerings <- ec2_describe_capacity_block_offerings

#' Describes a request to assign the billing of the unused capacity of a
#' Capacity Reservation
#'
#' @description
#' Describes a request to assign the billing of the unused capacity of a Capacity Reservation. For more information, see [Billing assignment for shared Amazon EC2 Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservation_billing_requests/](https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservation_billing_requests/) for full documentation.
#'
#' @param CapacityReservationIds The ID of the Capacity Reservation.
#' @param Role &#91;required&#93; Specify one of the following:
#' 
#' -   `odcr-owner` - If you are the Capacity Reservation owner, specify
#'     this value to view requests that you have initiated. Not supported
#'     with the `requested-by` filter.
#' 
#' -   `unused-reservation-billing-owner` - If you are the consumer
#'     account, specify this value to view requests that have been sent to
#'     you. Not supported with the `unused-reservation-billing-owner`
#'     filter.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param Filters One or more filters.
#' 
#' -   `status` - The state of the request (`pending` | `accepted` |
#'     `rejected` | `cancelled` | `revoked` | `expired`).
#' 
#' -   `requested-by` - The account ID of the Capacity Reservation owner
#'     that initiated the request. Not supported if you specify
#'     `requested-by` for **Role**.
#' 
#' -   `unused-reservation-billing-owner` - The ID of the consumer account
#'     to which the request was sent. Not supported if you specify
#'     `unused-reservation-billing-owner` for **Role**.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_reservation_billing_requests
ec2_describe_capacity_reservation_billing_requests <- function(CapacityReservationIds = NULL, Role, NextToken = NULL, MaxResults = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCapacityReservationBillingRequests",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CapacityReservationBillingRequests"),
    stream_api = FALSE
  )
  input <- .ec2$describe_capacity_reservation_billing_requests_input(CapacityReservationIds = CapacityReservationIds, Role = Role, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_capacity_reservation_billing_requests_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_reservation_billing_requests <- ec2_describe_capacity_reservation_billing_requests

#' Describes one or more Capacity Reservation Fleets
#'
#' @description
#' Describes one or more Capacity Reservation Fleets.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservation_fleets/](https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservation_fleets/) for full documentation.
#'
#' @param CapacityReservationFleetIds The IDs of the Capacity Reservation Fleets to describe.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param Filters One or more filters.
#' 
#' -   `state` - The state of the Fleet (`submitted` | `modifying` |
#'     `active` | `partially_fulfilled` | `expiring` | `expired` |
#'     `cancelling` | `cancelled` | `failed`).
#' 
#' -   `instance-match-criteria` - The instance matching criteria for the
#'     Fleet. Only `open` is supported.
#' 
#' -   `tenancy` - The tenancy of the Fleet (`default` | `dedicated`).
#' 
#' -   `allocation-strategy` - The allocation strategy used by the Fleet.
#'     Only `prioritized` is supported.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_reservation_fleets
ec2_describe_capacity_reservation_fleets <- function(CapacityReservationFleetIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCapacityReservationFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CapacityReservationFleets"),
    stream_api = FALSE
  )
  input <- .ec2$describe_capacity_reservation_fleets_input(CapacityReservationFleetIds = CapacityReservationFleetIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_capacity_reservation_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_reservation_fleets <- ec2_describe_capacity_reservation_fleets

#' Describes one or more of your Capacity Reservations
#'
#' @description
#' Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the Amazon Web Services Region that you're currently using.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservations/](https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservations/) for full documentation.
#'
#' @param CapacityReservationIds The ID of the Capacity Reservation.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param Filters One or more filters.
#' 
#' -   `instance-type` - The type of instance for which the Capacity
#'     Reservation reserves capacity.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     Capacity Reservation.
#' 
#' -   `instance-platform` - The type of operating system for which the
#'     Capacity Reservation reserves capacity.
#' 
#' -   `availability-zone` - The Availability Zone of the Capacity
#'     Reservation.
#' 
#' -   `tenancy` - Indicates the tenancy of the Capacity Reservation. A
#'     Capacity Reservation can have one of the following tenancy settings:
#' 
#'     -   `default` - The Capacity Reservation is created on hardware that
#'         is shared with other Amazon Web Services accounts.
#' 
#'     -   `dedicated` - The Capacity Reservation is created on
#'         single-tenant hardware that is dedicated to a single Amazon Web
#'         Services account.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost on
#'     which the Capacity Reservation was created.
#' 
#' -   `state` - The current state of the Capacity Reservation. A Capacity
#'     Reservation can be in one of the following states:
#' 
#'     -   `active`- The Capacity Reservation is active and the capacity is
#'         available for your use.
#' 
#'     -   `expired` - The Capacity Reservation expired automatically at
#'         the date and time specified in your request. The reserved
#'         capacity is no longer available for your use.
#' 
#'     -   `cancelled` - The Capacity Reservation was cancelled. The
#'         reserved capacity is no longer available for your use.
#' 
#'     -   `pending` - The Capacity Reservation request was successful but
#'         the capacity provisioning is still pending.
#' 
#'     -   `failed` - The Capacity Reservation request has failed. A
#'         request might fail due to invalid request parameters, capacity
#'         constraints, or instance limit constraints. Failed requests are
#'         retained for 60 minutes.
#' 
#' -   `start-date` - The date and time at which the Capacity Reservation
#'     was started.
#' 
#' -   `end-date` - The date and time at which the Capacity Reservation
#'     expires. When a Capacity Reservation expires, the reserved capacity
#'     is released and you can no longer launch instances into it. The
#'     Capacity Reservation's state changes to expired when it reaches its
#'     end date and time.
#' 
#' -   `end-date-type` - Indicates the way in which the Capacity
#'     Reservation ends. A Capacity Reservation can have one of the
#'     following end types:
#' 
#'     -   `unlimited` - The Capacity Reservation remains active until you
#'         explicitly cancel it.
#' 
#'     -   `limited` - The Capacity Reservation expires automatically at a
#'         specified date and time.
#' 
#' -   `instance-match-criteria` - Indicates the type of instance launches
#'     that the Capacity Reservation accepts. The options include:
#' 
#'     -   `open` - The Capacity Reservation accepts all instances that
#'         have matching attributes (instance type, platform, and
#'         Availability Zone). Instances that have matching attributes
#'         launch into the Capacity Reservation automatically without
#'         specifying any additional parameters.
#' 
#'     -   `targeted` - The Capacity Reservation only accepts instances
#'         that have matching attributes (instance type, platform, and
#'         Availability Zone), and explicitly target the Capacity
#'         Reservation. This ensures that only permitted instances can use
#'         the reserved capacity.
#' 
#' -   `placement-group-arn` - The ARN of the cluster placement group in
#'     which the Capacity Reservation was created.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_reservations
ec2_describe_capacity_reservations <- function(CapacityReservationIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCapacityReservations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CapacityReservations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_capacity_reservations_input(CapacityReservationIds = CapacityReservationIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_capacity_reservations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_reservations <- ec2_describe_capacity_reservations

#' Describes one or more of your carrier gateways
#'
#' @description
#' Describes one or more of your carrier gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_carrier_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_carrier_gateways/) for full documentation.
#'
#' @param CarrierGatewayIds One or more carrier gateway IDs.
#' @param Filters One or more filters.
#' 
#' -   `carrier-gateway-id` - The ID of the carrier gateway.
#' 
#' -   `state` - The state of the carrier gateway (`pending` | `failed` |
#'     `available` | `deleting` | `deleted`).
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the owner of the
#'     carrier gateway.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC associated with the carrier gateway.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_carrier_gateways
ec2_describe_carrier_gateways <- function(CarrierGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCarrierGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CarrierGateways"),
    stream_api = FALSE
  )
  input <- .ec2$describe_carrier_gateways_input(CarrierGatewayIds = CarrierGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_carrier_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_carrier_gateways <- ec2_describe_carrier_gateways

#' This action is deprecated
#'
#' @description
#' This action is deprecated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_classic_link_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_classic_link_instances/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceIds The instance IDs. Must be instances linked to a VPC through ClassicLink.
#' @param Filters The filters.
#' 
#' -   `group-id` - The ID of a VPC security group that's associated with
#'     the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC to which the instance is linked.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' Constraint: If the value is greater than 1000, we return only 1000
#' items.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_classic_link_instances
ec2_describe_classic_link_instances <- function(DryRun = NULL, InstanceIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeClassicLinkInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Instances"),
    stream_api = FALSE
  )
  input <- .ec2$describe_classic_link_instances_input(DryRun = DryRun, InstanceIds = InstanceIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_classic_link_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_classic_link_instances <- ec2_describe_classic_link_instances

#' Describes the authorization rules for a specified Client VPN endpoint
#'
#' @description
#' Describes the authorization rules for a specified Client VPN endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_authorization_rules/](https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_authorization_rules/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `description` - The description of the authorization rule.
#' 
#' -   `destination-cidr` - The CIDR of the network to which the
#'     authorization rule applies.
#' 
#' -   `group-id` - The ID of the Active Directory group to which the
#'     authorization rule grants access.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_authorization_rules
ec2_describe_client_vpn_authorization_rules <- function(ClientVpnEndpointId, DryRun = NULL, NextToken = NULL, Filters = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnAuthorizationRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AuthorizationRules"),
    stream_api = FALSE
  )
  input <- .ec2$describe_client_vpn_authorization_rules_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun, NextToken = NextToken, Filters = Filters, MaxResults = MaxResults)
  output <- .ec2$describe_client_vpn_authorization_rules_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_authorization_rules <- ec2_describe_client_vpn_authorization_rules

#' Describes active client connections and connections that have been
#' terminated within the last 60 minutes for the specified Client VPN
#' endpoint
#'
#' @description
#' Describes active client connections and connections that have been terminated within the last 60 minutes for the specified Client VPN endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_connections/](https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_connections/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `connection-id` - The ID of the connection.
#' 
#' -   `username` - For Active Directory client authentication, the user
#'     name of the client who established the client connection.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_connections
ec2_describe_client_vpn_connections <- function(ClientVpnEndpointId, Filters = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Connections"),
    stream_api = FALSE
  )
  input <- .ec2$describe_client_vpn_connections_input(ClientVpnEndpointId = ClientVpnEndpointId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_connections_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_connections <- ec2_describe_client_vpn_connections

#' Describes one or more Client VPN endpoints in the account
#'
#' @description
#' Describes one or more Client VPN endpoints in the account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_endpoints/](https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_endpoints/) for full documentation.
#'
#' @param ClientVpnEndpointIds The ID of the Client VPN endpoint.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `endpoint-id` - The ID of the Client VPN endpoint.
#' 
#' -   `transport-protocol` - The transport protocol (`tcp` | `udp`).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_endpoints
ec2_describe_client_vpn_endpoints <- function(ClientVpnEndpointIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ClientVpnEndpoints"),
    stream_api = FALSE
  )
  input <- .ec2$describe_client_vpn_endpoints_input(ClientVpnEndpointIds = ClientVpnEndpointIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_endpoints <- ec2_describe_client_vpn_endpoints

#' Describes the routes for the specified Client VPN endpoint
#'
#' @description
#' Describes the routes for the specified Client VPN endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_routes/](https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_routes/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `destination-cidr` - The CIDR of the route destination.
#' 
#' -   `origin` - How the route was associated with the Client VPN endpoint
#'     (`associate` | `add-route`).
#' 
#' -   `target-subnet` - The ID of the subnet through which traffic is
#'     routed.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_routes
ec2_describe_client_vpn_routes <- function(ClientVpnEndpointId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnRoutes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Routes"),
    stream_api = FALSE
  )
  input <- .ec2$describe_client_vpn_routes_input(ClientVpnEndpointId = ClientVpnEndpointId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_routes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_routes <- ec2_describe_client_vpn_routes

#' Describes the target networks associated with the specified Client VPN
#' endpoint
#'
#' @description
#' Describes the target networks associated with the specified Client VPN endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_target_networks/](https://www.paws-r-sdk.com/docs/ec2_describe_client_vpn_target_networks/) for full documentation.
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param AssociationIds The IDs of the target network associations.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `association-id` - The ID of the association.
#' 
#' -   `target-network-id` - The ID of the subnet specified as the target
#'     network.
#' 
#' -   `vpc-id` - The ID of the VPC in which the target network is located.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_target_networks
ec2_describe_client_vpn_target_networks <- function(ClientVpnEndpointId, AssociationIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnTargetNetworks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ClientVpnTargetNetworks"),
    stream_api = FALSE
  )
  input <- .ec2$describe_client_vpn_target_networks_input(ClientVpnEndpointId = ClientVpnEndpointId, AssociationIds = AssociationIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_target_networks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_target_networks <- ec2_describe_client_vpn_target_networks

#' Describes the specified customer-owned address pools or all of your
#' customer-owned address pools
#'
#' @description
#' Describes the specified customer-owned address pools or all of your customer-owned address pools.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_coip_pools/](https://www.paws-r-sdk.com/docs/ec2_describe_coip_pools/) for full documentation.
#'
#' @param PoolIds The IDs of the address pools.
#' @param Filters One or more filters.
#' 
#' -   `coip-pool.local-gateway-route-table-id` - The ID of the local
#'     gateway route table.
#' 
#' -   `coip-pool.pool-id` - The ID of the address pool.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_coip_pools
ec2_describe_coip_pools <- function(PoolIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCoipPools",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "CoipPools"),
    stream_api = FALSE
  )
  input <- .ec2$describe_coip_pools_input(PoolIds = PoolIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_coip_pools_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_coip_pools <- ec2_describe_coip_pools

#' Describes the specified conversion tasks or all your conversion tasks
#'
#' @description
#' Describes the specified conversion tasks or all your conversion tasks. For more information, see the [VM Import/Export User Guide](https://docs.aws.amazon.com/vm-import/latest/userguide/).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_conversion_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_conversion_tasks/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConversionTaskIds The conversion task IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_conversion_tasks
ec2_describe_conversion_tasks <- function(DryRun = NULL, ConversionTaskIds = NULL) {
  op <- new_operation(
    name = "DescribeConversionTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_conversion_tasks_input(DryRun = DryRun, ConversionTaskIds = ConversionTaskIds)
  output <- .ec2$describe_conversion_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_conversion_tasks <- ec2_describe_conversion_tasks

#' Describes one or more of your VPN customer gateways
#'
#' @description
#' Describes one or more of your VPN customer gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_customer_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_customer_gateways/) for full documentation.
#'
#' @param CustomerGatewayIds One or more customer gateway IDs.
#' 
#' Default: Describes all your customer gateways.
#' @param Filters One or more filters.
#' 
#' -   `bgp-asn` - The customer gateway's Border Gateway Protocol (BGP)
#'     Autonomous System Number (ASN).
#' 
#' -   `customer-gateway-id` - The ID of the customer gateway.
#' 
#' -   `ip-address` - The IP address of the customer gateway device's
#'     external interface.
#' 
#' -   `state` - The state of the customer gateway (`pending` | `available`
#'     | `deleting` | `deleted`).
#' 
#' -   `type` - The type of customer gateway. Currently, the only supported
#'     type is `ipsec.1`.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_customer_gateways
ec2_describe_customer_gateways <- function(CustomerGatewayIds = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCustomerGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_customer_gateways_input(CustomerGatewayIds = CustomerGatewayIds, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_customer_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_customer_gateways <- ec2_describe_customer_gateways

#' Describes the metadata of an account status report, including the status
#' of the report
#'
#' @description
#' Describes the metadata of an account status report, including the status of the report.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_declarative_policies_reports/](https://www.paws-r-sdk.com/docs/ec2_describe_declarative_policies_reports/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param ReportIds One or more report IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_declarative_policies_reports
ec2_describe_declarative_policies_reports <- function(DryRun = NULL, NextToken = NULL, MaxResults = NULL, ReportIds = NULL) {
  op <- new_operation(
    name = "DescribeDeclarativePoliciesReports",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_declarative_policies_reports_input(DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults, ReportIds = ReportIds)
  output <- .ec2$describe_declarative_policies_reports_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_declarative_policies_reports <- ec2_describe_declarative_policies_reports

#' Describes your DHCP option sets
#'
#' @description
#' Describes your DHCP option sets. The default is to describe all your DHCP option sets. Alternatively, you can specify specific DHCP option set IDs or filter the results to include only the DHCP option sets that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_dhcp_options/](https://www.paws-r-sdk.com/docs/ec2_describe_dhcp_options/) for full documentation.
#'
#' @param DhcpOptionsIds The IDs of DHCP option sets.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `dhcp-options-id` - The ID of a DHCP options set.
#' 
#' -   `key` - The key for one of the options (for example, `domain-name`).
#' 
#' -   `value` - The value for one of the options.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     DHCP options set.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_dhcp_options
ec2_describe_dhcp_options <- function(DhcpOptionsIds = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeDhcpOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DhcpOptions"),
    stream_api = FALSE
  )
  input <- .ec2$describe_dhcp_options_input(DhcpOptionsIds = DhcpOptionsIds, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_dhcp_options <- ec2_describe_dhcp_options

#' Describes your egress-only internet gateways
#'
#' @description
#' Describes your egress-only internet gateways. The default is to describe all your egress-only internet gateways. Alternatively, you can specify specific egress-only internet gateway IDs or filter the results to include only the egress-only internet gateways that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_egress_only_internet_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_egress_only_internet_gateways/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayIds The IDs of the egress-only internet gateways.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param Filters The filters.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_egress_only_internet_gateways
ec2_describe_egress_only_internet_gateways <- function(DryRun = NULL, EgressOnlyInternetGatewayIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEgressOnlyInternetGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "EgressOnlyInternetGateways"),
    stream_api = FALSE
  )
  input <- .ec2$describe_egress_only_internet_gateways_input(DryRun = DryRun, EgressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ec2$describe_egress_only_internet_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_egress_only_internet_gateways <- ec2_describe_egress_only_internet_gateways

#' Amazon Elastic Graphics reached end of life on January 8, 2024
#'
#' @description
#' Amazon Elastic Graphics reached end of life on January 8, 2024.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_elastic_gpus/](https://www.paws-r-sdk.com/docs/ec2_describe_elastic_gpus/) for full documentation.
#'
#' @param ElasticGpuIds The Elastic Graphics accelerator IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone in which the Elastic
#'     Graphics accelerator resides.
#' 
#' -   `elastic-gpu-health` - The status of the Elastic Graphics
#'     accelerator (`OK` | `IMPAIRED`).
#' 
#' -   `elastic-gpu-state` - The state of the Elastic Graphics accelerator
#'     (`ATTACHED`).
#' 
#' -   `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
#'     example, `eg1.medium`.
#' 
#' -   `instance-id` - The ID of the instance to which the Elastic Graphics
#'     accelerator is associated.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000.
#' @param NextToken The token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_elastic_gpus
ec2_describe_elastic_gpus <- function(ElasticGpuIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeElasticGpus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_elastic_gpus_input(ElasticGpuIds = ElasticGpuIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_elastic_gpus_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_elastic_gpus <- ec2_describe_elastic_gpus

#' Describes the specified export image tasks or all of your export image
#' tasks
#'
#' @description
#' Describes the specified export image tasks or all of your export image tasks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_export_image_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_export_image_tasks/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filter tasks using the `task-state` filter and one of the following
#' values: `active`, `completed`, `deleting`, or `deleted`.
#' @param ExportImageTaskIds The IDs of the export image tasks.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken A token that indicates the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_export_image_tasks
ec2_describe_export_image_tasks <- function(DryRun = NULL, Filters = NULL, ExportImageTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeExportImageTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ExportImageTasks"),
    stream_api = FALSE
  )
  input <- .ec2$describe_export_image_tasks_input(DryRun = DryRun, Filters = Filters, ExportImageTaskIds = ExportImageTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_export_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_export_image_tasks <- ec2_describe_export_image_tasks

#' Describes the specified export instance tasks or all of your export
#' instance tasks
#'
#' @description
#' Describes the specified export instance tasks or all of your export instance tasks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_export_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_export_tasks/) for full documentation.
#'
#' @param Filters the filters for the export tasks.
#' @param ExportTaskIds The export task IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_export_tasks
ec2_describe_export_tasks <- function(Filters = NULL, ExportTaskIds = NULL) {
  op <- new_operation(
    name = "DescribeExportTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_export_tasks_input(Filters = Filters, ExportTaskIds = ExportTaskIds)
  output <- .ec2$describe_export_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_export_tasks <- ec2_describe_export_tasks

#' Describe details for Windows AMIs that are configured for Windows fast
#' launch
#'
#' @description
#' Describe details for Windows AMIs that are configured for Windows fast launch.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fast_launch_images/](https://www.paws-r-sdk.com/docs/ec2_describe_fast_launch_images/) for full documentation.
#'
#' @param ImageIds Specify one or more Windows AMI image IDs for the request.
#' @param Filters Use the following filters to streamline results.
#' 
#' -   `resource-type` - The resource type for pre-provisioning.
#' 
#' -   `owner-id` - The owner ID for the pre-provisioning resource.
#' 
#' -   `state` - The current state of fast launching for the Windows AMI.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fast_launch_images
ec2_describe_fast_launch_images <- function(ImageIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeFastLaunchImages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FastLaunchImages"),
    stream_api = FALSE
  )
  input <- .ec2$describe_fast_launch_images_input(ImageIds = ImageIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_fast_launch_images_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fast_launch_images <- ec2_describe_fast_launch_images

#' Describes the state of fast snapshot restores for your snapshots
#'
#' @description
#' Describes the state of fast snapshot restores for your snapshots.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fast_snapshot_restores/](https://www.paws-r-sdk.com/docs/ec2_describe_fast_snapshot_restores/) for full documentation.
#'
#' @param Filters The filters. The possible values are:
#' 
#' -   `availability-zone`: The Availability Zone of the snapshot.
#' 
#' -   `owner-id`: The ID of the Amazon Web Services account that enabled
#'     fast snapshot restore on the snapshot.
#' 
#' -   `snapshot-id`: The ID of the snapshot.
#' 
#' -   `state`: The state of fast snapshot restores for the snapshot
#'     (`enabling` | `optimizing` | `enabled` | `disabling` | `disabled`).
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fast_snapshot_restores
ec2_describe_fast_snapshot_restores <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeFastSnapshotRestores",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FastSnapshotRestores"),
    stream_api = FALSE
  )
  input <- .ec2$describe_fast_snapshot_restores_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_fast_snapshot_restores_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fast_snapshot_restores <- ec2_describe_fast_snapshot_restores

#' Describes the events for the specified EC2 Fleet during the specified
#' time
#'
#' @description
#' Describes the events for the specified EC2 Fleet during the specified time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fleet_history/](https://www.paws-r-sdk.com/docs/ec2_describe_fleet_history/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EventType The type of events to describe. By default, all events are described.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param StartTime &#91;required&#93; The start date and time for the events, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleet_history
ec2_describe_fleet_history <- function(DryRun = NULL, EventType = NULL, MaxResults = NULL, NextToken = NULL, FleetId, StartTime) {
  op <- new_operation(
    name = "DescribeFleetHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_fleet_history_input(DryRun = DryRun, EventType = EventType, MaxResults = MaxResults, NextToken = NextToken, FleetId = FleetId, StartTime = StartTime)
  output <- .ec2$describe_fleet_history_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleet_history <- ec2_describe_fleet_history

#' Describes the running instances for the specified EC2 Fleet
#'
#' @description
#' Describes the running instances for the specified EC2 Fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fleet_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_fleet_instances/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param Filters The filters.
#' 
#' -   `instance-type` - The instance type.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleet_instances
ec2_describe_fleet_instances <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, FleetId, Filters = NULL) {
  op <- new_operation(
    name = "DescribeFleetInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_fleet_instances_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, FleetId = FleetId, Filters = Filters)
  output <- .ec2$describe_fleet_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleet_instances <- ec2_describe_fleet_instances

#' Describes the specified EC2 Fleet or all of your EC2 Fleets
#'
#' @description
#' Describes the specified EC2 Fleet or all of your EC2 Fleets.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fleets/](https://www.paws-r-sdk.com/docs/ec2_describe_fleets/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param FleetIds The IDs of the EC2 Fleets.
#' 
#' If a fleet is of type `instant`, you must specify the fleet ID,
#' otherwise it does not appear in the response.
#' @param Filters The filters.
#' 
#' -   `activity-status` - The progress of the EC2 Fleet ( `error` |
#'     `pending-fulfillment` | `pending-termination` | `fulfilled`).
#' 
#' -   `excess-capacity-termination-policy` - Indicates whether to
#'     terminate running instances if the target capacity is decreased
#'     below the current EC2 Fleet size (`true` | `false`).
#' 
#' -   `fleet-state` - The state of the EC2 Fleet (`submitted` | `active` |
#'     `deleted` | `failed` | `deleted-running` | `deleted-terminating` |
#'     `modifying`).
#' 
#' -   `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
#'     replace unhealthy instances (`true` | `false`).
#' 
#' -   `type` - The type of request (`instant` | `request` | `maintain`).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleets
ec2_describe_fleets <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, FleetIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Fleets"),
    stream_api = FALSE
  )
  input <- .ec2$describe_fleets_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, FleetIds = FleetIds, Filters = Filters)
  output <- .ec2$describe_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleets <- ec2_describe_fleets

#' Describes one or more flow logs
#'
#' @description
#' Describes one or more flow logs.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_flow_logs/](https://www.paws-r-sdk.com/docs/ec2_describe_flow_logs/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filter One or more filters.
#' 
#' -   `deliver-log-status` - The status of the logs delivery (`SUCCESS` |
#'     `FAILED`).
#' 
#' -   `log-destination-type` - The type of destination for the flow log
#'     data (`cloud-watch-logs` | `s3` | `kinesis-data-firehose`).
#' 
#' -   `flow-log-id` - The ID of the flow log.
#' 
#' -   `log-group-name` - The name of the log group.
#' 
#' -   `resource-id` - The ID of the VPC, subnet, or network interface.
#' 
#' -   `traffic-type` - The type of traffic (`ACCEPT` | `REJECT` | `ALL`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param FlowLogIds One or more flow log IDs.
#' 
#' Constraint: Maximum of 1000 flow log IDs.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token to request the next page of items. Pagination continues from
#' the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_flow_logs
ec2_describe_flow_logs <- function(DryRun = NULL, Filter = NULL, FlowLogIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFlowLogs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FlowLogs"),
    stream_api = FALSE
  )
  input <- .ec2$describe_flow_logs_input(DryRun = DryRun, Filter = Filter, FlowLogIds = FlowLogIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_flow_logs <- ec2_describe_flow_logs

#' Describes the specified attribute of the specified Amazon FPGA Image
#' (AFI)
#'
#' @description
#' Describes the specified attribute of the specified Amazon FPGA Image (AFI).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fpga_image_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_fpga_image_attribute/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#' @param Attribute &#91;required&#93; The AFI attribute.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fpga_image_attribute
ec2_describe_fpga_image_attribute <- function(DryRun = NULL, FpgaImageId, Attribute) {
  op <- new_operation(
    name = "DescribeFpgaImageAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_fpga_image_attribute_input(DryRun = DryRun, FpgaImageId = FpgaImageId, Attribute = Attribute)
  output <- .ec2$describe_fpga_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fpga_image_attribute <- ec2_describe_fpga_image_attribute

#' Describes the Amazon FPGA Images (AFIs) available to you
#'
#' @description
#' Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which you have load permissions.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_fpga_images/](https://www.paws-r-sdk.com/docs/ec2_describe_fpga_images/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageIds The AFI IDs.
#' @param Owners Filters the AFI by owner. Specify an Amazon Web Services account ID,
#' `self` (owner is the sender of the request), or an Amazon Web Services
#' owner alias (valid values are `amazon` | `aws-marketplace`).
#' @param Filters The filters.
#' 
#' -   `create-time` - The creation time of the AFI.
#' 
#' -   `fpga-image-id` - The FPGA image identifier (AFI ID).
#' 
#' -   `fpga-image-global-id` - The global FPGA image identifier (AGFI ID).
#' 
#' -   `name` - The name of the AFI.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the AFI owner.
#' 
#' -   `product-code` - The product code.
#' 
#' -   `shell-version` - The version of the Amazon Web Services Shell that
#'     was used to create the bitstream.
#' 
#' -   `state` - The state of the AFI (`pending` | `failed` | `available` |
#'     `unavailable`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `update-time` - The time of the most recent update.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fpga_images
ec2_describe_fpga_images <- function(DryRun = NULL, FpgaImageIds = NULL, Owners = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeFpgaImages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FpgaImages"),
    stream_api = FALSE
  )
  input <- .ec2$describe_fpga_images_input(DryRun = DryRun, FpgaImageIds = FpgaImageIds, Owners = Owners, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_fpga_images_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fpga_images <- ec2_describe_fpga_images

#' Describes the Dedicated Host reservations that are available to purchase
#'
#' @description
#' Describes the Dedicated Host reservations that are available to purchase.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_host_reservation_offerings/](https://www.paws-r-sdk.com/docs/ec2_describe_host_reservation_offerings/) for full documentation.
#'
#' @param Filter The filters.
#' 
#' -   `instance-family` - The instance family of the offering (for
#'     example, `m4`).
#' 
#' -   `payment-option` - The payment option (`NoUpfront` |
#'     `PartialUpfront` | `AllUpfront`).
#' @param MaxDuration This is the maximum duration of the reservation to purchase, specified
#' in seconds. Reservations are available in one-year and three-year terms.
#' The number of seconds specified must be the number of seconds in a year
#' (365x24x60x60) times one of the supported durations (1 or 3). For
#' example, specify 94608000 for three years.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param MinDuration This is the minimum duration of the reservation you'd like to purchase,
#' specified in seconds. Reservations are available in one-year and
#' three-year terms. The number of seconds specified must be the number of
#' seconds in a year (365x24x60x60) times one of the supported durations (1
#' or 3). For example, specify 31536000 for one year.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param OfferingId The ID of the reservation offering.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_host_reservation_offerings
ec2_describe_host_reservation_offerings <- function(Filter = NULL, MaxDuration = NULL, MaxResults = NULL, MinDuration = NULL, NextToken = NULL, OfferingId = NULL) {
  op <- new_operation(
    name = "DescribeHostReservationOfferings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "OfferingSet"),
    stream_api = FALSE
  )
  input <- .ec2$describe_host_reservation_offerings_input(Filter = Filter, MaxDuration = MaxDuration, MaxResults = MaxResults, MinDuration = MinDuration, NextToken = NextToken, OfferingId = OfferingId)
  output <- .ec2$describe_host_reservation_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_host_reservation_offerings <- ec2_describe_host_reservation_offerings

#' Describes reservations that are associated with Dedicated Hosts in your
#' account
#'
#' @description
#' Describes reservations that are associated with Dedicated Hosts in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_host_reservations/](https://www.paws-r-sdk.com/docs/ec2_describe_host_reservations/) for full documentation.
#'
#' @param Filter The filters.
#' 
#' -   `instance-family` - The instance family (for example, `m4`).
#' 
#' -   `payment-option` - The payment option (`NoUpfront` |
#'     `PartialUpfront` | `AllUpfront`).
#' 
#' -   `state` - The state of the reservation (`payment-pending` |
#'     `payment-failed` | `active` | `retired`).
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param HostReservationIdSet The host reservation IDs.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param NextToken The token to use to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_host_reservations
ec2_describe_host_reservations <- function(Filter = NULL, HostReservationIdSet = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeHostReservations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "HostReservationSet"),
    stream_api = FALSE
  )
  input <- .ec2$describe_host_reservations_input(Filter = Filter, HostReservationIdSet = HostReservationIdSet, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_host_reservations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_host_reservations <- ec2_describe_host_reservations

#' Describes the specified Dedicated Hosts or all your Dedicated Hosts
#'
#' @description
#' Describes the specified Dedicated Hosts or all your Dedicated Hosts.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_hosts/](https://www.paws-r-sdk.com/docs/ec2_describe_hosts/) for full documentation.
#'
#' @param HostIds The IDs of the Dedicated Hosts. The IDs are used for targeted instance
#' launches.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' 
#' You cannot specify this parameter and the host IDs parameter in the same
#' request.
#' @param Filter The filters.
#' 
#' -   `auto-placement` - Whether auto-placement is enabled or disabled
#'     (`on` | `off`).
#' 
#' -   `availability-zone` - The Availability Zone of the host.
#' 
#' -   `client-token` - The idempotency token that you provided when you
#'     allocated the host.
#' 
#' -   `host-reservation-id` - The ID of the reservation assigned to this
#'     host.
#' 
#' -   `instance-type` - The instance type size that the Dedicated Host is
#'     configured to support.
#' 
#' -   `state` - The allocation state of the Dedicated Host (`available` |
#'     `under-assessment` | `permanent-failure` | `released` |
#'     `released-permanent-failure`).
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_hosts
ec2_describe_hosts <- function(HostIds = NULL, NextToken = NULL, MaxResults = NULL, Filter = NULL) {
  op <- new_operation(
    name = "DescribeHosts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Hosts"),
    stream_api = FALSE
  )
  input <- .ec2$describe_hosts_input(HostIds = HostIds, NextToken = NextToken, MaxResults = MaxResults, Filter = Filter)
  output <- .ec2$describe_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_hosts <- ec2_describe_hosts

#' Describes your IAM instance profile associations
#'
#' @description
#' Describes your IAM instance profile associations.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_iam_instance_profile_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_iam_instance_profile_associations/) for full documentation.
#'
#' @param AssociationIds The IAM instance profile associations.
#' @param Filters The filters.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `state` - The state of the association (`associating` | `associated`
#'     | `disassociating`).
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_iam_instance_profile_associations
ec2_describe_iam_instance_profile_associations <- function(AssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeIamInstanceProfileAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "IamInstanceProfileAssociations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_iam_instance_profile_associations_input(AssociationIds = AssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_iam_instance_profile_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_iam_instance_profile_associations <- ec2_describe_iam_instance_profile_associations

#' Describes the ID format settings for your resources on a per-Region
#' basis, for example, to view which resource types are enabled for longer
#' IDs
#'
#' @description
#' Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_id_format/](https://www.paws-r-sdk.com/docs/ec2_describe_id_format/) for full documentation.
#'
#' @param Resource The type of resource: `bundle` | `conversion-task` | `customer-gateway`
#' | `dhcp-options` | `elastic-ip-allocation` | `elastic-ip-association` |
#' `export-task` | `flow-log` | `image` | `import-task` | `instance` |
#' `internet-gateway` | `network-acl` | `network-acl-association` |
#' `network-interface` | `network-interface-attachment` | `prefix-list` |
#' `reservation` | `route-table` | `route-table-association` |
#' `security-group` | `snapshot` | `subnet` |
#' `subnet-cidr-block-association` | `volume` | `vpc` |
#' `vpc-cidr-block-association` | `vpc-endpoint` | `vpc-peering-connection`
#' | `vpn-connection` | `vpn-gateway`
#'
#' @keywords internal
#'
#' @rdname ec2_describe_id_format
ec2_describe_id_format <- function(Resource = NULL) {
  op <- new_operation(
    name = "DescribeIdFormat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_id_format_input(Resource = Resource)
  output <- .ec2$describe_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_id_format <- ec2_describe_id_format

#' Describes the ID format settings for resources for the specified IAM
#' user, IAM role, or root user
#'
#' @description
#' Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see [Resource IDs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resources.html) in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_identity_id_format/](https://www.paws-r-sdk.com/docs/ec2_describe_identity_id_format/) for full documentation.
#'
#' @param Resource The type of resource: `bundle` | `conversion-task` | `customer-gateway`
#' | `dhcp-options` | `elastic-ip-allocation` | `elastic-ip-association` |
#' `export-task` | `flow-log` | `image` | `import-task` | `instance` |
#' `internet-gateway` | `network-acl` | `network-acl-association` |
#' `network-interface` | `network-interface-attachment` | `prefix-list` |
#' `reservation` | `route-table` | `route-table-association` |
#' `security-group` | `snapshot` | `subnet` |
#' `subnet-cidr-block-association` | `volume` | `vpc` |
#' `vpc-cidr-block-association` | `vpc-endpoint` | `vpc-peering-connection`
#' | `vpn-connection` | `vpn-gateway`
#' @param PrincipalArn &#91;required&#93; The ARN of the principal, which can be an IAM role, IAM user, or the
#' root user.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_identity_id_format
ec2_describe_identity_id_format <- function(Resource = NULL, PrincipalArn) {
  op <- new_operation(
    name = "DescribeIdentityIdFormat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_identity_id_format_input(Resource = Resource, PrincipalArn = PrincipalArn)
  output <- .ec2$describe_identity_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_identity_id_format <- ec2_describe_identity_id_format

#' Describes the specified attribute of the specified AMI
#'
#' @description
#' Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_image_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_image_attribute/) for full documentation.
#'
#' @param Attribute &#91;required&#93; The AMI attribute.
#' 
#' **Note**: The `blockDeviceMapping` attribute is deprecated. Using this
#' attribute returns the `Client.AuthFailure` error. To get information
#' about the block device mappings for an AMI, use the
#' [`describe_images`][ec2_describe_images] action.
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_image_attribute
ec2_describe_image_attribute <- function(Attribute, ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeImageAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_image_attribute_input(Attribute = Attribute, ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$describe_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_image_attribute <- ec2_describe_image_attribute

#' Describes the specified images (AMIs, AKIs, and ARIs) available to you
#' or all of the images available to you
#'
#' @description
#' Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_images/](https://www.paws-r-sdk.com/docs/ec2_describe_images/) for full documentation.
#'
#' @param ExecutableUsers Scopes the images by users with explicit launch permissions. Specify an
#' Amazon Web Services account ID, `self` (the sender of the request), or
#' `all` (public AMIs).
#' 
#' -   If you specify an Amazon Web Services account ID that is not your
#'     own, only AMIs shared with that specific Amazon Web Services account
#'     ID are returned. However, AMIs that are shared with the account’s
#'     organization or organizational unit (OU) are not returned.
#' 
#' -   If you specify `self` or your own Amazon Web Services account ID,
#'     AMIs shared with your account are returned. In addition, AMIs that
#'     are shared with the organization or OU of which you are member are
#'     also returned.
#' 
#' -   If you specify `all`, all public AMIs are returned.
#' @param ImageIds The image IDs.
#' 
#' Default: Describes all images available to you.
#' @param Owners Scopes the results to images with the specified owners. You can specify
#' a combination of Amazon Web Services account IDs, `self`, `amazon`,
#' `aws-backup-vault`, and `aws-marketplace`. If you omit this parameter,
#' the results include all images for which you have launch permissions,
#' regardless of ownership.
#' @param IncludeDeprecated Specifies whether to include deprecated AMIs.
#' 
#' Default: No deprecated AMIs are included in the response.
#' 
#' If you are the AMI owner, all deprecated AMIs appear in the response
#' regardless of what you specify for this parameter.
#' @param IncludeDisabled Specifies whether to include disabled AMIs.
#' 
#' Default: No disabled AMIs are included in the response.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `architecture` - The image architecture (`i386` | `x86_64` | `arm64`
#'     | `x86_64_mac` | `arm64_mac`).
#' 
#' -   `block-device-mapping.delete-on-termination` - A Boolean value that
#'     indicates whether the Amazon EBS volume is deleted on instance
#'     termination.
#' 
#' -   `block-device-mapping.device-name` - The device name specified in
#'     the block device mapping (for example, `/dev/sdh` or `xvdh`).
#' 
#' -   `block-device-mapping.snapshot-id` - The ID of the snapshot used for
#'     the Amazon EBS volume.
#' 
#' -   `block-device-mapping.volume-size` - The volume size of the Amazon
#'     EBS volume, in GiB.
#' 
#' -   `block-device-mapping.volume-type` - The volume type of the Amazon
#'     EBS volume (`io1` | `io2` | `gp2` | `gp3` | `sc1 `| `st1` |
#'     `standard`).
#' 
#' -   `block-device-mapping.encrypted` - A Boolean that indicates whether
#'     the Amazon EBS volume is encrypted.
#' 
#' -   `creation-date` - The time when the image was created, in the ISO
#'     8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for
#'     example, `2021-09-29T11:04:43.305Z`. You can use a wildcard (`*`),
#'     for example, `2021-09-29T*`, which matches an entire day.
#' 
#' -   `description` - The description of the image (provided during image
#'     creation).
#' 
#' -   `ena-support` - A Boolean that indicates whether enhanced networking
#'     with ENA is enabled.
#' 
#' -   `hypervisor` - The hypervisor type (`ovm` | `xen`).
#' 
#' -   `image-allowed` - A Boolean that indicates whether the image meets
#'     the criteria specified for Allowed AMIs.
#' 
#' -   `image-id` - The ID of the image.
#' 
#' -   `image-type` - The image type (`machine` | `kernel` | `ramdisk`).
#' 
#' -   `is-public` - A Boolean that indicates whether the image is public.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `manifest-location` - The location of the image manifest.
#' 
#' -   `name` - The name of the AMI (provided during image creation).
#' 
#' -   `owner-alias` - The owner alias (`amazon` | `aws-backup-vault` |
#'     `aws-marketplace`). The valid aliases are defined in an
#'     Amazon-maintained list. This is not the Amazon Web Services account
#'     alias that can be set using the IAM console. We recommend that you
#'     use the **Owner** request parameter instead of this filter.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the owner. We
#'     recommend that you use the **Owner** request parameter instead of
#'     this filter.
#' 
#' -   `platform` - The platform. The only supported value is `windows`.
#' 
#' -   `product-code` - The product code.
#' 
#' -   `product-code.type` - The type of the product code (`marketplace`).
#' 
#' -   `ramdisk-id` - The RAM disk ID.
#' 
#' -   `root-device-name` - The device name of the root device volume (for
#'     example, `/dev/sda1`).
#' 
#' -   `root-device-type` - The type of the root device volume (`ebs` |
#'     `instance-store`).
#' 
#' -   `source-image-id` - The ID of the source AMI from which the AMI was
#'     created.
#' 
#' -   `source-image-region` - The Region of the source AMI.
#' 
#' -   `source-instance-id` - The ID of the instance that the AMI was
#'     created from if the AMI was created using CreateImage. This filter
#'     is applicable only if the AMI was created using
#'     [`create_image`][ec2_create_image].
#' 
#' -   `state` - The state of the image (`available` | `pending` |
#'     `failed`).
#' 
#' -   `state-reason-code` - The reason code for the state change.
#' 
#' -   `state-reason-message` - The message for the state change.
#' 
#' -   `sriov-net-support` - A value of `simple` indicates that enhanced
#'     networking with the Intel 82599 VF interface is enabled.
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `virtualization-type` - The virtualization type (`paravirtual` |
#'     `hvm`).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_images
ec2_describe_images <- function(ExecutableUsers = NULL, ImageIds = NULL, Owners = NULL, IncludeDeprecated = NULL, IncludeDisabled = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Images"),
    stream_api = FALSE
  )
  input <- .ec2$describe_images_input(ExecutableUsers = ExecutableUsers, ImageIds = ImageIds, Owners = Owners, IncludeDeprecated = IncludeDeprecated, IncludeDisabled = IncludeDisabled, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_images_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_images <- ec2_describe_images

#' Displays details about an import virtual machine or import snapshot
#' tasks that are already created
#'
#' @description
#' Displays details about an import virtual machine or import snapshot tasks that are already created.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_import_image_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_import_image_tasks/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filter tasks using the `task-state` filter and one of the following
#' values: `active`, `completed`, `deleting`, or `deleted`.
#' @param ImportTaskIds The IDs of the import image tasks.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken A token that indicates the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_import_image_tasks
ec2_describe_import_image_tasks <- function(DryRun = NULL, Filters = NULL, ImportTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImportImageTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ImportImageTasks"),
    stream_api = FALSE
  )
  input <- .ec2$describe_import_image_tasks_input(DryRun = DryRun, Filters = Filters, ImportTaskIds = ImportTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_import_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_import_image_tasks <- ec2_describe_import_image_tasks

#' Describes your import snapshot tasks
#'
#' @description
#' Describes your import snapshot tasks.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_import_snapshot_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_import_snapshot_tasks/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' @param ImportTaskIds A list of import snapshot task IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken A token that indicates the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_import_snapshot_tasks
ec2_describe_import_snapshot_tasks <- function(DryRun = NULL, Filters = NULL, ImportTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImportSnapshotTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ImportSnapshotTasks"),
    stream_api = FALSE
  )
  input <- .ec2$describe_import_snapshot_tasks_input(DryRun = DryRun, Filters = Filters, ImportTaskIds = ImportTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_import_snapshot_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_import_snapshot_tasks <- ec2_describe_import_snapshot_tasks

#' Describes the specified attribute of the specified instance
#'
#' @description
#' Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: `instanceType` | `kernel` | `ramdisk` | `userData` | `disableApiTermination` | `instanceInitiatedShutdownBehavior` | `rootDeviceName` | `blockDeviceMapping` | `productCodes` | `sourceDestCheck` | `groupSet` | `ebsOptimized` | `sriovNetSupport`
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_attribute/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param Attribute &#91;required&#93; The instance attribute.
#' 
#' Note: The `enaSupport` attribute is not supported at this time.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_attribute
ec2_describe_instance_attribute <- function(DryRun = NULL, InstanceId, Attribute) {
  op <- new_operation(
    name = "DescribeInstanceAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_attribute_input(DryRun = DryRun, InstanceId = InstanceId, Attribute = Attribute)
  output <- .ec2$describe_instance_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_attribute <- ec2_describe_instance_attribute

#' Describes the specified EC2 Instance Connect Endpoints or all EC2
#' Instance Connect Endpoints
#'
#' @description
#' Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance Connect Endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_connect_endpoints/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_connect_endpoints/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param Filters One or more filters.
#' 
#' -   `instance-connect-endpoint-id` - The ID of the EC2 Instance Connect
#'     Endpoint.
#' 
#' -   `state` - The state of the EC2 Instance Connect Endpoint
#'     (`create-in-progress` | `create-complete` | `create-failed` |
#'     `delete-in-progress` | `delete-complete` | `delete-failed`).
#' 
#' -   `subnet-id` - The ID of the subnet in which the EC2 Instance Connect
#'     Endpoint was created.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tag-value` - The value of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific value,
#'     regardless of tag key.
#' 
#' -   `vpc-id` - The ID of the VPC in which the EC2 Instance Connect
#'     Endpoint was created.
#' @param InstanceConnectEndpointIds One or more EC2 Instance Connect Endpoint IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_connect_endpoints
ec2_describe_instance_connect_endpoints <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, InstanceConnectEndpointIds = NULL) {
  op <- new_operation(
    name = "DescribeInstanceConnectEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceConnectEndpoints"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_connect_endpoints_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, InstanceConnectEndpointIds = InstanceConnectEndpointIds)
  output <- .ec2$describe_instance_connect_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_connect_endpoints <- ec2_describe_instance_connect_endpoints

#' Describes the credit option for CPU usage of the specified burstable
#' performance instances
#'
#' @description
#' Describes the credit option for CPU usage of the specified burstable performance instances. The credit options are `standard` and `unlimited`.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_credit_specifications/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_credit_specifications/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `instance-id` - The ID of the instance.
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 1000 explicitly specified instance IDs.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' You cannot specify this parameter and the instance IDs parameter in the
#' same call.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_credit_specifications
ec2_describe_instance_credit_specifications <- function(DryRun = NULL, Filters = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceCreditSpecifications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceCreditSpecifications"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_credit_specifications_input(DryRun = DryRun, Filters = Filters, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_credit_specifications_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_credit_specifications <- ec2_describe_instance_credit_specifications

#' Describes the tag keys that are registered to appear in scheduled event
#' notifications for resources in the current Region
#'
#' @description
#' Describes the tag keys that are registered to appear in scheduled event notifications for resources in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_event_notification_attributes/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_event_notification_attributes/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_event_notification_attributes
ec2_describe_instance_event_notification_attributes <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeInstanceEventNotificationAttributes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_event_notification_attributes_input(DryRun = DryRun)
  output <- .ec2$describe_instance_event_notification_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_event_notification_attributes <- ec2_describe_instance_event_notification_attributes

#' Describes the specified event windows or all event windows
#'
#' @description
#' Describes the specified event windows or all event windows.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_event_windows/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_event_windows/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceEventWindowIds The IDs of the event windows.
#' @param Filters One or more filters.
#' 
#' -   `dedicated-host-id` - The event windows associated with the
#'     specified Dedicated Host ID.
#' 
#' -   `event-window-name` - The event windows associated with the
#'     specified names.
#' 
#' -   `instance-id` - The event windows associated with the specified
#'     instance ID.
#' 
#' -   `instance-tag` - The event windows associated with the specified tag
#'     and value.
#' 
#' -   `instance-tag-key` - The event windows associated with the specified
#'     tag key, regardless of the value.
#' 
#' -   `instance-tag-value` - The event windows associated with the
#'     specified tag value, regardless of the key.
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     event window. Use the tag key in the filter name and the tag value
#'     as the filter value. For example, to find all resources that have a
#'     tag with the key `Owner` and the value `CMX`, specify `tag:Owner`
#'     for the filter name and `CMX` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the event window. Use this
#'     filter to find all event windows that have a tag with a specific
#'     key, regardless of the tag value.
#' 
#' -   `tag-value` - The value of a tag assigned to the event window. Use
#'     this filter to find all event windows that have a tag with a
#'     specific value, regardless of the tag key.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 20 and 500. You cannot specify this
#' parameter and the event window IDs parameter in the same call.
#' @param NextToken The token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_event_windows
ec2_describe_instance_event_windows <- function(DryRun = NULL, InstanceEventWindowIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceEventWindows",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceEventWindows"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_event_windows_input(DryRun = DryRun, InstanceEventWindowIds = InstanceEventWindowIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_event_windows_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_event_windows <- ec2_describe_instance_event_windows

#' Describes the AMI that was used to launch an instance, even if the AMI
#' is deprecated, deregistered, made private (no longer public or shared
#' with your account), or not allowed
#'
#' @description
#' Describes the AMI that was used to launch an instance, even if the AMI is deprecated, deregistered, made private (no longer public or shared with your account), or not allowed.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_image_metadata/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_image_metadata/) for full documentation.
#'
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The name of the Availability Zone (for
#'     example, `us-west-2a`) or Local Zone (for example,
#'     `us-west-2-lax-1b`) of the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `image-allowed` - A Boolean that indicates whether the image meets
#'     the criteria specified for Allowed AMIs.
#' 
#' -   `instance-state-name` - The state of the instance (`pending` |
#'     `running` | `shutting-down` | `terminated` | `stopping` |
#'     `stopped`).
#' 
#' -   `instance-type` - The type of instance (for example, `t3.micro`).
#' 
#' -   `launch-time` - The time when the instance was launched, in the ISO
#'     8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for
#'     example, `2023-09-29T11:04:43.305Z`. You can use a wildcard (`*`),
#'     for example, `2023-09-29T*`, which matches an entire day.
#' 
#' -   `owner-alias` - The owner alias (`amazon` | `aws-marketplace` |
#'     `aws-backup-vault`). The valid aliases are defined in an
#'     Amazon-maintained list. This is not the Amazon Web Services account
#'     alias that can be set using the IAM console. We recommend that you
#'     use the `Owner` request parameter instead of this filter.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the owner. We
#'     recommend that you use the `Owner` request parameter instead of this
#'     filter.
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `zone-id` - The ID of the Availability Zone (for example,
#'     `usw2-az2`) or Local Zone (for example, `usw2-lax1-az1`) of the
#'     instance.
#' @param InstanceIds The instance IDs.
#' 
#' If you don't specify an instance ID or filters, the output includes
#' information for all instances.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' Default: 1000
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_image_metadata
ec2_describe_instance_image_metadata <- function(Filters = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeInstanceImageMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceImageMetadata"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_image_metadata_input(Filters = Filters, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_instance_image_metadata_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_image_metadata <- ec2_describe_instance_image_metadata

#' Describes the status of the specified instances or all of your instances
#'
#' @description
#' Describes the status of the specified instances or all of your instances. By default, only running instances are described, unless you specifically indicate to return the status of all instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_status/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_status/) for full documentation.
#'
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 100 explicitly specified instance IDs.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' You cannot specify this parameter and the instance IDs parameter in the
#' same request.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `event.code` - The code for the scheduled event (`instance-reboot` |
#'     `system-reboot` | `system-maintenance` | `instance-retirement` |
#'     `instance-stop`).
#' 
#' -   `event.description` - A description of the event.
#' 
#' -   `event.instance-event-id` - The ID of the event whose date and time
#'     you are modifying.
#' 
#' -   `event.not-after` - The latest end time for the scheduled event (for
#'     example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `event.not-before` - The earliest start time for the scheduled event
#'     (for example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `event.not-before-deadline` - The deadline for starting the event
#'     (for example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `instance-state-code` - The code for the instance state, as a 16-bit
#'     unsigned integer. The high byte is used for internal purposes and
#'     should be ignored. The low byte is set based on the state
#'     represented. The valid values are 0 (pending), 16 (running), 32
#'     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
#' 
#' -   `instance-state-name` - The state of the instance (`pending` |
#'     `running` | `shutting-down` | `terminated` | `stopping` |
#'     `stopped`).
#' 
#' -   `instance-status.reachability` - Filters on instance status where
#'     the name is `reachability` (`passed` | `failed` | `initializing` |
#'     `insufficient-data`).
#' 
#' -   `instance-status.status` - The status of the instance (`ok` |
#'     `impaired` | `initializing` | `insufficient-data` |
#'     `not-applicable`).
#' 
#' -   `operator.managed` - A Boolean that indicates whether this is a
#'     managed instance.
#' 
#' -   `operator.principal` - The principal that manages the instance. Only
#'     valid for managed instances, where `managed` is `true`.
#' 
#' -   `system-status.reachability` - Filters on system status where the
#'     name is `reachability` (`passed` | `failed` | `initializing` |
#'     `insufficient-data`).
#' 
#' -   `system-status.status` - The system status of the instance (`ok` |
#'     `impaired` | `initializing` | `insufficient-data` |
#'     `not-applicable`).
#' 
#' -   `attached-ebs-status.status` - The status of the attached EBS volume
#'     for the instance (`ok` | `impaired` | `initializing` |
#'     `insufficient-data` | `not-applicable`).
#' @param IncludeAllInstances When `true`, includes the health status for all instances. When `false`,
#' includes the health status for running instances only.
#' 
#' Default: `false`
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_status
ec2_describe_instance_status <- function(InstanceIds = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL, Filters = NULL, IncludeAllInstances = NULL) {
  op <- new_operation(
    name = "DescribeInstanceStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InstanceStatuses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_status_input(InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun, Filters = Filters, IncludeAllInstances = IncludeAllInstances)
  output <- .ec2$describe_instance_status_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_status <- ec2_describe_instance_status

#' Describes a tree-based hierarchy that represents the physical host
#' placement of your EC2 instances within an Availability Zone or Local
#' Zone
#'
#' @description
#' Describes a tree-based hierarchy that represents the physical host placement of your EC2 instances within an Availability Zone or Local Zone. You can use this information to determine the relative proximity of your EC2 instances within the Amazon Web Services network to support your tightly coupled workloads.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_topology/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_topology/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' You can't specify this parameter and the instance IDs parameter in the
#' same request.
#' 
#' Default: `20`
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 100 explicitly specified instance IDs.
#' @param GroupNames The name of the placement group that each instance is in.
#' 
#' Constraints: Maximum 100 explicitly specified placement group names.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The name of the Availability Zone (for
#'     example, `us-west-2a`) or Local Zone (for example,
#'     `us-west-2-lax-1b`) that the instance is in.
#' 
#' -   `instance-type` - The instance type (for example, `p4d.24xlarge`) or
#'     instance family (for example, `p4d*`). You can use the `*` wildcard
#'     to match zero or more characters, or the `?` wildcard to match zero
#'     or one character.
#' 
#' -   `zone-id` - The ID of the Availability Zone (for example,
#'     `usw2-az2`) or Local Zone (for example, `usw2-lax1-az1`) that the
#'     instance is in.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_topology
ec2_describe_instance_topology <- function(DryRun = NULL, NextToken = NULL, MaxResults = NULL, InstanceIds = NULL, GroupNames = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTopology",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Instances"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_topology_input(DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults, InstanceIds = InstanceIds, GroupNames = GroupNames, Filters = Filters)
  output <- .ec2$describe_instance_topology_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_topology <- ec2_describe_instance_topology

#' Lists the instance types that are offered for the specified location
#'
#' @description
#' Lists the instance types that are offered for the specified location. If no location is specified, the default is to list the instance types that are offered in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_type_offerings/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_type_offerings/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LocationType The location type.
#' 
#' -   `availability-zone` - The Availability Zone. When you specify a
#'     location filter, it must be an Availability Zone for the current
#'     Region.
#' 
#' -   `availability-zone-id` - The AZ ID. When you specify a location
#'     filter, it must be an AZ ID for the current Region.
#' 
#' -   `outpost` - The Outpost ARN. When you specify a location filter, it
#'     must be an Outpost ARN for the current Region.
#' 
#' -   `region` - The current Region. If you specify a location filter, it
#'     must match the current Region.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `instance-type` - The instance type. For a list of possible values,
#'     see
#'     [Instance](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Instance.html).
#' 
#' -   `location` - The location. For a list of possible identifiers, see
#'     [Regions and
#'     Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html).
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_type_offerings
ec2_describe_instance_type_offerings <- function(DryRun = NULL, LocationType = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTypeOfferings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceTypeOfferings"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_type_offerings_input(DryRun = DryRun, LocationType = LocationType, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_type_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_type_offerings <- ec2_describe_instance_type_offerings

#' Describes the specified instance types
#'
#' @description
#' Describes the specified instance types. By default, all instance types for the current Region are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instance_types/](https://www.paws-r-sdk.com/docs/ec2_describe_instance_types/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTypes The instance types.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `auto-recovery-supported` - Indicates whether Amazon CloudWatch
#'     action based recovery is supported (`true` | `false`).
#' 
#' -   `bare-metal` - Indicates whether it is a bare metal instance type
#'     (`true` | `false`).
#' 
#' -   `burstable-performance-supported` - Indicates whether the instance
#'     type is a burstable performance T instance type (`true` | `false`).
#' 
#' -   `current-generation` - Indicates whether this instance type is the
#'     latest generation instance type of an instance family (`true` |
#'     `false`).
#' 
#' -   `ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps` - The
#'     baseline bandwidth performance for an EBS-optimized instance type,
#'     in Mbps.
#' 
#' -   `ebs-info.ebs-optimized-info.baseline-iops` - The baseline
#'     input/output storage operations per second for an EBS-optimized
#'     instance type.
#' 
#' -   `ebs-info.ebs-optimized-info.baseline-throughput-in-mbps` - The
#'     baseline throughput performance for an EBS-optimized instance type,
#'     in MB/s.
#' 
#' -   `ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps` - The
#'     maximum bandwidth performance for an EBS-optimized instance type, in
#'     Mbps.
#' 
#' -   `ebs-info.ebs-optimized-info.maximum-iops` - The maximum
#'     input/output storage operations per second for an EBS-optimized
#'     instance type.
#' 
#' -   `ebs-info.ebs-optimized-info.maximum-throughput-in-mbps` - The
#'     maximum throughput performance for an EBS-optimized instance type,
#'     in MB/s.
#' 
#' -   `ebs-info.ebs-optimized-support` - Indicates whether the instance
#'     type is EBS-optimized (`supported` | `unsupported` | `default`).
#' 
#' -   `ebs-info.encryption-support` - Indicates whether EBS encryption is
#'     supported (`supported` | `unsupported`).
#' 
#' -   `ebs-info.nvme-support` - Indicates whether non-volatile memory
#'     express (NVMe) is supported for EBS volumes (`required` |
#'     `supported` | `unsupported`).
#' 
#' -   `free-tier-eligible` - Indicates whether the instance type is
#'     eligible to use in the free tier (`true` | `false`).
#' 
#' -   `hibernation-supported` - Indicates whether On-Demand hibernation is
#'     supported (`true` | `false`).
#' 
#' -   `hypervisor` - The hypervisor (`nitro` | `xen`).
#' 
#' -   `instance-storage-info.disk.count` - The number of local disks.
#' 
#' -   `instance-storage-info.disk.size-in-gb` - The storage size of each
#'     instance storage disk, in GB.
#' 
#' -   `instance-storage-info.disk.type` - The storage technology for the
#'     local instance storage disks (`hdd` | `ssd`).
#' 
#' -   `instance-storage-info.encryption-support` - Indicates whether data
#'     is encrypted at rest (`required` | `supported` | `unsupported`).
#' 
#' -   `instance-storage-info.nvme-support` - Indicates whether
#'     non-volatile memory express (NVMe) is supported for instance store
#'     (`required` | `supported` | `unsupported`).
#' 
#' -   `instance-storage-info.total-size-in-gb` - The total amount of
#'     storage available from all local instance storage, in GB.
#' 
#' -   `instance-storage-supported` - Indicates whether the instance type
#'     has local instance storage (`true` | `false`).
#' 
#' -   `instance-type` - The instance type (for example `c5.2xlarge` or
#'     c5*).
#' 
#' -   `memory-info.size-in-mib` - The memory size.
#' 
#' -   `network-info.bandwidth-weightings` - For instances that support
#'     bandwidth weighting to boost performance (`default`, `vpc-1`,
#'     `ebs-1`).
#' 
#' -   `network-info.efa-info.maximum-efa-interfaces` - The maximum number
#'     of Elastic Fabric Adapters (EFAs) per instance.
#' 
#' -   `network-info.efa-supported` - Indicates whether the instance type
#'     supports Elastic Fabric Adapter (EFA) (`true` | `false`).
#' 
#' -   `network-info.ena-support` - Indicates whether Elastic Network
#'     Adapter (ENA) is supported or required (`required` | `supported` |
#'     `unsupported`).
#' 
#' -   `network-info.encryption-in-transit-supported` - Indicates whether
#'     the instance type automatically encrypts in-transit traffic between
#'     instances (`true` | `false`).
#' 
#' -   `network-info.ipv4-addresses-per-interface` - The maximum number of
#'     private IPv4 addresses per network interface.
#' 
#' -   `network-info.ipv6-addresses-per-interface` - The maximum number of
#'     private IPv6 addresses per network interface.
#' 
#' -   `network-info.ipv6-supported` - Indicates whether the instance type
#'     supports IPv6 (`true` | `false`).
#' 
#' -   `network-info.maximum-network-cards` - The maximum number of network
#'     cards per instance.
#' 
#' -   `network-info.maximum-network-interfaces` - The maximum number of
#'     network interfaces per instance.
#' 
#' -   `network-info.network-performance` - The network performance (for
#'     example, "25 Gigabit").
#' 
#' -   `nitro-enclaves-support` - Indicates whether Nitro Enclaves is
#'     supported (`supported` | `unsupported`).
#' 
#' -   `nitro-tpm-support` - Indicates whether NitroTPM is supported
#'     (`supported` | `unsupported`).
#' 
#' -   `nitro-tpm-info.supported-versions` - The supported NitroTPM version
#'     (`2.0`).
#' 
#' -   `processor-info.supported-architecture` - The CPU architecture
#'     (`arm64` | `i386` | `x86_64`).
#' 
#' -   `processor-info.sustained-clock-speed-in-ghz` - The CPU clock speed,
#'     in GHz.
#' 
#' -   `processor-info.supported-features` - The supported CPU features
#'     (`amd-sev-snp`).
#' 
#' -   `supported-boot-mode` - The boot mode (`legacy-bios` | `uefi`).
#' 
#' -   `supported-root-device-type` - The root device type (`ebs` |
#'     `instance-store`).
#' 
#' -   `supported-usage-class` - The usage class (`on-demand` | `spot` |
#'     `capacity-block`).
#' 
#' -   `supported-virtualization-type` - The virtualization type (`hvm` |
#'     `paravirtual`).
#' 
#' -   `vcpu-info.default-cores` - The default number of cores for the
#'     instance type.
#' 
#' -   `vcpu-info.default-threads-per-core` - The default number of threads
#'     per core for the instance type.
#' 
#' -   `vcpu-info.default-vcpus` - The default number of vCPUs for the
#'     instance type.
#' 
#' -   `vcpu-info.valid-cores` - The number of cores that can be configured
#'     for the instance type.
#' 
#' -   `vcpu-info.valid-threads-per-core` - The number of threads per core
#'     that can be configured for the instance type. For example, "1" or
#'     "1,2".
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_types
ec2_describe_instance_types <- function(DryRun = NULL, InstanceTypes = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceTypes"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instance_types_input(DryRun = DryRun, InstanceTypes = InstanceTypes, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_types_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_types <- ec2_describe_instance_types

#' Describes the specified instances or all instances
#'
#' @description
#' Describes the specified instances or all instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_instances/) for full documentation.
#'
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `affinity` - The affinity setting for an instance running on a
#'     Dedicated Host (`default` | `host`).
#' 
#' -   `architecture` - The instance architecture (`i386` | `x86_64` |
#'     `arm64`).
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `block-device-mapping.attach-time` - The attach time for an EBS
#'     volume mapped to the instance, for example,
#'     `2022-09-15T17:15:20.000Z`.
#' 
#' -   `block-device-mapping.delete-on-termination` - A Boolean that
#'     indicates whether the EBS volume is deleted on instance termination.
#' 
#' -   `block-device-mapping.device-name` - The device name specified in
#'     the block device mapping (for example, `/dev/sdh` or `xvdh`).
#' 
#' -   `block-device-mapping.status` - The status for the EBS volume
#'     (`attaching` | `attached` | `detaching` | `detached`).
#' 
#' -   `block-device-mapping.volume-id` - The volume ID of the EBS volume.
#' 
#' -   `boot-mode` - The boot mode that was specified by the AMI
#'     (`legacy-bios` | `uefi` | `uefi-preferred`).
#' 
#' -   `capacity-reservation-id` - The ID of the Capacity Reservation into
#'     which the instance was launched.
#' 
#' -   `capacity-reservation-specification.capacity-reservation-preference` -
#'     The instance's Capacity Reservation preference (`open` | `none`).
#' 
#' -   `capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id` -
#'     The ID of the targeted Capacity Reservation.
#' 
#' -   `capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn` -
#'     The ARN of the targeted Capacity Reservation group.
#' 
#' -   `client-token` - The idempotency token you provided when you
#'     launched the instance.
#' 
#' -   `current-instance-boot-mode` - The boot mode that is used to launch
#'     the instance at launch or start (`legacy-bios` | `uefi`).
#' 
#' -   `dns-name` - The public DNS name of the instance.
#' 
#' -   `ebs-optimized` - A Boolean that indicates whether the instance is
#'     optimized for Amazon EBS I/O.
#' 
#' -   `ena-support` - A Boolean that indicates whether the instance is
#'     enabled for enhanced networking with ENA.
#' 
#' -   `enclave-options.enabled` - A Boolean that indicates whether the
#'     instance is enabled for Amazon Web Services Nitro Enclaves.
#' 
#' -   `hibernation-options.configured` - A Boolean that indicates whether
#'     the instance is enabled for hibernation. A value of `true` means
#'     that the instance is enabled for hibernation.
#' 
#' -   `host-id` - The ID of the Dedicated Host on which the instance is
#'     running, if applicable.
#' 
#' -   `hypervisor` - The hypervisor type of the instance (`ovm` | `xen`).
#'     The value `xen` is used for both Xen and Nitro hypervisors.
#' 
#' -   `iam-instance-profile.arn` - The instance profile associated with
#'     the instance. Specified as an ARN.
#' 
#' -   `iam-instance-profile.id` - The instance profile associated with the
#'     instance. Specified as an ID.
#' 
#' -   `image-id` - The ID of the image used to launch the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `instance-lifecycle` - Indicates whether this is a Spot Instance, a
#'     Scheduled Instance, or a Capacity Block (`spot` | `scheduled` |
#'     `capacity-block`).
#' 
#' -   `instance-state-code` - The state of the instance, as a 16-bit
#'     unsigned integer. The high byte is used for internal purposes and
#'     should be ignored. The low byte is set based on the state
#'     represented. The valid values are: 0 (pending), 16 (running), 32
#'     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
#' 
#' -   `instance-state-name` - The state of the instance (`pending` |
#'     `running` | `shutting-down` | `terminated` | `stopping` |
#'     `stopped`).
#' 
#' -   `instance-type` - The type of instance (for example, `t2.micro`).
#' 
#' -   `instance.group-id` - The ID of the security group for the instance.
#' 
#' -   `instance.group-name` - The name of the security group for the
#'     instance.
#' 
#' -   `ip-address` - The public IPv4 address of the instance.
#' 
#' -   `ipv6-address` - The IPv6 address of the instance.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `key-name` - The name of the key pair used when the instance was
#'     launched.
#' 
#' -   `launch-index` - When launching multiple instances, this is the
#'     index for the instance in the launch group (for example, 0, 1, 2,
#'     and so on).
#' 
#' -   `launch-time` - The time when the instance was launched, in the ISO
#'     8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for
#'     example, `2021-09-29T11:04:43.305Z`. You can use a wildcard (`*`),
#'     for example, `2021-09-29T*`, which matches an entire day.
#' 
#' -   `maintenance-options.auto-recovery` - The current automatic recovery
#'     behavior of the instance (`disabled` | `default`).
#' 
#' -   `metadata-options.http-endpoint` - The status of access to the HTTP
#'     metadata endpoint on your instance (`enabled` | `disabled`)
#' 
#' -   `metadata-options.http-protocol-ipv4` - Indicates whether the IPv4
#'     endpoint is enabled (`disabled` | `enabled`).
#' 
#' -   `metadata-options.http-protocol-ipv6` - Indicates whether the IPv6
#'     endpoint is enabled (`disabled` | `enabled`).
#' 
#' -   `metadata-options.http-put-response-hop-limit` - The HTTP metadata
#'     request put response hop limit (integer, possible values `1` to
#'     `64`)
#' 
#' -   `metadata-options.http-tokens` - The metadata request authorization
#'     state (`optional` | `required`)
#' 
#' -   `metadata-options.instance-metadata-tags` - The status of access to
#'     instance tags from the instance metadata (`enabled` | `disabled`)
#' 
#' -   `metadata-options.state` - The state of the metadata option changes
#'     (`pending` | `applied`).
#' 
#' -   `monitoring-state` - Indicates whether detailed monitoring is
#'     enabled (`disabled` | `enabled`).
#' 
#' -   `network-interface.addresses.association.allocation-id` - The
#'     allocation ID.
#' 
#' -   `network-interface.addresses.association.association-id` - The
#'     association ID.
#' 
#' -   `network-interface.addresses.association.carrier-ip` - The carrier
#'     IP address.
#' 
#' -   `network-interface.addresses.association.customer-owned-ip` - The
#'     customer-owned IP address.
#' 
#' -   `network-interface.addresses.association.ip-owner-id` - The owner ID
#'     of the private IPv4 address associated with the network interface.
#' 
#' -   `network-interface.addresses.association.public-dns-name` - The
#'     public DNS name.
#' 
#' -   `network-interface.addresses.association.public-ip` - The ID of the
#'     association of an Elastic IP address (IPv4) with a network
#'     interface.
#' 
#' -   `network-interface.addresses.primary` - Specifies whether the IPv4
#'     address of the network interface is the primary private IPv4
#'     address.
#' 
#' -   `network-interface.addresses.private-dns-name` - The private DNS
#'     name.
#' 
#' -   `network-interface.addresses.private-ip-address` - The private IPv4
#'     address associated with the network interface.
#' 
#' -   `network-interface.association.allocation-id` - The allocation ID
#'     returned when you allocated the Elastic IP address (IPv4) for your
#'     network interface.
#' 
#' -   `network-interface.association.association-id` - The association ID
#'     returned when the network interface was associated with an IPv4
#'     address.
#' 
#' -   `network-interface.association.carrier-ip` - The customer-owned IP
#'     address.
#' 
#' -   `network-interface.association.customer-owned-ip` - The
#'     customer-owned IP address.
#' 
#' -   `network-interface.association.ip-owner-id` - The owner of the
#'     Elastic IP address (IPv4) associated with the network interface.
#' 
#' -   `network-interface.association.public-dns-name` - The public DNS
#'     name.
#' 
#' -   `network-interface.association.public-ip` - The address of the
#'     Elastic IP address (IPv4) bound to the network interface.
#' 
#' -   `network-interface.attachment.attach-time` - The time that the
#'     network interface was attached to an instance.
#' 
#' -   `network-interface.attachment.attachment-id` - The ID of the
#'     interface attachment.
#' 
#' -   `network-interface.attachment.delete-on-termination` - Specifies
#'     whether the attachment is deleted when an instance is terminated.
#' 
#' -   `network-interface.attachment.device-index` - The device index to
#'     which the network interface is attached.
#' 
#' -   `network-interface.attachment.instance-id` - The ID of the instance
#'     to which the network interface is attached.
#' 
#' -   `network-interface.attachment.instance-owner-id` - The owner ID of
#'     the instance to which the network interface is attached.
#' 
#' -   `network-interface.attachment.network-card-index` - The index of the
#'     network card.
#' 
#' -   `network-interface.attachment.status` - The status of the attachment
#'     (`attaching` | `attached` | `detaching` | `detached`).
#' 
#' -   `network-interface.availability-zone` - The Availability Zone for
#'     the network interface.
#' 
#' -   `network-interface.deny-all-igw-traffic` - A Boolean that indicates
#'     whether a network interface with an IPv6 address is unreachable from
#'     the public internet.
#' 
#' -   `network-interface.description` - The description of the network
#'     interface.
#' 
#' -   `network-interface.group-id` - The ID of a security group associated
#'     with the network interface.
#' 
#' -   `network-interface.group-name` - The name of a security group
#'     associated with the network interface.
#' 
#' -   `network-interface.ipv4-prefixes.ipv4-prefix` - The IPv4 prefixes
#'     that are assigned to the network interface.
#' 
#' -   `network-interface.ipv6-address` - The IPv6 address associated with
#'     the network interface.
#' 
#' -   `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
#'     associated with the network interface.
#' 
#' -   `network-interface.ipv6-addresses.is-primary-ipv6` - A Boolean that
#'     indicates whether this is the primary IPv6 address.
#' 
#' -   `network-interface.ipv6-native` - A Boolean that indicates whether
#'     this is an IPv6 only network interface.
#' 
#' -   `network-interface.ipv6-prefixes.ipv6-prefix` - The IPv6 prefix
#'     assigned to the network interface.
#' 
#' -   `network-interface.mac-address` - The MAC address of the network
#'     interface.
#' 
#' -   `network-interface.network-interface-id` - The ID of the network
#'     interface.
#' 
#' -   `network-interface.operator.managed` - A Boolean that indicates
#'     whether the instance has a managed network interface.
#' 
#' -   `network-interface.operator.principal` - The principal that manages
#'     the network interface. Only valid for instances with managed network
#'     interfaces, where `managed` is `true`.
#' 
#' -   `network-interface.outpost-arn` - The ARN of the Outpost.
#' 
#' -   `network-interface.owner-id` - The ID of the owner of the network
#'     interface.
#' 
#' -   `network-interface.private-dns-name` - The private DNS name of the
#'     network interface.
#' 
#' -   `network-interface.private-ip-address` - The private IPv4 address.
#' 
#' -   `network-interface.public-dns-name` - The public DNS name.
#' 
#' -   `network-interface.requester-id` - The requester ID for the network
#'     interface.
#' 
#' -   `network-interface.requester-managed` - Indicates whether the
#'     network interface is being managed by Amazon Web Services.
#' 
#' -   `network-interface.status` - The status of the network interface
#'     (`available`) | `in-use`).
#' 
#' -   `network-interface.source-dest-check` - Whether the network
#'     interface performs source/destination checking. A value of `true`
#'     means that checking is enabled, and `false` means that checking is
#'     disabled. The value must be `false` for the network interface to
#'     perform network address translation (NAT) in your VPC.
#' 
#' -   `network-interface.subnet-id` - The ID of the subnet for the network
#'     interface.
#' 
#' -   `network-interface.tag-key` - The key of a tag assigned to the
#'     network interface.
#' 
#' -   `network-interface.tag-value` - The value of a tag assigned to the
#'     network interface.
#' 
#' -   `network-interface.vpc-id` - The ID of the VPC for the network
#'     interface.
#' 
#' -   `network-performance-options.bandwidth-weighting` - Where the
#'     performance boost is applied, if applicable. Valid values:
#'     `default`, `vpc-1`, `ebs-1`.
#' 
#' -   `operator.managed` - A Boolean that indicates whether this is a
#'     managed instance.
#' 
#' -   `operator.principal` - The principal that manages the instance. Only
#'     valid for managed instances, where `managed` is `true`.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the instance
#'     owner.
#' 
#' -   `placement-group-name` - The name of the placement group for the
#'     instance.
#' 
#' -   `placement-partition-number` - The partition in which the instance
#'     is located.
#' 
#' -   `platform` - The platform. To list only Windows instances, use
#'     `windows`.
#' 
#' -   `platform-details` - The platform (`Linux/UNIX` |
#'     `Red Hat BYOL Linux` | ` Red Hat Enterprise Linux` |
#'     `Red Hat Enterprise Linux with HA` |
#'     `Red Hat Enterprise Linux with SQL Server Standard and HA` |
#'     `Red Hat Enterprise Linux with SQL Server Enterprise and HA` |
#'     `Red Hat Enterprise Linux with SQL Server Standard` |
#'     `Red Hat Enterprise Linux with SQL Server Web` |
#'     `Red Hat Enterprise Linux with SQL Server Enterprise` |
#'     `SQL Server Enterprise` | `SQL Server Standard` | `SQL Server Web` |
#'     `SUSE Linux` | `Ubuntu Pro` | `Windows` | `Windows BYOL` |
#'     `Windows with SQL Server Enterprise` |
#'     `Windows with SQL Server Standard` | `Windows with SQL Server Web`).
#' 
#' -   `private-dns-name` - The private IPv4 DNS name of the instance.
#' 
#' -   `private-dns-name-options.enable-resource-name-dns-a-record` - A
#'     Boolean that indicates whether to respond to DNS queries for
#'     instance hostnames with DNS A records.
#' 
#' -   `private-dns-name-options.enable-resource-name-dns-aaaa-record` - A
#'     Boolean that indicates whether to respond to DNS queries for
#'     instance hostnames with DNS AAAA records.
#' 
#' -   `private-dns-name-options.hostname-type` - The type of hostname
#'     (`ip-name` | `resource-name`).
#' 
#' -   `private-ip-address` - The private IPv4 address of the instance.
#'     This can only be used to filter by the primary IP address of the
#'     network interface attached to the instance. To filter by additional
#'     IP addresses assigned to the network interface, use the filter
#'     `network-interface.addresses.private-ip-address`.
#' 
#' -   `product-code` - The product code associated with the AMI used to
#'     launch the instance.
#' 
#' -   `product-code.type` - The type of product code (`devpay` |
#'     `marketplace`).
#' 
#' -   `ramdisk-id` - The RAM disk ID.
#' 
#' -   `reason` - The reason for the current state of the instance (for
#'     example, shows "User Initiated \[date\]" when you stop or terminate
#'     the instance). Similar to the state-reason-code filter.
#' 
#' -   `requester-id` - The ID of the entity that launched the instance on
#'     your behalf (for example, Amazon Web Services Management Console,
#'     Auto Scaling, and so on).
#' 
#' -   `reservation-id` - The ID of the instance's reservation. A
#'     reservation ID is created any time you launch an instance. A
#'     reservation ID has a one-to-one relationship with an instance launch
#'     request, but can be associated with more than one instance if you
#'     launch multiple instances using the same launch request. For
#'     example, if you launch one instance, you get one reservation ID. If
#'     you launch ten instances using the same launch request, you also get
#'     one reservation ID.
#' 
#' -   `root-device-name` - The device name of the root device volume (for
#'     example, `/dev/sda1`).
#' 
#' -   `root-device-type` - The type of the root device volume (`ebs` |
#'     `instance-store`).
#' 
#' -   `source-dest-check` - Indicates whether the instance performs
#'     source/destination checking. A value of `true` means that checking
#'     is enabled, and `false` means that checking is disabled. The value
#'     must be `false` for the instance to perform network address
#'     translation (NAT) in your VPC.
#' 
#' -   `spot-instance-request-id` - The ID of the Spot Instance request.
#' 
#' -   `state-reason-code` - The reason code for the state change.
#' 
#' -   `state-reason-message` - A message that describes the state change.
#' 
#' -   `subnet-id` - The ID of the subnet for the instance.
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tenancy` - The tenancy of an instance (`dedicated` | `default` |
#'     `host`).
#' 
#' -   `tpm-support` - Indicates if the instance is configured for NitroTPM
#'     support (`v2.0`).
#' 
#' -   `usage-operation` - The usage operation value for the instance
#'     ([`run_instances`][ec2_run_instances] | `RunInstances:00g0` |
#'     `RunInstances:0010` | `RunInstances:1010` | `RunInstances:1014` |
#'     `RunInstances:1110` | `RunInstances:0014` | `RunInstances:0210` |
#'     `RunInstances:0110` | `RunInstances:0100` | `RunInstances:0004` |
#'     `RunInstances:0200` | `RunInstances:000g` | `RunInstances:0g00` |
#'     `RunInstances:0002` | `RunInstances:0800` | `RunInstances:0102` |
#'     `RunInstances:0006` | `RunInstances:0202`).
#' 
#' -   `usage-operation-update-time` - The time that the usage operation
#'     was last updated, for example, `2022-09-15T17:15:20.000Z`.
#' 
#' -   `virtualization-type` - The virtualization type of the instance
#'     (`paravirtual` | `hvm`).
#' 
#' -   `vpc-id` - The ID of the VPC that the instance is running in.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' You cannot specify this parameter and the instance IDs parameter in the
#' same request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instances
ec2_describe_instances <- function(InstanceIds = NULL, DryRun = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Reservations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_instances_input(InstanceIds = InstanceIds, DryRun = DryRun, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instances <- ec2_describe_instances

#' Describes your internet gateways
#'
#' @description
#' Describes your internet gateways. The default is to describe all your internet gateways. Alternatively, you can specify specific internet gateway IDs or filter the results to include only the internet gateways that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_internet_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_internet_gateways/) for full documentation.
#'
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayIds The IDs of the internet gateways.
#' 
#' Default: Describes all your internet gateways.
#' @param Filters The filters.
#' 
#' -   `attachment.state` - The current state of the attachment between the
#'     gateway and the VPC (`available`). Present only if a VPC is
#'     attached.
#' 
#' -   `attachment.vpc-id` - The ID of an attached VPC.
#' 
#' -   `internet-gateway-id` - The ID of the Internet gateway.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     internet gateway.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_internet_gateways
ec2_describe_internet_gateways <- function(NextToken = NULL, MaxResults = NULL, DryRun = NULL, InternetGatewayIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeInternetGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InternetGateways"),
    stream_api = FALSE
  )
  input <- .ec2$describe_internet_gateways_input(NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, InternetGatewayIds = InternetGatewayIds, Filters = Filters)
  output <- .ec2$describe_internet_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_internet_gateways <- ec2_describe_internet_gateways

#' Describes your Autonomous System Numbers (ASNs), their provisioning
#' statuses, and the BYOIP CIDRs with which they are associated
#'
#' @description
#' Describes your Autonomous System Numbers (ASNs), their provisioning statuses, and the BYOIP CIDRs with which they are associated. For more information, see [Tutorial: Bring your ASN to IPAM](https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html) in the *Amazon VPC IPAM guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipam_byoasn/](https://www.paws-r-sdk.com/docs/ec2_describe_ipam_byoasn/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipam_byoasn
ec2_describe_ipam_byoasn <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeIpamByoasn",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipam_byoasn_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_ipam_byoasn_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipam_byoasn <- ec2_describe_ipam_byoasn

#' Describe verification tokens
#'
#' @description
#' Describe verification tokens. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipam_external_resource_verification_tokens/](https://www.paws-r-sdk.com/docs/ec2_describe_ipam_external_resource_verification_tokens/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters for the request. For more information about
#' filtering, see [Filtering CLI
#' output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
#' 
#' Available filters:
#' 
#' -   `ipam-arn`
#' 
#' -   `ipam-external-resource-verification-token-arn`
#' 
#' -   `ipam-external-resource-verification-token-id`
#' 
#' -   `ipam-id`
#' 
#' -   `ipam-region`
#' 
#' -   `state`
#' 
#' -   `status`
#' 
#' -   `token-name`
#' 
#' -   `token-value`
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of tokens to return in one page of results.
#' @param IpamExternalResourceVerificationTokenIds Verification token IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipam_external_resource_verification_tokens
ec2_describe_ipam_external_resource_verification_tokens <- function(DryRun = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL, IpamExternalResourceVerificationTokenIds = NULL) {
  op <- new_operation(
    name = "DescribeIpamExternalResourceVerificationTokens",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipam_external_resource_verification_tokens_input(DryRun = DryRun, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, IpamExternalResourceVerificationTokenIds = IpamExternalResourceVerificationTokenIds)
  output <- .ec2$describe_ipam_external_resource_verification_tokens_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipam_external_resource_verification_tokens <- ec2_describe_ipam_external_resource_verification_tokens

#' Get information about your IPAM pools
#'
#' @description
#' Get information about your IPAM pools.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipam_pools/](https://www.paws-r-sdk.com/docs/ec2_describe_ipam_pools/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters for the request. For more information about
#' filtering, see [Filtering CLI
#' output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
#' @param MaxResults The maximum number of results to return in the request.
#' @param NextToken The token for the next page of results.
#' @param IpamPoolIds The IDs of the IPAM pools you would like information on.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipam_pools
ec2_describe_ipam_pools <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, IpamPoolIds = NULL) {
  op <- new_operation(
    name = "DescribeIpamPools",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "IpamPools"),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipam_pools_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, IpamPoolIds = IpamPoolIds)
  output <- .ec2$describe_ipam_pools_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipam_pools <- ec2_describe_ipam_pools

#' Describes IPAM resource discoveries
#'
#' @description
#' Describes IPAM resource discoveries. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipam_resource_discoveries/](https://www.paws-r-sdk.com/docs/ec2_describe_ipam_resource_discoveries/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamResourceDiscoveryIds The IPAM resource discovery IDs.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param MaxResults The maximum number of resource discoveries to return in one page of
#' results.
#' @param Filters The resource discovery filters.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipam_resource_discoveries
ec2_describe_ipam_resource_discoveries <- function(DryRun = NULL, IpamResourceDiscoveryIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeIpamResourceDiscoveries",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "IpamResourceDiscoveries"),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipam_resource_discoveries_input(DryRun = DryRun, IpamResourceDiscoveryIds = IpamResourceDiscoveryIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ec2$describe_ipam_resource_discoveries_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipam_resource_discoveries <- ec2_describe_ipam_resource_discoveries

#' Describes resource discovery association with an Amazon VPC IPAM
#'
#' @description
#' Describes resource discovery association with an Amazon VPC IPAM. An associated resource discovery is a resource discovery that has been associated with an IPAM..
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipam_resource_discovery_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_ipam_resource_discovery_associations/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param IpamResourceDiscoveryAssociationIds The resource discovery association IDs.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param MaxResults The maximum number of resource discovery associations to return in one
#' page of results.
#' @param Filters The resource discovery association filters.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipam_resource_discovery_associations
ec2_describe_ipam_resource_discovery_associations <- function(DryRun = NULL, IpamResourceDiscoveryAssociationIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeIpamResourceDiscoveryAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "IpamResourceDiscoveryAssociations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipam_resource_discovery_associations_input(DryRun = DryRun, IpamResourceDiscoveryAssociationIds = IpamResourceDiscoveryAssociationIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ec2$describe_ipam_resource_discovery_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipam_resource_discovery_associations <- ec2_describe_ipam_resource_discovery_associations

#' Get information about your IPAM scopes
#'
#' @description
#' Get information about your IPAM scopes.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipam_scopes/](https://www.paws-r-sdk.com/docs/ec2_describe_ipam_scopes/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters for the request. For more information about
#' filtering, see [Filtering CLI
#' output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
#' @param MaxResults The maximum number of results to return in the request.
#' @param NextToken The token for the next page of results.
#' @param IpamScopeIds The IDs of the scopes you want information on.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipam_scopes
ec2_describe_ipam_scopes <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, IpamScopeIds = NULL) {
  op <- new_operation(
    name = "DescribeIpamScopes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "IpamScopes"),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipam_scopes_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, IpamScopeIds = IpamScopeIds)
  output <- .ec2$describe_ipam_scopes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipam_scopes <- ec2_describe_ipam_scopes

#' Get information about your IPAM pools
#'
#' @description
#' Get information about your IPAM pools.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipams/](https://www.paws-r-sdk.com/docs/ec2_describe_ipams/) for full documentation.
#'
#' @param DryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters for the request. For more information about
#' filtering, see [Filtering CLI
#' output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
#' @param MaxResults The maximum number of results to return in the request.
#' @param NextToken The token for the next page of results.
#' @param IpamIds The IDs of the IPAMs you want information on.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipams
ec2_describe_ipams <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, IpamIds = NULL) {
  op <- new_operation(
    name = "DescribeIpams",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Ipams"),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipams_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, IpamIds = IpamIds)
  output <- .ec2$describe_ipams_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipams <- ec2_describe_ipams

#' Describes your IPv6 address pools
#'
#' @description
#' Describes your IPv6 address pools.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_ipv_6_pools/](https://www.paws-r-sdk.com/docs/ec2_describe_ipv_6_pools/) for full documentation.
#'
#' @param PoolIds The IDs of the IPv6 address pools.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_ipv_6_pools
ec2_describe_ipv_6_pools <- function(PoolIds = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeIpv6Pools",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Ipv6Pools"),
    stream_api = FALSE
  )
  input <- .ec2$describe_ipv_6_pools_input(PoolIds = PoolIds, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_ipv_6_pools_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_ipv_6_pools <- ec2_describe_ipv_6_pools

#' Describes the specified key pairs or all of your key pairs
#'
#' @description
#' Describes the specified key pairs or all of your key pairs.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_key_pairs/](https://www.paws-r-sdk.com/docs/ec2_describe_key_pairs/) for full documentation.
#'
#' @param KeyNames The key pair names.
#' 
#' Default: Describes all of your key pairs.
#' @param KeyPairIds The IDs of the key pairs.
#' @param IncludePublicKey If `true`, the public key material is included in the response.
#' 
#' Default: `false`
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `key-pair-id` - The ID of the key pair.
#' 
#' -   `fingerprint` - The fingerprint of the key pair.
#' 
#' -   `key-name` - The name of the key pair.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_key_pairs
ec2_describe_key_pairs <- function(KeyNames = NULL, KeyPairIds = NULL, IncludePublicKey = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeKeyPairs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_key_pairs_input(KeyNames = KeyNames, KeyPairIds = KeyPairIds, IncludePublicKey = IncludePublicKey, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_key_pairs_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_key_pairs <- ec2_describe_key_pairs

#' Describes one or more versions of a specified launch template
#'
#' @description
#' Describes one or more versions of a specified launch template. You can describe all versions, individual versions, or a range of versions. You can also describe all the latest versions or all the default versions of all the launch templates in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_launch_template_versions/](https://www.paws-r-sdk.com/docs/ec2_describe_launch_template_versions/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template.
#' 
#' To describe one or more versions of a specified launch template, you
#' must specify either the launch template ID or the launch template name,
#' but not both.
#' 
#' To describe all the latest or default launch template versions in your
#' account, you must omit this parameter.
#' @param LaunchTemplateName The name of the launch template.
#' 
#' To describe one or more versions of a specified launch template, you
#' must specify either the launch template name or the launch template ID,
#' but not both.
#' 
#' To describe all the latest or default launch template versions in your
#' account, you must omit this parameter.
#' @param Versions One or more versions of the launch template. Valid values depend on
#' whether you are describing a specified launch template (by ID or name)
#' or all launch templates in your account.
#' 
#' To describe one or more versions of a specified launch template, valid
#' values are `$Latest`, `$Default`, and numbers.
#' 
#' To describe all launch templates in your account that are defined as the
#' latest version, the valid value is `$Latest`. To describe all launch
#' templates in your account that are defined as the default version, the
#' valid value is `$Default`. You can specify `$Latest` and `$Default` in
#' the same request. You cannot specify numbers.
#' @param MinVersion The version number after which to describe launch template versions.
#' @param MaxVersion The version number up to which to describe launch template versions.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 1 and 200.
#' @param Filters One or more filters.
#' 
#' -   `create-time` - The time the launch template version was created.
#' 
#' -   `ebs-optimized` - A boolean that indicates whether the instance is
#'     optimized for Amazon EBS I/O.
#' 
#' -   `http-endpoint` - Indicates whether the HTTP metadata endpoint on
#'     your instances is enabled (`enabled` | `disabled`).
#' 
#' -   `http-protocol-ipv4` - Indicates whether the IPv4 endpoint for the
#'     instance metadata service is enabled (`enabled` | `disabled`).
#' 
#' -   `host-resource-group-arn` - The ARN of the host resource group in
#'     which to launch the instances.
#' 
#' -   `http-tokens` - The state of token usage for your instance metadata
#'     requests (`optional` | `required`).
#' 
#' -   `iam-instance-profile` - The ARN of the IAM instance profile.
#' 
#' -   `image-id` - The ID of the AMI.
#' 
#' -   `instance-type` - The instance type.
#' 
#' -   `is-default-version` - A boolean that indicates whether the launch
#'     template version is the default version.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `license-configuration-arn` - The ARN of the license configuration.
#' 
#' -   `network-card-index` - The index of the network card.
#' 
#' -   `ram-disk-id` - The RAM disk ID.
#' @param ResolveAlias If `true`, and if a Systems Manager parameter is specified for
#' `ImageId`, the AMI ID is displayed in the response for `imageId`.
#' 
#' If `false`, and if a Systems Manager parameter is specified for
#' `ImageId`, the parameter is displayed in the response for `imageId`.
#' 
#' For more information, see [Use a Systems Manager parameter instead of an
#' AMI
#' ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#use-an-ssm-parameter-instead-of-an-ami-id)
#' in the *Amazon EC2 User Guide*.
#' 
#' Default: `false`
#'
#' @keywords internal
#'
#' @rdname ec2_describe_launch_template_versions
ec2_describe_launch_template_versions <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, Versions = NULL, MinVersion = NULL, MaxVersion = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL, ResolveAlias = NULL) {
  op <- new_operation(
    name = "DescribeLaunchTemplateVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LaunchTemplateVersions"),
    stream_api = FALSE
  )
  input <- .ec2$describe_launch_template_versions_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, Versions = Versions, MinVersion = MinVersion, MaxVersion = MaxVersion, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, ResolveAlias = ResolveAlias)
  output <- .ec2$describe_launch_template_versions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_launch_template_versions <- ec2_describe_launch_template_versions

#' Describes one or more launch templates
#'
#' @description
#' Describes one or more launch templates.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_launch_templates/](https://www.paws-r-sdk.com/docs/ec2_describe_launch_templates/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateIds One or more launch template IDs.
#' @param LaunchTemplateNames One or more launch template names.
#' @param Filters One or more filters.
#' 
#' -   `create-time` - The time the launch template was created.
#' 
#' -   `launch-template-name` - The name of the launch template.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 1 and 200.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_launch_templates
ec2_describe_launch_templates <- function(DryRun = NULL, LaunchTemplateIds = NULL, LaunchTemplateNames = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeLaunchTemplates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LaunchTemplates"),
    stream_api = FALSE
  )
  input <- .ec2$describe_launch_templates_input(DryRun = DryRun, LaunchTemplateIds = LaunchTemplateIds, LaunchTemplateNames = LaunchTemplateNames, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_launch_templates_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_launch_templates <- ec2_describe_launch_templates

#' Describes the associations between virtual interface groups and local
#' gateway route tables
#'
#' @description
#' Describes the associations between virtual interface groups and local gateway route tables.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_route_table_virtual_interface_group_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_route_table_virtual_interface_group_associations/) for full documentation.
#'
#' @param LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds The IDs of the associations.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-arn` - The Amazon Resource Name (ARN) of
#'     the local gateway route table for the virtual interface group.
#' 
#' -   `local-gateway-route-table-id` - The ID of the local gateway route
#'     table.
#' 
#' -   `local-gateway-route-table-virtual-interface-group-association-id` -
#'     The ID of the association.
#' 
#' -   `local-gateway-route-table-virtual-interface-group-id` - The ID of
#'     the virtual interface group.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     local gateway virtual interface group association.
#' 
#' -   `state` - The state of the association.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_descr_local_gatew_route_table_virtu_inter_group_assoc
ec2_describe_local_gateway_route_table_virtual_interface_group_associations <- function(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LocalGatewayRouteTableVirtualInterfaceGroupAssociations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_local_gateway_route_table_virtual_interface_group_associations_input(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_table_virtual_interface_group_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_table_virtual_interface_group_associations <- ec2_describe_local_gateway_route_table_virtual_interface_group_associations

#' Describes the specified associations between VPCs and local gateway
#' route tables
#'
#' @description
#' Describes the specified associations between VPCs and local gateway route tables.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_route_table_vpc_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_route_table_vpc_associations/) for full documentation.
#'
#' @param LocalGatewayRouteTableVpcAssociationIds The IDs of the associations.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-arn` - The Amazon Resource Name (ARN) of
#'     the local gateway route table for the association.
#' 
#' -   `local-gateway-route-table-id` - The ID of the local gateway route
#'     table.
#' 
#' -   `local-gateway-route-table-vpc-association-id` - The ID of the
#'     association.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     local gateway route table for the association.
#' 
#' -   `state` - The state of the association.
#' 
#' -   `vpc-id` - The ID of the VPC.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_table_vpc_associations
ec2_describe_local_gateway_route_table_vpc_associations <- function(LocalGatewayRouteTableVpcAssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTableVpcAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LocalGatewayRouteTableVpcAssociations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_local_gateway_route_table_vpc_associations_input(LocalGatewayRouteTableVpcAssociationIds = LocalGatewayRouteTableVpcAssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_table_vpc_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_table_vpc_associations <- ec2_describe_local_gateway_route_table_vpc_associations

#' Describes one or more local gateway route tables
#'
#' @description
#' Describes one or more local gateway route tables. By default, all local gateway route tables are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_route_tables/](https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_route_tables/) for full documentation.
#'
#' @param LocalGatewayRouteTableIds The IDs of the local gateway route tables.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-route-table-arn` - The Amazon Resource Name (ARN) of
#'     the local gateway route table.
#' 
#' -   `local-gateway-route-table-id` - The ID of a local gateway route
#'     table.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     local gateway route table.
#' 
#' -   `state` - The state of the local gateway route table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_tables
ec2_describe_local_gateway_route_tables <- function(LocalGatewayRouteTableIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LocalGatewayRouteTables"),
    stream_api = FALSE
  )
  input <- .ec2$describe_local_gateway_route_tables_input(LocalGatewayRouteTableIds = LocalGatewayRouteTableIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_tables <- ec2_describe_local_gateway_route_tables

#' Describes the specified local gateway virtual interface groups
#'
#' @description
#' Describes the specified local gateway virtual interface groups.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_virtual_interface_groups/](https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_virtual_interface_groups/) for full documentation.
#'
#' @param LocalGatewayVirtualInterfaceGroupIds The IDs of the virtual interface groups.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `local-gateway-virtual-interface-group-id` - The ID of the virtual
#'     interface group.
#' 
#' -   `local-gateway-virtual-interface-id` - The ID of the virtual
#'     interface.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     local gateway virtual interface group.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_virtual_interface_groups
ec2_describe_local_gateway_virtual_interface_groups <- function(LocalGatewayVirtualInterfaceGroupIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayVirtualInterfaceGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LocalGatewayVirtualInterfaceGroups"),
    stream_api = FALSE
  )
  input <- .ec2$describe_local_gateway_virtual_interface_groups_input(LocalGatewayVirtualInterfaceGroupIds = LocalGatewayVirtualInterfaceGroupIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_virtual_interface_groups_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_virtual_interface_groups <- ec2_describe_local_gateway_virtual_interface_groups

#' Describes the specified local gateway virtual interfaces
#'
#' @description
#' Describes the specified local gateway virtual interfaces.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_virtual_interfaces/](https://www.paws-r-sdk.com/docs/ec2_describe_local_gateway_virtual_interfaces/) for full documentation.
#'
#' @param LocalGatewayVirtualInterfaceIds The IDs of the virtual interfaces.
#' @param Filters One or more filters.
#' 
#' -   `local-address` - The local address.
#' 
#' -   `local-bgp-asn` - The Border Gateway Protocol (BGP) Autonomous
#'     System Number (ASN) of the local gateway.
#' 
#' -   `local-gateway-id` - The ID of the local gateway.
#' 
#' -   `local-gateway-virtual-interface-id` - The ID of the virtual
#'     interface.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     local gateway virtual interface.
#' 
#' -   `peer-address` - The peer address.
#' 
#' -   `peer-bgp-asn` - The peer BGP ASN.
#' 
#' -   `vlan` - The ID of the VLAN.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_virtual_interfaces
ec2_describe_local_gateway_virtual_interfaces <- function(LocalGatewayVirtualInterfaceIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayVirtualInterfaces",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LocalGatewayVirtualInterfaces"),
    stream_api = FALSE
  )
  input <- .ec2$describe_local_gateway_virtual_interfaces_input(LocalGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_virtual_interfaces_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_virtual_interfaces <- ec2_describe_local_gateway_virtual_interfaces

#' Describes one or more local gateways
#'
#' @description
#' Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_local_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_local_gateways/) for full documentation.
#'
#' @param LocalGatewayIds The IDs of the local gateways.
#' @param Filters One or more filters.
#' 
#' -   `local-gateway-id` - The ID of a local gateway.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     local gateway.
#' 
#' -   `state` - The state of the association.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateways
ec2_describe_local_gateways <- function(LocalGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LocalGateways"),
    stream_api = FALSE
  )
  input <- .ec2$describe_local_gateways_input(LocalGatewayIds = LocalGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateways <- ec2_describe_local_gateways

#' Describes the lock status for a snapshot
#'
#' @description
#' Describes the lock status for a snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_locked_snapshots/](https://www.paws-r-sdk.com/docs/ec2_describe_locked_snapshots/) for full documentation.
#'
#' @param Filters The filters.
#' 
#' -   `lock-state` - The state of the snapshot lock (`compliance-cooloff`
#'     | `governance` | `compliance` | `expired`).
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param SnapshotIds The IDs of the snapshots for which to view the lock status.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_locked_snapshots
ec2_describe_locked_snapshots <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL, SnapshotIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLockedSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_locked_snapshots_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, SnapshotIds = SnapshotIds, DryRun = DryRun)
  output <- .ec2$describe_locked_snapshots_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_locked_snapshots <- ec2_describe_locked_snapshots

#' Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac
#' Dedicated Hosts
#'
#' @description
#' Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac Dedicated Hosts.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_mac_hosts/](https://www.paws-r-sdk.com/docs/ec2_describe_mac_hosts/) for full documentation.
#'
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone of the EC2 Mac Dedicated
#'     Host.
#' 
#' -   `instance-type` - The instance type size that the EC2 Mac Dedicated
#'     Host is configured to support.
#' @param HostIds The IDs of the EC2 Mac Dedicated Hosts.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param NextToken The token to use to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_mac_hosts
ec2_describe_mac_hosts <- function(Filters = NULL, HostIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMacHosts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "MacHosts"),
    stream_api = FALSE
  )
  input <- .ec2$describe_mac_hosts_input(Filters = Filters, HostIds = HostIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_mac_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_mac_hosts <- ec2_describe_mac_hosts

#' Describes your managed prefix lists and any Amazon Web Services-managed
#' prefix lists
#'
#' @description
#' Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_managed_prefix_lists/](https://www.paws-r-sdk.com/docs/ec2_describe_managed_prefix_lists/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `owner-id` - The ID of the prefix list owner.
#' 
#' -   `prefix-list-id` - The ID of the prefix list.
#' 
#' -   `prefix-list-name` - The name of the prefix list.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param PrefixListIds One or more prefix list IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_managed_prefix_lists
ec2_describe_managed_prefix_lists <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, PrefixListIds = NULL) {
  op <- new_operation(
    name = "DescribeManagedPrefixLists",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PrefixLists"),
    stream_api = FALSE
  )
  input <- .ec2$describe_managed_prefix_lists_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, PrefixListIds = PrefixListIds)
  output <- .ec2$describe_managed_prefix_lists_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_managed_prefix_lists <- ec2_describe_managed_prefix_lists

#' This action is deprecated
#'
#' @description
#' This action is deprecated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_moving_addresses/](https://www.paws-r-sdk.com/docs/ec2_describe_moving_addresses/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PublicIps One or more Elastic IP addresses.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters.
#' 
#' -   `moving-status` - The status of the Elastic IP address
#'     (`MovingToVpc` | `RestoringToClassic`).
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1000; if `MaxResults` is given a value outside of
#' this range, an error is returned.
#' 
#' Default: If no value is provided, the default is 1000.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_moving_addresses
ec2_describe_moving_addresses <- function(DryRun = NULL, PublicIps = NULL, NextToken = NULL, Filters = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeMovingAddresses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "MovingAddressStatuses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_moving_addresses_input(DryRun = DryRun, PublicIps = PublicIps, NextToken = NextToken, Filters = Filters, MaxResults = MaxResults)
  output <- .ec2$describe_moving_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_moving_addresses <- ec2_describe_moving_addresses

#' Describes your NAT gateways
#'
#' @description
#' Describes your NAT gateways. The default is to describe all your NAT gateways. Alternatively, you can specify specific NAT gateway IDs or filter the results to include only the NAT gateways that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_nat_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_nat_gateways/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filter The filters.
#' 
#' -   `nat-gateway-id` - The ID of the NAT gateway.
#' 
#' -   `state` - The state of the NAT gateway (`pending` | `failed` |
#'     `available` | `deleting` | `deleted`).
#' 
#' -   `subnet-id` - The ID of the subnet in which the NAT gateway resides.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC in which the NAT gateway resides.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NatGatewayIds The IDs of the NAT gateways.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_nat_gateways
ec2_describe_nat_gateways <- function(DryRun = NULL, Filter = NULL, MaxResults = NULL, NatGatewayIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNatGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NatGateways"),
    stream_api = FALSE
  )
  input <- .ec2$describe_nat_gateways_input(DryRun = DryRun, Filter = Filter, MaxResults = MaxResults, NatGatewayIds = NatGatewayIds, NextToken = NextToken)
  output <- .ec2$describe_nat_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_nat_gateways <- ec2_describe_nat_gateways

#' Describes your network ACLs
#'
#' @description
#' Describes your network ACLs. The default is to describe all your network ACLs. Alternatively, you can specify specific network ACL IDs or filter the results to include only the network ACLs that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_acls/](https://www.paws-r-sdk.com/docs/ec2_describe_network_acls/) for full documentation.
#'
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclIds The IDs of the network ACLs.
#' @param Filters The filters.
#' 
#' -   `association.association-id` - The ID of an association ID for the
#'     ACL.
#' 
#' -   `association.network-acl-id` - The ID of the network ACL involved in
#'     the association.
#' 
#' -   `association.subnet-id` - The ID of the subnet involved in the
#'     association.
#' 
#' -   `default` - Indicates whether the ACL is the default network ACL for
#'     the VPC.
#' 
#' -   `entry.cidr` - The IPv4 CIDR range specified in the entry.
#' 
#' -   `entry.icmp.code` - The ICMP code specified in the entry, if any.
#' 
#' -   `entry.icmp.type` - The ICMP type specified in the entry, if any.
#' 
#' -   `entry.ipv6-cidr` - The IPv6 CIDR range specified in the entry.
#' 
#' -   `entry.port-range.from` - The start of the port range specified in
#'     the entry.
#' 
#' -   `entry.port-range.to` - The end of the port range specified in the
#'     entry.
#' 
#' -   `entry.protocol` - The protocol specified in the entry (`tcp` |
#'     `udp` | `icmp` or a protocol number).
#' 
#' -   `entry.rule-action` - Allows or denies the matching traffic (`allow`
#'     | `deny`).
#' 
#' -   `entry.egress` - A Boolean that indicates the type of rule. Specify
#'     `true` for egress rules, or `false` for ingress rules.
#' 
#' -   `entry.rule-number` - The number of an entry (in other words, rule)
#'     in the set of ACL entries.
#' 
#' -   `network-acl-id` - The ID of the network ACL.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     network ACL.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the network ACL.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_acls
ec2_describe_network_acls <- function(NextToken = NULL, MaxResults = NULL, DryRun = NULL, NetworkAclIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeNetworkAcls",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkAcls"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_acls_input(NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, NetworkAclIds = NetworkAclIds, Filters = Filters)
  output <- .ec2$describe_network_acls_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_acls <- ec2_describe_network_acls

#' Describes the specified Network Access Scope analyses
#'
#' @description
#' Describes the specified Network Access Scope analyses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_access_scope_analyses/](https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_access_scope_analyses/) for full documentation.
#'
#' @param NetworkInsightsAccessScopeAnalysisIds The IDs of the Network Access Scope analyses.
#' @param NetworkInsightsAccessScopeId The ID of the Network Access Scope.
#' @param AnalysisStartTimeBegin Filters the results based on the start time. The analysis must have
#' started on or after this time.
#' @param AnalysisStartTimeEnd Filters the results based on the start time. The analysis must have
#' started on or before this time.
#' @param Filters There are no supported filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_insights_access_scope_analyses
ec2_describe_network_insights_access_scope_analyses <- function(NetworkInsightsAccessScopeAnalysisIds = NULL, NetworkInsightsAccessScopeId = NULL, AnalysisStartTimeBegin = NULL, AnalysisStartTimeEnd = NULL, Filters = NULL, MaxResults = NULL, DryRun = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInsightsAccessScopeAnalyses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkInsightsAccessScopeAnalyses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_insights_access_scope_analyses_input(NetworkInsightsAccessScopeAnalysisIds = NetworkInsightsAccessScopeAnalysisIds, NetworkInsightsAccessScopeId = NetworkInsightsAccessScopeId, AnalysisStartTimeBegin = AnalysisStartTimeBegin, AnalysisStartTimeEnd = AnalysisStartTimeEnd, Filters = Filters, MaxResults = MaxResults, DryRun = DryRun, NextToken = NextToken)
  output <- .ec2$describe_network_insights_access_scope_analyses_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_insights_access_scope_analyses <- ec2_describe_network_insights_access_scope_analyses

#' Describes the specified Network Access Scopes
#'
#' @description
#' Describes the specified Network Access Scopes.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_access_scopes/](https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_access_scopes/) for full documentation.
#'
#' @param NetworkInsightsAccessScopeIds The IDs of the Network Access Scopes.
#' @param Filters There are no supported filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_insights_access_scopes
ec2_describe_network_insights_access_scopes <- function(NetworkInsightsAccessScopeIds = NULL, Filters = NULL, MaxResults = NULL, DryRun = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInsightsAccessScopes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkInsightsAccessScopes"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_insights_access_scopes_input(NetworkInsightsAccessScopeIds = NetworkInsightsAccessScopeIds, Filters = Filters, MaxResults = MaxResults, DryRun = DryRun, NextToken = NextToken)
  output <- .ec2$describe_network_insights_access_scopes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_insights_access_scopes <- ec2_describe_network_insights_access_scopes

#' Describes one or more of your network insights analyses
#'
#' @description
#' Describes one or more of your network insights analyses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_analyses/](https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_analyses/) for full documentation.
#'
#' @param NetworkInsightsAnalysisIds The ID of the network insights analyses. You must specify either
#' analysis IDs or a path ID.
#' @param NetworkInsightsPathId The ID of the path. You must specify either a path ID or analysis IDs.
#' @param AnalysisStartTime The time when the network insights analyses started.
#' @param AnalysisEndTime The time when the network insights analyses ended.
#' @param Filters The filters. The following are the possible values:
#' 
#' -   path-found - A Boolean value that indicates whether a feasible path
#'     is found.
#' 
#' -   status - The status of the analysis (running | succeeded | failed).
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_insights_analyses
ec2_describe_network_insights_analyses <- function(NetworkInsightsAnalysisIds = NULL, NetworkInsightsPathId = NULL, AnalysisStartTime = NULL, AnalysisEndTime = NULL, Filters = NULL, MaxResults = NULL, DryRun = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInsightsAnalyses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkInsightsAnalyses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_insights_analyses_input(NetworkInsightsAnalysisIds = NetworkInsightsAnalysisIds, NetworkInsightsPathId = NetworkInsightsPathId, AnalysisStartTime = AnalysisStartTime, AnalysisEndTime = AnalysisEndTime, Filters = Filters, MaxResults = MaxResults, DryRun = DryRun, NextToken = NextToken)
  output <- .ec2$describe_network_insights_analyses_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_insights_analyses <- ec2_describe_network_insights_analyses

#' Describes one or more of your paths
#'
#' @description
#' Describes one or more of your paths.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_paths/](https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_paths/) for full documentation.
#'
#' @param NetworkInsightsPathIds The IDs of the paths.
#' @param Filters The filters. The following are the possible values:
#' 
#' -   destination - The ID of the resource.
#' 
#' -   filter-at-source.source-address - The source IPv4 address at the
#'     source.
#' 
#' -   filter-at-source.source-port-range - The source port range at the
#'     source.
#' 
#' -   filter-at-source.destination-address - The destination IPv4 address
#'     at the source.
#' 
#' -   filter-at-source.destination-port-range - The destination port range
#'     at the source.
#' 
#' -   filter-at-destination.source-address - The source IPv4 address at
#'     the destination.
#' 
#' -   filter-at-destination.source-port-range - The source port range at
#'     the destination.
#' 
#' -   filter-at-destination.destination-address - The destination IPv4
#'     address at the destination.
#' 
#' -   filter-at-destination.destination-port-range - The destination port
#'     range at the destination.
#' 
#' -   protocol - The protocol.
#' 
#' -   source - The ID of the resource.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_insights_paths
ec2_describe_network_insights_paths <- function(NetworkInsightsPathIds = NULL, Filters = NULL, MaxResults = NULL, DryRun = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInsightsPaths",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkInsightsPaths"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_insights_paths_input(NetworkInsightsPathIds = NetworkInsightsPathIds, Filters = Filters, MaxResults = MaxResults, DryRun = DryRun, NextToken = NextToken)
  output <- .ec2$describe_network_insights_paths_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_insights_paths <- ec2_describe_network_insights_paths

#' Describes a network interface attribute
#'
#' @description
#' Describes a network interface attribute. You can specify only one attribute at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_interface_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_network_interface_attribute/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param Attribute The attribute of the network interface. This parameter is required.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interface_attribute
ec2_describe_network_interface_attribute <- function(DryRun = NULL, NetworkInterfaceId, Attribute = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfaceAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_interface_attribute_input(DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId, Attribute = Attribute)
  output <- .ec2$describe_network_interface_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interface_attribute <- ec2_describe_network_interface_attribute

#' Describes the permissions for your network interfaces
#'
#' @description
#' Describes the permissions for your network interfaces.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_interface_permissions/](https://www.paws-r-sdk.com/docs/ec2_describe_network_interface_permissions/) for full documentation.
#'
#' @param NetworkInterfacePermissionIds The network interface permission IDs.
#' @param Filters One or more filters.
#' 
#' -   `network-interface-permission.network-interface-permission-id` - The
#'     ID of the permission.
#' 
#' -   `network-interface-permission.network-interface-id` - The ID of the
#'     network interface.
#' 
#' -   `network-interface-permission.aws-account-id` - The Amazon Web
#'     Services account ID.
#' 
#' -   `network-interface-permission.aws-service` - The Amazon Web Services
#'     service.
#' 
#' -   `network-interface-permission.permission` - The type of permission
#'     (`INSTANCE-ATTACH` | `EIP-ASSOCIATE`).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. If this parameter is not specified, up to 50 results are
#' returned by default. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interface_permissions
ec2_describe_network_interface_permissions <- function(NetworkInterfacePermissionIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfacePermissions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkInterfacePermissions"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_interface_permissions_input(NetworkInterfacePermissionIds = NetworkInterfacePermissionIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_interface_permissions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interface_permissions <- ec2_describe_network_interface_permissions

#' Describes one or more of your network interfaces
#'
#' @description
#' Describes one or more of your network interfaces.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_network_interfaces/](https://www.paws-r-sdk.com/docs/ec2_describe_network_interfaces/) for full documentation.
#'
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. You cannot specify this parameter and the network interface IDs
#' parameter in the same request. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceIds The network interface IDs.
#' 
#' Default: Describes all your network interfaces.
#' @param Filters One or more filters.
#' 
#' -   `association.allocation-id` - The allocation ID returned when you
#'     allocated the Elastic IP address (IPv4) for your network interface.
#' 
#' -   `association.association-id` - The association ID returned when the
#'     network interface was associated with an IPv4 address.
#' 
#' -   `addresses.association.owner-id` - The owner ID of the addresses
#'     associated with the network interface.
#' 
#' -   `addresses.association.public-ip` - The association ID returned when
#'     the network interface was associated with the Elastic IP address
#'     (IPv4).
#' 
#' -   `addresses.primary` - Whether the private IPv4 address is the
#'     primary IP address associated with the network interface.
#' 
#' -   `addresses.private-ip-address` - The private IPv4 addresses
#'     associated with the network interface.
#' 
#' -   `association.ip-owner-id` - The owner of the Elastic IP address
#'     (IPv4) associated with the network interface.
#' 
#' -   `association.public-ip` - The address of the Elastic IP address
#'     (IPv4) bound to the network interface.
#' 
#' -   `association.public-dns-name` - The public DNS name for the network
#'     interface (IPv4).
#' 
#' -   `attachment.attach-time` - The time that the network interface was
#'     attached to an instance.
#' 
#' -   `attachment.attachment-id` - The ID of the interface attachment.
#' 
#' -   `attachment.delete-on-termination` - Indicates whether the
#'     attachment is deleted when an instance is terminated.
#' 
#' -   `attachment.device-index` - The device index to which the network
#'     interface is attached.
#' 
#' -   `attachment.instance-id` - The ID of the instance to which the
#'     network interface is attached.
#' 
#' -   `attachment.instance-owner-id` - The owner ID of the instance to
#'     which the network interface is attached.
#' 
#' -   `attachment.status` - The status of the attachment (`attaching` |
#'     `attached` | `detaching` | `detached`).
#' 
#' -   `availability-zone` - The Availability Zone of the network
#'     interface.
#' 
#' -   `description` - The description of the network interface.
#' 
#' -   `group-id` - The ID of a security group associated with the network
#'     interface.
#' 
#' -   `ipv6-addresses.ipv6-address` - An IPv6 address associated with the
#'     network interface.
#' 
#' -   `interface-type` - The type of network interface
#'     (`api_gateway_managed` | `aws_codestar_connections_managed` |
#'     `branch` | `ec2_instance_connect_endpoint` | `efa` | `efa-only` |
#'     `efs` | `gateway_load_balancer` | `gateway_load_balancer_endpoint` |
#'     `global_accelerator_managed` | `interface` | `iot_rules_managed` |
#'     `lambda` | `load_balancer` | `nat_gateway` | `network_load_balancer`
#'     | `quicksight` | `transit_gateway` | `trunk` | `vpc_endpoint`).
#' 
#' -   `mac-address` - The MAC address of the network interface.
#' 
#' -   `network-interface-id` - The ID of the network interface.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the network
#'     interface owner.
#' 
#' -   `private-dns-name` - The private DNS name of the network interface
#'     (IPv4).
#' 
#' -   `private-ip-address` - The private IPv4 address or addresses of the
#'     network interface.
#' 
#' -   `requester-id` - The alias or Amazon Web Services account ID of the
#'     principal or service that created the network interface.
#' 
#' -   `requester-managed` - Indicates whether the network interface is
#'     being managed by an Amazon Web Services service (for example, Amazon
#'     Web Services Management Console, Auto Scaling, and so on).
#' 
#' -   `source-dest-check` - Indicates whether the network interface
#'     performs source/destination checking. A value of `true` means
#'     checking is enabled, and `false` means checking is disabled. The
#'     value must be `false` for the network interface to perform network
#'     address translation (NAT) in your VPC.
#' 
#' -   `status` - The status of the network interface. If the network
#'     interface is not attached to an instance, the status is `available`;
#'     if a network interface is attached to an instance the status is
#'     `in-use`.
#' 
#' -   `subnet-id` - The ID of the subnet for the network interface.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the network interface.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interfaces
ec2_describe_network_interfaces <- function(NextToken = NULL, MaxResults = NULL, DryRun = NULL, NetworkInterfaceIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfaces",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NetworkInterfaces"),
    stream_api = FALSE
  )
  input <- .ec2$describe_network_interfaces_input(NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, NetworkInterfaceIds = NetworkInterfaceIds, Filters = Filters)
  output <- .ec2$describe_network_interfaces_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interfaces <- ec2_describe_network_interfaces

#' Describes the specified placement groups or all of your placement groups
#'
#' @description
#' Describes the specified placement groups or all of your placement groups.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_placement_groups/](https://www.paws-r-sdk.com/docs/ec2_describe_placement_groups/) for full documentation.
#'
#' @param GroupIds The IDs of the placement groups.
#' @param DryRun Checks whether you have the required permissions for the operation,
#' without actually making the request, and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param GroupNames The names of the placement groups.
#' 
#' Constraints:
#' 
#' -   You can specify a name only if the placement group is owned by your
#'     account.
#' 
#' -   If a placement group is *shared* with your account, specifying the
#'     name results in an error. You must use the `GroupId` parameter
#'     instead.
#' @param Filters The filters.
#' 
#' -   `group-name` - The name of the placement group.
#' 
#' -   `group-arn` - The Amazon Resource Name (ARN) of the placement group.
#' 
#' -   `spread-level` - The spread level for the placement group (`host` |
#'     `rack`).
#' 
#' -   `state` - The state of the placement group (`pending` | `available`
#'     | `deleting` | `deleted`).
#' 
#' -   `strategy` - The strategy of the placement group (`cluster` |
#'     `spread` | `partition`).
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_placement_groups
ec2_describe_placement_groups <- function(GroupIds = NULL, DryRun = NULL, GroupNames = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribePlacementGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_placement_groups_input(GroupIds = GroupIds, DryRun = DryRun, GroupNames = GroupNames, Filters = Filters)
  output <- .ec2$describe_placement_groups_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_placement_groups <- ec2_describe_placement_groups

#' Describes available Amazon Web Services services in a prefix list
#' format, which includes the prefix list name and prefix list ID of the
#' service and the IP address range for the service
#'
#' @description
#' Describes available Amazon Web Services services in a prefix list format, which includes the prefix list name and prefix list ID of the service and the IP address range for the service.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_prefix_lists/](https://www.paws-r-sdk.com/docs/ec2_describe_prefix_lists/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `prefix-list-id`: The ID of a prefix list.
#' 
#' -   `prefix-list-name`: The name of a prefix list.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param PrefixListIds One or more prefix list IDs.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_prefix_lists
ec2_describe_prefix_lists <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, PrefixListIds = NULL) {
  op <- new_operation(
    name = "DescribePrefixLists",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PrefixLists"),
    stream_api = FALSE
  )
  input <- .ec2$describe_prefix_lists_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, PrefixListIds = PrefixListIds)
  output <- .ec2$describe_prefix_lists_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_prefix_lists <- ec2_describe_prefix_lists

#' Describes the ID format settings for the root user and all IAM roles and
#' IAM users that have explicitly specified a longer ID (17-character ID)
#' preference
#'
#' @description
#' Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_principal_id_format/](https://www.paws-r-sdk.com/docs/ec2_describe_principal_id_format/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources The type of resource: `bundle` | `conversion-task` | `customer-gateway`
#' | `dhcp-options` | `elastic-ip-allocation` | `elastic-ip-association` |
#' `export-task` | `flow-log` | `image` | `import-task` | `instance` |
#' `internet-gateway` | `network-acl` | `network-acl-association` |
#' `network-interface` | `network-interface-attachment` | `prefix-list` |
#' `reservation` | `route-table` | `route-table-association` |
#' `security-group` | `snapshot` | `subnet` |
#' `subnet-cidr-block-association` | `volume` | `vpc` |
#' `vpc-cidr-block-association` | `vpc-endpoint` | `vpc-peering-connection`
#' | `vpn-connection` | `vpn-gateway`
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned NextToken
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_principal_id_format
ec2_describe_principal_id_format <- function(DryRun = NULL, Resources = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePrincipalIdFormat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Principals"),
    stream_api = FALSE
  )
  input <- .ec2$describe_principal_id_format_input(DryRun = DryRun, Resources = Resources, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_principal_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_principal_id_format <- ec2_describe_principal_id_format

#' Describes the specified IPv4 address pools
#'
#' @description
#' Describes the specified IPv4 address pools.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_public_ipv_4_pools/](https://www.paws-r-sdk.com/docs/ec2_describe_public_ipv_4_pools/) for full documentation.
#'
#' @param PoolIds The IDs of the address pools.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param Filters One or more filters.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_public_ipv_4_pools
ec2_describe_public_ipv_4_pools <- function(PoolIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribePublicIpv4Pools",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PublicIpv4Pools"),
    stream_api = FALSE
  )
  input <- .ec2$describe_public_ipv_4_pools_input(PoolIds = PoolIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ec2$describe_public_ipv_4_pools_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_public_ipv_4_pools <- ec2_describe_public_ipv_4_pools

#' Describes the Regions that are enabled for your account, or all Regions
#'
#' @description
#' Describes the Regions that are enabled for your account, or all Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_regions/](https://www.paws-r-sdk.com/docs/ec2_describe_regions/) for full documentation.
#'
#' @param RegionNames The names of the Regions. You can specify any Regions, whether they are
#' enabled and disabled for your account.
#' @param AllRegions Indicates whether to display all Regions, including Regions that are
#' disabled for your account.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `endpoint` - The endpoint of the Region (for example,
#'     `ec2.us-east-1.amazonaws.com`).
#' 
#' -   `opt-in-status` - The opt-in status of the Region
#'     (`opt-in-not-required` | `opted-in` | `not-opted-in`).
#' 
#' -   `region-name` - The name of the Region (for example, `us-east-1`).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_regions
ec2_describe_regions <- function(RegionNames = NULL, AllRegions = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeRegions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_regions_input(RegionNames = RegionNames, AllRegions = AllRegions, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_regions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_regions <- ec2_describe_regions

#' Describes a root volume replacement task
#'
#' @description
#' Describes a root volume replacement task. For more information, see [Replace a root volume](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_replace_root_volume_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_replace_root_volume_tasks/) for full documentation.
#'
#' @param ReplaceRootVolumeTaskIds The ID of the root volume replacement task to view.
#' @param Filters Filter to use:
#' 
#' -   `instance-id` - The ID of the instance for which the root volume
#'     replacement task was created.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_replace_root_volume_tasks
ec2_describe_replace_root_volume_tasks <- function(ReplaceRootVolumeTaskIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeReplaceRootVolumeTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ReplaceRootVolumeTasks"),
    stream_api = FALSE
  )
  input <- .ec2$describe_replace_root_volume_tasks_input(ReplaceRootVolumeTaskIds = ReplaceRootVolumeTaskIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_replace_root_volume_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_replace_root_volume_tasks <- ec2_describe_replace_root_volume_tasks

#' Describes one or more of the Reserved Instances that you purchased
#'
#' @description
#' Describes one or more of the Reserved Instances that you purchased.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances/) for full documentation.
#'
#' @param OfferingClass Describes whether the Reserved Instance is Standard or Convertible.
#' @param ReservedInstancesIds One or more Reserved Instance IDs.
#' 
#' Default: Describes all your Reserved Instances, or only those otherwise
#' specified.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone where the Reserved
#'     Instance can be used.
#' 
#' -   `duration` - The duration of the Reserved Instance (one year or
#'     three years), in seconds (`31536000` | `94608000`).
#' 
#' -   `end` - The time when the Reserved Instance expires (for example,
#'     2015-08-07T11:54:42.000Z).
#' 
#' -   `fixed-price` - The purchase price of the Reserved Instance (for
#'     example, 9800.0).
#' 
#' -   `instance-type` - The instance type that is covered by the
#'     reservation.
#' 
#' -   `scope` - The scope of the Reserved Instance (`Region` or
#'     `Availability Zone`).
#' 
#' -   `product-description` - The Reserved Instance product platform
#'     description (`Linux/UNIX` | `Linux with SQL Server Standard` |
#'     `Linux with SQL Server Web` | `Linux with SQL Server Enterprise` |
#'     `SUSE Linux` | `Red Hat Enterprise Linux` |
#'     `Red Hat Enterprise Linux with HA` | `Windows` |
#'     `Windows with SQL Server Standard` | `Windows with SQL Server Web` |
#'     `Windows with SQL Server Enterprise`).
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instance.
#' 
#' -   `start` - The time at which the Reserved Instance purchase request
#'     was placed (for example, 2014-08-07T11:54:42.000Z).
#' 
#' -   `state` - The state of the Reserved Instance (`payment-pending` |
#'     `active` | `payment-failed` | `retired`).
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `usage-price` - The usage price of the Reserved Instance, per hour
#'     (for example, 0.84).
#' @param OfferingType The Reserved Instance offering type. If you are using tools that predate
#' the 2011-11-01 API version, you only have access to the
#' `Medium Utilization` Reserved Instance offering type.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances
ec2_describe_reserved_instances <- function(OfferingClass = NULL, ReservedInstancesIds = NULL, DryRun = NULL, Filters = NULL, OfferingType = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_reserved_instances_input(OfferingClass = OfferingClass, ReservedInstancesIds = ReservedInstancesIds, DryRun = DryRun, Filters = Filters, OfferingType = OfferingType)
  output <- .ec2$describe_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances <- ec2_describe_reserved_instances

#' Describes your account's Reserved Instance listings in the Reserved
#' Instance Marketplace
#'
#' @description
#' Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_listings/](https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_listings/) for full documentation.
#'
#' @param ReservedInstancesId One or more Reserved Instance IDs.
#' @param ReservedInstancesListingId One or more Reserved Instance listing IDs.
#' @param Filters One or more filters.
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instances.
#' 
#' -   `reserved-instances-listing-id` - The ID of the Reserved Instances
#'     listing.
#' 
#' -   `status` - The status of the Reserved Instance listing (`pending` |
#'     `active` | `cancelled` | `closed`).
#' 
#' -   `status-message` - The reason for the status.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_listings
ec2_describe_reserved_instances_listings <- function(ReservedInstancesId = NULL, ReservedInstancesListingId = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesListings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_reserved_instances_listings_input(ReservedInstancesId = ReservedInstancesId, ReservedInstancesListingId = ReservedInstancesListingId, Filters = Filters)
  output <- .ec2$describe_reserved_instances_listings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_listings <- ec2_describe_reserved_instances_listings

#' Describes the modifications made to your Reserved Instances
#'
#' @description
#' Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_modifications/](https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_modifications/) for full documentation.
#'
#' @param ReservedInstancesModificationIds IDs for the submitted modification request.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters.
#' 
#' -   `client-token` - The idempotency token for the modification request.
#' 
#' -   `create-date` - The time when the modification request was created.
#' 
#' -   `effective-date` - The time when the modification becomes effective.
#' 
#' -   `modification-result.reserved-instances-id` - The ID for the
#'     Reserved Instances created as part of the modification request. This
#'     ID is only available when the status of the modification is
#'     `fulfilled`.
#' 
#' -   `modification-result.target-configuration.availability-zone` - The
#'     Availability Zone for the new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.instance-count ` - The
#'     number of new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.instance-type` - The
#'     instance type of the new Reserved Instances.
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instances modified.
#' 
#' -   `reserved-instances-modification-id` - The ID of the modification
#'     request.
#' 
#' -   `status` - The status of the Reserved Instances modification request
#'     (`processing` | `fulfilled` | `failed`).
#' 
#' -   `status-message` - The reason for the status.
#' 
#' -   `update-date` - The time when the modification request was last
#'     updated.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_modifications
ec2_describe_reserved_instances_modifications <- function(ReservedInstancesModificationIds = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesModifications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "ReservedInstancesModifications"),
    stream_api = FALSE
  )
  input <- .ec2$describe_reserved_instances_modifications_input(ReservedInstancesModificationIds = ReservedInstancesModificationIds, NextToken = NextToken, Filters = Filters)
  output <- .ec2$describe_reserved_instances_modifications_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_modifications <- ec2_describe_reserved_instances_modifications

#' Describes Reserved Instance offerings that are available for purchase
#'
#' @description
#' Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_offerings/](https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_offerings/) for full documentation.
#'
#' @param AvailabilityZone The Availability Zone in which the Reserved Instance can be used.
#' @param IncludeMarketplace Include Reserved Instance Marketplace offerings in the response.
#' @param InstanceType The instance type that the reservation will cover (for example,
#' `m1.small`). For more information, see [Amazon EC2 instance
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon EC2 User Guide*.
#' @param MaxDuration The maximum duration (in seconds) to filter when searching for
#' offerings.
#' 
#' Default: 94608000 (3 years)
#' @param MaxInstanceCount The maximum number of instances to filter when searching for offerings.
#' 
#' Default: 20
#' @param MinDuration The minimum duration (in seconds) to filter when searching for
#' offerings.
#' 
#' Default: 2592000 (1 month)
#' @param OfferingClass The offering class of the Reserved Instance. Can be `standard` or
#' `convertible`.
#' @param ProductDescription The Reserved Instance product platform description. Instances that
#' include `(Amazon VPC)` in the description are for use with Amazon VPC.
#' @param ReservedInstancesOfferingIds One or more Reserved Instances offering IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone where the Reserved
#'     Instance can be used.
#' 
#' -   `duration` - The duration of the Reserved Instance (for example, one
#'     year or three years), in seconds (`31536000` | `94608000`).
#' 
#' -   `fixed-price` - The purchase price of the Reserved Instance (for
#'     example, 9800.0).
#' 
#' -   `instance-type` - The instance type that is covered by the
#'     reservation.
#' 
#' -   `marketplace` - Set to `true` to show only Reserved Instance
#'     Marketplace offerings. When this filter is not used, which is the
#'     default behavior, all offerings from both Amazon Web Services and
#'     the Reserved Instance Marketplace are listed.
#' 
#' -   `product-description` - The Reserved Instance product platform
#'     description (`Linux/UNIX` | `Linux with SQL Server Standard` |
#'     `Linux with SQL Server Web` | `Linux with SQL Server Enterprise` |
#'     `SUSE Linux` | `Red Hat Enterprise Linux` |
#'     `Red Hat Enterprise Linux with HA` | `Windows` |
#'     `Windows with SQL Server Standard` | `Windows with SQL Server Web` |
#'     `Windows with SQL Server Enterprise`).
#' 
#' -   `reserved-instances-offering-id` - The Reserved Instances offering
#'     ID.
#' 
#' -   `scope` - The scope of the Reserved Instance (`Availability Zone` or
#'     `Region`).
#' 
#' -   `usage-price` - The usage price of the Reserved Instance, per hour
#'     (for example, 0.84).
#' @param InstanceTenancy The tenancy of the instances covered by the reservation. A Reserved
#' Instance with a tenancy of `dedicated` is applied to instances that run
#' in a VPC on single-tenant hardware (i.e., Dedicated Instances).
#' 
#' **Important:** The `host` value cannot be used with this parameter. Use
#' the `default` or `dedicated` values only.
#' 
#' Default: `default`
#' @param OfferingType The Reserved Instance offering type. If you are using tools that predate
#' the 2011-11-01 API version, you only have access to the
#' `Medium Utilization` Reserved Instance offering type.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. The maximum
#' is 100.
#' 
#' Default: 100
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_offerings
ec2_describe_reserved_instances_offerings <- function(AvailabilityZone = NULL, IncludeMarketplace = NULL, InstanceType = NULL, MaxDuration = NULL, MaxInstanceCount = NULL, MinDuration = NULL, OfferingClass = NULL, ProductDescription = NULL, ReservedInstancesOfferingIds = NULL, DryRun = NULL, Filters = NULL, InstanceTenancy = NULL, OfferingType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesOfferings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ReservedInstancesOfferings"),
    stream_api = FALSE
  )
  input <- .ec2$describe_reserved_instances_offerings_input(AvailabilityZone = AvailabilityZone, IncludeMarketplace = IncludeMarketplace, InstanceType = InstanceType, MaxDuration = MaxDuration, MaxInstanceCount = MaxInstanceCount, MinDuration = MinDuration, OfferingClass = OfferingClass, ProductDescription = ProductDescription, ReservedInstancesOfferingIds = ReservedInstancesOfferingIds, DryRun = DryRun, Filters = Filters, InstanceTenancy = InstanceTenancy, OfferingType = OfferingType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_reserved_instances_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_offerings <- ec2_describe_reserved_instances_offerings

#' Describes your route tables
#'
#' @description
#' Describes your route tables. The default is to describe all your route tables. Alternatively, you can specify specific route table IDs or filter the results to include only the route tables that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_route_tables/](https://www.paws-r-sdk.com/docs/ec2_describe_route_tables/) for full documentation.
#'
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableIds The IDs of the route tables.
#' @param Filters The filters.
#' 
#' -   `association.gateway-id` - The ID of the gateway involved in the
#'     association.
#' 
#' -   `association.route-table-association-id` - The ID of an association
#'     ID for the route table.
#' 
#' -   `association.route-table-id` - The ID of the route table involved in
#'     the association.
#' 
#' -   `association.subnet-id` - The ID of the subnet involved in the
#'     association.
#' 
#' -   `association.main` - Indicates whether the route table is the main
#'     route table for the VPC (`true` | `false`). Route tables that do not
#'     have an association ID are not returned in the response.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     route table.
#' 
#' -   `route-table-id` - The ID of the route table.
#' 
#' -   `route.destination-cidr-block` - The IPv4 CIDR range specified in a
#'     route in the table.
#' 
#' -   `route.destination-ipv6-cidr-block` - The IPv6 CIDR range specified
#'     in a route in the route table.
#' 
#' -   `route.destination-prefix-list-id` - The ID (prefix) of the Amazon
#'     Web Services service specified in a route in the table.
#' 
#' -   `route.egress-only-internet-gateway-id` - The ID of an egress-only
#'     Internet gateway specified in a route in the route table.
#' 
#' -   `route.gateway-id` - The ID of a gateway specified in a route in the
#'     table.
#' 
#' -   `route.instance-id` - The ID of an instance specified in a route in
#'     the table.
#' 
#' -   `route.nat-gateway-id` - The ID of a NAT gateway.
#' 
#' -   `route.transit-gateway-id` - The ID of a transit gateway.
#' 
#' -   `route.origin` - Describes how the route was created.
#'     [`create_route_table`][ec2_create_route_table] indicates that the
#'     route was automatically created when the route table was created;
#'     [`create_route`][ec2_create_route] indicates that the route was
#'     manually added to the route table;
#'     [`enable_vgw_route_propagation`][ec2_enable_vgw_route_propagation]
#'     indicates that the route was propagated by route propagation.
#' 
#' -   `route.state` - The state of a route in the route table (`active` |
#'     `blackhole`). The blackhole state indicates that the route's target
#'     isn't available (for example, the specified gateway isn't attached
#'     to the VPC, the specified NAT instance has been terminated, and so
#'     on).
#' 
#' -   `route.vpc-peering-connection-id` - The ID of a VPC peering
#'     connection specified in a route in the table.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the route table.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_route_tables
ec2_describe_route_tables <- function(NextToken = NULL, MaxResults = NULL, DryRun = NULL, RouteTableIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeRouteTables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RouteTables"),
    stream_api = FALSE
  )
  input <- .ec2$describe_route_tables_input(NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, RouteTableIds = RouteTableIds, Filters = Filters)
  output <- .ec2$describe_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_route_tables <- ec2_describe_route_tables

#' Finds available schedules that meet the specified criteria
#'
#' @description
#' Finds available schedules that meet the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_scheduled_instance_availability/](https://www.paws-r-sdk.com/docs/ec2_describe_scheduled_instance_availability/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone (for example,
#'     `us-west-2a`).
#' 
#' -   `instance-type` - The instance type (for example, `c4.large`).
#' 
#' -   `platform` - The platform (`Linux/UNIX` or `Windows`).
#' @param FirstSlotStartTimeRange &#91;required&#93; The time period for the first schedule to start.
#' @param MaxResults The maximum number of results to return in a single call. This value can
#' be between 5 and 300. The default value is 300. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param MaxSlotDurationInHours The maximum available duration, in hours. This value must be greater
#' than `MinSlotDurationInHours` and less than 1,720.
#' @param MinSlotDurationInHours The minimum available duration, in hours. The minimum required duration
#' is 1,200 hours per year. For example, the minimum daily schedule is 4
#' hours, the minimum weekly schedule is 24 hours, and the minimum monthly
#' schedule is 100 hours.
#' @param NextToken The token for the next set of results.
#' @param Recurrence &#91;required&#93; The schedule recurrence.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_scheduled_instance_availability
ec2_describe_scheduled_instance_availability <- function(DryRun = NULL, Filters = NULL, FirstSlotStartTimeRange, MaxResults = NULL, MaxSlotDurationInHours = NULL, MinSlotDurationInHours = NULL, NextToken = NULL, Recurrence) {
  op <- new_operation(
    name = "DescribeScheduledInstanceAvailability",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ScheduledInstanceAvailabilitySet"),
    stream_api = FALSE
  )
  input <- .ec2$describe_scheduled_instance_availability_input(DryRun = DryRun, Filters = Filters, FirstSlotStartTimeRange = FirstSlotStartTimeRange, MaxResults = MaxResults, MaxSlotDurationInHours = MaxSlotDurationInHours, MinSlotDurationInHours = MinSlotDurationInHours, NextToken = NextToken, Recurrence = Recurrence)
  output <- .ec2$describe_scheduled_instance_availability_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_scheduled_instance_availability <- ec2_describe_scheduled_instance_availability

#' Describes the specified Scheduled Instances or all your Scheduled
#' Instances
#'
#' @description
#' Describes the specified Scheduled Instances or all your Scheduled Instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_scheduled_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_scheduled_instances/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone (for example,
#'     `us-west-2a`).
#' 
#' -   `instance-type` - The instance type (for example, `c4.large`).
#' 
#' -   `platform` - The platform (`Linux/UNIX` or `Windows`).
#' @param MaxResults The maximum number of results to return in a single call. This value can
#' be between 5 and 300. The default value is 100. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param ScheduledInstanceIds The Scheduled Instance IDs.
#' @param SlotStartTimeRange The time period for the first schedule to start.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_scheduled_instances
ec2_describe_scheduled_instances <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, ScheduledInstanceIds = NULL, SlotStartTimeRange = NULL) {
  op <- new_operation(
    name = "DescribeScheduledInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ScheduledInstanceSet"),
    stream_api = FALSE
  )
  input <- .ec2$describe_scheduled_instances_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, ScheduledInstanceIds = ScheduledInstanceIds, SlotStartTimeRange = SlotStartTimeRange)
  output <- .ec2$describe_scheduled_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_scheduled_instances <- ec2_describe_scheduled_instances

#' Describes the VPCs on the other side of a VPC peering or Transit Gateway
#' connection that are referencing the security groups you've specified in
#' this request
#'
#' @description
#' Describes the VPCs on the other side of a VPC peering or Transit Gateway connection that are referencing the security groups you've specified in this request.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_security_group_references/](https://www.paws-r-sdk.com/docs/ec2_describe_security_group_references/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupId &#91;required&#93; The IDs of the security groups in your account.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_security_group_references
ec2_describe_security_group_references <- function(DryRun = NULL, GroupId) {
  op <- new_operation(
    name = "DescribeSecurityGroupReferences",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_security_group_references_input(DryRun = DryRun, GroupId = GroupId)
  output <- .ec2$describe_security_group_references_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_security_group_references <- ec2_describe_security_group_references

#' Describes one or more of your security group rules
#'
#' @description
#' Describes one or more of your security group rules.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_security_group_rules/](https://www.paws-r-sdk.com/docs/ec2_describe_security_group_rules/) for full documentation.
#'
#' @param Filters One or more filters.
#' 
#' -   `group-id` - The ID of the security group.
#' 
#' -   `security-group-rule-id` - The ID of the security group rule.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' @param SecurityGroupRuleIds The IDs of the security group rules.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. This value can be between 5 and 1000. If this parameter is not
#' specified, then all items are returned. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_security_group_rules
ec2_describe_security_group_rules <- function(Filters = NULL, SecurityGroupRuleIds = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSecurityGroupRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SecurityGroupRules"),
    stream_api = FALSE
  )
  input <- .ec2$describe_security_group_rules_input(Filters = Filters, SecurityGroupRuleIds = SecurityGroupRuleIds, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_security_group_rules_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_security_group_rules <- ec2_describe_security_group_rules

#' Describes security group VPC associations made with
#' AssociateSecurityGroupVpc
#'
#' @description
#' Describes security group VPC associations made with [`associate_security_group_vpc`][ec2_associate_security_group_vpc].
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_security_group_vpc_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_security_group_vpc_associations/) for full documentation.
#'
#' @param Filters Security group VPC association filters.
#' 
#' -   `group-id`: The security group ID.
#' 
#' -   `vpc-id`: The ID of the associated VPC.
#' 
#' -   `vpc-owner-id`: The account ID of the VPC owner.
#' 
#' -   `state`: The state of the association.
#' 
#' -   `tag:<key>`: The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key`: The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_security_group_vpc_associations
ec2_describe_security_group_vpc_associations <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSecurityGroupVpcAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SecurityGroupVpcAssociations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_security_group_vpc_associations_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_security_group_vpc_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_security_group_vpc_associations <- ec2_describe_security_group_vpc_associations

#' Describes the specified security groups or all of your security groups
#'
#' @description
#' Describes the specified security groups or all of your security groups.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_security_groups/](https://www.paws-r-sdk.com/docs/ec2_describe_security_groups/) for full documentation.
#'
#' @param GroupIds The IDs of the security groups. Required for security groups in a
#' nondefault VPC.
#' 
#' Default: Describes all of your security groups.
#' @param GroupNames \[Default VPC\] The names of the security groups. You can specify either
#' the security group name or the security group ID.
#' 
#' Default: Describes all of your security groups.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. This value can be between 5 and 1000. If this parameter is not
#' specified, then all items are returned. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters. If using multiple filters for rules, the results include
#' security groups for which any combination of rules - not necessarily a
#' single rule - match all filters.
#' 
#' -   `description` - The description of the security group.
#' 
#' -   `egress.ip-permission.cidr` - An IPv4 CIDR block for an outbound
#'     security group rule.
#' 
#' -   `egress.ip-permission.from-port` - For an outbound rule, the start
#'     of port range for the TCP and UDP protocols, or an ICMP type number.
#' 
#' -   `egress.ip-permission.group-id` - The ID of a security group that
#'     has been referenced in an outbound security group rule.
#' 
#' -   `egress.ip-permission.group-name` - The name of a security group
#'     that is referenced in an outbound security group rule.
#' 
#' -   `egress.ip-permission.ipv6-cidr` - An IPv6 CIDR block for an
#'     outbound security group rule.
#' 
#' -   `egress.ip-permission.prefix-list-id` - The ID of a prefix list to
#'     which a security group rule allows outbound access.
#' 
#' -   `egress.ip-permission.protocol` - The IP protocol for an outbound
#'     security group rule (`tcp` | `udp` | `icmp`, a protocol number, or
#'     -1 for all protocols).
#' 
#' -   `egress.ip-permission.to-port` - For an outbound rule, the end of
#'     port range for the TCP and UDP protocols, or an ICMP code.
#' 
#' -   `egress.ip-permission.user-id` - The ID of an Amazon Web Services
#'     account that has been referenced in an outbound security group rule.
#' 
#' -   `group-id` - The ID of the security group.
#' 
#' -   `group-name` - The name of the security group.
#' 
#' -   `ip-permission.cidr` - An IPv4 CIDR block for an inbound security
#'     group rule.
#' 
#' -   `ip-permission.from-port` - For an inbound rule, the start of port
#'     range for the TCP and UDP protocols, or an ICMP type number.
#' 
#' -   `ip-permission.group-id` - The ID of a security group that has been
#'     referenced in an inbound security group rule.
#' 
#' -   `ip-permission.group-name` - The name of a security group that is
#'     referenced in an inbound security group rule.
#' 
#' -   `ip-permission.ipv6-cidr` - An IPv6 CIDR block for an inbound
#'     security group rule.
#' 
#' -   `ip-permission.prefix-list-id` - The ID of a prefix list from which
#'     a security group rule allows inbound access.
#' 
#' -   `ip-permission.protocol` - The IP protocol for an inbound security
#'     group rule (`tcp` | `udp` | `icmp`, a protocol number, or -1 for all
#'     protocols).
#' 
#' -   `ip-permission.to-port` - For an inbound rule, the end of port range
#'     for the TCP and UDP protocols, or an ICMP code.
#' 
#' -   `ip-permission.user-id` - The ID of an Amazon Web Services account
#'     that has been referenced in an inbound security group rule.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the owner of the
#'     security group.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC specified when the security group was
#'     created.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_security_groups
ec2_describe_security_groups <- function(GroupIds = NULL, GroupNames = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSecurityGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SecurityGroups"),
    stream_api = FALSE
  )
  input <- .ec2$describe_security_groups_input(GroupIds = GroupIds, GroupNames = GroupNames, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_security_groups_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_security_groups <- ec2_describe_security_groups

#' Describes the specified attribute of the specified snapshot
#'
#' @description
#' Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_snapshot_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_snapshot_attribute/) for full documentation.
#'
#' @param Attribute &#91;required&#93; The snapshot attribute you would like to view.
#' @param SnapshotId &#91;required&#93; The ID of the EBS snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_snapshot_attribute
ec2_describe_snapshot_attribute <- function(Attribute, SnapshotId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_snapshot_attribute_input(Attribute = Attribute, SnapshotId = SnapshotId, DryRun = DryRun)
  output <- .ec2$describe_snapshot_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_snapshot_attribute <- ec2_describe_snapshot_attribute

#' Describes the storage tier status of one or more Amazon EBS snapshots
#'
#' @description
#' Describes the storage tier status of one or more Amazon EBS snapshots.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_snapshot_tier_status/](https://www.paws-r-sdk.com/docs/ec2_describe_snapshot_tier_status/) for full documentation.
#'
#' @param Filters The filters.
#' 
#' -   `snapshot-id` - The snapshot ID.
#' 
#' -   `volume-id` - The ID of the volume the snapshot is for.
#' 
#' -   `last-tiering-operation` - The state of the last archive or restore
#'     action. (`archival-in-progress` | `archival-completed` |
#'     `archival-failed` | `permanent-restore-in-progress` |
#'     `permanent-restore-completed` | `permanent-restore-failed` |
#'     `temporary-restore-in-progress` | `temporary-restore-completed` |
#'     `temporary-restore-failed`)
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_snapshot_tier_status
ec2_describe_snapshot_tier_status <- function(Filters = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSnapshotTierStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SnapshotTierStatuses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_snapshot_tier_status_input(Filters = Filters, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_snapshot_tier_status_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_snapshot_tier_status <- ec2_describe_snapshot_tier_status

#' Describes the specified EBS snapshots available to you or all of the EBS
#' snapshots available to you
#'
#' @description
#' Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_snapshots/](https://www.paws-r-sdk.com/docs/ec2_describe_snapshots/) for full documentation.
#'
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param OwnerIds Scopes the results to snapshots with the specified owners. You can
#' specify a combination of Amazon Web Services account IDs, `self`, and
#' `amazon`.
#' @param RestorableByUserIds The IDs of the Amazon Web Services accounts that can create volumes from
#' the snapshot.
#' @param SnapshotIds The snapshot IDs.
#' 
#' Default: Describes the snapshots for which you have create volume
#' permissions.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `description` - A description of the snapshot.
#' 
#' -   `encrypted` - Indicates whether the snapshot is encrypted (`true` |
#'     `false`)
#' 
#' -   `owner-alias` - The owner alias, from an Amazon-maintained list
#'     (`amazon`). This is not the user-configured Amazon Web Services
#'     account alias set using the IAM console. We recommend that you use
#'     the related parameter instead of this filter.
#' 
#' -   `owner-id` - The Amazon Web Services account ID of the owner. We
#'     recommend that you use the related parameter instead of this filter.
#' 
#' -   `progress` - The progress of the snapshot, as a percentage (for
#'     example, 80%).
#' 
#' -   `snapshot-id` - The snapshot ID.
#' 
#' -   `start-time` - The time stamp when the snapshot was initiated.
#' 
#' -   `status` - The status of the snapshot (`pending` | `completed` |
#'     `error`).
#' 
#' -   `storage-tier` - The storage tier of the snapshot (`archive` |
#'     `standard`).
#' 
#' -   `transfer-type` - The type of operation used to create the snapshot
#'     (`time-based` | `standard`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `volume-id` - The ID of the volume the snapshot is for.
#' 
#' -   `volume-size` - The size of the volume, in GiB.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_snapshots
ec2_describe_snapshots <- function(MaxResults = NULL, NextToken = NULL, OwnerIds = NULL, RestorableByUserIds = NULL, SnapshotIds = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Snapshots"),
    stream_api = FALSE
  )
  input <- .ec2$describe_snapshots_input(MaxResults = MaxResults, NextToken = NextToken, OwnerIds = OwnerIds, RestorableByUserIds = RestorableByUserIds, SnapshotIds = SnapshotIds, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_snapshots_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_snapshots <- ec2_describe_snapshots

#' Describes the data feed for Spot Instances
#'
#' @description
#' Describes the data feed for Spot Instances. For more information, see [Spot Instance data feed](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_spot_datafeed_subscription/](https://www.paws-r-sdk.com/docs/ec2_describe_spot_datafeed_subscription/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_datafeed_subscription
ec2_describe_spot_datafeed_subscription <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_spot_datafeed_subscription_input(DryRun = DryRun)
  output <- .ec2$describe_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_datafeed_subscription <- ec2_describe_spot_datafeed_subscription

#' Describes the running instances for the specified Spot Fleet
#'
#' @description
#' Describes the running instances for the specified Spot Fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_spot_fleet_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_spot_fleet_instances/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotFleetRequestId &#91;required&#93; The ID of the Spot Fleet request.
#' @param NextToken The token to include in another request to get the next page of items.
#' This value is `null` when there are no more items to return.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_fleet_instances
ec2_describe_spot_fleet_instances <- function(DryRun = NULL, SpotFleetRequestId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSpotFleetInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ActiveInstances"),
    stream_api = FALSE
  )
  input <- .ec2$describe_spot_fleet_instances_input(DryRun = DryRun, SpotFleetRequestId = SpotFleetRequestId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_spot_fleet_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_fleet_instances <- ec2_describe_spot_fleet_instances

#' Describes the events for the specified Spot Fleet request during the
#' specified time
#'
#' @description
#' Describes the events for the specified Spot Fleet request during the specified time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_spot_fleet_request_history/](https://www.paws-r-sdk.com/docs/ec2_describe_spot_fleet_request_history/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotFleetRequestId &#91;required&#93; The ID of the Spot Fleet request.
#' @param EventType The type of events to describe. By default, all events are described.
#' @param StartTime &#91;required&#93; The starting date and time for the events, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#' @param NextToken The token to include in another request to get the next page of items.
#' This value is `null` when there are no more items to return.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_fleet_request_history
ec2_describe_spot_fleet_request_history <- function(DryRun = NULL, SpotFleetRequestId, EventType = NULL, StartTime, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSpotFleetRequestHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_spot_fleet_request_history_input(DryRun = DryRun, SpotFleetRequestId = SpotFleetRequestId, EventType = EventType, StartTime = StartTime, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_spot_fleet_request_history_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_fleet_request_history <- ec2_describe_spot_fleet_request_history

#' Describes your Spot Fleet requests
#'
#' @description
#' Describes your Spot Fleet requests.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_spot_fleet_requests/](https://www.paws-r-sdk.com/docs/ec2_describe_spot_fleet_requests/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotFleetRequestIds The IDs of the Spot Fleet requests.
#' @param NextToken The token to include in another request to get the next page of items.
#' This value is `null` when there are no more items to return.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_fleet_requests
ec2_describe_spot_fleet_requests <- function(DryRun = NULL, SpotFleetRequestIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSpotFleetRequests",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SpotFleetRequestConfigs"),
    stream_api = FALSE
  )
  input <- .ec2$describe_spot_fleet_requests_input(DryRun = DryRun, SpotFleetRequestIds = SpotFleetRequestIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_spot_fleet_requests_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_fleet_requests <- ec2_describe_spot_fleet_requests

#' Describes the specified Spot Instance requests
#'
#' @description
#' Describes the specified Spot Instance requests.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_spot_instance_requests/](https://www.paws-r-sdk.com/docs/ec2_describe_spot_instance_requests/) for full documentation.
#'
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotInstanceRequestIds The IDs of the Spot Instance requests.
#' @param Filters The filters.
#' 
#' -   `availability-zone-group` - The Availability Zone group.
#' 
#' -   `create-time` - The time stamp when the Spot Instance request was
#'     created.
#' 
#' -   `fault-code` - The fault code related to the request.
#' 
#' -   `fault-message` - The fault message related to the request.
#' 
#' -   `instance-id` - The ID of the instance that fulfilled the request.
#' 
#' -   `launch-group` - The Spot Instance launch group.
#' 
#' -   `launch.block-device-mapping.delete-on-termination` - Indicates
#'     whether the EBS volume is deleted on instance termination.
#' 
#' -   `launch.block-device-mapping.device-name` - The device name for the
#'     volume in the block device mapping (for example, `/dev/sdh` or
#'     `xvdh`).
#' 
#' -   `launch.block-device-mapping.snapshot-id` - The ID of the snapshot
#'     for the EBS volume.
#' 
#' -   `launch.block-device-mapping.volume-size` - The size of the EBS
#'     volume, in GiB.
#' 
#' -   `launch.block-device-mapping.volume-type` - The type of EBS volume:
#'     `gp2` or `gp3` for General Purpose SSD, `io1` or `io2` for
#'     Provisioned IOPS SSD, `st1` for Throughput Optimized HDD, `sc1` for
#'     Cold HDD, or `standard` for Magnetic.
#' 
#' -   `launch.group-id` - The ID of the security group for the instance.
#' 
#' -   `launch.group-name` - The name of the security group for the
#'     instance.
#' 
#' -   `launch.image-id` - The ID of the AMI.
#' 
#' -   `launch.instance-type` - The type of instance (for example,
#'     `m3.medium`).
#' 
#' -   `launch.kernel-id` - The kernel ID.
#' 
#' -   `launch.key-name` - The name of the key pair the instance launched
#'     with.
#' 
#' -   `launch.monitoring-enabled` - Whether detailed monitoring is enabled
#'     for the Spot Instance.
#' 
#' -   `launch.ramdisk-id` - The RAM disk ID.
#' 
#' -   `launched-availability-zone` - The Availability Zone in which the
#'     request is launched.
#' 
#' -   `network-interface.addresses.primary` - Indicates whether the IP
#'     address is the primary private IP address.
#' 
#' -   `network-interface.delete-on-termination` - Indicates whether the
#'     network interface is deleted when the instance is terminated.
#' 
#' -   `network-interface.description` - A description of the network
#'     interface.
#' 
#' -   `network-interface.device-index` - The index of the device for the
#'     network interface attachment on the instance.
#' 
#' -   `network-interface.group-id` - The ID of the security group
#'     associated with the network interface.
#' 
#' -   `network-interface.network-interface-id` - The ID of the network
#'     interface.
#' 
#' -   `network-interface.private-ip-address` - The primary private IP
#'     address of the network interface.
#' 
#' -   `network-interface.subnet-id` - The ID of the subnet for the
#'     instance.
#' 
#' -   `product-description` - The product description associated with the
#'     instance (`Linux/UNIX` | `Windows`).
#' 
#' -   `spot-instance-request-id` - The Spot Instance request ID.
#' 
#' -   `spot-price` - The maximum hourly price for any Spot Instance
#'     launched to fulfill the request.
#' 
#' -   `state` - The state of the Spot Instance request (`open` | `active`
#'     | `closed` | `cancelled` | `failed`). Spot request status
#'     information can help you track your Amazon EC2 Spot Instance
#'     requests. For more information, see [Spot request
#'     status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-request-status.html)
#'     in the *Amazon EC2 User Guide*.
#' 
#' -   `status-code` - The short code describing the most recent evaluation
#'     of your Spot Instance request.
#' 
#' -   `status-message` - The message explaining the status of the Spot
#'     Instance request.
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `type` - The type of Spot Instance request (`one-time` |
#'     `persistent`).
#' 
#' -   `valid-from` - The start date of the request.
#' 
#' -   `valid-until` - The end date of the request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_instance_requests
ec2_describe_spot_instance_requests <- function(NextToken = NULL, MaxResults = NULL, DryRun = NULL, SpotInstanceRequestIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSpotInstanceRequests",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SpotInstanceRequests"),
    stream_api = FALSE
  )
  input <- .ec2$describe_spot_instance_requests_input(NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, SpotInstanceRequestIds = SpotInstanceRequestIds, Filters = Filters)
  output <- .ec2$describe_spot_instance_requests_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_instance_requests <- ec2_describe_spot_instance_requests

#' Describes the Spot price history
#'
#' @description
#' Describes the Spot price history. For more information, see [Spot Instance pricing history](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_spot_price_history/](https://www.paws-r-sdk.com/docs/ec2_describe_spot_price_history/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param StartTime The date and time, up to the past 90 days, from which to start
#' retrieving the price history data, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#' @param EndTime The date and time, up to the current date, from which to stop retrieving
#' the price history data, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#' @param InstanceTypes Filters the results by the specified instance types.
#' @param ProductDescriptions Filters the results by the specified basic product descriptions.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone for which prices should
#'     be returned.
#' 
#' -   `instance-type` - The type of instance (for example, `m3.medium`).
#' 
#' -   `product-description` - The product description for the Spot price
#'     (`Linux/UNIX` | `Red Hat Enterprise Linux` | `SUSE Linux` |
#'     `Windows` | `Linux/UNIX (Amazon VPC)` |
#'     `Red Hat Enterprise Linux (Amazon VPC)` | `SUSE Linux (Amazon VPC)`
#'     | `Windows (Amazon VPC)`).
#' 
#' -   `spot-price` - The Spot price. The value must match exactly (or use
#'     wildcards; greater than or less than comparison is not supported).
#' 
#' -   `timestamp` - The time stamp of the Spot price history, in UTC
#'     format (for example, *ddd MMM dd HH*:*mm*:*ss* UTC *YYYY*). You can
#'     use wildcards (`*` and `?`). Greater than or less than comparison is
#'     not supported.
#' @param AvailabilityZone Filters the results by the specified Availability Zone.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_price_history
ec2_describe_spot_price_history <- function(DryRun = NULL, StartTime = NULL, EndTime = NULL, InstanceTypes = NULL, ProductDescriptions = NULL, Filters = NULL, AvailabilityZone = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSpotPriceHistory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SpotPriceHistory"),
    stream_api = FALSE
  )
  input <- .ec2$describe_spot_price_history_input(DryRun = DryRun, StartTime = StartTime, EndTime = EndTime, InstanceTypes = InstanceTypes, ProductDescriptions = ProductDescriptions, Filters = Filters, AvailabilityZone = AvailabilityZone, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_spot_price_history_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_price_history <- ec2_describe_spot_price_history

#' Describes the stale security group rules for security groups referenced
#' across a VPC peering connection, transit gateway connection, or with a
#' security group VPC association
#'
#' @description
#' Describes the stale security group rules for security groups referenced across a VPC peering connection, transit gateway connection, or with a security group VPC association. Rules are stale when they reference a deleted security group. Rules can also be stale if they reference a security group in a peer VPC for which the VPC peering connection has been deleted, across a transit gateway where the transit gateway has been deleted (or [the transit gateway security group referencing feature](https://docs.aws.amazon.com/vpc/latest/tgw/tgw-vpc-attachments.html#vpc-attachment-security) has been disabled), or if a security group VPC association has been disassociated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_stale_security_groups/](https://www.paws-r-sdk.com/docs/ec2_describe_stale_security_groups/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_stale_security_groups
ec2_describe_stale_security_groups <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, VpcId) {
  op <- new_operation(
    name = "DescribeStaleSecurityGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "StaleSecurityGroupSet"),
    stream_api = FALSE
  )
  input <- .ec2$describe_stale_security_groups_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, VpcId = VpcId)
  output <- .ec2$describe_stale_security_groups_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_stale_security_groups <- ec2_describe_stale_security_groups

#' Describes the progress of the AMI store tasks
#'
#' @description
#' Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from the last 31 days.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_store_image_tasks/](https://www.paws-r-sdk.com/docs/ec2_describe_store_image_tasks/) for full documentation.
#'
#' @param ImageIds The AMI IDs for which to show progress. Up to 20 AMI IDs can be included
#' in a request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `task-state` - Returns tasks in a certain state (`InProgress` |
#'     `Completed` | `Failed`)
#' 
#' -   `bucket` - Returns task information for tasks that targeted a
#'     specific bucket. For the filter value, specify the bucket name.
#' 
#' When you specify the `ImageIds` parameter, any filters that you specify
#' are ignored. To use the filters, you must remove the `ImageIds`
#' parameter.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' 
#' You cannot specify this parameter and the `ImageIds` parameter in the
#' same call.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_store_image_tasks
ec2_describe_store_image_tasks <- function(ImageIds = NULL, DryRun = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeStoreImageTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "StoreImageTaskResults"),
    stream_api = FALSE
  )
  input <- .ec2$describe_store_image_tasks_input(ImageIds = ImageIds, DryRun = DryRun, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_store_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_store_image_tasks <- ec2_describe_store_image_tasks

#' Describes your subnets
#'
#' @description
#' Describes your subnets. The default is to describe all your subnets. Alternatively, you can specify specific subnet IDs or filter the results to include only the subnets that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_subnets/](https://www.paws-r-sdk.com/docs/ec2_describe_subnets/) for full documentation.
#'
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone for the subnet. You can
#'     also use `availabilityZone` as the filter name.
#' 
#' -   `availability-zone-id` - The ID of the Availability Zone for the
#'     subnet. You can also use `availabilityZoneId` as the filter name.
#' 
#' -   `available-ip-address-count` - The number of IPv4 addresses in the
#'     subnet that are available.
#' 
#' -   `cidr-block` - The IPv4 CIDR block of the subnet. The CIDR block you
#'     specify must exactly match the subnet's CIDR block for information
#'     to be returned for the subnet. You can also use `cidr` or
#'     `cidrBlock` as the filter names.
#' 
#' -   `customer-owned-ipv4-pool` - The customer-owned IPv4 address pool
#'     associated with the subnet.
#' 
#' -   `default-for-az` - Indicates whether this is the default subnet for
#'     the Availability Zone (`true` | `false`). You can also use
#'     `defaultForAz` as the filter name.
#' 
#' -   `enable-dns64` - Indicates whether DNS queries made to the
#'     Amazon-provided DNS Resolver in this subnet should return synthetic
#'     IPv6 addresses for IPv4-only destinations.
#' 
#' -   `enable-lni-at-device-index` - Indicates the device position for
#'     local network interfaces in this subnet. For example, `1` indicates
#'     local network interfaces in this subnet are the secondary network
#'     interface (eth1).
#' 
#' -   `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
#'     associated with the subnet.
#' 
#' -   `ipv6-cidr-block-association.association-id` - An association ID for
#'     an IPv6 CIDR block associated with the subnet.
#' 
#' -   `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
#'     block associated with the subnet.
#' 
#' -   `ipv6-native` - Indicates whether this is an IPv6 only subnet
#'     (`true` | `false`).
#' 
#' -   `map-customer-owned-ip-on-launch` - Indicates whether a network
#'     interface created in this subnet (including a network interface
#'     created by [`run_instances`][ec2_run_instances]) receives a
#'     customer-owned IPv4 address.
#' 
#' -   `map-public-ip-on-launch` - Indicates whether instances launched in
#'     this subnet receive a public IPv4 address.
#' 
#' -   `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     subnet.
#' 
#' -   `private-dns-name-options-on-launch.hostname-type` - The type of
#'     hostname to assign to instances in the subnet at launch. For
#'     IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS
#'     name can be based on the instance IPv4 address (ip-name) or the
#'     instance ID (resource-name). For IPv6 only subnets, an instance DNS
#'     name must be based on the instance ID (resource-name).
#' 
#' -   `private-dns-name-options-on-launch.enable-resource-name-dns-a-record` -
#'     Indicates whether to respond to DNS queries for instance hostnames
#'     with DNS A records.
#' 
#' -   `private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record` -
#'     Indicates whether to respond to DNS queries for instance hostnames
#'     with DNS AAAA records.
#' 
#' -   `state` - The state of the subnet (`pending` | `available`).
#' 
#' -   `subnet-arn` - The Amazon Resource Name (ARN) of the subnet.
#' 
#' -   `subnet-id` - The ID of the subnet.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the subnet.
#' @param SubnetIds The IDs of the subnets.
#' 
#' Default: Describes all your subnets.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_subnets
ec2_describe_subnets <- function(Filters = NULL, SubnetIds = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSubnets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Subnets"),
    stream_api = FALSE
  )
  input <- .ec2$describe_subnets_input(Filters = Filters, SubnetIds = SubnetIds, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_subnets_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_subnets <- ec2_describe_subnets

#' Describes the specified tags for your EC2 resources
#'
#' @description
#' Describes the specified tags for your EC2 resources.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_tags/](https://www.paws-r-sdk.com/docs/ec2_describe_tags/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `key` - The tag key.
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-type` - The resource type. For a list of possible values,
#'     see
#'     [TagSpecification](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TagSpecification.html).
#' 
#' -   `tag`:\<key\> - The key/value combination of the tag. For example,
#'     specify "tag:Owner" for the filter name and "TeamA" for the filter
#'     value to find resources with the tag "Owner=TeamA".
#' 
#' -   `value` - The tag value.
#' @param MaxResults The maximum number of items to return for this request. This value can
#' be between 5 and 1000. To get the next page of items, make another
#' request with the token returned in the output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_tags
ec2_describe_tags <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .ec2$describe_tags_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_tags_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_tags <- ec2_describe_tags

#' Describe traffic mirror filters that determine the traffic that is
#' mirrored
#'
#' @description
#' Describe traffic mirror filters that determine the traffic that is mirrored.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_filter_rules/](https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_filter_rules/) for full documentation.
#'
#' @param TrafficMirrorFilterRuleIds Traffic filter rule IDs.
#' @param TrafficMirrorFilterId Traffic filter ID.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Traffic mirror filters.
#' 
#' -   `traffic-mirror-filter-rule-id`: The ID of the Traffic Mirror rule.
#' 
#' -   `traffic-mirror-filter-id`: The ID of the filter that this rule is
#'     associated with.
#' 
#' -   `rule-number`: The number of the Traffic Mirror rule.
#' 
#' -   `rule-action`: The action taken on the filtered traffic. Possible
#'     actions are `accept` and `reject`.
#' 
#' -   `traffic-direction`: The traffic direction. Possible directions are
#'     `ingress` and `egress`.
#' 
#' -   `protocol`: The protocol, for example UDP, assigned to the Traffic
#'     Mirror rule.
#' 
#' -   `source-cidr-block`: The source CIDR block assigned to the Traffic
#'     Mirror rule.
#' 
#' -   `destination-cidr-block`: The destination CIDR block assigned to the
#'     Traffic Mirror rule.
#' 
#' -   `description`: The description of the Traffic Mirror rule.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_filter_rules
ec2_describe_traffic_mirror_filter_rules <- function(TrafficMirrorFilterRuleIds = NULL, TrafficMirrorFilterId = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorFilterRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_traffic_mirror_filter_rules_input(TrafficMirrorFilterRuleIds = TrafficMirrorFilterRuleIds, TrafficMirrorFilterId = TrafficMirrorFilterId, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_filter_rules_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_filter_rules <- ec2_describe_traffic_mirror_filter_rules

#' Describes one or more Traffic Mirror filters
#'
#' @description
#' Describes one or more Traffic Mirror filters.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_filters/](https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_filters/) for full documentation.
#'
#' @param TrafficMirrorFilterIds The ID of the Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `description`: The Traffic Mirror filter description.
#' 
#' -   `traffic-mirror-filter-id`: The ID of the Traffic Mirror filter.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_filters
ec2_describe_traffic_mirror_filters <- function(TrafficMirrorFilterIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorFilters",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TrafficMirrorFilters"),
    stream_api = FALSE
  )
  input <- .ec2$describe_traffic_mirror_filters_input(TrafficMirrorFilterIds = TrafficMirrorFilterIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_filters_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_filters <- ec2_describe_traffic_mirror_filters

#' Describes one or more Traffic Mirror sessions
#'
#' @description
#' Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_sessions/](https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_sessions/) for full documentation.
#'
#' @param TrafficMirrorSessionIds The ID of the Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `description`: The Traffic Mirror session description.
#' 
#' -   `network-interface-id`: The ID of the Traffic Mirror session network
#'     interface.
#' 
#' -   `owner-id`: The ID of the account that owns the Traffic Mirror
#'     session.
#' 
#' -   `packet-length`: The assigned number of packets to mirror.
#' 
#' -   `session-number`: The assigned session number.
#' 
#' -   `traffic-mirror-filter-id`: The ID of the Traffic Mirror filter.
#' 
#' -   `traffic-mirror-session-id`: The ID of the Traffic Mirror session.
#' 
#' -   `traffic-mirror-target-id`: The ID of the Traffic Mirror target.
#' 
#' -   `virtual-network-id`: The virtual network ID of the Traffic Mirror
#'     session.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_sessions
ec2_describe_traffic_mirror_sessions <- function(TrafficMirrorSessionIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorSessions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TrafficMirrorSessions"),
    stream_api = FALSE
  )
  input <- .ec2$describe_traffic_mirror_sessions_input(TrafficMirrorSessionIds = TrafficMirrorSessionIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_sessions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_sessions <- ec2_describe_traffic_mirror_sessions

#' Information about one or more Traffic Mirror targets
#'
#' @description
#' Information about one or more Traffic Mirror targets.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_targets/](https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_targets/) for full documentation.
#'
#' @param TrafficMirrorTargetIds The ID of the Traffic Mirror targets.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `description`: The Traffic Mirror target description.
#' 
#' -   `network-interface-id`: The ID of the Traffic Mirror session network
#'     interface.
#' 
#' -   `network-load-balancer-arn`: The Amazon Resource Name (ARN) of the
#'     Network Load Balancer that is associated with the session.
#' 
#' -   `owner-id`: The ID of the account that owns the Traffic Mirror
#'     session.
#' 
#' -   `traffic-mirror-target-id`: The ID of the Traffic Mirror target.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_targets
ec2_describe_traffic_mirror_targets <- function(TrafficMirrorTargetIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorTargets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TrafficMirrorTargets"),
    stream_api = FALSE
  )
  input <- .ec2$describe_traffic_mirror_targets_input(TrafficMirrorTargetIds = TrafficMirrorTargetIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_targets_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_targets <- ec2_describe_traffic_mirror_targets

#' Describes one or more attachments between resources and transit gateways
#'
#' @description
#' Describes one or more attachments between resources and transit gateways. By default, all attachments are described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_attachments/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_attachments/) for full documentation.
#'
#' @param TransitGatewayAttachmentIds The IDs of the attachments.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `association.state` - The state of the association (`associating` |
#'     `associated` | `disassociating`).
#' 
#' -   `association.transit-gateway-route-table-id` - The ID of the route
#'     table for the transit gateway.
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-owner-id` - The ID of the Amazon Web Services account that
#'     owns the resource.
#' 
#' -   `resource-type` - The resource type. Valid values are `vpc` | `vpn`
#'     | `direct-connect-gateway` | `peering` | `connect`.
#' 
#' -   `state` - The state of the attachment. Valid values are `available`
#'     | `deleted` | `deleting` | `failed` | `failing` |
#'     `initiatingRequest` | `modifying` | `pendingAcceptance` | `pending`
#'     | `rollingBack` | `rejected` | `rejecting`.
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transit-gateway-owner-id` - The ID of the Amazon Web Services
#'     account that owns the transit gateway.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_attachments
ec2_describe_transit_gateway_attachments <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayAttachments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayAttachments"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_attachments_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_attachments_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_attachments <- ec2_describe_transit_gateway_attachments

#' Describes one or more Connect peers
#'
#' @description
#' Describes one or more Connect peers.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_connect_peers/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_connect_peers/) for full documentation.
#'
#' @param TransitGatewayConnectPeerIds The IDs of the Connect peers.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `state` - The state of the Connect peer (`pending` | `available` |
#'     `deleting` | `deleted`).
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' 
#' -   `transit-gateway-connect-peer-id` - The ID of the Connect peer.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_connect_peers
ec2_describe_transit_gateway_connect_peers <- function(TransitGatewayConnectPeerIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayConnectPeers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayConnectPeers"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_connect_peers_input(TransitGatewayConnectPeerIds = TransitGatewayConnectPeerIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_connect_peers_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_connect_peers <- ec2_describe_transit_gateway_connect_peers

#' Describes one or more Connect attachments
#'
#' @description
#' Describes one or more Connect attachments.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_connects/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_connects/) for full documentation.
#'
#' @param TransitGatewayAttachmentIds The IDs of the attachments.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `options.protocol` - The tunnel protocol (`gre`).
#' 
#' -   `state` - The state of the attachment (`initiating` |
#'     `initiatingRequest` | `pendingAcceptance` | `rollingBack` |
#'     `pending` | `available` | `modifying` | `deleting` | `deleted` |
#'     `failed` | `rejected` | `rejecting` | `failing`).
#' 
#' -   `transit-gateway-attachment-id` - The ID of the Connect attachment.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transport-transit-gateway-attachment-id` - The ID of the transit
#'     gateway attachment from which the Connect attachment was created.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_connects
ec2_describe_transit_gateway_connects <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayConnects",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayConnects"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_connects_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_connects_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_connects <- ec2_describe_transit_gateway_connects

#' Describes one or more transit gateway multicast domains
#'
#' @description
#' Describes one or more transit gateway multicast domains.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_multicast_domains/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_multicast_domains/) for full documentation.
#'
#' @param TransitGatewayMulticastDomainIds The ID of the transit gateway multicast domain.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `state` - The state of the transit gateway multicast domain. Valid
#'     values are `pending` | `available` | `deleting` | `deleted`.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transit-gateway-multicast-domain-id` - The ID of the transit
#'     gateway multicast domain.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_multicast_domains
ec2_describe_transit_gateway_multicast_domains <- function(TransitGatewayMulticastDomainIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayMulticastDomains",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayMulticastDomains"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_multicast_domains_input(TransitGatewayMulticastDomainIds = TransitGatewayMulticastDomainIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_multicast_domains_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_multicast_domains <- ec2_describe_transit_gateway_multicast_domains

#' Describes your transit gateway peering attachments
#'
#' @description
#' Describes your transit gateway peering attachments.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_peering_attachments/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_peering_attachments/) for full documentation.
#'
#' @param TransitGatewayAttachmentIds One or more IDs of the transit gateway peering attachments.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `transit-gateway-attachment-id` - The ID of the transit gateway
#'     attachment.
#' 
#' -   `local-owner-id` - The ID of your Amazon Web Services account.
#' 
#' -   `remote-owner-id` - The ID of the Amazon Web Services account in the
#'     remote Region that owns the transit gateway.
#' 
#' -   `state` - The state of the peering attachment. Valid values are
#'     `available` | `deleted` | `deleting` | `failed` | `failing` |
#'     `initiatingRequest` | `modifying` | `pendingAcceptance` | `pending`
#'     | `rollingBack` | `rejected` | `rejecting`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_peering_attachments
ec2_describe_transit_gateway_peering_attachments <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayPeeringAttachments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayPeeringAttachments"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_peering_attachments_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_peering_attachments_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_peering_attachments <- ec2_describe_transit_gateway_peering_attachments

#' Describes one or more transit gateway route policy tables
#'
#' @description
#' Describes one or more transit gateway route policy tables.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_policy_tables/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_policy_tables/) for full documentation.
#'
#' @param TransitGatewayPolicyTableIds The IDs of the transit gateway policy tables.
#' @param Filters The filters associated with the transit gateway policy table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_policy_tables
ec2_describe_transit_gateway_policy_tables <- function(TransitGatewayPolicyTableIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayPolicyTables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayPolicyTables"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_policy_tables_input(TransitGatewayPolicyTableIds = TransitGatewayPolicyTableIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_policy_tables_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_policy_tables <- ec2_describe_transit_gateway_policy_tables

#' Describes one or more transit gateway route table advertisements
#'
#' @description
#' Describes one or more transit gateway route table advertisements.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_route_table_announcements/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_route_table_announcements/) for full documentation.
#'
#' @param TransitGatewayRouteTableAnnouncementIds The IDs of the transit gateway route tables that are being advertised.
#' @param Filters The filters associated with the transit gateway policy table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_route_table_announcements
ec2_describe_transit_gateway_route_table_announcements <- function(TransitGatewayRouteTableAnnouncementIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayRouteTableAnnouncements",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayRouteTableAnnouncements"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_route_table_announcements_input(TransitGatewayRouteTableAnnouncementIds = TransitGatewayRouteTableAnnouncementIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_route_table_announcements_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_route_table_announcements <- ec2_describe_transit_gateway_route_table_announcements

#' Describes one or more transit gateway route tables
#'
#' @description
#' Describes one or more transit gateway route tables. By default, all transit gateway route tables are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_route_tables/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_route_tables/) for full documentation.
#'
#' @param TransitGatewayRouteTableIds The IDs of the transit gateway route tables.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `default-association-route-table` - Indicates whether this is the
#'     default association route table for the transit gateway (`true` |
#'     `false`).
#' 
#' -   `default-propagation-route-table` - Indicates whether this is the
#'     default propagation route table for the transit gateway (`true` |
#'     `false`).
#' 
#' -   `state` - The state of the route table (`available` | `deleting` |
#'     `deleted` | `pending`).
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transit-gateway-route-table-id` - The ID of the transit gateway
#'     route table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_route_tables
ec2_describe_transit_gateway_route_tables <- function(TransitGatewayRouteTableIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayRouteTables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayRouteTables"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_route_tables_input(TransitGatewayRouteTableIds = TransitGatewayRouteTableIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_route_tables <- ec2_describe_transit_gateway_route_tables

#' Describes one or more VPC attachments
#'
#' @description
#' Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_vpc_attachments/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateway_vpc_attachments/) for full documentation.
#'
#' @param TransitGatewayAttachmentIds The IDs of the attachments.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `state` - The state of the attachment. Valid values are `available`
#'     | `deleted` | `deleting` | `failed` | `failing` |
#'     `initiatingRequest` | `modifying` | `pendingAcceptance` | `pending`
#'     | `rollingBack` | `rejected` | `rejecting`.
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `vpc-id` - The ID of the VPC.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_vpc_attachments
ec2_describe_transit_gateway_vpc_attachments <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayVpcAttachments",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGatewayVpcAttachments"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateway_vpc_attachments_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_vpc_attachments_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_vpc_attachments <- ec2_describe_transit_gateway_vpc_attachments

#' Describes one or more transit gateways
#'
#' @description
#' Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can filter the results.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_transit_gateways/) for full documentation.
#'
#' @param TransitGatewayIds The IDs of the transit gateways.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `options.propagation-default-route-table-id` - The ID of the default
#'     propagation route table.
#' 
#' -   `options.amazon-side-asn` - The private ASN for the Amazon side of a
#'     BGP session.
#' 
#' -   `options.association-default-route-table-id` - The ID of the default
#'     association route table.
#' 
#' -   `options.auto-accept-shared-attachments` - Indicates whether there
#'     is automatic acceptance of attachment requests (`enable` |
#'     `disable`).
#' 
#' -   `options.default-route-table-association` - Indicates whether
#'     resource attachments are automatically associated with the default
#'     association route table (`enable` | `disable`).
#' 
#' -   `options.default-route-table-propagation` - Indicates whether
#'     resource attachments automatically propagate routes to the default
#'     propagation route table (`enable` | `disable`).
#' 
#' -   `options.dns-support` - Indicates whether DNS support is enabled
#'     (`enable` | `disable`).
#' 
#' -   `options.vpn-ecmp-support` - Indicates whether Equal Cost Multipath
#'     Protocol support is enabled (`enable` | `disable`).
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     transit gateway.
#' 
#' -   `state` - The state of the transit gateway (`available` | `deleted`
#'     | `deleting` | `modifying` | `pending`).
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `tag-key `- The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateways
ec2_describe_transit_gateways <- function(TransitGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TransitGateways"),
    stream_api = FALSE
  )
  input <- .ec2$describe_transit_gateways_input(TransitGatewayIds = TransitGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateways <- ec2_describe_transit_gateways

#' Describes one or more network interface trunk associations
#'
#' @description
#' Describes one or more network interface trunk associations.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_trunk_interface_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_trunk_interface_associations/) for full documentation.
#'
#' @param AssociationIds The IDs of the associations.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `gre-key` - The ID of a trunk interface association.
#' 
#' -   `interface-protocol` - The interface protocol. Valid values are
#'     `VLAN` and `GRE`.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_trunk_interface_associations
ec2_describe_trunk_interface_associations <- function(AssociationIds = NULL, DryRun = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeTrunkInterfaceAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InterfaceAssociations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_trunk_interface_associations_input(AssociationIds = AssociationIds, DryRun = DryRun, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_trunk_interface_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_trunk_interface_associations <- ec2_describe_trunk_interface_associations

#' Describes the specified Amazon Web Services Verified Access endpoints
#'
#' @description
#' Describes the specified Amazon Web Services Verified Access endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_endpoints/](https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_endpoints/) for full documentation.
#'
#' @param VerifiedAccessEndpointIds The ID of the Verified Access endpoint.
#' @param VerifiedAccessInstanceId The ID of the Verified Access instance.
#' @param VerifiedAccessGroupId The ID of the Verified Access group.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_verified_access_endpoints
ec2_describe_verified_access_endpoints <- function(VerifiedAccessEndpointIds = NULL, VerifiedAccessInstanceId = NULL, VerifiedAccessGroupId = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVerifiedAccessEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VerifiedAccessEndpoints"),
    stream_api = FALSE
  )
  input <- .ec2$describe_verified_access_endpoints_input(VerifiedAccessEndpointIds = VerifiedAccessEndpointIds, VerifiedAccessInstanceId = VerifiedAccessInstanceId, VerifiedAccessGroupId = VerifiedAccessGroupId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_verified_access_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_verified_access_endpoints <- ec2_describe_verified_access_endpoints

#' Describes the specified Verified Access groups
#'
#' @description
#' Describes the specified Verified Access groups.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_groups/](https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_groups/) for full documentation.
#'
#' @param VerifiedAccessGroupIds The ID of the Verified Access groups.
#' @param VerifiedAccessInstanceId The ID of the Verified Access instance.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_verified_access_groups
ec2_describe_verified_access_groups <- function(VerifiedAccessGroupIds = NULL, VerifiedAccessInstanceId = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVerifiedAccessGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VerifiedAccessGroups"),
    stream_api = FALSE
  )
  input <- .ec2$describe_verified_access_groups_input(VerifiedAccessGroupIds = VerifiedAccessGroupIds, VerifiedAccessInstanceId = VerifiedAccessInstanceId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_verified_access_groups_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_verified_access_groups <- ec2_describe_verified_access_groups

#' Describes the specified Amazon Web Services Verified Access instances
#'
#' @description
#' Describes the specified Amazon Web Services Verified Access instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_instance_logging_configurations/](https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_instance_logging_configurations/) for full documentation.
#'
#' @param VerifiedAccessInstanceIds The IDs of the Verified Access instances.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_verified_access_instance_logging_configurations
ec2_describe_verified_access_instance_logging_configurations <- function(VerifiedAccessInstanceIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVerifiedAccessInstanceLoggingConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LoggingConfigurations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_verified_access_instance_logging_configurations_input(VerifiedAccessInstanceIds = VerifiedAccessInstanceIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_verified_access_instance_logging_configurations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_verified_access_instance_logging_configurations <- ec2_describe_verified_access_instance_logging_configurations

#' Describes the specified Amazon Web Services Verified Access instances
#'
#' @description
#' Describes the specified Amazon Web Services Verified Access instances.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_instances/](https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_instances/) for full documentation.
#'
#' @param VerifiedAccessInstanceIds The IDs of the Verified Access instances.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_verified_access_instances
ec2_describe_verified_access_instances <- function(VerifiedAccessInstanceIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVerifiedAccessInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VerifiedAccessInstances"),
    stream_api = FALSE
  )
  input <- .ec2$describe_verified_access_instances_input(VerifiedAccessInstanceIds = VerifiedAccessInstanceIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_verified_access_instances_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_verified_access_instances <- ec2_describe_verified_access_instances

#' Describes the specified Amazon Web Services Verified Access trust
#' providers
#'
#' @description
#' Describes the specified Amazon Web Services Verified Access trust providers.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_trust_providers/](https://www.paws-r-sdk.com/docs/ec2_describe_verified_access_trust_providers/) for full documentation.
#'
#' @param VerifiedAccessTrustProviderIds The IDs of the Verified Access trust providers.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_verified_access_trust_providers
ec2_describe_verified_access_trust_providers <- function(VerifiedAccessTrustProviderIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVerifiedAccessTrustProviders",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VerifiedAccessTrustProviders"),
    stream_api = FALSE
  )
  input <- .ec2$describe_verified_access_trust_providers_input(VerifiedAccessTrustProviderIds = VerifiedAccessTrustProviderIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_verified_access_trust_providers_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_verified_access_trust_providers <- ec2_describe_verified_access_trust_providers

#' Describes the specified attribute of the specified volume
#'
#' @description
#' Describes the specified attribute of the specified volume. You can specify only one attribute at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_volume_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_volume_attribute/) for full documentation.
#'
#' @param Attribute &#91;required&#93; The attribute of the volume. This parameter is required.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volume_attribute
ec2_describe_volume_attribute <- function(Attribute, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVolumeAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_volume_attribute_input(Attribute = Attribute, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$describe_volume_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volume_attribute <- ec2_describe_volume_attribute

#' Describes the status of the specified volumes
#'
#' @description
#' Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_volume_status/](https://www.paws-r-sdk.com/docs/ec2_describe_volume_status/) for full documentation.
#'
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param VolumeIds The IDs of the volumes.
#' 
#' Default: Describes all your volumes.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `action.code` - The action code for the event (for example,
#'     `enable-volume-io`).
#' 
#' -   `action.description` - A description of the action.
#' 
#' -   `action.event-id` - The event ID associated with the action.
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `event.description` - A description of the event.
#' 
#' -   `event.event-id` - The event ID.
#' 
#' -   `event.event-type` - The event type (for `io-enabled`: `passed` |
#'     `failed`; for `io-performance`: `io-performance:degraded` |
#'     `io-performance:severely-degraded` | `io-performance:stalled`).
#' 
#' -   `event.not-after` - The latest end time for the event.
#' 
#' -   `event.not-before` - The earliest start time for the event.
#' 
#' -   `volume-status.details-name` - The cause for `volume-status.status`
#'     (`io-enabled` | `io-performance`).
#' 
#' -   `volume-status.details-status` - The status of
#'     `volume-status.details-name` (for `io-enabled`: `passed` | `failed`;
#'     for `io-performance`: `normal` | `degraded` | `severely-degraded` |
#'     `stalled`).
#' 
#' -   `volume-status.status` - The status of the volume (`ok` | `impaired`
#'     | `warning` | `insufficient-data`).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volume_status
ec2_describe_volume_status <- function(MaxResults = NULL, NextToken = NULL, VolumeIds = NULL, DryRun = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeVolumeStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VolumeStatuses"),
    stream_api = FALSE
  )
  input <- .ec2$describe_volume_status_input(MaxResults = MaxResults, NextToken = NextToken, VolumeIds = VolumeIds, DryRun = DryRun, Filters = Filters)
  output <- .ec2$describe_volume_status_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volume_status <- ec2_describe_volume_status

#' Describes the specified EBS volumes or all of your EBS volumes
#'
#' @description
#' Describes the specified EBS volumes or all of your EBS volumes.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_volumes/](https://www.paws-r-sdk.com/docs/ec2_describe_volumes/) for full documentation.
#'
#' @param VolumeIds The volume IDs. If not specified, then all volumes are included in the
#' response.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `attachment.attach-time` - The time stamp when the attachment
#'     initiated.
#' 
#' -   `attachment.delete-on-termination` - Whether the volume is deleted
#'     on instance termination.
#' 
#' -   `attachment.device` - The device name specified in the block device
#'     mapping (for example, `/dev/sda1`).
#' 
#' -   `attachment.instance-id` - The ID of the instance the volume is
#'     attached to.
#' 
#' -   `attachment.status` - The attachment state (`attaching` | `attached`
#'     | `detaching`).
#' 
#' -   `availability-zone` - The Availability Zone in which the volume was
#'     created.
#' 
#' -   `create-time` - The time stamp when the volume was created.
#' 
#' -   `encrypted` - Indicates whether the volume is encrypted (`true` |
#'     `false`)
#' 
#' -   `fast-restored` - Indicates whether the volume was created from a
#'     snapshot that is enabled for fast snapshot restore (`true` |
#'     `false`).
#' 
#' -   `multi-attach-enabled` - Indicates whether the volume is enabled for
#'     Multi-Attach (`true` | `false`)
#' 
#' -   `operator.managed` - A Boolean that indicates whether this is a
#'     managed volume.
#' 
#' -   `operator.principal` - The principal that manages the volume. Only
#'     valid for managed volumes, where `managed` is `true`.
#' 
#' -   `size` - The size of the volume, in GiB.
#' 
#' -   `snapshot-id` - The snapshot from which the volume was created.
#' 
#' -   `status` - The state of the volume (`creating` | `available` |
#'     `in-use` | `deleting` | `deleted` | `error`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `volume-id` - The volume ID.
#' 
#' -   `volume-type` - The Amazon EBS volume type (`gp2` | `gp3` | `io1` |
#'     `io2` | `st1` | `sc1`| `standard`)
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volumes
ec2_describe_volumes <- function(VolumeIds = NULL, DryRun = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVolumes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Volumes"),
    stream_api = FALSE
  )
  input <- .ec2$describe_volumes_input(VolumeIds = VolumeIds, DryRun = DryRun, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_volumes_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volumes <- ec2_describe_volumes

#' Describes the most recent volume modification request for the specified
#' EBS volumes
#'
#' @description
#' Describes the most recent volume modification request for the specified EBS volumes.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_volumes_modifications/](https://www.paws-r-sdk.com/docs/ec2_describe_volumes_modifications/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VolumeIds The IDs of the volumes.
#' @param Filters The filters.
#' 
#' -   `modification-state` - The current modification state (modifying |
#'     optimizing | completed | failed).
#' 
#' -   `original-iops` - The original IOPS rate of the volume.
#' 
#' -   `original-size` - The original size of the volume, in GiB.
#' 
#' -   `original-volume-type` - The original volume type of the volume
#'     (standard | io1 | io2 | gp2 | sc1 | st1).
#' 
#' -   `originalMultiAttachEnabled` - Indicates whether Multi-Attach
#'     support was enabled (true | false).
#' 
#' -   `start-time` - The modification start time.
#' 
#' -   `target-iops` - The target IOPS rate of the volume.
#' 
#' -   `target-size` - The target size of the volume, in GiB.
#' 
#' -   `target-volume-type` - The target volume type of the volume
#'     (standard | io1 | io2 | gp2 | sc1 | st1).
#' 
#' -   `targetMultiAttachEnabled` - Indicates whether Multi-Attach support
#'     is to be enabled (true | false).
#' 
#' -   `volume-id` - The ID of the volume.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of results (up to a limit of 500) to be returned in a
#' paginated request. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volumes_modifications
ec2_describe_volumes_modifications <- function(DryRun = NULL, VolumeIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVolumesModifications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VolumesModifications"),
    stream_api = FALSE
  )
  input <- .ec2$describe_volumes_modifications_input(DryRun = DryRun, VolumeIds = VolumeIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_volumes_modifications_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volumes_modifications <- ec2_describe_volumes_modifications

#' Describes the specified attribute of the specified VPC
#'
#' @description
#' Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_attribute/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_attribute/) for full documentation.
#'
#' @param Attribute &#91;required&#93; The VPC attribute.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_attribute
ec2_describe_vpc_attribute <- function(Attribute, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpcAttribute",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_attribute_input(Attribute = Attribute, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$describe_vpc_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_attribute <- ec2_describe_vpc_attribute

#' Describe VPC Block Public Access (BPA) exclusions
#'
#' @description
#' Describe VPC Block Public Access (BPA) exclusions. A VPC BPA exclusion is a mode that can be applied to a single VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see [Block public access to VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_block_public_access_exclusions/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_block_public_access_exclusions/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filters for the request:
#' 
#' -   `resource-arn` - The Amazon Resource Name (ARN) of a exclusion.
#' 
#' -   `internet-gateway-exclusion-mode` - The mode of a VPC BPA exclusion.
#'     Possible values: `allow-bidirectional | allow-egress`.
#' 
#' -   `state` - The state of VPC BPA. Possible values:
#'     `create-in-progress | create-complete | update-in-progress | update-complete | delete-in-progress | deleted-complete | disable-in-progress | disable-complete`
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tag-value`: The value of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific value,
#'     regardless of the tag key.
#' @param ExclusionIds IDs of exclusions.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_block_public_access_exclusions
ec2_describe_vpc_block_public_access_exclusions <- function(DryRun = NULL, Filters = NULL, ExclusionIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVpcBlockPublicAccessExclusions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_block_public_access_exclusions_input(DryRun = DryRun, Filters = Filters, ExclusionIds = ExclusionIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_vpc_block_public_access_exclusions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_block_public_access_exclusions <- ec2_describe_vpc_block_public_access_exclusions

#' Describe VPC Block Public Access (BPA) options
#'
#' @description
#' Describe VPC Block Public Access (BPA) options. VPC Block Public Access (BPA) enables you to block resources in VPCs and subnets that you own in a Region from reaching or being reached from the internet through internet gateways and egress-only internet gateways. To learn more about VPC BPA, see [Block public access to VPCs and subnets](https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_block_public_access_options/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_block_public_access_options/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_block_public_access_options
ec2_describe_vpc_block_public_access_options <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpcBlockPublicAccessOptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_block_public_access_options_input(DryRun = DryRun)
  output <- .ec2$describe_vpc_block_public_access_options_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_block_public_access_options <- ec2_describe_vpc_block_public_access_options

#' This action is deprecated
#'
#' @description
#' This action is deprecated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_classic_link/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_classic_link/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcIds The VPCs for which you want to describe the ClassicLink status.
#' @param Filters The filters.
#' 
#' -   `is-classic-link-enabled` - Whether the VPC is enabled for
#'     ClassicLink (`true` | `false`).
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_classic_link
ec2_describe_vpc_classic_link <- function(DryRun = NULL, VpcIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeVpcClassicLink",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_classic_link_input(DryRun = DryRun, VpcIds = VpcIds, Filters = Filters)
  output <- .ec2$describe_vpc_classic_link_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_classic_link <- ec2_describe_vpc_classic_link

#' This action is deprecated
#'
#' @description
#' This action is deprecated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_classic_link_dns_support/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_classic_link_dns_support/) for full documentation.
#'
#' @param VpcIds The IDs of the VPCs.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_classic_link_dns_support
ec2_describe_vpc_classic_link_dns_support <- function(VpcIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcClassicLinkDnsSupport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Vpcs"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_classic_link_dns_support_input(VpcIds = VpcIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_classic_link_dns_support_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_classic_link_dns_support <- ec2_describe_vpc_classic_link_dns_support

#' Describes the VPC resources, VPC endpoint services, Amazon Lattice
#' services, or service networks associated with the VPC endpoint
#'
#' @description
#' Describes the VPC resources, VPC endpoint services, Amazon Lattice services, or service networks associated with the VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_associations/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_associations/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointIds The IDs of the VPC endpoints.
#' @param Filters The filters.
#' 
#' -   `vpc-endpoint-id` - The ID of the VPC endpoint.
#' 
#' -   `associated-resource-accessibility` - The association state. When
#'     the state is `accessible`, it returns `AVAILABLE`. When the state is
#'     `inaccessible`, it returns `PENDING` or `FAILED`.
#' 
#' -   `association-id` - The ID of the VPC endpoint association.
#' 
#' -   `associated-resource-id` - The ID of the associated resource
#'     configuration.
#' 
#' -   `service-network-arn` - The Amazon Resource Name (ARN) of the
#'     associated service network. Only VPC endpoints of type service
#'     network will be returned.
#' 
#' -   `resource-configuration-group-arn` - The Amazon Resource Name (ARN)
#'     of the resource configuration of type GROUP.
#' 
#' -   `service-network-resource-association-id` - The ID of the
#'     association.
#' @param MaxResults The maximum page size.
#' @param NextToken The pagination token.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_associations
ec2_describe_vpc_endpoint_associations <- function(DryRun = NULL, VpcEndpointIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoint_associations_input(DryRun = DryRun, VpcEndpointIds = VpcEndpointIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_associations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_associations <- ec2_describe_vpc_endpoint_associations

#' Describes the connection notifications for VPC endpoints and VPC
#' endpoint services
#'
#' @description
#' Describes the connection notifications for VPC endpoints and VPC endpoint services.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_connection_notifications/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_connection_notifications/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConnectionNotificationId The ID of the notification.
#' @param Filters The filters.
#' 
#' -   `connection-notification-arn` - The ARN of the SNS topic for the
#'     notification.
#' 
#' -   `connection-notification-id` - The ID of the notification.
#' 
#' -   `connection-notification-state` - The state of the notification
#'     (`Enabled` | `Disabled`).
#' 
#' -   `connection-notification-type` - The type of notification (`Topic`).
#' 
#' -   `service-id` - The ID of the endpoint service.
#' 
#' -   `vpc-endpoint-id` - The ID of the VPC endpoint.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another request with the returned
#' `NextToken` value.
#' @param NextToken The token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_connection_notifications
ec2_describe_vpc_endpoint_connection_notifications <- function(DryRun = NULL, ConnectionNotificationId = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointConnectionNotifications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ConnectionNotificationSet"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoint_connection_notifications_input(DryRun = DryRun, ConnectionNotificationId = ConnectionNotificationId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_connection_notifications_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_connection_notifications <- ec2_describe_vpc_endpoint_connection_notifications

#' Describes the VPC endpoint connections to your VPC endpoint services,
#' including any endpoints that are pending your acceptance
#'
#' @description
#' Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending your acceptance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_connections/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_connections/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `ip-address-type` - The IP address type (`ipv4` | `ipv6`).
#' 
#' -   `service-id` - The ID of the service.
#' 
#' -   `vpc-endpoint-owner` - The ID of the Amazon Web Services account ID
#'     that owns the endpoint.
#' 
#' -   `vpc-endpoint-region` - The Region of the endpoint or `cross-region`
#'     to find endpoints for other Regions.
#' 
#' -   `vpc-endpoint-state` - The state of the endpoint
#'     (`pendingAcceptance` | `pending` | `available` | `deleting` |
#'     `deleted` | `rejected` | `failed`).
#' 
#' -   `vpc-endpoint-id` - The ID of the endpoint.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1,000; if `MaxResults` is given a value larger than
#' 1,000, only 1,000 results are returned.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_connections
ec2_describe_vpc_endpoint_connections <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VpcEndpointConnections"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoint_connections_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_connections_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_connections <- ec2_describe_vpc_endpoint_connections

#' Describes the VPC endpoint service configurations in your account (your
#' services)
#'
#' @description
#' Describes the VPC endpoint service configurations in your account (your services).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_service_configurations/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_service_configurations/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceIds The IDs of the endpoint services.
#' @param Filters The filters.
#' 
#' -   `service-name` - The name of the service.
#' 
#' -   `service-id` - The ID of the service.
#' 
#' -   `service-state` - The state of the service (`Pending` | `Available`
#'     | `Deleting` | `Deleted` | `Failed`).
#' 
#' -   `supported-ip-address-types` - The IP address type (`ipv4` |
#'     `ipv6`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1,000; if `MaxResults` is given a value larger than
#' 1,000, only 1,000 results are returned.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_service_configurations
ec2_describe_vpc_endpoint_service_configurations <- function(DryRun = NULL, ServiceIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointServiceConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ServiceConfigurations"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoint_service_configurations_input(DryRun = DryRun, ServiceIds = ServiceIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_service_configurations_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_service_configurations <- ec2_describe_vpc_endpoint_service_configurations

#' Describes the principals (service consumers) that are permitted to
#' discover your VPC endpoint service
#'
#' @description
#' Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_service_permissions/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_service_permissions/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId &#91;required&#93; The ID of the service.
#' @param Filters The filters.
#' 
#' -   `principal` - The ARN of the principal.
#' 
#' -   `principal-type` - The principal type (`All` | `Service` |
#'     `OrganizationUnit` | `Account` | `User` | `Role`).
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1,000; if `MaxResults` is given a value larger than
#' 1,000, only 1,000 results are returned.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_service_permissions
ec2_describe_vpc_endpoint_service_permissions <- function(DryRun = NULL, ServiceId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointServicePermissions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AllowedPrincipals"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoint_service_permissions_input(DryRun = DryRun, ServiceId = ServiceId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_service_permissions_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_service_permissions <- ec2_describe_vpc_endpoint_service_permissions

#' Describes available services to which you can create a VPC endpoint
#'
#' @description
#' Describes available services to which you can create a VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_services/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_services/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceNames The service names.
#' @param Filters The filters.
#' 
#' -   `owner` - The ID or alias of the Amazon Web Services account that
#'     owns the service.
#' 
#' -   `service-name` - The name of the service.
#' 
#' -   `service-region` - The Region of the service.
#' 
#' -   `service-type` - The type of service (`Interface` | `Gateway` |
#'     `GatewayLoadBalancer`).
#' 
#' -   `supported-ip-address-types` - The IP address type (`ipv4` |
#'     `ipv6`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' 
#' Constraint: If the value is greater than 1,000, we return only 1,000
#' items.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a prior call.)
#' @param ServiceRegions The service Regions.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_services
ec2_describe_vpc_endpoint_services <- function(DryRun = NULL, ServiceNames = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, ServiceRegions = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointServices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = list("ServiceDetails", "ServiceNames")),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoint_services_input(DryRun = DryRun, ServiceNames = ServiceNames, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, ServiceRegions = ServiceRegions)
  output <- .ec2$describe_vpc_endpoint_services_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_services <- ec2_describe_vpc_endpoint_services

#' Describes your VPC endpoints
#'
#' @description
#' Describes your VPC endpoints. The default is to describe all your VPC endpoints. Alternatively, you can specify specific VPC endpoint IDs or filter the results to include only the VPC endpoints that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoints/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoints/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointIds The IDs of the VPC endpoints.
#' @param Filters The filters.
#' 
#' -   `ip-address-type` - The IP address type (`ipv4` | `ipv6`).
#' 
#' -   `service-name` - The name of the service.
#' 
#' -   `service-region` - The Region of the service.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC in which the endpoint resides.
#' 
#' -   `vpc-endpoint-id` - The ID of the endpoint.
#' 
#' -   `vpc-endpoint-state` - The state of the endpoint
#'     (`pendingAcceptance` | `pending` | `available` | `deleting` |
#'     `deleted` | `rejected` | `failed`).
#' 
#' -   `vpc-endpoint-type` - The type of VPC endpoint (`Interface` |
#'     `Gateway` | `GatewayLoadBalancer`).
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' 
#' Constraint: If the value is greater than 1,000, we return only 1,000
#' items.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a prior call.)
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoints
ec2_describe_vpc_endpoints <- function(DryRun = NULL, VpcEndpointIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VpcEndpoints"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_endpoints_input(DryRun = DryRun, VpcEndpointIds = VpcEndpointIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoints <- ec2_describe_vpc_endpoints

#' Describes your VPC peering connections
#'
#' @description
#' Describes your VPC peering connections. The default is to describe all your VPC peering connections. Alternatively, you can specify specific VPC peering connection IDs or filter the results to include only the VPC peering connections that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpc_peering_connections/](https://www.paws-r-sdk.com/docs/ec2_describe_vpc_peering_connections/) for full documentation.
#'
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionIds The IDs of the VPC peering connections.
#' 
#' Default: Describes all your VPC peering connections.
#' @param Filters The filters.
#' 
#' -   `accepter-vpc-info.cidr-block` - The IPv4 CIDR block of the accepter
#'     VPC.
#' 
#' -   `accepter-vpc-info.owner-id` - The ID of the Amazon Web Services
#'     account that owns the accepter VPC.
#' 
#' -   `accepter-vpc-info.vpc-id` - The ID of the accepter VPC.
#' 
#' -   `expiration-time` - The expiration date and time for the VPC peering
#'     connection.
#' 
#' -   `requester-vpc-info.cidr-block` - The IPv4 CIDR block of the
#'     requester's VPC.
#' 
#' -   `requester-vpc-info.owner-id` - The ID of the Amazon Web Services
#'     account that owns the requester VPC.
#' 
#' -   `requester-vpc-info.vpc-id` - The ID of the requester VPC.
#' 
#' -   `status-code` - The status of the VPC peering connection
#'     (`pending-acceptance` | `failed` | `expired` | `provisioning` |
#'     `active` | `deleting` | `deleted` | `rejected`).
#' 
#' -   `status-message` - A message that provides more information about
#'     the status of the VPC peering connection, if applicable.
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-peering-connection-id` - The ID of the VPC peering connection.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_peering_connections
ec2_describe_vpc_peering_connections <- function(NextToken = NULL, MaxResults = NULL, DryRun = NULL, VpcPeeringConnectionIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeVpcPeeringConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VpcPeeringConnections"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpc_peering_connections_input(NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun, VpcPeeringConnectionIds = VpcPeeringConnectionIds, Filters = Filters)
  output <- .ec2$describe_vpc_peering_connections_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_peering_connections <- ec2_describe_vpc_peering_connections

#' Describes your VPCs
#'
#' @description
#' Describes your VPCs. The default is to describe all your VPCs. Alternatively, you can specify specific VPC IDs or filter the results to include only the VPCs that match specific criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpcs/](https://www.paws-r-sdk.com/docs/ec2_describe_vpcs/) for full documentation.
#'
#' @param Filters The filters.
#' 
#' -   `cidr` - The primary IPv4 CIDR block of the VPC. The CIDR block you
#'     specify must exactly match the VPC's CIDR block for information to
#'     be returned for the VPC. Must contain the slash followed by one or
#'     two digits (for example, `/28`).
#' 
#' -   `cidr-block-association.cidr-block` - An IPv4 CIDR block associated
#'     with the VPC.
#' 
#' -   `cidr-block-association.association-id` - The association ID for an
#'     IPv4 CIDR block associated with the VPC.
#' 
#' -   `cidr-block-association.state` - The state of an IPv4 CIDR block
#'     associated with the VPC.
#' 
#' -   `dhcp-options-id` - The ID of a set of DHCP options.
#' 
#' -   `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
#'     associated with the VPC.
#' 
#' -   `ipv6-cidr-block-association.ipv6-pool` - The ID of the IPv6 address
#'     pool from which the IPv6 CIDR block is allocated.
#' 
#' -   `ipv6-cidr-block-association.association-id` - The association ID
#'     for an IPv6 CIDR block associated with the VPC.
#' 
#' -   `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
#'     block associated with the VPC.
#' 
#' -   `is-default` - Indicates whether the VPC is the default VPC.
#' 
#' -   `owner-id` - The ID of the Amazon Web Services account that owns the
#'     VPC.
#' 
#' -   `state` - The state of the VPC (`pending` | `available`).
#' 
#' -   `tag` - The key/value combination of a tag assigned to the resource.
#'     Use the tag key in the filter name and the tag value as the filter
#'     value. For example, to find all resources that have a tag with the
#'     key `Owner` and the value `TeamA`, specify `tag:Owner` for the
#'     filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC.
#' @param VpcIds The IDs of the VPCs.
#' @param NextToken The token returned from a previous paginated request. Pagination
#' continues from the end of the items returned by the previous request.
#' @param MaxResults The maximum number of items to return for this request. To get the next
#' page of items, make another request with the token returned in the
#' output. For more information, see
#' [Pagination](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpcs
ec2_describe_vpcs <- function(Filters = NULL, VpcIds = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpcs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Vpcs"),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpcs_input(Filters = Filters, VpcIds = VpcIds, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_vpcs_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpcs <- ec2_describe_vpcs

#' Describes one or more of your VPN connections
#'
#' @description
#' Describes one or more of your VPN connections.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpn_connections/](https://www.paws-r-sdk.com/docs/ec2_describe_vpn_connections/) for full documentation.
#'
#' @param Filters One or more filters.
#' 
#' -   `customer-gateway-configuration` - The configuration information for
#'     the customer gateway.
#' 
#' -   `customer-gateway-id` - The ID of a customer gateway associated with
#'     the VPN connection.
#' 
#' -   `state` - The state of the VPN connection (`pending` | `available` |
#'     `deleting` | `deleted`).
#' 
#' -   `option.static-routes-only` - Indicates whether the connection has
#'     static routes only. Used for devices that do not support Border
#'     Gateway Protocol (BGP).
#' 
#' -   `route.destination-cidr-block` - The destination CIDR block. This
#'     corresponds to the subnet used in a customer data center.
#' 
#' -   `bgp-asn` - The BGP Autonomous System Number (ASN) associated with a
#'     BGP device.
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `type` - The type of VPN connection. Currently the only supported
#'     type is `ipsec.1`.
#' 
#' -   `vpn-connection-id` - The ID of the VPN connection.
#' 
#' -   `vpn-gateway-id` - The ID of a virtual private gateway associated
#'     with the VPN connection.
#' 
#' -   `transit-gateway-id` - The ID of a transit gateway associated with
#'     the VPN connection.
#' @param VpnConnectionIds One or more VPN connection IDs.
#' 
#' Default: Describes your VPN connections.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpn_connections
ec2_describe_vpn_connections <- function(Filters = NULL, VpnConnectionIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpnConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpn_connections_input(Filters = Filters, VpnConnectionIds = VpnConnectionIds, DryRun = DryRun)
  output <- .ec2$describe_vpn_connections_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpn_connections <- ec2_describe_vpn_connections

#' Describes one or more of your virtual private gateways
#'
#' @description
#' Describes one or more of your virtual private gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_describe_vpn_gateways/](https://www.paws-r-sdk.com/docs/ec2_describe_vpn_gateways/) for full documentation.
#'
#' @param Filters One or more filters.
#' 
#' -   `amazon-side-asn` - The Autonomous System Number (ASN) for the
#'     Amazon side of the gateway.
#' 
#' -   `attachment.state` - The current state of the attachment between the
#'     gateway and the VPC (`attaching` | `attached` | `detaching` |
#'     `detached`).
#' 
#' -   `attachment.vpc-id` - The ID of an attached VPC.
#' 
#' -   `availability-zone` - The Availability Zone for the virtual private
#'     gateway (if applicable).
#' 
#' -   `state` - The state of the virtual private gateway (`pending` |
#'     `available` | `deleting` | `deleted`).
#' 
#' -   `tag`:\<key\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `type` - The type of virtual private gateway. Currently the only
#'     supported type is `ipsec.1`.
#' 
#' -   `vpn-gateway-id` - The ID of the virtual private gateway.
#' @param VpnGatewayIds One or more virtual private gateway IDs.
#' 
#' Default: Describes all your virtual private gateways.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpn_gateways
ec2_describe_vpn_gateways <- function(Filters = NULL, VpnGatewayIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpnGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$describe_vpn_gateways_input(Filters = Filters, VpnGatewayIds = VpnGatewayIds, DryRun = DryRun)
  output <- .ec2$describe_vpn_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpn_gateways <- ec2_describe_vpn_gateways

#' This action is deprecated
#'
#' @description
#' This action is deprecated.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_detach_classic_link_vpc/](https://www.paws-r-sdk.com/docs/ec2_detach_classic_link_vpc/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance to unlink from the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC to which the instance is linked.
#'
#' @keywords internal
#'
#' @rdname ec2_detach_classic_link_vpc
ec2_detach_classic_link_vpc <- function(DryRun = NULL, InstanceId, VpcId) {
  op <- new_operation(
    name = "DetachClassicLinkVpc",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$detach_classic_link_vpc_input(DryRun = DryRun, InstanceId = InstanceId, VpcId = VpcId)
  output <- .ec2$detach_classic_link_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_classic_link_vpc <- ec2_detach_classic_link_vpc

#' Detaches an internet gateway from a VPC, disabling connectivity between
#' the internet and the VPC
#'
#' @description
#' Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses or public IPv4 addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_detach_internet_gateway/](https://www.paws-r-sdk.com/docs/ec2_detach_internet_gateway/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname ec2_detach_internet_gateway
ec2_detach_internet_gateway <- function(DryRun = NULL, InternetGatewayId, VpcId) {
  op <- new_operation(
    name = "DetachInternetGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$detach_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId, VpcId = VpcId)
  output <- .ec2$detach_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_internet_gateway <- ec2_detach_internet_gateway

#' Detaches a network interface from an instance
#'
#' @description
#' Detaches a network interface from an instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_detach_network_interface/](https://www.paws-r-sdk.com/docs/ec2_detach_network_interface/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#' @param Force Specifies whether to force a detachment.
#' 
#' -   Use the `Force` parameter only as a last resort to detach a network
#'     interface from a failed instance.
#' 
#' -   If you use the `Force` parameter to detach a network interface, you
#'     might not be able to attach a different network interface to the
#'     same index on the instance without first stopping and starting the
#'     instance.
#' 
#' -   If you force the detachment of a network interface, the [instance
#'     metadata](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
#'     might not get updated. This means that the attributes associated
#'     with the detached network interface might still be visible. The
#'     instance metadata will get updated when you stop and start the
#'     instance.
#'
#' @keywords internal
#'
#' @rdname ec2_detach_network_interface
ec2_detach_network_interface <- function(DryRun = NULL, AttachmentId, Force = NULL) {
  op <- new_operation(
    name = "DetachNetworkInterface",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$detach_network_interface_input(DryRun = DryRun, AttachmentId = AttachmentId, Force = Force)
  output <- .ec2$detach_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_network_interface <- ec2_detach_network_interface

#' Detaches the specified Amazon Web Services Verified Access trust
#' provider from the specified Amazon Web Services Verified Access instance
#'
#' @description
#' Detaches the specified Amazon Web Services Verified Access trust provider from the specified Amazon Web Services Verified Access instance.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_detach_verified_access_trust_provider/](https://www.paws-r-sdk.com/docs/ec2_detach_verified_access_trust_provider/) for full documentation.
#'
#' @param VerifiedAccessInstanceId &#91;required&#93; The ID of the Verified Access instance.
#' @param VerifiedAccessTrustProviderId &#91;required&#93; The ID of the Verified Access trust provider.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' idempotency](https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_detach_verified_access_trust_provider
ec2_detach_verified_access_trust_provider <- function(VerifiedAccessInstanceId, VerifiedAccessTrustProviderId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DetachVerifiedAccessTrustProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$detach_verified_access_trust_provider_input(VerifiedAccessInstanceId = VerifiedAccessInstanceId, VerifiedAccessTrustProviderId = VerifiedAccessTrustProviderId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$detach_verified_access_trust_provider_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_verified_access_trust_provider <- ec2_detach_verified_access_trust_provider

#' Detaches an EBS volume from an instance
#'
#' @description
#' Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the `busy` state while detaching. If this happens, detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of an instance, it can't be detached while the instance is running. To detach the root volume, stop the instance first.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_detach_volume/](https://www.paws-r-sdk.com/docs/ec2_detach_volume/) for full documentation.
#'
#' @param Device The device name.
#' @param Force Forces detachment if the previous detachment attempt did not occur
#' cleanly (for example, logging into an instance, unmounting the volume,
#' and detaching normally). This option can lead to data loss or a
#' corrupted file system. Use this option only as a last resort to detach a
#' volume from a failed instance. The instance won't have an opportunity to
#' flush file system caches or file system metadata. If you use this
#' option, you must perform file system check and repair procedures.
#' @param InstanceId The ID of the instance. If you are detaching a Multi-Attach enabled
#' volume, you must specify an instance ID.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_detach_volume
ec2_detach_volume <- function(Device = NULL, Force = NULL, InstanceId = NULL, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DetachVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$detach_volume_input(Device = Device, Force = Force, InstanceId = InstanceId, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$detach_volume_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_volume <- ec2_detach_volume

#' Detaches a virtual private gateway from a VPC
#'
#' @description
#' Detaches a virtual private gateway from a VPC. You do this if you're planning to turn off the VPC and not use it anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the virtual private gateway (any attachments to the virtual private gateway are also described).
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_detach_vpn_gateway/](https://www.paws-r-sdk.com/docs/ec2_detach_vpn_gateway/) for full documentation.
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_detach_vpn_gateway
ec2_detach_vpn_gateway <- function(VpcId, VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DetachVpnGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$detach_vpn_gateway_input(VpcId = VpcId, VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$detach_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_vpn_gateway <- ec2_detach_vpn_gateway

#' Disables Elastic IP address transfer
#'
#' @description
#' Disables Elastic IP address transfer. For more information, see [Transfer Elastic IP addresses](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro) in the *Amazon VPC User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_disable_address_transfer/](https://www.paws-r-sdk.com/docs/ec2_disable_address_transfer/) for full documentation.
#'
#' @param AllocationId &#91;required&#93; The allocation ID of an Elastic IP address.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_disable_address_transfer
ec2_disable_address_transfer <- function(AllocationId, DryRun = NULL) {
  op <- new_operation(
    name = "DisableAddressTransfer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$disable_address_transfer_input(AllocationId = AllocationId, DryRun = DryRun)
  output <- .ec2$disable_address_transfer_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_address_transfer <- ec2_disable_address_transfer

#' Disables Allowed AMIs for your account in the specified Amazon Web
#' Services Region
#'
#' @description
#' Disables Allowed AMIs for your account in the specified Amazon Web Services Region. When set to `disabled`, the image criteria in your Allowed AMIs settings do not apply, and no restrictions are placed on AMI discoverability or usage. Users in your account can launch instances using any public AMI or AMI shared with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_disable_allowed_images_settings/](https://www.paws-r-sdk.com/docs/ec2_disable_allowed_images_settings/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_disable_allowed_images_settings
ec2_disable_allowed_images_settings <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DisableAllowedImagesSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$disable_allowed_images_settings_input(DryRun = DryRun)
  output <- .ec2$disable_allowed_images_settings_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_allowed_images_settings <- ec2_disable_allowed_images_settings

#' Disables Infrastructure Performance metric subscriptions
#'
#' @description
#' Disables Infrastructure Performance metric subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_disable_aws_network_performance_metric_subscription/](https://www.paws-r-sdk.com/docs/ec2_disable_aws_network_performance_metric_subscription/) for full documentation.
#'
#' @param Source The source Region or Availability Zone that the metric subscription is
#' disabled for. For example, `us-east-1`.
#' @param Destination The target Region or Availability Zone that the metric subscription is
#' disabled for. For example, `eu-north-1`.
#' @param Metric The metric used for the disabled subscription.
#' @param Statistic The statistic used for the disabled subscription.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_disable_aws_network_performance_metric_subscription
ec2_disable_aws_network_performance_metric_subscription <- function(Source = NULL, Destination = NULL, Metric = NULL, Statistic = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DisableAwsNetworkPerformanceMetricSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$disable_aws_network_performance_metric_subscription_input(Source = Source, Destination = Destination, Metric = Metric, Statistic = Statistic, DryRun = DryRun)
  output <- .ec2$disable_aws_network_performance_metric_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_aws_network_performance_metric_subscription <- ec2_disable_aws_network_performance_metric_subscription

#' Disables EBS encryption by default for your account in the current
#' Region
#'
#' @description
#' Disables EBS encryption by default for your account in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_disable_ebs_encryption_by_default/](https://www.paws-r-sdk.com/docs/ec2_disable_ebs_encryption_by_default/) for full documentation.
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_disable_ebs_encryption_by_default
ec2_disable_ebs_encryption_by_default <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DisableEbsEncryptionByDefault",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ec2$disable_ebs_encryption_by_default_input(DryRun = DryRun)
  output <- .ec2$disable_ebs_encryption_by_default_output()
  config <- get_config()
  svc <- .ec2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_ebs_encryption_by_default <- ec2_disable_ebs_encryption_by_default

#' Discontinue Windows fast launch for a Windows AMI, and clean up existing
#' pre-provisioned snapshots
#'
#' @description
#' Discontinue Windows fast launch for a Windows AMI, and clean up existing pre-provisioned snapshots. After you disable Windows fast launch, the AMI uses the standard launch process for each new instance. Amazon EC2 must remove all pre-provisioned snapshots before you can enable Windows fast launch again.
#'
#' See [https://www.paws-r-sdk.com/docs/ec2_disable_fast_launch/](https://www.paws-r-sdk.com/docs/ec2_disable_fast_launch/) for full documentation.
#'
#' @param ImageId &#91;required&#93; Specify the ID of the image for which to disable Windows fast launch.
#' @param Force Forces the image settings to turn off Windows fast launch for your
#' Windows AMI. This parameter overrides any errors that are encountered
#' while cleaning up resources in your account.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname ec2_disable_fast_launch
ec2_disable_fast_launch <- function(ImageId, Force = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DisableFastLaunch",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_