% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_repository}
\alias{proton_create_repository}
\title{Create and register a link to a repository}
\usage{
proton_create_repository(
  connectionArn,
  encryptionKey = NULL,
  name,
  provider,
  tags = NULL
)
}
\arguments{
\item{connectionArn}{[required] The Amazon Resource Name (ARN) of your AWS CodeStar connection that
connects Proton to your repository provider account. For more
information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html}{Setting up for Proton}
in the \emph{Proton User Guide}.}

\item{encryptionKey}{The ARN of your customer Amazon Web Services Key Management Service
(Amazon Web Services KMS) key.}

\item{name}{[required] The repository name (for example, \code{myrepos/myrepo}).}

\item{provider}{[required] The repository provider.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton repository. A tag is a key-value pair.

For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton resources and tagging}
in the \emph{Proton User Guide}.}
}
\description{
Create and register a link to a repository. Proton uses the link to repeatedly access the repository, to either push to it (self-managed provisioning) or pull from it (template sync). You can share a linked repository across multiple resources (like environments using self-managed provisioning, or synced templates). When you create a repository link, Proton creates a \href{https://docs.aws.amazon.com/proton/latest/userguide/using-service-linked-roles.html}{service-linked role} for you.

See \url{https://www.paws-r-sdk.com/docs/proton_create_repository/} for full documentation.
}
\keyword{internal}
