% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_layer_versions}
\alias{lambda_list_layer_versions}
\title{Lists the versions of an Lambda layer}
\usage{
lambda_list_layer_versions(
  CompatibleRuntime = NULL,
  LayerName,
  Marker = NULL,
  MaxItems = NULL,
  CompatibleArchitecture = NULL
)
}
\arguments{
\item{CompatibleRuntime}{A runtime identifier. For example, \code{java21}.

The following list includes deprecated runtimes. For more information,
see \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy}{Runtime deprecation policy}.}

\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{Marker}{A pagination token returned by a previous call.}

\item{MaxItems}{The maximum number of versions to return.}

\item{CompatibleArchitecture}{The compatible \href{https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html}{instruction set architecture}.}
}
\description{
Lists the versions of an \href{https://docs.aws.amazon.com/lambda/latest/dg/chapter-layers.html}{Lambda layer}. Versions that have been deleted aren't listed. Specify a \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{runtime identifier} to list only versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.

See \url{https://www.paws-r-sdk.com/docs/lambda_list_layer_versions/} for full documentation.
}
\keyword{internal}
