% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_ipam_resource_discovery}
\alias{ec2_create_ipam_resource_discovery}
\title{Creates an IPAM resource discovery}
\usage{
ec2_create_ipam_resource_discovery(
  DryRun = NULL,
  Description = NULL,
  OperatingRegions = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{Description}{A description for the IPAM resource discovery.}

\item{OperatingRegions}{Operating Regions for the IPAM resource discovery. Operating Regions are
Amazon Web Services Regions where the IPAM is allowed to manage IP
address CIDRs. IPAM only discovers and monitors resources in the Amazon
Web Services Regions you select as operating Regions.}

\item{TagSpecifications}{Tag specifications for the IPAM resource discovery.}

\item{ClientToken}{A client token for the IPAM resource discovery.}
}
\description{
Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and monitor resources that belong to the owning account.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_ipam_resource_discovery/} for full documentation.
}
\keyword{internal}
