% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_create_job_queue}
\alias{batch_create_job_queue}
\title{Creates an Batch job queue}
\usage{
batch_create_job_queue(
  jobQueueName,
  state = NULL,
  schedulingPolicyArn = NULL,
  priority,
  computeEnvironmentOrder,
  tags = NULL
)
}
\arguments{
\item{jobQueueName}{[required] The name of the job queue. It can be up to 128 letters long. It can
contain uppercase and lowercase letters, numbers, hyphens (-), and
underscores (_).}

\item{state}{The state of the job queue. If the job queue state is \code{ENABLED}, it is
able to accept jobs. If the job queue state is \code{DISABLED}, new jobs
can't be added to the queue, but jobs already in the queue can finish.}

\item{schedulingPolicyArn}{The Amazon Resource Name (ARN) of the fair share scheduling policy. If
this parameter is specified, the job queue uses a fair share scheduling
policy. If this parameter isn't specified, the job queue uses a first
in, first out (FIFO) scheduling policy. After a job queue is created,
you can replace but can't remove the fair share scheduling policy. The
format is \code{aws:Partition:batch:Region:Account:scheduling-policy/Name }.
An example is
\code{aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy}.}

\item{priority}{[required] The priority of the job queue. Job queues with a higher priority (or a
higher integer value for the \code{priority} parameter) are evaluated first
when associated with the same compute environment. Priority is
determined in descending order. For example, a job queue with a priority
value of \code{10} is given scheduling preference over a job queue with a
priority value of \code{1}. All of the compute environments must be either
EC2 (\code{EC2} or \code{SPOT}) or Fargate (\code{FARGATE} or \code{FARGATE_SPOT}); EC2 and
Fargate compute environments can't be mixed.}

\item{computeEnvironmentOrder}{[required] The set of compute environments mapped to a job queue and their order
relative to each other. The job scheduler uses this parameter to
determine which compute environment runs a specific job. Compute
environments must be in the \code{VALID} state before you can associate them
with a job queue. You can associate up to three compute environments
with a job queue. All of the compute environments must be either EC2
(\code{EC2} or \code{SPOT}) or Fargate (\code{FARGATE} or \code{FARGATE_SPOT}); EC2 and
Fargate compute environments can't be mixed.

All compute environments that are associated with a job queue must share
the same architecture. Batch doesn't support mixing compute environment
architecture types in a single job queue.}

\item{tags}{The tags that you apply to the job queue to help you categorize and
organize your resources. Each tag consists of a key and an optional
value. For more information, see \href{https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html}{Tagging your Batch resources}
in \emph{Batch User Guide}.}
}
\description{
Creates an Batch job queue. When you create a job queue, you associate one or more compute environments to the queue and assign an order of preference for the compute environments.

See \url{https://www.paws-r-sdk.com/docs/batch_create_job_queue/} for full documentation.
}
\keyword{internal}
