% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_type_offerings}
\alias{ec2_describe_instance_type_offerings}
\title{Returns a list of all instance types offered}
\usage{
ec2_describe_instance_type_offerings(
  DryRun = NULL,
  LocationType = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LocationType}{The location type.}

\item{Filters}{One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{location} - This depends on the location type. For example, if the
location type is \code{region} (default), the location is the Region code
(for example, \code{us-east-2}.)
\item \code{instance-type} - The instance type. For example, \code{c5.2xlarge}.
}}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}
}
\description{
Returns a list of all instance types offered. The results can be filtered by location (Region or Availability Zone). If no location is specified, the instance types offered in the current Region are returned.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_instance_type_offerings/} for full documentation.
}
\keyword{internal}
