% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_remove_permission}
\alias{lambda_remove_permission}
\title{Revokes function-use permission from an AWS service or another account}
\usage{
lambda_remove_permission(FunctionName, StatementId, Qualifier,
  RevisionId)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{StatementId}{[required] Statement ID of the permission to remove.}

\item{Qualifier}{Specify a version or alias to remove permissions from a published
version of the function.}

\item{RevisionId}{Only update the policy if the revision ID matches the ID that\'s
specified. Use this option to avoid modifying a policy that has changed
since you last read it.}
}
\description{
Revokes function-use permission from an AWS service or another account.
You can get the ID of the statement from the output of GetPolicy.
}
\section{Request syntax}{
\preformatted{svc$remove_permission(
  FunctionName = "string",
  StatementId = "string",
  Qualifier = "string",
  RevisionId = "string"
)
}
}

\examples{
\dontrun{
# The following example removes a permissions statement named xaccount
# from the PROD alias of a function named my-function.
svc$remove_permission(
  FunctionName = "my-function",
  Qualifier = "PROD",
  StatementId = "xaccount"
)
}

}
\keyword{internal}
