% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_auto_snapshot}
\alias{lightsail_delete_auto_snapshot}
\title{Deletes an automatic snapshot of an instance or disk}
\usage{
lightsail_delete_auto_snapshot(resourceName, date)
}
\arguments{
\item{resourceName}{[required] The name of the source instance or disk from which to delete the
automatic snapshot.}

\item{date}{[required] The date of the automatic snapshot to delete in \code{YYYY-MM-DD} format. Use
the \verb{get auto snapshots} operation to get the available automatic
snapshots for a resource.}
}
\description{
Deletes an automatic snapshot of an instance or disk. For more
information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_auto_snapshot(
  resourceName = "string",
  date = "string"
)
}
}

\keyword{internal}
