% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disassociate_address}
\alias{ec2_disassociate_address}
\title{Disassociates an Elastic IP address from the instance or network
interface it's associated with}
\usage{
ec2_disassociate_address(AssociationId, PublicIp, DryRun)
}
\arguments{
\item{AssociationId}{[EC2-VPC] The association ID. Required for EC2-VPC.}

\item{PublicIp}{[EC2-Classic] The Elastic IP address. Required for EC2-Classic.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Disassociates an Elastic IP address from the instance or network
interface it\'s associated with.
}
\details{
An Elastic IP address is for use in either the EC2-Classic platform or
in a VPC. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

This is an idempotent operation. If you perform the operation more than
once, Amazon EC2 doesn\'t return an error.
}
\section{Request syntax}{
\preformatted{svc$disassociate_address(
  AssociationId = "string",
  PublicIp = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example disassociates an Elastic IP address from an instance in a
# VPC.
\dontrun{svc$disassociate_address(
  AssociationId = "eipassoc-2bebb745"
)}

# This example disassociates an Elastic IP address from an instance in
# EC2-Classic.
\dontrun{svc$disassociate_address(
  PublicIp = "198.51.100.0"
)}

}
\keyword{internal}
