% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_instance_export_task}
\alias{ec2_create_instance_export_task}
\title{Exports a running or stopped instance to an S3 bucket}
\usage{
ec2_create_instance_export_task(Description, ExportToS3Task, InstanceId,
  TargetEnvironment)
}
\arguments{
\item{Description}{A description for the conversion task or the resource being exported.
The maximum length is 255 bytes.}

\item{ExportToS3Task}{The format and location for an instance export task.}

\item{InstanceId}{[required] The ID of the instance.}

\item{TargetEnvironment}{The target virtualization environment.}
}
\description{
Exports a running or stopped instance to an S3 bucket.
}
\details{
For information about the supported operating systems, image formats,
and known limitations for the types of instances you can export, see
\href{https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html}{Exporting an Instance as a VM Using VM Import/Export}
in the \emph{VM Import/Export User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_instance_export_task(
  Description = "string",
  ExportToS3Task = list(
    ContainerFormat = "ova",
    DiskImageFormat = "VMDK"|"RAW"|"VHD",
    S3Bucket = "string",
    S3Prefix = "string"
  ),
  InstanceId = "string",
  TargetEnvironment = "citrix"|"vmware"|"microsoft"
)
}
}

\keyword{internal}
