% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_delete_cluster}
\alias{eks_delete_cluster}
\title{Deletes the Amazon EKS cluster control plane}
\usage{
eks_delete_cluster(name)
}
\arguments{
\item{name}{[required] The name of the cluster to delete.}
}
\description{
Deletes the Amazon EKS cluster control plane.
}
\details{
If you have active services in your cluster that are associated with a
load balancer, you must delete those services before deleting the
cluster so that the load balancers are deleted properly. Otherwise, you
can have orphaned resources in your VPC that prevent you from being able
to delete the VPC. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html}{Deleting a Cluster}
in the \emph{Amazon EKS User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_cluster(
  name = "string"
)
}
}

\examples{
# This example command deletes a cluster named `devel` in your default
# region.
\donttest{svc$delete_cluster(
  name = "devel"
)}

}
\keyword{internal}
