% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_classic_link_dns_support}
\alias{ec2_describe_vpc_classic_link_dns_support}
\title{Describes the ClassicLink DNS support status of one or more VPCs}
\usage{
ec2_describe_vpc_classic_link_dns_support(MaxResults, NextToken, VpcIds)
}
\arguments{
\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{VpcIds}{One or more VPC IDs.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  Vpcs = list(
    list(
      ClassicLinkDnsSupported = TRUE|FALSE,
      VpcId = "string"
    )
  )
)
}
}
\description{
Describes the ClassicLink DNS support status of one or more VPCs. If
enabled, the DNS hostname of a linked EC2-Classic instance resolves to
its private IP address when addressed from an instance in the VPC to
which it's linked. Similarly, the DNS hostname of an instance in a VPC
resolves to its private IP address when addressed from a linked
EC2-Classic instance. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_vpc_classic_link_dns_support(
  MaxResults = 123,
  NextToken = "string",
  VpcIds = list(
    "string"
  )
)
}
}

\keyword{internal}
