% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_send_contact_method_verification}
\alias{lightsail_send_contact_method_verification}
\title{Sends a verification request to an email contact method to ensure it's
owned by the requester}
\usage{
lightsail_send_contact_method_verification(protocol)
}
\arguments{
\item{protocol}{[required] The protocol to verify, such as \code{Email} or \code{SMS} (text messaging).}
}
\description{
Sends a verification request to an email contact method to ensure it's
owned by the requester. SMS contact methods don't need to be verified.

A contact method is used to send you notifications about your Amazon
Lightsail resources. You can add one email address and one mobile phone
number contact method in each AWS Region. However, SMS text messaging is
not supported in some AWS Regions, and SMS text messages cannot be sent
to some countries/regions. For more information, see Notifications in
Amazon Lightsail.

A verification request is sent to the contact method when you initially
create it. Use this action to send another verification request if a
previous verification request was deleted, or has expired.

Notifications are not sent to an email contact method until after it is
verified, and confirmed as valid.
}
\section{Request syntax}{
\preformatted{svc$send_contact_method_verification(
  protocol = "Email"
)
}
}

\keyword{internal}
