% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_managed_prefix_list}
\alias{ec2_create_managed_prefix_list}
\title{Creates a managed prefix list}
\usage{
ec2_create_managed_prefix_list(DryRun, PrefixListName, Entries,
  MaxEntries, TagSpecifications, AddressFamily, ClientToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PrefixListName}{[required] A name for the prefix list.

Constraints: Up to 255 characters in length. The name cannot start with
\code{com.amazonaws}.}

\item{Entries}{One or more entries for the prefix list.}

\item{MaxEntries}{[required] The maximum number of entries for the prefix list.}

\item{TagSpecifications}{The tags to apply to the prefix list during creation.}

\item{AddressFamily}{[required] The IP address type.

Valid Values: \code{IPv4} | \code{IPv6}}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraints: Up to 255 UTF-8 characters in length.}
}
\description{
Creates a managed prefix list. You can specify one or more entries for
the prefix list. Each entry consists of a CIDR block and an optional
description.

You must specify the maximum number of entries for the prefix list. The
maximum number of entries cannot be changed later.
}
\section{Request syntax}{
\preformatted{svc$create_managed_prefix_list(
  DryRun = TRUE|FALSE,
  PrefixListName = "string",
  Entries = list(
    list(
      Cidr = "string",
      Description = "string"
    )
  ),
  MaxEntries = 123,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  AddressFamily = "string",
  ClientToken = "string"
)
}
}

\keyword{internal}
