% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_list_tags_for_resource}
\alias{batch_list_tags_for_resource}
\title{Lists the tags for an AWS Batch resource}
\usage{
batch_list_tags_for_resource(resourceArn)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource that tags
are listed for. AWS Batch resources that support tags are compute
environments, jobs, job definitions, and job queues. ARNs for child jobs
of array and multi-node parallel (MNP) jobs are not supported.}
}
\description{
Lists the tags for an AWS Batch resource. AWS Batch resources that
support tags are compute environments, jobs, job definitions, and job
queues. ARNs for child jobs of array and multi-node parallel (MNP) jobs
are not supported.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  resourceArn = "string"
)
}
}

\examples{
\dontrun{
# This demonstrates calling the ListTagsForResource action.
svc$list_tags_for_resource(
  resourceArn = "arn:aws:batch:us-east-1:123456789012:job-definition/sleep30:1"
)
}

}
\keyword{internal}
