% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_account_settings}
\alias{ecs_list_account_settings}
\title{Lists the account settings for an Amazon ECS resource for a specified
principal}
\usage{
ecs_list_account_settings(name, value, principalArn, effectiveSettings,
  nextToken, maxResults)
}
\arguments{
\item{name}{The resource name you want to list the account settings for.}

\item{value}{The value of the account settings with which to filter results. You must
also specify an account setting name to use this parameter.}

\item{principalArn}{The ARN of the principal, which can be an IAM user, IAM role, or the
root user. If this field is omitted, the account settings are listed
only for the authenticated user.}

\item{effectiveSettings}{Specifies whether to return the effective settings. If \code{true}, the
account settings for the root user or the default setting for the
\code{principalArn}. If \code{false}, the account settings for the \code{principalArn}
are returned if they are set. Otherwise, no account settings are
returned.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{ListAccountSettings} request where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of account setting results returned by
\code{ListAccountSettings} in paginated output. When this parameter is used,
\code{ListAccountSettings} only returns \code{maxResults} results in a single page
along with a \code{nextToken} response element. The remaining results of the
initial request can be seen by sending another \code{ListAccountSettings}
request with the returned \code{nextToken} value. This value can be between 1
and 10. If this parameter is not used, then \code{ListAccountSettings}
returns up to 10 results and a \code{nextToken} value if applicable.}
}
\description{
Lists the account settings for an Amazon ECS resource for a specified
principal.
}
\section{Request syntax}{
\preformatted{svc$list_account_settings(
  name = "serviceLongArnFormat"|"taskLongArnFormat"|"containerInstanceLongArnFormat",
  value = "string",
  principalArn = "string",
  effectiveSettings = TRUE|FALSE,
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
# This example displays the effective account settings for your account.
\donttest{svc$list_account_settings(
  effectiveSettings = TRUE
)}

# This example displays the effective account settings for the specified
# user or role.
\donttest{svc$list_account_settings(
  effectiveSettings = TRUE,
  principalArn = "arn:aws:iam::<aws_account_id>:user/principalName"
)}

}
\keyword{internal}
