% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_flow_logs}
\alias{ec2_describe_flow_logs}
\title{Describes one or more flow logs}
\usage{
ec2_describe_flow_logs(DryRun, Filter, FlowLogIds, MaxResults,
  NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filter}{One or more filters.
\itemize{
\item \code{deliver-log-status} - The status of the logs delivery (\code{SUCCESS} \|
\code{FAILED}).
\item \code{log-destination-type} - The type of destination to which the flow
log publishes data. Possible destination types include
\code{cloud-watch-logs} and \code{S3}.
\item \code{flow-log-id} - The ID of the flow log.
\item \code{log-group-name} - The name of the log group.
\item \code{resource-id} - The ID of the VPC, subnet, or network interface.
\item \code{traffic-type} - The type of traffic (\code{ACCEPT} \| \code{REJECT} \|
\code{ALL}).
}}

\item{FlowLogIds}{One or more flow log IDs.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more flow logs. To view the information in your flow
logs (the log streams for the network interfaces), you must use the
CloudWatch Logs console or the CloudWatch Logs API.
}
\section{Request syntax}{
\preformatted{svc$describe_flow_logs(
  DryRun = TRUE|FALSE,
  Filter = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  FlowLogIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
