% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_put_geofence}
\alias{locationservice_put_geofence}
\title{Stores a geofence geometry in a given geofence collection, or updates
the geometry of an existing geofence if a geofence ID is included in the
request}
\usage{
locationservice_put_geofence(CollectionName, GeofenceId, Geometry)
}
\arguments{
\item{CollectionName}{[required] The geofence collection to store the geofence in.}

\item{GeofenceId}{[required] An identifier for the geofence. For example, \code{ExampleGeofence-1}.}

\item{Geometry}{[required] Contains the details to specify the position of the geofence. Can be
either a polygon or a circle. Including both will return a validation
error.

Each \href{https://docs.aws.amazon.com/location/latest/APIReference/API_GeofenceGeometry.html}{geofence polygon}
can have a maximum of 1,000 vertices.}
}
\description{
Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.

See \url{https://www.paws-r-sdk.com/docs/locationservice_put_geofence/} for full documentation.
}
\keyword{internal}
